package software.amazon.awscdk.services.fsx;

/**
 * The FSx for Lustre File System implementation of IFileSystem.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISecurityGroup sg = SecurityGroup.fromSecurityGroupId(this, "FsxSecurityGroup", "{SECURITY-GROUP-ID}");
 * IFileSystem fs = LustreFileSystem.fromLustreFileSystemAttributes(this, "FsxLustreFileSystem", FileSystemAttributes.builder()
 *         .dnsName("{FILE-SYSTEM-DNS-NAME}")
 *         .fileSystemId("{FILE-SYSTEM-ID}")
 *         .securityGroup(sg)
 *         .build());
 * IVpc vpc = Vpc.fromVpcAttributes(this, "Vpc", VpcAttributes.builder()
 *         .availabilityZones(List.of("us-west-2a", "us-west-2b"))
 *         .publicSubnetIds(List.of("{US-WEST-2A-SUBNET-ID}", "{US-WEST-2B-SUBNET-ID}"))
 *         .vpcId("{VPC-ID}")
 *         .build());
 * Instance inst = Instance.Builder.create(this, "inst")
 *         .instanceType(InstanceType.of(InstanceClass.T2, InstanceSize.LARGE))
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .build())
 *         .vpc(vpc)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .build();
 * fs.connections.allowDefaultPortFrom(inst);
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.251Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreFileSystem")
public class LustreFileSystem extends software.amazon.awscdk.services.fsx.FileSystemBase {

    protected LustreFileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LustreFileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LustreFileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.LustreFileSystemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing FSx for Lustre file system from the given properties.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.IFileSystem fromLustreFileSystemAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.FileSystemAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.fsx.LustreFileSystem.class, "fromLustreFileSystemAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.IFileSystem.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The security groups/rules used to allow network connections to the file system.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The DNS name assigned to this file system.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDnsName() {
        return software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID that AWS assigns to the file system.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The mount name of the file system, generated by FSx.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMountName() {
        return software.amazon.jsii.Kernel.get(this, "mountName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.LustreFileSystem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.LustreFileSystem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fsx.LustreFileSystemProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fsx.LustreFileSystemProps.Builder();
        }

        /**
         * The storage capacity of the file system being created.
         * <p>
         * For Windows file systems, valid values are 32 GiB to 65,536 GiB.
         * For SCRATCH_1 deployment types, valid values are 1,200, 2,400, 3,600, then continuing in increments of 3,600 GiB.
         * For SCRATCH_2 and PERSISTENT_1 types, valid values are 1,200, 2,400, then continuing in increments of 2,400 GiB.
         * <p>
         * @return {@code this}
         * @param storageCapacityGiB The storage capacity of the file system being created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCapacityGiB(final java.lang.Number storageCapacityGiB) {
            this.props.storageCapacityGiB(storageCapacityGiB);
            return this;
        }

        /**
         * The VPC to launch the file system in.
         * <p>
         * @return {@code this}
         * @param vpc The VPC to launch the file system in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * The ID of the backup.
         * <p>
         * Specifies the backup to use if you're creating a file system from an existing backup.
         * <p>
         * Default: - no backup will be used.
         * <p>
         * @return {@code this}
         * @param backupId The ID of the backup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(final java.lang.String backupId) {
            this.props.backupId(backupId);
            return this;
        }

        /**
         * The KMS key used for encryption to protect your data at rest.
         * <p>
         * Default: - the aws/fsx default KMS key for the AWS account being deployed into.
         * <p>
         * @return {@code this}
         * @param kmsKey The KMS key used for encryption to protect your data at rest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * Policy to apply when the file system is removed from the stack.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the file system is removed from the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Security Group to assign to this file system.
         * <p>
         * Default: - creates new security group which allows all outbound traffic.
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to assign to this file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Additional configuration for FSx specific to Lustre.
         * <p>
         * @return {@code this}
         * @param lustreConfiguration Additional configuration for FSx specific to Lustre. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lustreConfiguration(final software.amazon.awscdk.services.fsx.LustreConfiguration lustreConfiguration) {
            this.props.lustreConfiguration(lustreConfiguration);
            return this;
        }

        /**
         * The subnet that the file system will be accessible from.
         * <p>
         * @return {@code this}
         * @param vpcSubnet The subnet that the file system will be accessible from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnet(final software.amazon.awscdk.services.ec2.ISubnet vpcSubnet) {
            this.props.vpcSubnet(vpcSubnet);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.fsx.LustreFileSystem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.LustreFileSystem build() {
            return new software.amazon.awscdk.services.fsx.LustreFileSystem(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
