package software.amazon.awscdk.services.events;

/**
 * Properties for defining a `CfnRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.*;
 * Object eventPattern;
 * CfnRuleProps cfnRuleProps = CfnRuleProps.builder()
 *         .description("description")
 *         .eventBusName("eventBusName")
 *         .eventPattern(eventPattern)
 *         .name("name")
 *         .roleArn("roleArn")
 *         .scheduleExpression("scheduleExpression")
 *         .state("state")
 *         .targets(List.of(TargetProperty.builder()
 *                 .arn("arn")
 *                 .id("id")
 *                 // the properties below are optional
 *                 .batchParameters(BatchParametersProperty.builder()
 *                         .jobDefinition("jobDefinition")
 *                         .jobName("jobName")
 *                         // the properties below are optional
 *                         .arrayProperties(BatchArrayPropertiesProperty.builder()
 *                                 .size(123)
 *                                 .build())
 *                         .retryStrategy(BatchRetryStrategyProperty.builder()
 *                                 .attempts(123)
 *                                 .build())
 *                         .build())
 *                 .deadLetterConfig(DeadLetterConfigProperty.builder()
 *                         .arn("arn")
 *                         .build())
 *                 .ecsParameters(EcsParametersProperty.builder()
 *                         .taskDefinitionArn("taskDefinitionArn")
 *                         // the properties below are optional
 *                         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                                 .capacityProvider("capacityProvider")
 *                                 // the properties below are optional
 *                                 .base(123)
 *                                 .weight(123)
 *                                 .build()))
 *                         .enableEcsManagedTags(false)
 *                         .enableExecuteCommand(false)
 *                         .group("group")
 *                         .launchType("launchType")
 *                         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                                 .awsVpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                                         .subnets(List.of("subnets"))
 *                                         // the properties below are optional
 *                                         .assignPublicIp("assignPublicIp")
 *                                         .securityGroups(List.of("securityGroups"))
 *                                         .build())
 *                                 .build())
 *                         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                                 .expression("expression")
 *                                 .type("type")
 *                                 .build()))
 *                         .placementStrategies(List.of(PlacementStrategyProperty.builder()
 *                                 .field("field")
 *                                 .type("type")
 *                                 .build()))
 *                         .platformVersion("platformVersion")
 *                         .propagateTags("propagateTags")
 *                         .referenceId("referenceId")
 *                         .tagList(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .taskCount(123)
 *                         .build())
 *                 .httpParameters(HttpParametersProperty.builder()
 *                         .headerParameters(Map.of(
 *                                 "headerParametersKey", "headerParameters"))
 *                         .pathParameterValues(List.of("pathParameterValues"))
 *                         .queryStringParameters(Map.of(
 *                                 "queryStringParametersKey", "queryStringParameters"))
 *                         .build())
 *                 .input("input")
 *                 .inputPath("inputPath")
 *                 .inputTransformer(InputTransformerProperty.builder()
 *                         .inputTemplate("inputTemplate")
 *                         // the properties below are optional
 *                         .inputPathsMap(Map.of(
 *                                 "inputPathsMapKey", "inputPathsMap"))
 *                         .build())
 *                 .kinesisParameters(KinesisParametersProperty.builder()
 *                         .partitionKeyPath("partitionKeyPath")
 *                         .build())
 *                 .redshiftDataParameters(RedshiftDataParametersProperty.builder()
 *                         .database("database")
 *                         .sql("sql")
 *                         // the properties below are optional
 *                         .dbUser("dbUser")
 *                         .secretManagerArn("secretManagerArn")
 *                         .statementName("statementName")
 *                         .withEvent(false)
 *                         .build())
 *                 .retryPolicy(RetryPolicyProperty.builder()
 *                         .maximumEventAgeInSeconds(123)
 *                         .maximumRetryAttempts(123)
 *                         .build())
 *                 .roleArn("roleArn")
 *                 .runCommandParameters(RunCommandParametersProperty.builder()
 *                         .runCommandTargets(List.of(RunCommandTargetProperty.builder()
 *                                 .key("key")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .build())
 *                 .sqsParameters(SqsParametersProperty.builder()
 *                         .messageGroupId("messageGroupId")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:10.123Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.CfnRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The description of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name or ARN of the event bus associated with the rule.
     * <p>
     * If you omit this, the default event bus is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventBusName() {
        return null;
    }

    /**
     * The event pattern of the rule.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <em>Amazon EventBridge User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventPattern() {
        return null;
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the role that is used for target invocation.
     * <p>
     * If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return null;
    }

    /**
     * The scheduling expression.
     * <p>
     * For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html">Creating an Amazon EventBridge rule that runs on a schedule</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
        return null;
    }

    /**
     * The state of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
     * <p>
     * Targets are the resources that are invoked when a rule is triggered.
     * <p>
     * <blockquote>
     * <p>
     * Each rule can have up to five (5) targets associated with it at one time.
     * <p>
     * </blockquote>
     * <p>
     * You can configure the following as targets for Events:
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API destination</a></li>
     * <li>Amazon API Gateway REST API endpoints</li>
     * <li>API Gateway</li>
     * <li>AWS Batch job queue</li>
     * <li>CloudWatch Logs group</li>
     * <li>CodeBuild project</li>
     * <li>CodePipeline</li>
     * <li>Amazon EC2 <code>CreateSnapshot</code> API call</li>
     * <li>EC2 Image Builder</li>
     * <li>Amazon EC2 <code>RebootInstances</code> API call</li>
     * <li>Amazon EC2 <code>StopInstances</code> API call</li>
     * <li>Amazon EC2 <code>TerminateInstances</code> API call</li>
     * <li>Amazon ECS tasks</li>
     * <li>Event bus in a different AWS account or Region.</li>
     * </ul>
     * <p>
     * You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.
     * <p>
     * <ul>
     * <li>Firehose delivery stream (Kinesis Data Firehose)</li>
     * <li>Inspector assessment template (Amazon Inspector)</li>
     * <li>Kinesis stream (Kinesis Data Stream)</li>
     * <li>AWS Lambda function</li>
     * <li>Redshift clusters (Data API statement execution)</li>
     * <li>Amazon SNS topic</li>
     * <li>Amazon SQS queues (includes FIFO queues)</li>
     * <li>SSM Automation</li>
     * <li>SSM OpsItem</li>
     * <li>SSM Run Command</li>
     * <li>Step Functions state machines</li>
     * </ul>
     * <p>
     * Creating rules with built-in targets is supported only in the AWS Management Console . The built-in targets are <code>EC2 CreateSnapshot API call</code> , <code>EC2 RebootInstances API call</code> , <code>EC2 StopInstances API call</code> , and <code>EC2 TerminateInstances API call</code> .
     * <p>
     * For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code> argument. To invoke a command on multiple EC2 instances with one rule, you can use the <code>RunCommandParameters</code> field.
     * <p>
     * To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions. For AWS Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams, AWS Step Functions state machines and API Gateway REST APIs, EventBridge relies on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code> . For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication and Access Control</a> in the <em>Amazon EventBridge User Guide</em> .
     * <p>
     * If another AWS account is in the same region and has granted you permission (using <code>PutPermission</code> ), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when you run <code>PutTargets</code> . If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a> .
     * <p>
     * <blockquote>
     * <p>
     * <code>Input</code> , <code>InputPath</code> , and <code>InputTransformer</code> are not available with <code>PutTarget</code> if the target is an event bus of a different AWS account.
     * <p>
     * </blockquote>
     * <p>
     * If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between AWS Accounts</a> in the <em>Amazon EventBridge User Guide</em> .
     * <p>
     * For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a> .
     * <p>
     * <em>Input</em> , <em>InputPath</em> , and <em>InputTransformer</em> are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:
     * <p>
     * <ul>
     * <li>If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).</li>
     * <li>If <em>Input</em> is specified in the form of valid JSON, then the matched event is overridden with this constant.</li>
     * <li>If <em>InputPath</em> is specified in the form of JSONPath (for example, <code>$.detail</code> ), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).</li>
     * <li>If <em>InputTransformer</em> is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.</li>
     * </ul>
     * <p>
     * When you specify <code>InputPath</code> or <code>InputTransformer</code> , you must use JSON dot notation, not bracket notation.
     * <p>
     * When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.
     * <p>
     * This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRuleProps> {
        java.lang.String description;
        java.lang.String eventBusName;
        java.lang.Object eventPattern;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.String scheduleExpression;
        java.lang.String state;
        java.lang.Object targets;

        /**
         * Sets the value of {@link CfnRuleProps#getDescription}
         * @param description The description of the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getEventBusName}
         * @param eventBusName The name or ARN of the event bus associated with the rule.
         *                     If you omit this, the default event bus is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBusName(java.lang.String eventBusName) {
            this.eventBusName = eventBusName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getEventPattern}
         * @param eventPattern The event pattern of the rule.
         *                     For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <em>Amazon EventBridge User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPattern(java.lang.Object eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getName}
         * @param name The name of the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the role that is used for target invocation.
         *                If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getScheduleExpression}
         * @param scheduleExpression The scheduling expression.
         *                           For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html">Creating an Amazon EventBridge rule that runs on a schedule</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(java.lang.String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getState}
         * @param state The state of the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getTargets}
         * @param targets Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
         *                Targets are the resources that are invoked when a rule is triggered.
         *                <p>
         *                <blockquote>
         *                <p>
         *                Each rule can have up to five (5) targets associated with it at one time.
         *                <p>
         *                </blockquote>
         *                <p>
         *                You can configure the following as targets for Events:
         *                <p>
         *                <ul>
         *                <li><a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API destination</a></li>
         *                <li>Amazon API Gateway REST API endpoints</li>
         *                <li>API Gateway</li>
         *                <li>AWS Batch job queue</li>
         *                <li>CloudWatch Logs group</li>
         *                <li>CodeBuild project</li>
         *                <li>CodePipeline</li>
         *                <li>Amazon EC2 <code>CreateSnapshot</code> API call</li>
         *                <li>EC2 Image Builder</li>
         *                <li>Amazon EC2 <code>RebootInstances</code> API call</li>
         *                <li>Amazon EC2 <code>StopInstances</code> API call</li>
         *                <li>Amazon EC2 <code>TerminateInstances</code> API call</li>
         *                <li>Amazon ECS tasks</li>
         *                <li>Event bus in a different AWS account or Region.</li>
         *                </ul>
         *                <p>
         *                You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.
         *                <p>
         *                <ul>
         *                <li>Firehose delivery stream (Kinesis Data Firehose)</li>
         *                <li>Inspector assessment template (Amazon Inspector)</li>
         *                <li>Kinesis stream (Kinesis Data Stream)</li>
         *                <li>AWS Lambda function</li>
         *                <li>Redshift clusters (Data API statement execution)</li>
         *                <li>Amazon SNS topic</li>
         *                <li>Amazon SQS queues (includes FIFO queues)</li>
         *                <li>SSM Automation</li>
         *                <li>SSM OpsItem</li>
         *                <li>SSM Run Command</li>
         *                <li>Step Functions state machines</li>
         *                </ul>
         *                <p>
         *                Creating rules with built-in targets is supported only in the AWS Management Console . The built-in targets are <code>EC2 CreateSnapshot API call</code> , <code>EC2 RebootInstances API call</code> , <code>EC2 StopInstances API call</code> , and <code>EC2 TerminateInstances API call</code> .
         *                <p>
         *                For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code> argument. To invoke a command on multiple EC2 instances with one rule, you can use the <code>RunCommandParameters</code> field.
         *                <p>
         *                To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions. For AWS Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams, AWS Step Functions state machines and API Gateway REST APIs, EventBridge relies on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code> . For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication and Access Control</a> in the <em>Amazon EventBridge User Guide</em> .
         *                <p>
         *                If another AWS account is in the same region and has granted you permission (using <code>PutPermission</code> ), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when you run <code>PutTargets</code> . If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                <code>Input</code> , <code>InputPath</code> , and <code>InputTransformer</code> are not available with <code>PutTarget</code> if the target is an event bus of a different AWS account.
         *                <p>
         *                </blockquote>
         *                <p>
         *                If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between AWS Accounts</a> in the <em>Amazon EventBridge User Guide</em> .
         *                <p>
         *                For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a> .
         *                <p>
         *                <em>Input</em> , <em>InputPath</em> , and <em>InputTransformer</em> are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:
         *                <p>
         *                <ul>
         *                <li>If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).</li>
         *                <li>If <em>Input</em> is specified in the form of valid JSON, then the matched event is overridden with this constant.</li>
         *                <li>If <em>InputPath</em> is specified in the form of JSONPath (for example, <code>$.detail</code> ), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).</li>
         *                <li>If <em>InputTransformer</em> is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.</li>
         *                </ul>
         *                <p>
         *                When you specify <code>InputPath</code> or <code>InputTransformer</code> , you must use JSON dot notation, not bracket notation.
         *                <p>
         *                When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.
         *                <p>
         *                This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.IResolvable targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getTargets}
         * @param targets Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
         *                Targets are the resources that are invoked when a rule is triggered.
         *                <p>
         *                <blockquote>
         *                <p>
         *                Each rule can have up to five (5) targets associated with it at one time.
         *                <p>
         *                </blockquote>
         *                <p>
         *                You can configure the following as targets for Events:
         *                <p>
         *                <ul>
         *                <li><a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API destination</a></li>
         *                <li>Amazon API Gateway REST API endpoints</li>
         *                <li>API Gateway</li>
         *                <li>AWS Batch job queue</li>
         *                <li>CloudWatch Logs group</li>
         *                <li>CodeBuild project</li>
         *                <li>CodePipeline</li>
         *                <li>Amazon EC2 <code>CreateSnapshot</code> API call</li>
         *                <li>EC2 Image Builder</li>
         *                <li>Amazon EC2 <code>RebootInstances</code> API call</li>
         *                <li>Amazon EC2 <code>StopInstances</code> API call</li>
         *                <li>Amazon EC2 <code>TerminateInstances</code> API call</li>
         *                <li>Amazon ECS tasks</li>
         *                <li>Event bus in a different AWS account or Region.</li>
         *                </ul>
         *                <p>
         *                You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.
         *                <p>
         *                <ul>
         *                <li>Firehose delivery stream (Kinesis Data Firehose)</li>
         *                <li>Inspector assessment template (Amazon Inspector)</li>
         *                <li>Kinesis stream (Kinesis Data Stream)</li>
         *                <li>AWS Lambda function</li>
         *                <li>Redshift clusters (Data API statement execution)</li>
         *                <li>Amazon SNS topic</li>
         *                <li>Amazon SQS queues (includes FIFO queues)</li>
         *                <li>SSM Automation</li>
         *                <li>SSM OpsItem</li>
         *                <li>SSM Run Command</li>
         *                <li>Step Functions state machines</li>
         *                </ul>
         *                <p>
         *                Creating rules with built-in targets is supported only in the AWS Management Console . The built-in targets are <code>EC2 CreateSnapshot API call</code> , <code>EC2 RebootInstances API call</code> , <code>EC2 StopInstances API call</code> , and <code>EC2 TerminateInstances API call</code> .
         *                <p>
         *                For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code> argument. To invoke a command on multiple EC2 instances with one rule, you can use the <code>RunCommandParameters</code> field.
         *                <p>
         *                To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions. For AWS Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams, AWS Step Functions state machines and API Gateway REST APIs, EventBridge relies on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code> . For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication and Access Control</a> in the <em>Amazon EventBridge User Guide</em> .
         *                <p>
         *                If another AWS account is in the same region and has granted you permission (using <code>PutPermission</code> ), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when you run <code>PutTargets</code> . If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                <code>Input</code> , <code>InputPath</code> , and <code>InputTransformer</code> are not available with <code>PutTarget</code> if the target is an event bus of a different AWS account.
         *                <p>
         *                </blockquote>
         *                <p>
         *                If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between AWS Accounts</a> in the <em>Amazon EventBridge User Guide</em> .
         *                <p>
         *                For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a> .
         *                <p>
         *                <em>Input</em> , <em>InputPath</em> , and <em>InputTransformer</em> are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:
         *                <p>
         *                <ul>
         *                <li>If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).</li>
         *                <li>If <em>Input</em> is specified in the form of valid JSON, then the matched event is overridden with this constant.</li>
         *                <li>If <em>InputPath</em> is specified in the form of JSONPath (for example, <code>$.detail</code> ), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).</li>
         *                <li>If <em>InputTransformer</em> is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.</li>
         *                </ul>
         *                <p>
         *                When you specify <code>InputPath</code> or <code>InputTransformer</code> , you must use JSON dot notation, not bracket notation.
         *                <p>
         *                When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.
         *                <p>
         *                This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<? extends java.lang.Object> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRuleProps {
        private final java.lang.String description;
        private final java.lang.String eventBusName;
        private final java.lang.Object eventPattern;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.String scheduleExpression;
        private final java.lang.String state;
        private final java.lang.Object targets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventBusName = software.amazon.jsii.Kernel.get(this, "eventBusName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.eventBusName = builder.eventBusName;
            this.eventPattern = builder.eventPattern;
            this.name = builder.name;
            this.roleArn = builder.roleArn;
            this.scheduleExpression = builder.scheduleExpression;
            this.state = builder.state;
            this.targets = builder.targets;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEventBusName() {
            return this.eventBusName;
        }

        @Override
        public final java.lang.Object getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.lang.Object getTargets() {
            return this.targets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEventBusName() != null) {
                data.set("eventBusName", om.valueToTree(this.getEventBusName()));
            }
            if (this.getEventPattern() != null) {
                data.set("eventPattern", om.valueToTree(this.getEventPattern()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getScheduleExpression() != null) {
                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.CfnRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRuleProps.Jsii$Proxy that = (CfnRuleProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.eventBusName != null ? !this.eventBusName.equals(that.eventBusName) : that.eventBusName != null) return false;
            if (this.eventPattern != null ? !this.eventPattern.equals(that.eventPattern) : that.eventPattern != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.scheduleExpression != null ? !this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.eventBusName != null ? this.eventBusName.hashCode() : 0);
            result = 31 * result + (this.eventPattern != null ? this.eventPattern.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            return result;
        }
    }
}
