package software.amazon.awscdk.services.eks;

/**
 * Kubernetes cluster version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster = Cluster.Builder.create(this, "HelloEKS")
 *         .version(KubernetesVersion.V1_21)
 *         .defaultCapacityType(DefaultCapacityType.EC2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:09.808Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubernetesVersion")
public class KubernetesVersion extends software.amazon.jsii.JsiiObject {

    protected KubernetesVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KubernetesVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        V1_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
        V1_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesVersion.class, "V1_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
    }

    /**
     * Custom cluster version.
     * <p>
     * @param version custom version number. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesVersion of(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.KubernetesVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Kubernetes version 1.14.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_14;

    /**
     * Kubernetes version 1.15.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_15;

    /**
     * Kubernetes version 1.16.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_16;

    /**
     * Kubernetes version 1.17.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_17;

    /**
     * Kubernetes version 1.18.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_18;

    /**
     * Kubernetes version 1.19.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_19;

    /**
     * Kubernetes version 1.20.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_20;

    /**
     * Kubernetes version 1.21.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.KubernetesVersion V1_21;

    /**
     * cluster version number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
