package software.amazon.awscdk.services.eks;

/**
 * Construct an Amazon Linux 2 image from the latest EKS Optimized AMI published in SSM.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * EksOptimizedImage eksOptimizedImage = EksOptimizedImage.Builder.create()
 *         .cpuArch(CpuArch.ARM_64)
 *         .kubernetesVersion("kubernetesVersion")
 *         .nodeType(NodeType.STANDARD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:09.775Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.EksOptimizedImage")
public class EksOptimizedImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected EksOptimizedImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EksOptimizedImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the EcsOptimizedAmi class.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EksOptimizedImage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.EksOptimizedImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     * Constructs a new instance of the EcsOptimizedAmi class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EksOptimizedImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Return the correct image.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.EksOptimizedImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.EksOptimizedImage> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.eks.EksOptimizedImageProps.Builder props;

        private Builder() {
        }

        /**
         * What cpu architecture to retrieve the image for (arm64 or x86_64).
         * <p>
         * Default: CpuArch.X86_64
         * <p>
         * @return {@code this}
         * @param cpuArch What cpu architecture to retrieve the image for (arm64 or x86_64). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuArch(final software.amazon.awscdk.services.eks.CpuArch cpuArch) {
            this.props().cpuArch(cpuArch);
            return this;
        }

        /**
         * The Kubernetes version to use.
         * <p>
         * Default: - The latest version
         * <p>
         * @return {@code this}
         * @param kubernetesVersion The Kubernetes version to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubernetesVersion(final java.lang.String kubernetesVersion) {
            this.props().kubernetesVersion(kubernetesVersion);
            return this;
        }

        /**
         * What instance type to retrieve the image for (standard or GPU-optimized).
         * <p>
         * Default: NodeType.STANDARD
         * <p>
         * @return {@code this}
         * @param nodeType What instance type to retrieve the image for (standard or GPU-optimized). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeType(final software.amazon.awscdk.services.eks.NodeType nodeType) {
            this.props().nodeType(nodeType);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.EksOptimizedImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.EksOptimizedImage build() {
            return new software.amazon.awscdk.services.eks.EksOptimizedImage(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.eks.EksOptimizedImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.eks.EksOptimizedImageProps.Builder();
            }
            return this.props;
        }
    }
}
