package software.amazon.awscdk.services.eks;

/**
 * Capacity type of the managed node group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addNodegroupCapacity("extra-ng-spot", NodegroupOptions.builder()
 *         .instanceTypes(List.of(
 *             new InstanceType("c5.large"),
 *             new InstanceType("c5a.large"),
 *             new InstanceType("c5d.large")))
 *         .minSize(3)
 *         .capacityType(CapacityType.SPOT)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:09.740Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CapacityType")
public enum CapacityType {
    /**
     * spot instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SPOT,
    /**
     * on-demand instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ON_DEMAND,
}
