package software.amazon.awscdk.services.efs;

/**
 * Permissions as POSIX ACL.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.efs.*;
 * // create a new VPC
 * Vpc vpc = new Vpc(this, "VPC");
 * // create a new Amazon EFS filesystem
 * FileSystem fileSystem = FileSystem.Builder.create(this, "Efs").vpc(vpc).build();
 * // create a new access point from the filesystem
 * AccessPoint accessPoint = fileSystem.addAccessPoint("AccessPoint", AccessPointOptions.builder()
 *         // set /export/lambda as the root of the access point
 *         .path("/export/lambda")
 *         // as /export/lambda does not exist in a new efs filesystem, the efs will create the directory with the following createAcl
 *         .createAcl(Acl.builder()
 *                 .ownerUid("1001")
 *                 .ownerGid("1001")
 *                 .permissions("750")
 *                 .build())
 *         // enforce the POSIX identity so lambda function will access with this identity
 *         .posixUser(PosixUser.builder()
 *                 .uid("1001")
 *                 .gid("1001")
 *                 .build())
 *         .build());
 * Function fn = Function.Builder.create(this, "MyLambda")
 *         // mount the access point to /mnt/msg in the lambda runtime environment
 *         .filesystem(FileSystem.fromEfsAccessPoint(accessPoint, "/mnt/msg"))
 *         .runtime(Runtime.NODEJS_12_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:09.693Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.Acl")
@software.amazon.jsii.Jsii.Proxy(Acl.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Acl extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the POSIX group ID to apply to the RootDirectory.
     * <p>
     * Accepts values from 0 to 2^32 (4294967295).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOwnerGid();

    /**
     * Specifies the POSIX user ID to apply to the RootDirectory.
     * <p>
     * Accepts values from 0 to 2^32 (4294967295).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOwnerUid();

    /**
     * Specifies the POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPermissions();

    /**
     * @return a {@link Builder} of {@link Acl}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Acl}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Acl> {
        java.lang.String ownerGid;
        java.lang.String ownerUid;
        java.lang.String permissions;

        /**
         * Sets the value of {@link Acl#getOwnerGid}
         * @param ownerGid Specifies the POSIX group ID to apply to the RootDirectory. This parameter is required.
         *                 Accepts values from 0 to 2^32 (4294967295).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerGid(java.lang.String ownerGid) {
            this.ownerGid = ownerGid;
            return this;
        }

        /**
         * Sets the value of {@link Acl#getOwnerUid}
         * @param ownerUid Specifies the POSIX user ID to apply to the RootDirectory. This parameter is required.
         *                 Accepts values from 0 to 2^32 (4294967295).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerUid(java.lang.String ownerUid) {
            this.ownerUid = ownerUid;
            return this;
        }

        /**
         * Sets the value of {@link Acl#getPermissions}
         * @param permissions Specifies the POSIX permissions to apply to the RootDirectory, in the format of an octal number representing the file's mode bits. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.lang.String permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Acl}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Acl build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Acl}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Acl {
        private final java.lang.String ownerGid;
        private final java.lang.String ownerUid;
        private final java.lang.String permissions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ownerGid = software.amazon.jsii.Kernel.get(this, "ownerGid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ownerUid = software.amazon.jsii.Kernel.get(this, "ownerUid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ownerGid = java.util.Objects.requireNonNull(builder.ownerGid, "ownerGid is required");
            this.ownerUid = java.util.Objects.requireNonNull(builder.ownerUid, "ownerUid is required");
            this.permissions = java.util.Objects.requireNonNull(builder.permissions, "permissions is required");
        }

        @Override
        public final java.lang.String getOwnerGid() {
            return this.ownerGid;
        }

        @Override
        public final java.lang.String getOwnerUid() {
            return this.ownerUid;
        }

        @Override
        public final java.lang.String getPermissions() {
            return this.permissions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ownerGid", om.valueToTree(this.getOwnerGid()));
            data.set("ownerUid", om.valueToTree(this.getOwnerUid()));
            data.set("permissions", om.valueToTree(this.getPermissions()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.Acl"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Acl.Jsii$Proxy that = (Acl.Jsii$Proxy) o;

            if (!ownerGid.equals(that.ownerGid)) return false;
            if (!ownerUid.equals(that.ownerUid)) return false;
            return this.permissions.equals(that.permissions);
        }

        @Override
        public final int hashCode() {
            int result = this.ownerGid.hashCode();
            result = 31 * result + (this.ownerUid.hashCode());
            result = 31 * result + (this.permissions.hashCode());
            return result;
        }
    }
}
