package software.amazon.awscdk.services.ecs.patterns;

/**
 * The base class for ScheduledEc2Task and ScheduledFargateTask tasks.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:09.687Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ScheduledTaskBase")
public abstract class ScheduledTaskBase extends software.constructs.Construct {

    protected ScheduledTaskBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledTaskBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ScheduledTaskBase class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ScheduledTaskBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds task as a target of the scheduled event rule.
     * <p>
     * @param ecsTaskTarget the EcsTask to add to the event rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addTaskAsTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.EcsTask ecsTaskTarget) {
        software.amazon.jsii.Kernel.call(this, "addTaskAsTarget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(ecsTaskTarget, "ecsTaskTarget is required") });
    }

    /**
     * Create an ECS task using the task definition provided and add it to the scheduled event rule.
     * <p>
     * @param taskDefinition the TaskDefinition to add to the event rule. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.EcsTask addTaskDefinitionToEventTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
        return software.amazon.jsii.Kernel.call(this, "addTaskDefinitionToEventTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.targets.EcsTask.class), new Object[] { java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required") });
    }

    /**
     * Create an AWS Log Driver with the provided streamPrefix.
     * <p>
     * @param prefix the Cloudwatch logging prefix. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AwsLogDriver createAWSLogDriver(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.Kernel.call(this, "createAWSLogDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AwsLogDriver.class), new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     * @param vpc
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc vpc) {
        return software.amazon.jsii.Kernel.call(this, "getDefaultCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Cluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), vpc });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getDefaultCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Cluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * The name of the cluster that hosts the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
    }

    /**
     * The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * The minimum value is 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getDesiredTaskCount() {
        return software.amazon.jsii.Kernel.get(this, "desiredTaskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The CloudWatch Events rule for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule getEventRule() {
        return software.amazon.jsii.Kernel.get(this, "eventRule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class));
    }

    /**
     * In what subnets to place the task's ENIs.
     * <p>
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     * <p>
     * Default: Private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBase implements software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
