package software.amazon.awscdk.services.ecs;

/**
 * An image hosted in a public or private repository.
 * <p>
 * For images hosted in Amazon ECR, see
 * <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/images.html">EcrImage</a>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.batch.*;
 * import software.amazon.awscdk.services.ecs.ContainerImage;
 * Object jobQueue = JobQueue.Builder.create(this, "MyQueue")
 *         .computeEnvironments(List.of(Map.of(
 *                 "computeEnvironment", ComputeEnvironment.Builder.create(this, "ComputeEnvironment")
 *                         .managed(false)
 *                         .build(),
 *                 "order", 1)))
 *         .build();
 * Object jobDefinition = JobDefinition.Builder.create(this, "MyJob")
 *         .container(Map.of(
 *                 "image", ContainerImage.fromRegistry("test-repo")))
 *         .build();
 * Queue queue = new Queue(this, "Queue");
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.hours(1)))
 *         .build();
 * rule.addTarget(BatchJob.Builder.create(jobQueue.getJobQueueArn(), jobQueue, jobDefinition.getJobDefinitionArn(), jobDefinition)
 *         .deadLetterQueue(queue)
 *         .event(RuleTargetInput.fromObject(Map.of("SomeParam", "SomeValue")))
 *         .retryAttempts(2)
 *         .maxEventAge(Duration.hours(2))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:09.598Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.RepositoryImage")
public class RepositoryImage extends software.amazon.awscdk.services.ecs.ContainerImage {

    protected RepositoryImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RepositoryImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the RepositoryImage class.
     * <p>
     * @param imageName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RepositoryImage(final @org.jetbrains.annotations.NotNull java.lang.String imageName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.RepositoryImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(imageName, "imageName is required"), props });
    }

    /**
     * Constructs a new instance of the RepositoryImage class.
     * <p>
     * @param imageName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RepositoryImage(final @org.jetbrains.annotations.NotNull java.lang.String imageName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(imageName, "imageName is required") });
    }

    /**
     * Called when the image is used by a ContainerDefinition.
     * <p>
     * @param scope This parameter is required.
     * @param containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImageConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(containerDefinition, "containerDefinition is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.RepositoryImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.RepositoryImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param imageName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String imageName) {
            return new Builder(imageName);
        }

        private final java.lang.String imageName;
        private software.amazon.awscdk.services.ecs.RepositoryImageProps.Builder props;

        private Builder(final java.lang.String imageName) {
            this.imageName = imageName;
        }

        /**
         * The secret to expose to the container that contains the credentials for the image repository.
         * <p>
         * The supported value is the full ARN of an AWS Secrets Manager secret.
         * <p>
         * @return {@code this}
         * @param credentials The secret to expose to the container that contains the credentials for the image repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.secretsmanager.ISecret credentials) {
            this.props().credentials(credentials);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.RepositoryImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.RepositoryImage build() {
            return new software.amazon.awscdk.services.ecs.RepositoryImage(
                this.imageName,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.RepositoryImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.RepositoryImageProps.Builder();
            }
            return this.props;
        }
    }
}
