package software.amazon.awscdk.services.dynamodb;

/**
 * What kind of server-side encryption to apply to this table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "MyTable")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .encryption(TableEncryption.CUSTOMER_MANAGED)
 *         .build();
 * // You can access the CMK that was added to the stack on your behalf by the Table construct via:
 * IKey tableEncryptionKey = table.getEncryptionKey();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.923Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableEncryption")
public enum TableEncryption {
    /**
     * Server-side KMS encryption with a master key owned by AWS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * Server-side KMS encryption with a customer master key managed by customer.
     * <p>
     * If <code>encryptionKey</code> is specified, this key will be used, otherwise, one will be defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CUSTOMER_MANAGED,
    /**
     * Server-side KMS encryption with a master key managed by AWS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_MANAGED,
}
