package software.amazon.awscdk.services.dms;

/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 * <p>
 * The <code>AWS::DMS::Endpoint</code> resource creates an AWS DMS endpoint.
 * <p>
 * Currently, the only endpoint setting types that AWS CloudFormation supports are <em>DynamoDBSettings</em> , <em>ElasticSearchSettings</em> , and <em>NeptuneSettings</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnEndpoint cfnEndpoint = CfnEndpoint.Builder.create(this, "MyCfnEndpoint")
 *         .endpointType("endpointType")
 *         .engineName("engineName")
 *         // the properties below are optional
 *         .certificateArn("certificateArn")
 *         .databaseName("databaseName")
 *         .docDbSettings(DocDbSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .dynamoDbSettings(DynamoDbSettingsProperty.builder()
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .elasticsearchSettings(ElasticsearchSettingsProperty.builder()
 *                 .endpointUri("endpointUri")
 *                 .errorRetryDuration(123)
 *                 .fullLoadErrorPercentage(123)
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .endpointIdentifier("endpointIdentifier")
 *         .extraConnectionAttributes("extraConnectionAttributes")
 *         .gcpMySqlSettings(GcpMySQLSettingsProperty.builder()
 *                 .afterConnectScript("afterConnectScript")
 *                 .cleanSourceMetadataOnMismatch(false)
 *                 .databaseName("databaseName")
 *                 .eventsPollInterval(123)
 *                 .maxFileSize(123)
 *                 .parallelLoadThreads(123)
 *                 .password("password")
 *                 .port(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .serverTimezone("serverTimezone")
 *                 .username("username")
 *                 .build())
 *         .ibmDb2Settings(IbmDb2SettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .kafkaSettings(KafkaSettingsProperty.builder()
 *                 .broker("broker")
 *                 .includeControlDetails(false)
 *                 .includeNullAndEmpty(false)
 *                 .includeTableAlterOperations(false)
 *                 .includeTransactionDetails(false)
 *                 .noHexPrefix(false)
 *                 .partitionIncludeSchemaTable(false)
 *                 .saslPassword("saslPassword")
 *                 .saslUserName("saslUserName")
 *                 .securityProtocol("securityProtocol")
 *                 .sslCaCertificateArn("sslCaCertificateArn")
 *                 .sslClientCertificateArn("sslClientCertificateArn")
 *                 .sslClientKeyArn("sslClientKeyArn")
 *                 .sslClientKeyPassword("sslClientKeyPassword")
 *                 .topic("topic")
 *                 .build())
 *         .kinesisSettings(KinesisSettingsProperty.builder()
 *                 .includeControlDetails(false)
 *                 .includeNullAndEmpty(false)
 *                 .includeTableAlterOperations(false)
 *                 .includeTransactionDetails(false)
 *                 .messageFormat("messageFormat")
 *                 .noHexPrefix(false)
 *                 .partitionIncludeSchemaTable(false)
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .streamArn("streamArn")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .microsoftSqlServerSettings(MicrosoftSqlServerSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .mongoDbSettings(MongoDbSettingsProperty.builder()
 *                 .authMechanism("authMechanism")
 *                 .authSource("authSource")
 *                 .authType("authType")
 *                 .databaseName("databaseName")
 *                 .docsToInvestigate("docsToInvestigate")
 *                 .extractDocId("extractDocId")
 *                 .nestingLevel("nestingLevel")
 *                 .password("password")
 *                 .port(123)
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .serverName("serverName")
 *                 .username("username")
 *                 .build())
 *         .mySqlSettings(MySqlSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .neptuneSettings(NeptuneSettingsProperty.builder()
 *                 .errorRetryDuration(123)
 *                 .iamAuthEnabled(false)
 *                 .maxFileSize(123)
 *                 .maxRetryCount(123)
 *                 .s3BucketFolder("s3BucketFolder")
 *                 .s3BucketName("s3BucketName")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .oracleSettings(OracleSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
 *                 .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .password("password")
 *         .port(123)
 *         .postgreSqlSettings(PostgreSqlSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .redisSettings(RedisSettingsProperty.builder()
 *                 .authPassword("authPassword")
 *                 .authType("authType")
 *                 .authUserName("authUserName")
 *                 .port(123)
 *                 .serverName("serverName")
 *                 .sslCaCertificateArn("sslCaCertificateArn")
 *                 .sslSecurityProtocol("sslSecurityProtocol")
 *                 .build())
 *         .redshiftSettings(RedshiftSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .resourceIdentifier("resourceIdentifier")
 *         .s3Settings(S3SettingsProperty.builder()
 *                 .bucketFolder("bucketFolder")
 *                 .bucketName("bucketName")
 *                 .compressionType("compressionType")
 *                 .csvDelimiter("csvDelimiter")
 *                 .csvRowDelimiter("csvRowDelimiter")
 *                 .externalTableDefinition("externalTableDefinition")
 *                 .serviceAccessRoleArn("serviceAccessRoleArn")
 *                 .build())
 *         .serverName("serverName")
 *         .sslMode("sslMode")
 *         .sybaseSettings(SybaseSettingsProperty.builder()
 *                 .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
 *                 .secretsManagerSecretId("secretsManagerSecretId")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .username("username")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.807Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint")
public class CfnEndpoint extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dms.CfnEndpoint.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DMS::Endpoint`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEndpoint(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dms.CfnEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A value that can be used for cross-account validation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrExternalId() {
        return software.amazon.jsii.Kernel.get(this, "attrExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * One or more tags to be assigned to the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The type of endpoint.
     * <p>
     * Valid values are <code>source</code> and <code>target</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpointType() {
        return software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of endpoint.
     * <p>
     * Valid values are <code>source</code> and <code>target</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointType", java.util.Objects.requireNonNull(value, "endpointType is required"));
    }

    /**
     * The type of engine for the endpoint.
     * <p>
     * Valid values, depending on the <code>EndpointType</code> value, include <code>"mysql"</code> , <code>"oracle"</code> , <code>"postgres"</code> , <code>"mariadb"</code> , <code>"aurora"</code> , <code>"aurora-postgresql"</code> , <code>"opensearch"</code> , <code>"redshift"</code> , <code>"s3"</code> , <code>"db2"</code> , <code>"azuredb"</code> , <code>"sybase"</code> , <code>"dynamodb"</code> , <code>"mongodb"</code> , <code>"kinesis"</code> , <code>"kafka"</code> , <code>"elasticsearch"</code> , <code>"docdb"</code> , <code>"sqlserver"</code> , and <code>"neptune"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngineName() {
        return software.amazon.jsii.Kernel.get(this, "engineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of engine for the endpoint.
     * <p>
     * Valid values, depending on the <code>EndpointType</code> value, include <code>"mysql"</code> , <code>"oracle"</code> , <code>"postgres"</code> , <code>"mariadb"</code> , <code>"aurora"</code> , <code>"aurora-postgresql"</code> , <code>"opensearch"</code> , <code>"redshift"</code> , <code>"s3"</code> , <code>"db2"</code> , <code>"azuredb"</code> , <code>"sybase"</code> , <code>"dynamodb"</code> , <code>"mongodb"</code> , <code>"kinesis"</code> , <code>"kafka"</code> , <code>"elasticsearch"</code> , <code>"docdb"</code> , <code>"sqlserver"</code> , and <code>"neptune"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineName", java.util.Objects.requireNonNull(value, "engineName is required"));
    }

    /**
     * The Amazon Resource Name (ARN) for the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateArn", value);
    }

    /**
     * The name of the endpoint database.
     * <p>
     * For a MySQL source or target endpoint, do not specify DatabaseName. To migrate to a specific database, use this setting and <code>targetDbType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint database.
     * <p>
     * For a MySQL source or target endpoint, do not specify DatabaseName. To migrate to a specific database, use this setting and <code>targetDbType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }

    /**
     * Settings in JSON format for the source DocumentDB endpoint.
     * <p>
     * For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html">Using DocumentDB as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDocDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "docDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source DocumentDB endpoint.
     * <p>
     * For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html">Using DocumentDB as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.DocDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "docDbSettings", value);
    }

    /**
     * Settings in JSON format for the source DocumentDB endpoint.
     * <p>
     * For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html">Using DocumentDB as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "docDbSettings", value);
    }

    /**
     * Settings in JSON format for the target Amazon DynamoDB endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "dynamoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target Amazon DynamoDB endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDynamoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.DynamoDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "dynamoDbSettings", value);
    }

    /**
     * Settings in JSON format for the target Amazon DynamoDB endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDynamoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dynamoDbSettings", value);
    }

    /**
     * Settings in JSON format for the target OpenSearch endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchSettings() {
        return software.amazon.jsii.Kernel.get(this, "elasticsearchSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target OpenSearch endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.ElasticsearchSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchSettings", value);
    }

    /**
     * Settings in JSON format for the target OpenSearch endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchSettings", value);
    }

    /**
     * The database endpoint identifier.
     * <p>
     * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "endpointIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The database endpoint identifier.
     * <p>
     * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointIdentifier", value);
    }

    /**
     * Additional attributes associated with the connection.
     * <p>
     * Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with AWS DMS Endpoints</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExtraConnectionAttributes() {
        return software.amazon.jsii.Kernel.get(this, "extraConnectionAttributes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Additional attributes associated with the connection.
     * <p>
     * Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with AWS DMS Endpoints</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtraConnectionAttributes(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "extraConnectionAttributes", value);
    }

    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGcpMySqlSettings() {
        return software.amazon.jsii.Kernel.get(this, "gcpMySqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGcpMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.GcpMySQLSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "gcpMySqlSettings", value);
    }

    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGcpMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gcpMySqlSettings", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIbmDb2Settings() {
        return software.amazon.jsii.Kernel.get(this, "ibmDb2Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIbmDb2Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.IbmDb2SettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "ibmDb2Settings", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIbmDb2Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ibmDb2Settings", value);
    }

    /**
     * Settings in JSON format for the target Apache Kafka endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKafkaSettings() {
        return software.amazon.jsii.Kernel.get(this, "kafkaSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target Apache Kafka endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.KafkaSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "kafkaSettings", value);
    }

    /**
     * Settings in JSON format for the target Apache Kafka endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kafkaSettings", value);
    }

    /**
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis Data Streams as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisSettings() {
        return software.amazon.jsii.Kernel.get(this, "kinesisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis Data Streams as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.KinesisSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisSettings", value);
    }

    /**
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis Data Streams as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisSettings", value);
    }

    /**
     * An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint.
     * <p>
     * If you don't specify a value for the <code>KmsKeyId</code> parameter, then AWS DMS uses your default encryption key.
     * <p>
     * AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Region .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint.
     * <p>
     * If you don't specify a value for the <code>KmsKeyId</code> parameter, then AWS DMS uses your default encryption key.
     * <p>
     * AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Region .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMicrosoftSqlServerSettings() {
        return software.amazon.jsii.Kernel.get(this, "microsoftSqlServerSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMicrosoftSqlServerSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "microsoftSqlServerSettings", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMicrosoftSqlServerSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "microsoftSqlServerSettings", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMongoDbSettings() {
        return software.amazon.jsii.Kernel.get(this, "mongoDbSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMongoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MongoDbSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mongoDbSettings", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMongoDbSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mongoDbSettings", value);
    }

    /**
     * Settings in JSON format for the source and target MySQL endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMySqlSettings() {
        return software.amazon.jsii.Kernel.get(this, "mySqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target MySQL endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.MySqlSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mySqlSettings", value);
    }

    /**
     * Settings in JSON format for the source and target MySQL endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMySqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mySqlSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNeptuneSettings() {
        return software.amazon.jsii.Kernel.get(this, "neptuneSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNeptuneSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.NeptuneSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "neptuneSettings", value);
    }

    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNeptuneSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "neptuneSettings", value);
    }

    /**
     * Settings in JSON format for the source and target Oracle endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOracleSettings() {
        return software.amazon.jsii.Kernel.get(this, "oracleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target Oracle endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOracleSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "oracleSettings", value);
    }

    /**
     * Settings in JSON format for the source and target Oracle endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOracleSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "oracleSettings", value);
    }

    /**
     * The password to be used to log in to the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password to be used to log in to the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "password", value);
    }

    /**
     * The port used by the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port used by the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPostgreSqlSettings() {
        return software.amazon.jsii.Kernel.get(this, "postgreSqlSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostgreSqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "postgreSqlSettings", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPostgreSqlSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "postgreSqlSettings", value);
    }

    /**
     * Settings in JSON format for the target Redis endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedisSettings() {
        return software.amazon.jsii.Kernel.get(this, "redisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target Redis endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.RedisSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "redisSettings", value);
    }

    /**
     * Settings in JSON format for the target Redis endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedisSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redisSettings", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftSettings() {
        return software.amazon.jsii.Kernel.get(this, "redshiftSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.RedshiftSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "redshiftSettings", value);
    }

    /**
     * Not currently supported by AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redshiftSettings", value);
    }

    /**
     * A friendly name for the resource identifier at the end of the `EndpointArn` response parameter that is returned in the created `Endpoint` object.
     * <p>
     * The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code> . For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code> . If you don't specify a <code>ResourceIdentifier</code> value, AWS DMS generates a default identifier value for the end of <code>EndpointArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly name for the resource identifier at the end of the `EndpointArn` response parameter that is returned in the created `Endpoint` object.
     * <p>
     * The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code> . For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code> . If you don't specify a <code>ResourceIdentifier</code> value, AWS DMS generates a default identifier value for the end of <code>EndpointArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceIdentifier", value);
    }

    /**
     * Settings in JSON format for the target Amazon S3 endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3Settings() {
        return software.amazon.jsii.Kernel.get(this, "s3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the target Amazon S3 endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.S3SettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3Settings", value);
    }

    /**
     * Settings in JSON format for the target Amazon S3 endpoint.
     * <p>
     * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3Settings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3Settings", value);
    }

    /**
     * The name of the server where the endpoint database resides.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
        return software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the server where the endpoint database resides.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverName", value);
    }

    /**
     * The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is `none` .
     * <p>
     * <blockquote>
     * <p>
     * When <code>engine_name</code> is set to S3, then the only allowed value is <code>none</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSslMode() {
        return software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is `none` .
     * <p>
     * <blockquote>
     * <p>
     * When <code>engine_name</code> is set to S3, then the only allowed value is <code>none</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSslMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sslMode", value);
    }

    /**
     * Settings in JSON format for the source and target SAP ASE endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSybaseSettings() {
        return software.amazon.jsii.Kernel.get(this, "sybaseSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings in JSON format for the source and target SAP ASE endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSybaseSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnEndpoint.SybaseSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "sybaseSettings", value);
    }

    /**
     * Settings in JSON format for the source and target SAP ASE endpoint.
     * <p>
     * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSybaseSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sybaseSettings", value);
    }

    /**
     * The user name to be used to log in to the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
        return software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user name to be used to log in to the endpoint database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "username", value);
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DocDbSettingsProperty docDbSettingsProperty = DocDbSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.DocDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DocDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocDbSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link DocDbSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link DocDbSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocDbSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.DocDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocDbSettingsProperty.Jsii$Proxy that = (DocDbSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role used to define an Amazon DynamoDB target endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DynamoDbSettingsProperty dynamoDbSettingsProperty = DynamoDbSettingsProperty.builder()
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.DynamoDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDbSettingsProperty> {
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link DynamoDbSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn The Amazon Resource Name (ARN) used by the service to access the IAM role.
             *                             The role must allow the <code>iam:PassRole</code> action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDbSettingsProperty {
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.DynamoDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDbSettingsProperty.Jsii$Proxy that = (DynamoDbSettingsProperty.Jsii$Proxy) o;

                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides information that defines an OpenSearch endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * ElasticsearchSettingsProperty elasticsearchSettingsProperty = ElasticsearchSettingsProperty.builder()
     *         .endpointUri("endpointUri")
     *         .errorRetryDuration(123)
     *         .fullLoadErrorPercentage(123)
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.ElasticsearchSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint for the OpenSearch cluster.
         * <p>
         * AWS DMS uses HTTPS if a transport protocol (http/https) is not specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointUri() {
            return null;
        }

        /**
         * The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorRetryDuration() {
            return null;
        }

        /**
         * The maximum percentage of records that can fail to be written before a full load operation stops.
         * <p>
         * To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch also has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records fail in the last 10 minutes, the full load operation stops.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFullLoadErrorPercentage() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchSettingsProperty> {
            java.lang.String endpointUri;
            java.lang.Number errorRetryDuration;
            java.lang.Number fullLoadErrorPercentage;
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getEndpointUri}
             * @param endpointUri The endpoint for the OpenSearch cluster.
             *                    AWS DMS uses HTTPS if a transport protocol (http/https) is not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointUri(java.lang.String endpointUri) {
                this.endpointUri = endpointUri;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getErrorRetryDuration}
             * @param errorRetryDuration The maximum number of seconds for which DMS retries failed API requests to the OpenSearch cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorRetryDuration(java.lang.Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getFullLoadErrorPercentage}
             * @param fullLoadErrorPercentage The maximum percentage of records that can fail to be written before a full load operation stops.
             *                                To avoid early failure, this counter is only effective after 1000 records are transferred. OpenSearch also has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records fail in the last 10 minutes, the full load operation stops.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fullLoadErrorPercentage(java.lang.Number fullLoadErrorPercentage) {
                this.fullLoadErrorPercentage = fullLoadErrorPercentage;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn The Amazon Resource Name (ARN) used by the service to access the IAM role.
             *                             The role must allow the <code>iam:PassRole</code> action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchSettingsProperty {
            private final java.lang.String endpointUri;
            private final java.lang.Number errorRetryDuration;
            private final java.lang.Number fullLoadErrorPercentage;
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointUri = software.amazon.jsii.Kernel.get(this, "endpointUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorRetryDuration = software.amazon.jsii.Kernel.get(this, "errorRetryDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fullLoadErrorPercentage = software.amazon.jsii.Kernel.get(this, "fullLoadErrorPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointUri = builder.endpointUri;
                this.errorRetryDuration = builder.errorRetryDuration;
                this.fullLoadErrorPercentage = builder.fullLoadErrorPercentage;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getEndpointUri() {
                return this.endpointUri;
            }

            @Override
            public final java.lang.Number getErrorRetryDuration() {
                return this.errorRetryDuration;
            }

            @Override
            public final java.lang.Number getFullLoadErrorPercentage() {
                return this.fullLoadErrorPercentage;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEndpointUri() != null) {
                    data.set("endpointUri", om.valueToTree(this.getEndpointUri()));
                }
                if (this.getErrorRetryDuration() != null) {
                    data.set("errorRetryDuration", om.valueToTree(this.getErrorRetryDuration()));
                }
                if (this.getFullLoadErrorPercentage() != null) {
                    data.set("fullLoadErrorPercentage", om.valueToTree(this.getFullLoadErrorPercentage()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.ElasticsearchSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchSettingsProperty.Jsii$Proxy that = (ElasticsearchSettingsProperty.Jsii$Proxy) o;

                if (this.endpointUri != null ? !this.endpointUri.equals(that.endpointUri) : that.endpointUri != null) return false;
                if (this.errorRetryDuration != null ? !this.errorRetryDuration.equals(that.errorRetryDuration) : that.errorRetryDuration != null) return false;
                if (this.fullLoadErrorPercentage != null ? !this.fullLoadErrorPercentage.equals(that.fullLoadErrorPercentage) : that.fullLoadErrorPercentage != null) return false;
                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointUri != null ? this.endpointUri.hashCode() : 0;
                result = 31 * result + (this.errorRetryDuration != null ? this.errorRetryDuration.hashCode() : 0);
                result = 31 * result + (this.fullLoadErrorPercentage != null ? this.fullLoadErrorPercentage.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * GcpMySQLSettingsProperty gcpMySQLSettingsProperty = GcpMySQLSettingsProperty.builder()
     *         .afterConnectScript("afterConnectScript")
     *         .cleanSourceMetadataOnMismatch(false)
     *         .databaseName("databaseName")
     *         .eventsPollInterval(123)
     *         .maxFileSize(123)
     *         .parallelLoadThreads(123)
     *         .password("password")
     *         .port(123)
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .serverName("serverName")
     *         .serverTimezone("serverTimezone")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.GcpMySQLSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(GcpMySQLSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GcpMySQLSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a script to run immediately after AWS DMS connects to the endpoint.
         * <p>
         * The migration task continues running regardless if the SQL statement succeeds or fails.
         * <p>
         * For this parameter, provide the code of the script itself, not the name of a file containing the script.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAfterConnectScript() {
            return null;
        }

        /**
         * Adjusts the behavior of AWS DMS when migrating from an SQL Server source database that is hosted as part of an Always On availability group cluster.
         * <p>
         * If you need AWS DMS to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCleanSourceMetadataOnMismatch() {
            return null;
        }

        /**
         * Database name for the endpoint.
         * <p>
         * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the AWS DMS task.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * Specifies how often to check the binary log for new changes/events when the database is idle.
         * <p>
         * The default is five seconds.
         * <p>
         * Example: <code>eventsPollInterval=5;</code>
         * <p>
         * In the example, AWS DMS checks for changes in the binary logs every five seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEventsPollInterval() {
            return null;
        }

        /**
         * Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.
         * <p>
         * Example: <code>maxFileSize=512</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * Improves performance when loading data into the MySQL-compatible target database.
         * <p>
         * Specifies how many threads to use to load the data into the MySQL-compatible target database. Setting a large number of threads can have an adverse effect on database performance, because a separate connection is required for each thread. The default is one.
         * <p>
         * Example: <code>parallelLoadThreads=1</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParallelLoadThreads() {
            return null;
        }

        /**
         * Endpoint connection password.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * `CfnEndpoint.GcpMySQLSettingsProperty.Port`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret.` The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the AWS Secrets Manager secret that allows access to the MySQL endpoint.
         * <p>
         * <blockquote>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the AWS Database Migration Service User Guide.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the MySQL endpoint connection details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * Endpoint TCP port.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * Specifies the time zone for the source MySQL database.
         * <p>
         * Example: <code>serverTimezone=US/Pacific;</code>
         * <p>
         * Note: Do not enclose time zones in single quotes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerTimezone() {
            return null;
        }

        /**
         * Endpoint connection user name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GcpMySQLSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GcpMySQLSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GcpMySQLSettingsProperty> {
            java.lang.String afterConnectScript;
            java.lang.Object cleanSourceMetadataOnMismatch;
            java.lang.String databaseName;
            java.lang.Number eventsPollInterval;
            java.lang.Number maxFileSize;
            java.lang.Number parallelLoadThreads;
            java.lang.String password;
            java.lang.Number port;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String serverName;
            java.lang.String serverTimezone;
            java.lang.String username;

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getAfterConnectScript}
             * @param afterConnectScript Specifies a script to run immediately after AWS DMS connects to the endpoint.
             *                           The migration task continues running regardless if the SQL statement succeeds or fails.
             *                           <p>
             *                           For this parameter, provide the code of the script itself, not the name of a file containing the script.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder afterConnectScript(java.lang.String afterConnectScript) {
                this.afterConnectScript = afterConnectScript;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getCleanSourceMetadataOnMismatch}
             * @param cleanSourceMetadataOnMismatch Adjusts the behavior of AWS DMS when migrating from an SQL Server source database that is hosted as part of an Always On availability group cluster.
             *                                      If you need AWS DMS to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cleanSourceMetadataOnMismatch(java.lang.Boolean cleanSourceMetadataOnMismatch) {
                this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getCleanSourceMetadataOnMismatch}
             * @param cleanSourceMetadataOnMismatch Adjusts the behavior of AWS DMS when migrating from an SQL Server source database that is hosted as part of an Always On availability group cluster.
             *                                      If you need AWS DMS to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cleanSourceMetadataOnMismatch(software.amazon.awscdk.IResolvable cleanSourceMetadataOnMismatch) {
                this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getDatabaseName}
             * @param databaseName Database name for the endpoint.
             *                     For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the AWS DMS task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getEventsPollInterval}
             * @param eventsPollInterval Specifies how often to check the binary log for new changes/events when the database is idle.
             *                           The default is five seconds.
             *                           <p>
             *                           Example: <code>eventsPollInterval=5;</code>
             *                           <p>
             *                           In the example, AWS DMS checks for changes in the binary logs every five seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventsPollInterval(java.lang.Number eventsPollInterval) {
                this.eventsPollInterval = eventsPollInterval;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getMaxFileSize}
             * @param maxFileSize Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.
             *                    Example: <code>maxFileSize=512</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getParallelLoadThreads}
             * @param parallelLoadThreads Improves performance when loading data into the MySQL-compatible target database.
             *                            Specifies how many threads to use to load the data into the MySQL-compatible target database. Setting a large number of threads can have an adverse effect on database performance, because a separate connection is required for each thread. The default is one.
             *                            <p>
             *                            Example: <code>parallelLoadThreads=1</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelLoadThreads(java.lang.Number parallelLoadThreads) {
                this.parallelLoadThreads = parallelLoadThreads;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getPassword}
             * @param password Endpoint connection password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getPort}
             * @param port `CfnEndpoint.GcpMySQLSettingsProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret.` The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the AWS Secrets Manager secret that allows access to the MySQL endpoint.
             *                                    <blockquote>
             *                                    <p>
             *                                    You can specify one of two sets of values for these permissions. You can specify the values for this setting and <code>SecretsManagerSecretId</code> . Or you can specify clear-text values for <code>UserName</code> , <code>Password</code> , <code>ServerName</code> , and <code>Port</code> . You can't specify both. For more information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access AWS Database Migration Service resources</a> in the AWS Database Migration Service User Guide.
             *                                    <p>
             *                                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the MySQL endpoint connection details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getServerName}
             * @param serverName Endpoint TCP port.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getServerTimezone}
             * @param serverTimezone Specifies the time zone for the source MySQL database.
             *                       Example: <code>serverTimezone=US/Pacific;</code>
             *                       <p>
             *                       Note: Do not enclose time zones in single quotes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverTimezone(java.lang.String serverTimezone) {
                this.serverTimezone = serverTimezone;
                return this;
            }

            /**
             * Sets the value of {@link GcpMySQLSettingsProperty#getUsername}
             * @param username Endpoint connection user name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GcpMySQLSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GcpMySQLSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GcpMySQLSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GcpMySQLSettingsProperty {
            private final java.lang.String afterConnectScript;
            private final java.lang.Object cleanSourceMetadataOnMismatch;
            private final java.lang.String databaseName;
            private final java.lang.Number eventsPollInterval;
            private final java.lang.Number maxFileSize;
            private final java.lang.Number parallelLoadThreads;
            private final java.lang.String password;
            private final java.lang.Number port;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String serverName;
            private final java.lang.String serverTimezone;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.afterConnectScript = software.amazon.jsii.Kernel.get(this, "afterConnectScript", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cleanSourceMetadataOnMismatch = software.amazon.jsii.Kernel.get(this, "cleanSourceMetadataOnMismatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventsPollInterval = software.amazon.jsii.Kernel.get(this, "eventsPollInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.parallelLoadThreads = software.amazon.jsii.Kernel.get(this, "parallelLoadThreads", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverTimezone = software.amazon.jsii.Kernel.get(this, "serverTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.afterConnectScript = builder.afterConnectScript;
                this.cleanSourceMetadataOnMismatch = builder.cleanSourceMetadataOnMismatch;
                this.databaseName = builder.databaseName;
                this.eventsPollInterval = builder.eventsPollInterval;
                this.maxFileSize = builder.maxFileSize;
                this.parallelLoadThreads = builder.parallelLoadThreads;
                this.password = builder.password;
                this.port = builder.port;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.serverName = builder.serverName;
                this.serverTimezone = builder.serverTimezone;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getAfterConnectScript() {
                return this.afterConnectScript;
            }

            @Override
            public final java.lang.Object getCleanSourceMetadataOnMismatch() {
                return this.cleanSourceMetadataOnMismatch;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getEventsPollInterval() {
                return this.eventsPollInterval;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Number getParallelLoadThreads() {
                return this.parallelLoadThreads;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getServerTimezone() {
                return this.serverTimezone;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAfterConnectScript() != null) {
                    data.set("afterConnectScript", om.valueToTree(this.getAfterConnectScript()));
                }
                if (this.getCleanSourceMetadataOnMismatch() != null) {
                    data.set("cleanSourceMetadataOnMismatch", om.valueToTree(this.getCleanSourceMetadataOnMismatch()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getEventsPollInterval() != null) {
                    data.set("eventsPollInterval", om.valueToTree(this.getEventsPollInterval()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getParallelLoadThreads() != null) {
                    data.set("parallelLoadThreads", om.valueToTree(this.getParallelLoadThreads()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getServerTimezone() != null) {
                    data.set("serverTimezone", om.valueToTree(this.getServerTimezone()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.GcpMySQLSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GcpMySQLSettingsProperty.Jsii$Proxy that = (GcpMySQLSettingsProperty.Jsii$Proxy) o;

                if (this.afterConnectScript != null ? !this.afterConnectScript.equals(that.afterConnectScript) : that.afterConnectScript != null) return false;
                if (this.cleanSourceMetadataOnMismatch != null ? !this.cleanSourceMetadataOnMismatch.equals(that.cleanSourceMetadataOnMismatch) : that.cleanSourceMetadataOnMismatch != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.eventsPollInterval != null ? !this.eventsPollInterval.equals(that.eventsPollInterval) : that.eventsPollInterval != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.parallelLoadThreads != null ? !this.parallelLoadThreads.equals(that.parallelLoadThreads) : that.parallelLoadThreads != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                if (this.serverTimezone != null ? !this.serverTimezone.equals(that.serverTimezone) : that.serverTimezone != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.afterConnectScript != null ? this.afterConnectScript.hashCode() : 0;
                result = 31 * result + (this.cleanSourceMetadataOnMismatch != null ? this.cleanSourceMetadataOnMismatch.hashCode() : 0);
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.eventsPollInterval != null ? this.eventsPollInterval.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.parallelLoadThreads != null ? this.parallelLoadThreads.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.serverTimezone != null ? this.serverTimezone.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * IbmDb2SettingsProperty ibmDb2SettingsProperty = IbmDb2SettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.IbmDb2SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(IbmDb2SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IbmDb2SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IbmDb2SettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link IbmDb2SettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IbmDb2SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IbmDb2SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IbmDb2SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IbmDb2SettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.IbmDb2SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IbmDb2SettingsProperty.Jsii$Proxy that = (IbmDb2SettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * KafkaSettingsProperty kafkaSettingsProperty = KafkaSettingsProperty.builder()
     *         .broker("broker")
     *         .includeControlDetails(false)
     *         .includeNullAndEmpty(false)
     *         .includeTableAlterOperations(false)
     *         .includeTransactionDetails(false)
     *         .noHexPrefix(false)
     *         .partitionIncludeSchemaTable(false)
     *         .saslPassword("saslPassword")
     *         .saslUserName("saslUserName")
     *         .securityProtocol("securityProtocol")
     *         .sslCaCertificateArn("sslCaCertificateArn")
     *         .sslClientCertificateArn("sslClientCertificateArn")
     *         .sslClientKeyArn("sslClientKeyArn")
     *         .sslClientKeyPassword("sslClientKeyPassword")
     *         .topic("topic")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.KafkaSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBroker() {
            return null;
        }

        /**
         * Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output.
         * <p>
         * The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeControlDetails() {
            return null;
        }

        /**
         * Include NULL and empty columns for records migrated to the endpoint.
         * <p>
         * The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeNullAndEmpty() {
            return null;
        }

        /**
         * Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table` , `drop-table` , `add-column` , `drop-column` , and `rename-column` .
         * <p>
         * The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTableAlterOperations() {
            return null;
        }

        /**
         * Provides detailed transaction information from the source database.
         * <p>
         * This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTransactionDetails() {
            return null;
        }

        /**
         * Set this optional parameter to `true` to avoid adding a '0x' prefix to raw data in hexadecimal format.
         * <p>
         * For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoHexPrefix() {
            return null;
        }

        /**
         * Prefixes schema and table names to partition values, when the partition type is `primary-key-type` .
         * <p>
         * Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartitionIncludeSchemaTable() {
            return null;
        }

        /**
         * The secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslPassword() {
            return null;
        }

        /**
         * The secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSaslUserName() {
            return null;
        }

        /**
         * Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS).
         * <p>
         * Options include <code>ssl-encryption</code> , <code>ssl-authentication</code> , and <code>sasl-ssl</code> . <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityProtocol() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslCaCertificateArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientCertificateArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientKeyArn() {
            return null;
        }

        /**
         * The password for the client private key used to securely connect to a Kafka target endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslClientKeyPassword() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaSettingsProperty> {
            java.lang.String broker;
            java.lang.Object includeControlDetails;
            java.lang.Object includeNullAndEmpty;
            java.lang.Object includeTableAlterOperations;
            java.lang.Object includeTransactionDetails;
            java.lang.Object noHexPrefix;
            java.lang.Object partitionIncludeSchemaTable;
            java.lang.String saslPassword;
            java.lang.String saslUserName;
            java.lang.String securityProtocol;
            java.lang.String sslCaCertificateArn;
            java.lang.String sslClientCertificateArn;
            java.lang.String sslClientKeyArn;
            java.lang.String sslClientKeyPassword;
            java.lang.String topic;

            /**
             * Sets the value of {@link KafkaSettingsProperty#getBroker}
             * @param broker Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder broker(java.lang.String broker) {
                this.broker = broker;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output.
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(java.lang.Boolean includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output.
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(software.amazon.awscdk.IResolvable includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint.
             *                            The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(java.lang.Boolean includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint.
             *                            The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(software.amazon.awscdk.IResolvable includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table` , `drop-table` , `add-column` , `drop-column` , and `rename-column` .
             *                                    The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(java.lang.Boolean includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table` , `drop-table` , `add-column` , `drop-column` , and `rename-column` .
             *                                    The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(software.amazon.awscdk.IResolvable includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails Provides detailed transaction information from the source database.
             *                                  This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(java.lang.Boolean includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails Provides detailed transaction information from the source database.
             *                                  This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(software.amazon.awscdk.IResolvable includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix Set this optional parameter to `true` to avoid adding a '0x' prefix to raw data in hexadecimal format.
             *                    For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(java.lang.Boolean noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix Set this optional parameter to `true` to avoid adding a '0x' prefix to raw data in hexadecimal format.
             *                    For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(software.amazon.awscdk.IResolvable noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is `primary-key-type` .
             *                                    Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(java.lang.Boolean partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is `primary-key-type` .
             *                                    Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(software.amazon.awscdk.IResolvable partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSaslPassword}
             * @param saslPassword The secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslPassword(java.lang.String saslPassword) {
                this.saslPassword = saslPassword;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSaslUserName}
             * @param saslUserName The secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder saslUserName(java.lang.String saslUserName) {
                this.saslUserName = saslUserName;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSecurityProtocol}
             * @param securityProtocol Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS).
             *                         Options include <code>ssl-encryption</code> , <code>ssl-authentication</code> , and <code>sasl-ssl</code> . <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityProtocol(java.lang.String securityProtocol) {
                this.securityProtocol = securityProtocol;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslCaCertificateArn}
             * @param sslCaCertificateArn The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCaCertificateArn(java.lang.String sslCaCertificateArn) {
                this.sslCaCertificateArn = sslCaCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientCertificateArn}
             * @param sslClientCertificateArn The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientCertificateArn(java.lang.String sslClientCertificateArn) {
                this.sslClientCertificateArn = sslClientCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientKeyArn}
             * @param sslClientKeyArn The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientKeyArn(java.lang.String sslClientKeyArn) {
                this.sslClientKeyArn = sslClientKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getSslClientKeyPassword}
             * @param sslClientKeyPassword The password for the client private key used to securely connect to a Kafka target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslClientKeyPassword(java.lang.String sslClientKeyPassword) {
                this.sslClientKeyPassword = sslClientKeyPassword;
                return this;
            }

            /**
             * Sets the value of {@link KafkaSettingsProperty#getTopic}
             * @param topic Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaSettingsProperty {
            private final java.lang.String broker;
            private final java.lang.Object includeControlDetails;
            private final java.lang.Object includeNullAndEmpty;
            private final java.lang.Object includeTableAlterOperations;
            private final java.lang.Object includeTransactionDetails;
            private final java.lang.Object noHexPrefix;
            private final java.lang.Object partitionIncludeSchemaTable;
            private final java.lang.String saslPassword;
            private final java.lang.String saslUserName;
            private final java.lang.String securityProtocol;
            private final java.lang.String sslCaCertificateArn;
            private final java.lang.String sslClientCertificateArn;
            private final java.lang.String sslClientKeyArn;
            private final java.lang.String sslClientKeyPassword;
            private final java.lang.String topic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.broker = software.amazon.jsii.Kernel.get(this, "broker", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeControlDetails = software.amazon.jsii.Kernel.get(this, "includeControlDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeNullAndEmpty = software.amazon.jsii.Kernel.get(this, "includeNullAndEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTableAlterOperations = software.amazon.jsii.Kernel.get(this, "includeTableAlterOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTransactionDetails = software.amazon.jsii.Kernel.get(this, "includeTransactionDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noHexPrefix = software.amazon.jsii.Kernel.get(this, "noHexPrefix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionIncludeSchemaTable = software.amazon.jsii.Kernel.get(this, "partitionIncludeSchemaTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.saslPassword = software.amazon.jsii.Kernel.get(this, "saslPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.saslUserName = software.amazon.jsii.Kernel.get(this, "saslUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityProtocol = software.amazon.jsii.Kernel.get(this, "securityProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslCaCertificateArn = software.amazon.jsii.Kernel.get(this, "sslCaCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientCertificateArn = software.amazon.jsii.Kernel.get(this, "sslClientCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientKeyArn = software.amazon.jsii.Kernel.get(this, "sslClientKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslClientKeyPassword = software.amazon.jsii.Kernel.get(this, "sslClientKeyPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.broker = builder.broker;
                this.includeControlDetails = builder.includeControlDetails;
                this.includeNullAndEmpty = builder.includeNullAndEmpty;
                this.includeTableAlterOperations = builder.includeTableAlterOperations;
                this.includeTransactionDetails = builder.includeTransactionDetails;
                this.noHexPrefix = builder.noHexPrefix;
                this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
                this.saslPassword = builder.saslPassword;
                this.saslUserName = builder.saslUserName;
                this.securityProtocol = builder.securityProtocol;
                this.sslCaCertificateArn = builder.sslCaCertificateArn;
                this.sslClientCertificateArn = builder.sslClientCertificateArn;
                this.sslClientKeyArn = builder.sslClientKeyArn;
                this.sslClientKeyPassword = builder.sslClientKeyPassword;
                this.topic = builder.topic;
            }

            @Override
            public final java.lang.String getBroker() {
                return this.broker;
            }

            @Override
            public final java.lang.Object getIncludeControlDetails() {
                return this.includeControlDetails;
            }

            @Override
            public final java.lang.Object getIncludeNullAndEmpty() {
                return this.includeNullAndEmpty;
            }

            @Override
            public final java.lang.Object getIncludeTableAlterOperations() {
                return this.includeTableAlterOperations;
            }

            @Override
            public final java.lang.Object getIncludeTransactionDetails() {
                return this.includeTransactionDetails;
            }

            @Override
            public final java.lang.Object getNoHexPrefix() {
                return this.noHexPrefix;
            }

            @Override
            public final java.lang.Object getPartitionIncludeSchemaTable() {
                return this.partitionIncludeSchemaTable;
            }

            @Override
            public final java.lang.String getSaslPassword() {
                return this.saslPassword;
            }

            @Override
            public final java.lang.String getSaslUserName() {
                return this.saslUserName;
            }

            @Override
            public final java.lang.String getSecurityProtocol() {
                return this.securityProtocol;
            }

            @Override
            public final java.lang.String getSslCaCertificateArn() {
                return this.sslCaCertificateArn;
            }

            @Override
            public final java.lang.String getSslClientCertificateArn() {
                return this.sslClientCertificateArn;
            }

            @Override
            public final java.lang.String getSslClientKeyArn() {
                return this.sslClientKeyArn;
            }

            @Override
            public final java.lang.String getSslClientKeyPassword() {
                return this.sslClientKeyPassword;
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBroker() != null) {
                    data.set("broker", om.valueToTree(this.getBroker()));
                }
                if (this.getIncludeControlDetails() != null) {
                    data.set("includeControlDetails", om.valueToTree(this.getIncludeControlDetails()));
                }
                if (this.getIncludeNullAndEmpty() != null) {
                    data.set("includeNullAndEmpty", om.valueToTree(this.getIncludeNullAndEmpty()));
                }
                if (this.getIncludeTableAlterOperations() != null) {
                    data.set("includeTableAlterOperations", om.valueToTree(this.getIncludeTableAlterOperations()));
                }
                if (this.getIncludeTransactionDetails() != null) {
                    data.set("includeTransactionDetails", om.valueToTree(this.getIncludeTransactionDetails()));
                }
                if (this.getNoHexPrefix() != null) {
                    data.set("noHexPrefix", om.valueToTree(this.getNoHexPrefix()));
                }
                if (this.getPartitionIncludeSchemaTable() != null) {
                    data.set("partitionIncludeSchemaTable", om.valueToTree(this.getPartitionIncludeSchemaTable()));
                }
                if (this.getSaslPassword() != null) {
                    data.set("saslPassword", om.valueToTree(this.getSaslPassword()));
                }
                if (this.getSaslUserName() != null) {
                    data.set("saslUserName", om.valueToTree(this.getSaslUserName()));
                }
                if (this.getSecurityProtocol() != null) {
                    data.set("securityProtocol", om.valueToTree(this.getSecurityProtocol()));
                }
                if (this.getSslCaCertificateArn() != null) {
                    data.set("sslCaCertificateArn", om.valueToTree(this.getSslCaCertificateArn()));
                }
                if (this.getSslClientCertificateArn() != null) {
                    data.set("sslClientCertificateArn", om.valueToTree(this.getSslClientCertificateArn()));
                }
                if (this.getSslClientKeyArn() != null) {
                    data.set("sslClientKeyArn", om.valueToTree(this.getSslClientKeyArn()));
                }
                if (this.getSslClientKeyPassword() != null) {
                    data.set("sslClientKeyPassword", om.valueToTree(this.getSslClientKeyPassword()));
                }
                if (this.getTopic() != null) {
                    data.set("topic", om.valueToTree(this.getTopic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.KafkaSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaSettingsProperty.Jsii$Proxy that = (KafkaSettingsProperty.Jsii$Proxy) o;

                if (this.broker != null ? !this.broker.equals(that.broker) : that.broker != null) return false;
                if (this.includeControlDetails != null ? !this.includeControlDetails.equals(that.includeControlDetails) : that.includeControlDetails != null) return false;
                if (this.includeNullAndEmpty != null ? !this.includeNullAndEmpty.equals(that.includeNullAndEmpty) : that.includeNullAndEmpty != null) return false;
                if (this.includeTableAlterOperations != null ? !this.includeTableAlterOperations.equals(that.includeTableAlterOperations) : that.includeTableAlterOperations != null) return false;
                if (this.includeTransactionDetails != null ? !this.includeTransactionDetails.equals(that.includeTransactionDetails) : that.includeTransactionDetails != null) return false;
                if (this.noHexPrefix != null ? !this.noHexPrefix.equals(that.noHexPrefix) : that.noHexPrefix != null) return false;
                if (this.partitionIncludeSchemaTable != null ? !this.partitionIncludeSchemaTable.equals(that.partitionIncludeSchemaTable) : that.partitionIncludeSchemaTable != null) return false;
                if (this.saslPassword != null ? !this.saslPassword.equals(that.saslPassword) : that.saslPassword != null) return false;
                if (this.saslUserName != null ? !this.saslUserName.equals(that.saslUserName) : that.saslUserName != null) return false;
                if (this.securityProtocol != null ? !this.securityProtocol.equals(that.securityProtocol) : that.securityProtocol != null) return false;
                if (this.sslCaCertificateArn != null ? !this.sslCaCertificateArn.equals(that.sslCaCertificateArn) : that.sslCaCertificateArn != null) return false;
                if (this.sslClientCertificateArn != null ? !this.sslClientCertificateArn.equals(that.sslClientCertificateArn) : that.sslClientCertificateArn != null) return false;
                if (this.sslClientKeyArn != null ? !this.sslClientKeyArn.equals(that.sslClientKeyArn) : that.sslClientKeyArn != null) return false;
                if (this.sslClientKeyPassword != null ? !this.sslClientKeyPassword.equals(that.sslClientKeyPassword) : that.sslClientKeyPassword != null) return false;
                return this.topic != null ? this.topic.equals(that.topic) : that.topic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.broker != null ? this.broker.hashCode() : 0;
                result = 31 * result + (this.includeControlDetails != null ? this.includeControlDetails.hashCode() : 0);
                result = 31 * result + (this.includeNullAndEmpty != null ? this.includeNullAndEmpty.hashCode() : 0);
                result = 31 * result + (this.includeTableAlterOperations != null ? this.includeTableAlterOperations.hashCode() : 0);
                result = 31 * result + (this.includeTransactionDetails != null ? this.includeTransactionDetails.hashCode() : 0);
                result = 31 * result + (this.noHexPrefix != null ? this.noHexPrefix.hashCode() : 0);
                result = 31 * result + (this.partitionIncludeSchemaTable != null ? this.partitionIncludeSchemaTable.hashCode() : 0);
                result = 31 * result + (this.saslPassword != null ? this.saslPassword.hashCode() : 0);
                result = 31 * result + (this.saslUserName != null ? this.saslUserName.hashCode() : 0);
                result = 31 * result + (this.securityProtocol != null ? this.securityProtocol.hashCode() : 0);
                result = 31 * result + (this.sslCaCertificateArn != null ? this.sslCaCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslClientCertificateArn != null ? this.sslClientCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslClientKeyArn != null ? this.sslClientKeyArn.hashCode() : 0);
                result = 31 * result + (this.sslClientKeyPassword != null ? this.sslClientKeyPassword.hashCode() : 0);
                result = 31 * result + (this.topic != null ? this.topic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation ..
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * KinesisSettingsProperty kinesisSettingsProperty = KinesisSettingsProperty.builder()
     *         .includeControlDetails(false)
     *         .includeNullAndEmpty(false)
     *         .includeTableAlterOperations(false)
     *         .includeTransactionDetails(false)
     *         .messageFormat("messageFormat")
     *         .noHexPrefix(false)
     *         .partitionIncludeSchemaTable(false)
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .streamArn("streamArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.KinesisSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output.
         * <p>
         * The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeControlDetails() {
            return null;
        }

        /**
         * Include NULL and empty columns for records migrated to the endpoint.
         * <p>
         * The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeNullAndEmpty() {
            return null;
        }

        /**
         * Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table` , `drop-table` , `add-column` , `drop-column` , and `rename-column` .
         * <p>
         * The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTableAlterOperations() {
            return null;
        }

        /**
         * Provides detailed transaction information from the source database.
         * <p>
         * This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeTransactionDetails() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageFormat() {
            return null;
        }

        /**
         * Set this optional parameter to `true` to avoid adding a '0x' prefix to raw data in hexadecimal format.
         * <p>
         * For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoHexPrefix() {
            return null;
        }

        /**
         * Prefixes schema and table names to partition values, when the partition type is `primary-key-type` .
         * <p>
         * Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which causes throttling. The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartitionIncludeSchemaTable() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisSettingsProperty> {
            java.lang.Object includeControlDetails;
            java.lang.Object includeNullAndEmpty;
            java.lang.Object includeTableAlterOperations;
            java.lang.Object includeTransactionDetails;
            java.lang.String messageFormat;
            java.lang.Object noHexPrefix;
            java.lang.Object partitionIncludeSchemaTable;
            java.lang.String serviceAccessRoleArn;
            java.lang.String streamArn;

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output.
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(java.lang.Boolean includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeControlDetails}
             * @param includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kinesis message output.
             *                              The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeControlDetails(software.amazon.awscdk.IResolvable includeControlDetails) {
                this.includeControlDetails = includeControlDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint.
             *                            The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(java.lang.Boolean includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeNullAndEmpty}
             * @param includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint.
             *                            The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeNullAndEmpty(software.amazon.awscdk.IResolvable includeNullAndEmpty) {
                this.includeNullAndEmpty = includeNullAndEmpty;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table` , `drop-table` , `add-column` , `drop-column` , and `rename-column` .
             *                                    The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(java.lang.Boolean includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTableAlterOperations}
             * @param includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table` , `drop-table` , `add-column` , `drop-column` , and `rename-column` .
             *                                    The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTableAlterOperations(software.amazon.awscdk.IResolvable includeTableAlterOperations) {
                this.includeTableAlterOperations = includeTableAlterOperations;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails Provides detailed transaction information from the source database.
             *                                  This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(java.lang.Boolean includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getIncludeTransactionDetails}
             * @param includeTransactionDetails Provides detailed transaction information from the source database.
             *                                  This information includes a commit timestamp, a log position, and values for <code>transaction_id</code> , previous <code>transaction_id</code> , and <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeTransactionDetails(software.amazon.awscdk.IResolvable includeTransactionDetails) {
                this.includeTransactionDetails = includeTransactionDetails;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getMessageFormat}
             * @param messageFormat Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageFormat(java.lang.String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix Set this optional parameter to `true` to avoid adding a '0x' prefix to raw data in hexadecimal format.
             *                    For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(java.lang.Boolean noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getNoHexPrefix}
             * @param noHexPrefix Set this optional parameter to `true` to avoid adding a '0x' prefix to raw data in hexadecimal format.
             *                    For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding the '0x' prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noHexPrefix(software.amazon.awscdk.IResolvable noHexPrefix) {
                this.noHexPrefix = noHexPrefix;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is `primary-key-type` .
             *                                    Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which causes throttling. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(java.lang.Boolean partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getPartitionIncludeSchemaTable}
             * @param partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is `primary-key-type` .
             *                                    Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which causes throttling. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionIncludeSchemaTable(software.amazon.awscdk.IResolvable partitionIncludeSchemaTable) {
                this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisSettingsProperty#getStreamArn}
             * @param streamArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamArn(java.lang.String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisSettingsProperty {
            private final java.lang.Object includeControlDetails;
            private final java.lang.Object includeNullAndEmpty;
            private final java.lang.Object includeTableAlterOperations;
            private final java.lang.Object includeTransactionDetails;
            private final java.lang.String messageFormat;
            private final java.lang.Object noHexPrefix;
            private final java.lang.Object partitionIncludeSchemaTable;
            private final java.lang.String serviceAccessRoleArn;
            private final java.lang.String streamArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includeControlDetails = software.amazon.jsii.Kernel.get(this, "includeControlDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeNullAndEmpty = software.amazon.jsii.Kernel.get(this, "includeNullAndEmpty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTableAlterOperations = software.amazon.jsii.Kernel.get(this, "includeTableAlterOperations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeTransactionDetails = software.amazon.jsii.Kernel.get(this, "includeTransactionDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageFormat = software.amazon.jsii.Kernel.get(this, "messageFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.noHexPrefix = software.amazon.jsii.Kernel.get(this, "noHexPrefix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionIncludeSchemaTable = software.amazon.jsii.Kernel.get(this, "partitionIncludeSchemaTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamArn = software.amazon.jsii.Kernel.get(this, "streamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includeControlDetails = builder.includeControlDetails;
                this.includeNullAndEmpty = builder.includeNullAndEmpty;
                this.includeTableAlterOperations = builder.includeTableAlterOperations;
                this.includeTransactionDetails = builder.includeTransactionDetails;
                this.messageFormat = builder.messageFormat;
                this.noHexPrefix = builder.noHexPrefix;
                this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
                this.streamArn = builder.streamArn;
            }

            @Override
            public final java.lang.Object getIncludeControlDetails() {
                return this.includeControlDetails;
            }

            @Override
            public final java.lang.Object getIncludeNullAndEmpty() {
                return this.includeNullAndEmpty;
            }

            @Override
            public final java.lang.Object getIncludeTableAlterOperations() {
                return this.includeTableAlterOperations;
            }

            @Override
            public final java.lang.Object getIncludeTransactionDetails() {
                return this.includeTransactionDetails;
            }

            @Override
            public final java.lang.String getMessageFormat() {
                return this.messageFormat;
            }

            @Override
            public final java.lang.Object getNoHexPrefix() {
                return this.noHexPrefix;
            }

            @Override
            public final java.lang.Object getPartitionIncludeSchemaTable() {
                return this.partitionIncludeSchemaTable;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getStreamArn() {
                return this.streamArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludeControlDetails() != null) {
                    data.set("includeControlDetails", om.valueToTree(this.getIncludeControlDetails()));
                }
                if (this.getIncludeNullAndEmpty() != null) {
                    data.set("includeNullAndEmpty", om.valueToTree(this.getIncludeNullAndEmpty()));
                }
                if (this.getIncludeTableAlterOperations() != null) {
                    data.set("includeTableAlterOperations", om.valueToTree(this.getIncludeTableAlterOperations()));
                }
                if (this.getIncludeTransactionDetails() != null) {
                    data.set("includeTransactionDetails", om.valueToTree(this.getIncludeTransactionDetails()));
                }
                if (this.getMessageFormat() != null) {
                    data.set("messageFormat", om.valueToTree(this.getMessageFormat()));
                }
                if (this.getNoHexPrefix() != null) {
                    data.set("noHexPrefix", om.valueToTree(this.getNoHexPrefix()));
                }
                if (this.getPartitionIncludeSchemaTable() != null) {
                    data.set("partitionIncludeSchemaTable", om.valueToTree(this.getPartitionIncludeSchemaTable()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }
                if (this.getStreamArn() != null) {
                    data.set("streamArn", om.valueToTree(this.getStreamArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.KinesisSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisSettingsProperty.Jsii$Proxy that = (KinesisSettingsProperty.Jsii$Proxy) o;

                if (this.includeControlDetails != null ? !this.includeControlDetails.equals(that.includeControlDetails) : that.includeControlDetails != null) return false;
                if (this.includeNullAndEmpty != null ? !this.includeNullAndEmpty.equals(that.includeNullAndEmpty) : that.includeNullAndEmpty != null) return false;
                if (this.includeTableAlterOperations != null ? !this.includeTableAlterOperations.equals(that.includeTableAlterOperations) : that.includeTableAlterOperations != null) return false;
                if (this.includeTransactionDetails != null ? !this.includeTransactionDetails.equals(that.includeTransactionDetails) : that.includeTransactionDetails != null) return false;
                if (this.messageFormat != null ? !this.messageFormat.equals(that.messageFormat) : that.messageFormat != null) return false;
                if (this.noHexPrefix != null ? !this.noHexPrefix.equals(that.noHexPrefix) : that.noHexPrefix != null) return false;
                if (this.partitionIncludeSchemaTable != null ? !this.partitionIncludeSchemaTable.equals(that.partitionIncludeSchemaTable) : that.partitionIncludeSchemaTable != null) return false;
                if (this.serviceAccessRoleArn != null ? !this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn != null) return false;
                return this.streamArn != null ? this.streamArn.equals(that.streamArn) : that.streamArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includeControlDetails != null ? this.includeControlDetails.hashCode() : 0;
                result = 31 * result + (this.includeNullAndEmpty != null ? this.includeNullAndEmpty.hashCode() : 0);
                result = 31 * result + (this.includeTableAlterOperations != null ? this.includeTableAlterOperations.hashCode() : 0);
                result = 31 * result + (this.includeTransactionDetails != null ? this.includeTransactionDetails.hashCode() : 0);
                result = 31 * result + (this.messageFormat != null ? this.messageFormat.hashCode() : 0);
                result = 31 * result + (this.noHexPrefix != null ? this.noHexPrefix.hashCode() : 0);
                result = 31 * result + (this.partitionIncludeSchemaTable != null ? this.partitionIncludeSchemaTable.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.streamArn != null ? this.streamArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MicrosoftSqlServerSettingsProperty microsoftSqlServerSettingsProperty = MicrosoftSqlServerSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MicrosoftSqlServerSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MicrosoftSqlServerSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MicrosoftSqlServerSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MicrosoftSqlServerSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MicrosoftSqlServerSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MicrosoftSqlServerSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MicrosoftSqlServerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MicrosoftSqlServerSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MicrosoftSqlServerSettingsProperty.Jsii$Proxy that = (MicrosoftSqlServerSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MongoDbSettingsProperty mongoDbSettingsProperty = MongoDbSettingsProperty.builder()
     *         .authMechanism("authMechanism")
     *         .authSource("authSource")
     *         .authType("authType")
     *         .databaseName("databaseName")
     *         .docsToInvestigate("docsToInvestigate")
     *         .extractDocId("extractDocId")
     *         .nestingLevel("nestingLevel")
     *         .password("password")
     *         .port(123)
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .serverName("serverName")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.MongoDbSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MongoDbSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MongoDbSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthMechanism() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthSource() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocsToInvestigate() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExtractDocId() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNestingLevel() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MongoDbSettingsProperty> {
            java.lang.String authMechanism;
            java.lang.String authSource;
            java.lang.String authType;
            java.lang.String databaseName;
            java.lang.String docsToInvestigate;
            java.lang.String extractDocId;
            java.lang.String nestingLevel;
            java.lang.String password;
            java.lang.Number port;
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;
            java.lang.String serverName;
            java.lang.String username;

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthMechanism}
             * @param authMechanism Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authMechanism(java.lang.String authMechanism) {
                this.authMechanism = authMechanism;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthSource}
             * @param authSource Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authSource(java.lang.String authSource) {
                this.authSource = authSource;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getAuthType}
             * @param authType Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getDatabaseName}
             * @param databaseName Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getDocsToInvestigate}
             * @param docsToInvestigate Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder docsToInvestigate(java.lang.String docsToInvestigate) {
                this.docsToInvestigate = docsToInvestigate;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getExtractDocId}
             * @param extractDocId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extractDocId(java.lang.String extractDocId) {
                this.extractDocId = extractDocId;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getNestingLevel}
             * @param nestingLevel Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nestingLevel(java.lang.String nestingLevel) {
                this.nestingLevel = nestingLevel;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getPassword}
             * @param password Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getPort}
             * @param port Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getServerName}
             * @param serverName Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link MongoDbSettingsProperty#getUsername}
             * @param username Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MongoDbSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MongoDbSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MongoDbSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MongoDbSettingsProperty {
            private final java.lang.String authMechanism;
            private final java.lang.String authSource;
            private final java.lang.String authType;
            private final java.lang.String databaseName;
            private final java.lang.String docsToInvestigate;
            private final java.lang.String extractDocId;
            private final java.lang.String nestingLevel;
            private final java.lang.String password;
            private final java.lang.Number port;
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;
            private final java.lang.String serverName;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authMechanism = software.amazon.jsii.Kernel.get(this, "authMechanism", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authSource = software.amazon.jsii.Kernel.get(this, "authSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.docsToInvestigate = software.amazon.jsii.Kernel.get(this, "docsToInvestigate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.extractDocId = software.amazon.jsii.Kernel.get(this, "extractDocId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nestingLevel = software.amazon.jsii.Kernel.get(this, "nestingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authMechanism = builder.authMechanism;
                this.authSource = builder.authSource;
                this.authType = builder.authType;
                this.databaseName = builder.databaseName;
                this.docsToInvestigate = builder.docsToInvestigate;
                this.extractDocId = builder.extractDocId;
                this.nestingLevel = builder.nestingLevel;
                this.password = builder.password;
                this.port = builder.port;
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
                this.serverName = builder.serverName;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getAuthMechanism() {
                return this.authMechanism;
            }

            @Override
            public final java.lang.String getAuthSource() {
                return this.authSource;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getDocsToInvestigate() {
                return this.docsToInvestigate;
            }

            @Override
            public final java.lang.String getExtractDocId() {
                return this.extractDocId;
            }

            @Override
            public final java.lang.String getNestingLevel() {
                return this.nestingLevel;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthMechanism() != null) {
                    data.set("authMechanism", om.valueToTree(this.getAuthMechanism()));
                }
                if (this.getAuthSource() != null) {
                    data.set("authSource", om.valueToTree(this.getAuthSource()));
                }
                if (this.getAuthType() != null) {
                    data.set("authType", om.valueToTree(this.getAuthType()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getDocsToInvestigate() != null) {
                    data.set("docsToInvestigate", om.valueToTree(this.getDocsToInvestigate()));
                }
                if (this.getExtractDocId() != null) {
                    data.set("extractDocId", om.valueToTree(this.getExtractDocId()));
                }
                if (this.getNestingLevel() != null) {
                    data.set("nestingLevel", om.valueToTree(this.getNestingLevel()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.MongoDbSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MongoDbSettingsProperty.Jsii$Proxy that = (MongoDbSettingsProperty.Jsii$Proxy) o;

                if (this.authMechanism != null ? !this.authMechanism.equals(that.authMechanism) : that.authMechanism != null) return false;
                if (this.authSource != null ? !this.authSource.equals(that.authSource) : that.authSource != null) return false;
                if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.docsToInvestigate != null ? !this.docsToInvestigate.equals(that.docsToInvestigate) : that.docsToInvestigate != null) return false;
                if (this.extractDocId != null ? !this.extractDocId.equals(that.extractDocId) : that.extractDocId != null) return false;
                if (this.nestingLevel != null ? !this.nestingLevel.equals(that.nestingLevel) : that.nestingLevel != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerSecretId != null ? !this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authMechanism != null ? this.authMechanism.hashCode() : 0;
                result = 31 * result + (this.authSource != null ? this.authSource.hashCode() : 0);
                result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.docsToInvestigate != null ? this.docsToInvestigate.hashCode() : 0);
                result = 31 * result + (this.extractDocId != null ? this.extractDocId.hashCode() : 0);
                result = 31 * result + (this.nestingLevel != null ? this.nestingLevel.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * MySqlSettingsProperty mySqlSettingsProperty = MySqlSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.MySqlSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MySqlSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MySqlSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MySqlSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link MySqlSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MySqlSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MySqlSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MySqlSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MySqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MySqlSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.MySqlSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MySqlSettingsProperty.Jsii$Proxy that = (MySqlSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines an Amazon Neptune endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * NeptuneSettingsProperty neptuneSettingsProperty = NeptuneSettingsProperty.builder()
     *         .errorRetryDuration(123)
     *         .iamAuthEnabled(false)
     *         .maxFileSize(123)
     *         .maxRetryCount(123)
     *         .s3BucketFolder("s3BucketFolder")
     *         .s3BucketName("s3BucketName")
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.NeptuneSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(NeptuneSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NeptuneSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of milliseconds for AWS DMS to wait to retry a bulk-load of migrated graph data to the Neptune target database before raising an error.
         * <p>
         * The default is 250.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorRetryDuration() {
            return null;
        }

        /**
         * If you want AWS Identity and Access Management (IAM) authorization enabled for this endpoint, set this parameter to `true` .
         * <p>
         * Then attach the appropriate IAM policy document to your service role specified by <code>ServiceAccessRoleArn</code> . The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIamAuthEnabled() {
            return null;
        }

        /**
         * The maximum size in kilobytes of migrated graph data stored in a .csv file before AWS DMS bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the bulk load is successful, AWS DMS clears the bucket, ready to store the next batch of migrated graph data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxFileSize() {
            return null;
        }

        /**
         * The number of times for AWS DMS to retry a bulk load of migrated graph data to the Neptune target database before raising an error.
         * <p>
         * The default is 5.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetryCount() {
            return null;
        }

        /**
         * A folder path where you want AWS DMS to store migrated graph data in the S3 bucket specified by `S3BucketName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketFolder() {
            return null;
        }

        /**
         * The name of the Amazon S3 bucket where AWS DMS can temporarily store migrated graph data in .csv files before bulk-loading it to the Neptune target database. AWS DMS maps the SQL source data to graph data before storing it in these .csv files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the service role that you created for the Neptune target endpoint.
         * <p>
         * The role must allow the <code>iam:PassRole</code> action. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <em>AWS Database Migration Service User Guide.</em>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NeptuneSettingsProperty> {
            java.lang.Number errorRetryDuration;
            java.lang.Object iamAuthEnabled;
            java.lang.Number maxFileSize;
            java.lang.Number maxRetryCount;
            java.lang.String s3BucketFolder;
            java.lang.String s3BucketName;
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getErrorRetryDuration}
             * @param errorRetryDuration The number of milliseconds for AWS DMS to wait to retry a bulk-load of migrated graph data to the Neptune target database before raising an error.
             *                           The default is 250.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorRetryDuration(java.lang.Number errorRetryDuration) {
                this.errorRetryDuration = errorRetryDuration;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getIamAuthEnabled}
             * @param iamAuthEnabled If you want AWS Identity and Access Management (IAM) authorization enabled for this endpoint, set this parameter to `true` .
             *                       Then attach the appropriate IAM policy document to your service role specified by <code>ServiceAccessRoleArn</code> . The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamAuthEnabled(java.lang.Boolean iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getIamAuthEnabled}
             * @param iamAuthEnabled If you want AWS Identity and Access Management (IAM) authorization enabled for this endpoint, set this parameter to `true` .
             *                       Then attach the appropriate IAM policy document to your service role specified by <code>ServiceAccessRoleArn</code> . The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamAuthEnabled(software.amazon.awscdk.IResolvable iamAuthEnabled) {
                this.iamAuthEnabled = iamAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getMaxFileSize}
             * @param maxFileSize The maximum size in kilobytes of migrated graph data stored in a .csv file before AWS DMS bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the bulk load is successful, AWS DMS clears the bucket, ready to store the next batch of migrated graph data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxFileSize(java.lang.Number maxFileSize) {
                this.maxFileSize = maxFileSize;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getMaxRetryCount}
             * @param maxRetryCount The number of times for AWS DMS to retry a bulk load of migrated graph data to the Neptune target database before raising an error.
             *                      The default is 5.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetryCount(java.lang.Number maxRetryCount) {
                this.maxRetryCount = maxRetryCount;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getS3BucketFolder}
             * @param s3BucketFolder A folder path where you want AWS DMS to store migrated graph data in the S3 bucket specified by `S3BucketName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketFolder(java.lang.String s3BucketFolder) {
                this.s3BucketFolder = s3BucketFolder;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getS3BucketName}
             * @param s3BucketName The name of the Amazon S3 bucket where AWS DMS can temporarily store migrated graph data in .csv files before bulk-loading it to the Neptune target database. AWS DMS maps the SQL source data to graph data before storing it in these .csv files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link NeptuneSettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn The Amazon Resource Name (ARN) of the service role that you created for the Neptune target endpoint.
             *                             The role must allow the <code>iam:PassRole</code> action. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <em>AWS Database Migration Service User Guide.</em>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NeptuneSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NeptuneSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NeptuneSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NeptuneSettingsProperty {
            private final java.lang.Number errorRetryDuration;
            private final java.lang.Object iamAuthEnabled;
            private final java.lang.Number maxFileSize;
            private final java.lang.Number maxRetryCount;
            private final java.lang.String s3BucketFolder;
            private final java.lang.String s3BucketName;
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorRetryDuration = software.amazon.jsii.Kernel.get(this, "errorRetryDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.iamAuthEnabled = software.amazon.jsii.Kernel.get(this, "iamAuthEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxFileSize = software.amazon.jsii.Kernel.get(this, "maxFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxRetryCount = software.amazon.jsii.Kernel.get(this, "maxRetryCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.s3BucketFolder = software.amazon.jsii.Kernel.get(this, "s3BucketFolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorRetryDuration = builder.errorRetryDuration;
                this.iamAuthEnabled = builder.iamAuthEnabled;
                this.maxFileSize = builder.maxFileSize;
                this.maxRetryCount = builder.maxRetryCount;
                this.s3BucketFolder = builder.s3BucketFolder;
                this.s3BucketName = builder.s3BucketName;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.Number getErrorRetryDuration() {
                return this.errorRetryDuration;
            }

            @Override
            public final java.lang.Object getIamAuthEnabled() {
                return this.iamAuthEnabled;
            }

            @Override
            public final java.lang.Number getMaxFileSize() {
                return this.maxFileSize;
            }

            @Override
            public final java.lang.Number getMaxRetryCount() {
                return this.maxRetryCount;
            }

            @Override
            public final java.lang.String getS3BucketFolder() {
                return this.s3BucketFolder;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorRetryDuration() != null) {
                    data.set("errorRetryDuration", om.valueToTree(this.getErrorRetryDuration()));
                }
                if (this.getIamAuthEnabled() != null) {
                    data.set("iamAuthEnabled", om.valueToTree(this.getIamAuthEnabled()));
                }
                if (this.getMaxFileSize() != null) {
                    data.set("maxFileSize", om.valueToTree(this.getMaxFileSize()));
                }
                if (this.getMaxRetryCount() != null) {
                    data.set("maxRetryCount", om.valueToTree(this.getMaxRetryCount()));
                }
                if (this.getS3BucketFolder() != null) {
                    data.set("s3BucketFolder", om.valueToTree(this.getS3BucketFolder()));
                }
                if (this.getS3BucketName() != null) {
                    data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.NeptuneSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NeptuneSettingsProperty.Jsii$Proxy that = (NeptuneSettingsProperty.Jsii$Proxy) o;

                if (this.errorRetryDuration != null ? !this.errorRetryDuration.equals(that.errorRetryDuration) : that.errorRetryDuration != null) return false;
                if (this.iamAuthEnabled != null ? !this.iamAuthEnabled.equals(that.iamAuthEnabled) : that.iamAuthEnabled != null) return false;
                if (this.maxFileSize != null ? !this.maxFileSize.equals(that.maxFileSize) : that.maxFileSize != null) return false;
                if (this.maxRetryCount != null ? !this.maxRetryCount.equals(that.maxRetryCount) : that.maxRetryCount != null) return false;
                if (this.s3BucketFolder != null ? !this.s3BucketFolder.equals(that.s3BucketFolder) : that.s3BucketFolder != null) return false;
                if (this.s3BucketName != null ? !this.s3BucketName.equals(that.s3BucketName) : that.s3BucketName != null) return false;
                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorRetryDuration != null ? this.errorRetryDuration.hashCode() : 0;
                result = 31 * result + (this.iamAuthEnabled != null ? this.iamAuthEnabled.hashCode() : 0);
                result = 31 * result + (this.maxFileSize != null ? this.maxFileSize.hashCode() : 0);
                result = 31 * result + (this.maxRetryCount != null ? this.maxRetryCount.hashCode() : 0);
                result = 31 * result + (this.s3BucketFolder != null ? this.s3BucketFolder.hashCode() : 0);
                result = 31 * result + (this.s3BucketName != null ? this.s3BucketName.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * OracleSettingsProperty oracleSettingsProperty = OracleSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerOracleAsmAccessRoleArn("secretsManagerOracleAsmAccessRoleArn")
     *         .secretsManagerOracleAsmSecretId("secretsManagerOracleAsmSecretId")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.OracleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(OracleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OracleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerOracleAsmAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerOracleAsmSecretId() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OracleSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerOracleAsmAccessRoleArn;
            java.lang.String secretsManagerOracleAsmSecretId;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerOracleAsmAccessRoleArn}
             * @param secretsManagerOracleAsmAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerOracleAsmAccessRoleArn(java.lang.String secretsManagerOracleAsmAccessRoleArn) {
                this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerOracleAsmSecretId}
             * @param secretsManagerOracleAsmSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerOracleAsmSecretId(java.lang.String secretsManagerOracleAsmSecretId) {
                this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
                return this;
            }

            /**
             * Sets the value of {@link OracleSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OracleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OracleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OracleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OracleSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerOracleAsmAccessRoleArn;
            private final java.lang.String secretsManagerOracleAsmSecretId;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerOracleAsmAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerOracleAsmAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerOracleAsmSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerOracleAsmSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerOracleAsmAccessRoleArn = builder.secretsManagerOracleAsmAccessRoleArn;
                this.secretsManagerOracleAsmSecretId = builder.secretsManagerOracleAsmSecretId;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerOracleAsmAccessRoleArn() {
                return this.secretsManagerOracleAsmAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerOracleAsmSecretId() {
                return this.secretsManagerOracleAsmSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerOracleAsmAccessRoleArn() != null) {
                    data.set("secretsManagerOracleAsmAccessRoleArn", om.valueToTree(this.getSecretsManagerOracleAsmAccessRoleArn()));
                }
                if (this.getSecretsManagerOracleAsmSecretId() != null) {
                    data.set("secretsManagerOracleAsmSecretId", om.valueToTree(this.getSecretsManagerOracleAsmSecretId()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.OracleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OracleSettingsProperty.Jsii$Proxy that = (OracleSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                if (this.secretsManagerOracleAsmAccessRoleArn != null ? !this.secretsManagerOracleAsmAccessRoleArn.equals(that.secretsManagerOracleAsmAccessRoleArn) : that.secretsManagerOracleAsmAccessRoleArn != null) return false;
                if (this.secretsManagerOracleAsmSecretId != null ? !this.secretsManagerOracleAsmSecretId.equals(that.secretsManagerOracleAsmSecretId) : that.secretsManagerOracleAsmSecretId != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerOracleAsmAccessRoleArn != null ? this.secretsManagerOracleAsmAccessRoleArn.hashCode() : 0);
                result = 31 * result + (this.secretsManagerOracleAsmSecretId != null ? this.secretsManagerOracleAsmSecretId.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * PostgreSqlSettingsProperty postgreSqlSettingsProperty = PostgreSqlSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.PostgreSqlSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(PostgreSqlSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PostgreSqlSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PostgreSqlSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link PostgreSqlSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PostgreSqlSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PostgreSqlSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PostgreSqlSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PostgreSqlSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.PostgreSqlSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PostgreSqlSettingsProperty.Jsii$Proxy that = (PostgreSqlSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that defines a Redis target endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * RedisSettingsProperty redisSettingsProperty = RedisSettingsProperty.builder()
     *         .authPassword("authPassword")
     *         .authType("authType")
     *         .authUserName("authUserName")
     *         .port(123)
     *         .serverName("serverName")
     *         .sslCaCertificateArn("sslCaCertificateArn")
     *         .sslSecurityProtocol("sslSecurityProtocol")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.RedisSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedisSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedisSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password provided with the `auth-role` and `auth-token` options of the `AuthType` setting for a Redis target endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthPassword() {
            return null;
        }

        /**
         * The type of authentication to perform when connecting to a Redis target.
         * <p>
         * Options include <code>none</code> , <code>auth-token</code> , and <code>auth-role</code> . The <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
            return null;
        }

        /**
         * The user name provided with the `auth-role` option of the `AuthType` setting for a Redis target endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthUserName() {
            return null;
        }

        /**
         * Transmission Control Protocol (TCP) port for the endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * Fully qualified domain name of the endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslCaCertificateArn() {
            return null;
        }

        /**
         * The connection to a Redis target endpoint using Transport Layer Security (TLS).
         * <p>
         * Valid values include <code>plaintext</code> and <code>ssl-encryption</code> . The default is <code>ssl-encryption</code> . The <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn</code> setting. If an ARN isn't given for a CA, DMS uses the Amazon root CA.
         * <p>
         * The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslSecurityProtocol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedisSettingsProperty> {
            java.lang.String authPassword;
            java.lang.String authType;
            java.lang.String authUserName;
            java.lang.Number port;
            java.lang.String serverName;
            java.lang.String sslCaCertificateArn;
            java.lang.String sslSecurityProtocol;

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthPassword}
             * @param authPassword The password provided with the `auth-role` and `auth-token` options of the `AuthType` setting for a Redis target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authPassword(java.lang.String authPassword) {
                this.authPassword = authPassword;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthType}
             * @param authType The type of authentication to perform when connecting to a Redis target.
             *                 Options include <code>none</code> , <code>auth-token</code> , and <code>auth-role</code> . The <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values to be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getAuthUserName}
             * @param authUserName The user name provided with the `auth-role` option of the `AuthType` setting for a Redis target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authUserName(java.lang.String authUserName) {
                this.authUserName = authUserName;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getPort}
             * @param port Transmission Control Protocol (TCP) port for the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getServerName}
             * @param serverName Fully qualified domain name of the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverName(java.lang.String serverName) {
                this.serverName = serverName;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getSslCaCertificateArn}
             * @param sslCaCertificateArn The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to connect to your Redis target endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCaCertificateArn(java.lang.String sslCaCertificateArn) {
                this.sslCaCertificateArn = sslCaCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link RedisSettingsProperty#getSslSecurityProtocol}
             * @param sslSecurityProtocol The connection to a Redis target endpoint using Transport Layer Security (TLS).
             *                            Valid values include <code>plaintext</code> and <code>ssl-encryption</code> . The default is <code>ssl-encryption</code> . The <code>ssl-encryption</code> option makes an encrypted connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA) using the <code>SslCaCertificateArn</code> setting. If an ARN isn't given for a CA, DMS uses the Amazon root CA.
             *                            <p>
             *                            The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS) encryption for traffic between endpoint and database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslSecurityProtocol(java.lang.String sslSecurityProtocol) {
                this.sslSecurityProtocol = sslSecurityProtocol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedisSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedisSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedisSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedisSettingsProperty {
            private final java.lang.String authPassword;
            private final java.lang.String authType;
            private final java.lang.String authUserName;
            private final java.lang.Number port;
            private final java.lang.String serverName;
            private final java.lang.String sslCaCertificateArn;
            private final java.lang.String sslSecurityProtocol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authPassword = software.amazon.jsii.Kernel.get(this, "authPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authUserName = software.amazon.jsii.Kernel.get(this, "authUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslCaCertificateArn = software.amazon.jsii.Kernel.get(this, "sslCaCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslSecurityProtocol = software.amazon.jsii.Kernel.get(this, "sslSecurityProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authPassword = builder.authPassword;
                this.authType = builder.authType;
                this.authUserName = builder.authUserName;
                this.port = builder.port;
                this.serverName = builder.serverName;
                this.sslCaCertificateArn = builder.sslCaCertificateArn;
                this.sslSecurityProtocol = builder.sslSecurityProtocol;
            }

            @Override
            public final java.lang.String getAuthPassword() {
                return this.authPassword;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.String getAuthUserName() {
                return this.authUserName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServerName() {
                return this.serverName;
            }

            @Override
            public final java.lang.String getSslCaCertificateArn() {
                return this.sslCaCertificateArn;
            }

            @Override
            public final java.lang.String getSslSecurityProtocol() {
                return this.sslSecurityProtocol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthPassword() != null) {
                    data.set("authPassword", om.valueToTree(this.getAuthPassword()));
                }
                if (this.getAuthType() != null) {
                    data.set("authType", om.valueToTree(this.getAuthType()));
                }
                if (this.getAuthUserName() != null) {
                    data.set("authUserName", om.valueToTree(this.getAuthUserName()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getServerName() != null) {
                    data.set("serverName", om.valueToTree(this.getServerName()));
                }
                if (this.getSslCaCertificateArn() != null) {
                    data.set("sslCaCertificateArn", om.valueToTree(this.getSslCaCertificateArn()));
                }
                if (this.getSslSecurityProtocol() != null) {
                    data.set("sslSecurityProtocol", om.valueToTree(this.getSslSecurityProtocol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.RedisSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedisSettingsProperty.Jsii$Proxy that = (RedisSettingsProperty.Jsii$Proxy) o;

                if (this.authPassword != null ? !this.authPassword.equals(that.authPassword) : that.authPassword != null) return false;
                if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
                if (this.authUserName != null ? !this.authUserName.equals(that.authUserName) : that.authUserName != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
                if (this.sslCaCertificateArn != null ? !this.sslCaCertificateArn.equals(that.sslCaCertificateArn) : that.sslCaCertificateArn != null) return false;
                return this.sslSecurityProtocol != null ? this.sslSecurityProtocol.equals(that.sslSecurityProtocol) : that.sslSecurityProtocol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authPassword != null ? this.authPassword.hashCode() : 0;
                result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
                result = 31 * result + (this.authUserName != null ? this.authUserName.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
                result = 31 * result + (this.sslCaCertificateArn != null ? this.sslCaCertificateArn.hashCode() : 0);
                result = 31 * result + (this.sslSecurityProtocol != null ? this.sslSecurityProtocol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * RedshiftSettingsProperty redshiftSettingsProperty = RedshiftSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.RedshiftSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.RedshiftSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftSettingsProperty.Jsii$Proxy that = (RedshiftSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * S3SettingsProperty s3SettingsProperty = S3SettingsProperty.builder()
     *         .bucketFolder("bucketFolder")
     *         .bucketName("bucketName")
     *         .compressionType("compressionType")
     *         .csvDelimiter("csvDelimiter")
     *         .csvRowDelimiter("csvRowDelimiter")
     *         .externalTableDefinition("externalTableDefinition")
     *         .serviceAccessRoleArn("serviceAccessRoleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.S3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketFolder() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionType() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCsvDelimiter() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCsvRowDelimiter() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalTableDefinition() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccessRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SettingsProperty> {
            java.lang.String bucketFolder;
            java.lang.String bucketName;
            java.lang.String compressionType;
            java.lang.String csvDelimiter;
            java.lang.String csvRowDelimiter;
            java.lang.String externalTableDefinition;
            java.lang.String serviceAccessRoleArn;

            /**
             * Sets the value of {@link S3SettingsProperty#getBucketFolder}
             * @param bucketFolder Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketFolder(java.lang.String bucketFolder) {
                this.bucketFolder = bucketFolder;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getBucketName}
             * @param bucketName Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCompressionType}
             * @param compressionType Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionType(java.lang.String compressionType) {
                this.compressionType = compressionType;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCsvDelimiter}
             * @param csvDelimiter Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvDelimiter(java.lang.String csvDelimiter) {
                this.csvDelimiter = csvDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getCsvRowDelimiter}
             * @param csvRowDelimiter Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvRowDelimiter(java.lang.String csvRowDelimiter) {
                this.csvRowDelimiter = csvRowDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getExternalTableDefinition}
             * @param externalTableDefinition Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalTableDefinition(java.lang.String externalTableDefinition) {
                this.externalTableDefinition = externalTableDefinition;
                return this;
            }

            /**
             * Sets the value of {@link S3SettingsProperty#getServiceAccessRoleArn}
             * @param serviceAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccessRoleArn(java.lang.String serviceAccessRoleArn) {
                this.serviceAccessRoleArn = serviceAccessRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SettingsProperty {
            private final java.lang.String bucketFolder;
            private final java.lang.String bucketName;
            private final java.lang.String compressionType;
            private final java.lang.String csvDelimiter;
            private final java.lang.String csvRowDelimiter;
            private final java.lang.String externalTableDefinition;
            private final java.lang.String serviceAccessRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketFolder = software.amazon.jsii.Kernel.get(this, "bucketFolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compressionType = software.amazon.jsii.Kernel.get(this, "compressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.csvDelimiter = software.amazon.jsii.Kernel.get(this, "csvDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.csvRowDelimiter = software.amazon.jsii.Kernel.get(this, "csvRowDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalTableDefinition = software.amazon.jsii.Kernel.get(this, "externalTableDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccessRoleArn = software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketFolder = builder.bucketFolder;
                this.bucketName = builder.bucketName;
                this.compressionType = builder.compressionType;
                this.csvDelimiter = builder.csvDelimiter;
                this.csvRowDelimiter = builder.csvRowDelimiter;
                this.externalTableDefinition = builder.externalTableDefinition;
                this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
            }

            @Override
            public final java.lang.String getBucketFolder() {
                return this.bucketFolder;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getCompressionType() {
                return this.compressionType;
            }

            @Override
            public final java.lang.String getCsvDelimiter() {
                return this.csvDelimiter;
            }

            @Override
            public final java.lang.String getCsvRowDelimiter() {
                return this.csvRowDelimiter;
            }

            @Override
            public final java.lang.String getExternalTableDefinition() {
                return this.externalTableDefinition;
            }

            @Override
            public final java.lang.String getServiceAccessRoleArn() {
                return this.serviceAccessRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketFolder() != null) {
                    data.set("bucketFolder", om.valueToTree(this.getBucketFolder()));
                }
                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getCompressionType() != null) {
                    data.set("compressionType", om.valueToTree(this.getCompressionType()));
                }
                if (this.getCsvDelimiter() != null) {
                    data.set("csvDelimiter", om.valueToTree(this.getCsvDelimiter()));
                }
                if (this.getCsvRowDelimiter() != null) {
                    data.set("csvRowDelimiter", om.valueToTree(this.getCsvRowDelimiter()));
                }
                if (this.getExternalTableDefinition() != null) {
                    data.set("externalTableDefinition", om.valueToTree(this.getExternalTableDefinition()));
                }
                if (this.getServiceAccessRoleArn() != null) {
                    data.set("serviceAccessRoleArn", om.valueToTree(this.getServiceAccessRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.S3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SettingsProperty.Jsii$Proxy that = (S3SettingsProperty.Jsii$Proxy) o;

                if (this.bucketFolder != null ? !this.bucketFolder.equals(that.bucketFolder) : that.bucketFolder != null) return false;
                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
                if (this.csvDelimiter != null ? !this.csvDelimiter.equals(that.csvDelimiter) : that.csvDelimiter != null) return false;
                if (this.csvRowDelimiter != null ? !this.csvRowDelimiter.equals(that.csvRowDelimiter) : that.csvRowDelimiter != null) return false;
                if (this.externalTableDefinition != null ? !this.externalTableDefinition.equals(that.externalTableDefinition) : that.externalTableDefinition != null) return false;
                return this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.equals(that.serviceAccessRoleArn) : that.serviceAccessRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketFolder != null ? this.bucketFolder.hashCode() : 0;
                result = 31 * result + (this.bucketName != null ? this.bucketName.hashCode() : 0);
                result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
                result = 31 * result + (this.csvDelimiter != null ? this.csvDelimiter.hashCode() : 0);
                result = 31 * result + (this.csvRowDelimiter != null ? this.csvRowDelimiter.hashCode() : 0);
                result = 31 * result + (this.externalTableDefinition != null ? this.externalTableDefinition.hashCode() : 0);
                result = 31 * result + (this.serviceAccessRoleArn != null ? this.serviceAccessRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Not currently supported by AWS CloudFormation .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * SybaseSettingsProperty sybaseSettingsProperty = SybaseSettingsProperty.builder()
     *         .secretsManagerAccessRoleArn("secretsManagerAccessRoleArn")
     *         .secretsManagerSecretId("secretsManagerSecretId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnEndpoint.SybaseSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SybaseSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SybaseSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerAccessRoleArn() {
            return null;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretsManagerSecretId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SybaseSettingsProperty> {
            java.lang.String secretsManagerAccessRoleArn;
            java.lang.String secretsManagerSecretId;

            /**
             * Sets the value of {@link SybaseSettingsProperty#getSecretsManagerAccessRoleArn}
             * @param secretsManagerAccessRoleArn Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerAccessRoleArn(java.lang.String secretsManagerAccessRoleArn) {
                this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link SybaseSettingsProperty#getSecretsManagerSecretId}
             * @param secretsManagerSecretId Not currently supported by AWS CloudFormation .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretId(java.lang.String secretsManagerSecretId) {
                this.secretsManagerSecretId = secretsManagerSecretId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SybaseSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SybaseSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SybaseSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SybaseSettingsProperty {
            private final java.lang.String secretsManagerAccessRoleArn;
            private final java.lang.String secretsManagerSecretId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretsManagerAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerSecretId = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
                this.secretsManagerSecretId = builder.secretsManagerSecretId;
            }

            @Override
            public final java.lang.String getSecretsManagerAccessRoleArn() {
                return this.secretsManagerAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretsManagerSecretId() {
                return this.secretsManagerSecretId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecretsManagerAccessRoleArn() != null) {
                    data.set("secretsManagerAccessRoleArn", om.valueToTree(this.getSecretsManagerAccessRoleArn()));
                }
                if (this.getSecretsManagerSecretId() != null) {
                    data.set("secretsManagerSecretId", om.valueToTree(this.getSecretsManagerSecretId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnEndpoint.SybaseSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SybaseSettingsProperty.Jsii$Proxy that = (SybaseSettingsProperty.Jsii$Proxy) o;

                if (this.secretsManagerAccessRoleArn != null ? !this.secretsManagerAccessRoleArn.equals(that.secretsManagerAccessRoleArn) : that.secretsManagerAccessRoleArn != null) return false;
                return this.secretsManagerSecretId != null ? this.secretsManagerSecretId.equals(that.secretsManagerSecretId) : that.secretsManagerSecretId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerAccessRoleArn != null ? this.secretsManagerAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.secretsManagerSecretId != null ? this.secretsManagerSecretId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dms.CfnEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dms.CfnEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dms.CfnEndpointProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dms.CfnEndpointProps.Builder();
        }

        /**
         * The type of endpoint.
         * <p>
         * Valid values are <code>source</code> and <code>target</code> .
         * <p>
         * @return {@code this}
         * @param endpointType The type of endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(final java.lang.String endpointType) {
            this.props.endpointType(endpointType);
            return this;
        }

        /**
         * The type of engine for the endpoint.
         * <p>
         * Valid values, depending on the <code>EndpointType</code> value, include <code>"mysql"</code> , <code>"oracle"</code> , <code>"postgres"</code> , <code>"mariadb"</code> , <code>"aurora"</code> , <code>"aurora-postgresql"</code> , <code>"opensearch"</code> , <code>"redshift"</code> , <code>"s3"</code> , <code>"db2"</code> , <code>"azuredb"</code> , <code>"sybase"</code> , <code>"dynamodb"</code> , <code>"mongodb"</code> , <code>"kinesis"</code> , <code>"kafka"</code> , <code>"elasticsearch"</code> , <code>"docdb"</code> , <code>"sqlserver"</code> , and <code>"neptune"</code> .
         * <p>
         * @return {@code this}
         * @param engineName The type of engine for the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineName(final java.lang.String engineName) {
            this.props.engineName(engineName);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) for the certificate.
         * <p>
         * @return {@code this}
         * @param certificateArn The Amazon Resource Name (ARN) for the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateArn(final java.lang.String certificateArn) {
            this.props.certificateArn(certificateArn);
            return this;
        }

        /**
         * The name of the endpoint database.
         * <p>
         * For a MySQL source or target endpoint, do not specify DatabaseName. To migrate to a specific database, use this setting and <code>targetDbType</code> .
         * <p>
         * @return {@code this}
         * @param databaseName The name of the endpoint database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * Settings in JSON format for the source DocumentDB endpoint.
         * <p>
         * For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html">Using DocumentDB as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param docDbSettings Settings in JSON format for the source DocumentDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder docDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.DocDbSettingsProperty docDbSettings) {
            this.props.docDbSettings(docDbSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source DocumentDB endpoint.
         * <p>
         * For more information about the available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html">Using DocumentDB as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param docDbSettings Settings in JSON format for the source DocumentDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder docDbSettings(final software.amazon.awscdk.IResolvable docDbSettings) {
            this.props.docDbSettings(docDbSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target Amazon DynamoDB endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param dynamoDbSettings Settings in JSON format for the target Amazon DynamoDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.DynamoDbSettingsProperty dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target Amazon DynamoDB endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate Data to DynamoDB</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param dynamoDbSettings Settings in JSON format for the target Amazon DynamoDB endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbSettings(final software.amazon.awscdk.IResolvable dynamoDbSettings) {
            this.props.dynamoDbSettings(dynamoDbSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target OpenSearch endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @param elasticsearchSettings Settings in JSON format for the target OpenSearch endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.ElasticsearchSettingsProperty elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target OpenSearch endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using OpenSearch as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide</em> .
         * <p>
         * @return {@code this}
         * @param elasticsearchSettings Settings in JSON format for the target OpenSearch endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchSettings(final software.amazon.awscdk.IResolvable elasticsearchSettings) {
            this.props.elasticsearchSettings(elasticsearchSettings);
            return this;
        }

        /**
         * The database endpoint identifier.
         * <p>
         * Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * <p>
         * @return {@code this}
         * @param endpointIdentifier The database endpoint identifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointIdentifier(final java.lang.String endpointIdentifier) {
            this.props.endpointIdentifier(endpointIdentifier);
            return this;
        }

        /**
         * Additional attributes associated with the connection.
         * <p>
         * Each attribute is specified as a name-value pair associated by an equal sign (=). Multiple attributes are separated by a semicolon (;) with no additional white space. For information on the attributes available for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with AWS DMS Endpoints</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param extraConnectionAttributes Additional attributes associated with the connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraConnectionAttributes(final java.lang.String extraConnectionAttributes) {
            this.props.extraConnectionAttributes(extraConnectionAttributes);
            return this;
        }

        /**
         * Settings in JSON format for the source GCP MySQL endpoint.
         * <p>
         * @return {@code this}
         * @param gcpMySqlSettings Settings in JSON format for the source GCP MySQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gcpMySqlSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.GcpMySQLSettingsProperty gcpMySqlSettings) {
            this.props.gcpMySqlSettings(gcpMySqlSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source GCP MySQL endpoint.
         * <p>
         * @return {@code this}
         * @param gcpMySqlSettings Settings in JSON format for the source GCP MySQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gcpMySqlSettings(final software.amazon.awscdk.IResolvable gcpMySqlSettings) {
            this.props.gcpMySqlSettings(gcpMySqlSettings);
            return this;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param ibmDb2Settings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ibmDb2Settings(final software.amazon.awscdk.services.dms.CfnEndpoint.IbmDb2SettingsProperty ibmDb2Settings) {
            this.props.ibmDb2Settings(ibmDb2Settings);
            return this;
        }
        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param ibmDb2Settings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ibmDb2Settings(final software.amazon.awscdk.IResolvable ibmDb2Settings) {
            this.props.ibmDb2Settings(ibmDb2Settings);
            return this;
        }

        /**
         * Settings in JSON format for the target Apache Kafka endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param kafkaSettings Settings in JSON format for the target Apache Kafka endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.KafkaSettingsProperty kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target Apache Kafka endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping to migrate data to a Kafka topic</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param kafkaSettings Settings in JSON format for the target Apache Kafka endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaSettings(final software.amazon.awscdk.IResolvable kafkaSettings) {
            this.props.kafkaSettings(kafkaSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis Data Streams as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param kinesisSettings Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.KinesisSettingsProperty kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis Data Streams as a Target for AWS Database Migration Service</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param kinesisSettings Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisSettings(final software.amazon.awscdk.IResolvable kinesisSettings) {
            this.props.kinesisSettings(kinesisSettings);
            return this;
        }

        /**
         * An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint.
         * <p>
         * If you don't specify a value for the <code>KmsKeyId</code> parameter, then AWS DMS uses your default encryption key.
         * <p>
         * AWS KMS creates the default encryption key for your AWS account . Your AWS account has a different default encryption key for each AWS Region .
         * <p>
         * @return {@code this}
         * @param kmsKeyId An AWS KMS key identifier that is used to encrypt the connection parameters for the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param microsoftSqlServerSettings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder microsoftSqlServerSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MicrosoftSqlServerSettingsProperty microsoftSqlServerSettings) {
            this.props.microsoftSqlServerSettings(microsoftSqlServerSettings);
            return this;
        }
        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param microsoftSqlServerSettings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder microsoftSqlServerSettings(final software.amazon.awscdk.IResolvable microsoftSqlServerSettings) {
            this.props.microsoftSqlServerSettings(microsoftSqlServerSettings);
            return this;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param mongoDbSettings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mongoDbSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MongoDbSettingsProperty mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }
        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param mongoDbSettings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mongoDbSettings(final software.amazon.awscdk.IResolvable mongoDbSettings) {
            this.props.mongoDbSettings(mongoDbSettings);
            return this;
        }

        /**
         * Settings in JSON format for the source and target MySQL endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param mySqlSettings Settings in JSON format for the source and target MySQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mySqlSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.MySqlSettingsProperty mySqlSettings) {
            this.props.mySqlSettings(mySqlSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target MySQL endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes when using MySQL as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param mySqlSettings Settings in JSON format for the source and target MySQL endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mySqlSettings(final software.amazon.awscdk.IResolvable mySqlSettings) {
            this.props.mySqlSettings(mySqlSettings);
            return this;
        }

        /**
         * `AWS::DMS::Endpoint.NeptuneSettings`.
         * <p>
         * @return {@code this}
         * @param neptuneSettings `AWS::DMS::Endpoint.NeptuneSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder neptuneSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.NeptuneSettingsProperty neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }
        /**
         * `AWS::DMS::Endpoint.NeptuneSettings`.
         * <p>
         * @return {@code this}
         * @param neptuneSettings `AWS::DMS::Endpoint.NeptuneSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder neptuneSettings(final software.amazon.awscdk.IResolvable neptuneSettings) {
            this.props.neptuneSettings(neptuneSettings);
            return this;
        }

        /**
         * Settings in JSON format for the source and target Oracle endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param oracleSettings Settings in JSON format for the source and target Oracle endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oracleSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.OracleSettingsProperty oracleSettings) {
            this.props.oracleSettings(oracleSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target Oracle endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">Extra connection attributes when using Oracle as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param oracleSettings Settings in JSON format for the source and target Oracle endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oracleSettings(final software.amazon.awscdk.IResolvable oracleSettings) {
            this.props.oracleSettings(oracleSettings);
            return this;
        }

        /**
         * The password to be used to log in to the endpoint database.
         * <p>
         * @return {@code this}
         * @param password The password to be used to log in to the endpoint database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(final java.lang.String password) {
            this.props.password(password);
            return this;
        }

        /**
         * The port used by the endpoint database.
         * <p>
         * @return {@code this}
         * @param port The port used by the endpoint database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param postgreSqlSettings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postgreSqlSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.PostgreSqlSettingsProperty postgreSqlSettings) {
            this.props.postgreSqlSettings(postgreSqlSettings);
            return this;
        }
        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param postgreSqlSettings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postgreSqlSettings(final software.amazon.awscdk.IResolvable postgreSqlSettings) {
            this.props.postgreSqlSettings(postgreSqlSettings);
            return this;
        }

        /**
         * Settings in JSON format for the target Redis endpoint.
         * <p>
         * @return {@code this}
         * @param redisSettings Settings in JSON format for the target Redis endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.RedisSettingsProperty redisSettings) {
            this.props.redisSettings(redisSettings);
            return this;
        }
        /**
         * Settings in JSON format for the target Redis endpoint.
         * <p>
         * @return {@code this}
         * @param redisSettings Settings in JSON format for the target Redis endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redisSettings(final software.amazon.awscdk.IResolvable redisSettings) {
            this.props.redisSettings(redisSettings);
            return this;
        }

        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param redshiftSettings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.RedshiftSettingsProperty redshiftSettings) {
            this.props.redshiftSettings(redshiftSettings);
            return this;
        }
        /**
         * Not currently supported by AWS CloudFormation .
         * <p>
         * @return {@code this}
         * @param redshiftSettings Not currently supported by AWS CloudFormation . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftSettings(final software.amazon.awscdk.IResolvable redshiftSettings) {
            this.props.redshiftSettings(redshiftSettings);
            return this;
        }

        /**
         * A friendly name for the resource identifier at the end of the `EndpointArn` response parameter that is returned in the created `Endpoint` object.
         * <p>
         * The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as <code>Example-App-ARN1</code> . For example, this value might result in the <code>EndpointArn</code> value <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code> . If you don't specify a <code>ResourceIdentifier</code> value, AWS DMS generates a default identifier value for the end of <code>EndpointArn</code> .
         * <p>
         * @return {@code this}
         * @param resourceIdentifier A friendly name for the resource identifier at the end of the `EndpointArn` response parameter that is returned in the created `Endpoint` object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(final java.lang.String resourceIdentifier) {
            this.props.resourceIdentifier(resourceIdentifier);
            return this;
        }

        /**
         * Settings in JSON format for the target Amazon S3 endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param s3Settings Settings in JSON format for the target Amazon S3 endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Settings(final software.amazon.awscdk.services.dms.CfnEndpoint.S3SettingsProperty s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }
        /**
         * Settings in JSON format for the target Amazon S3 endpoint.
         * <p>
         * For more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param s3Settings Settings in JSON format for the target Amazon S3 endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Settings(final software.amazon.awscdk.IResolvable s3Settings) {
            this.props.s3Settings(s3Settings);
            return this;
        }

        /**
         * The name of the server where the endpoint database resides.
         * <p>
         * @return {@code this}
         * @param serverName The name of the server where the endpoint database resides. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverName(final java.lang.String serverName) {
            this.props.serverName(serverName);
            return this;
        }

        /**
         * The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is `none` .
         * <p>
         * <blockquote>
         * <p>
         * When <code>engine_name</code> is set to S3, then the only allowed value is <code>none</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param sslMode The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is `none` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslMode(final java.lang.String sslMode) {
            this.props.sslMode(sslMode);
            return this;
        }

        /**
         * Settings in JSON format for the source and target SAP ASE endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param sybaseSettings Settings in JSON format for the source and target SAP ASE endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sybaseSettings(final software.amazon.awscdk.services.dms.CfnEndpoint.SybaseSettingsProperty sybaseSettings) {
            this.props.sybaseSettings(sybaseSettings);
            return this;
        }
        /**
         * Settings in JSON format for the source and target SAP ASE endpoint.
         * <p>
         * For information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a source for AWS DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes when using SAP ASE as a target for AWS DMS</a> in the <em>AWS Database Migration Service User Guide.</em>
         * <p>
         * @return {@code this}
         * @param sybaseSettings Settings in JSON format for the source and target SAP ASE endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sybaseSettings(final software.amazon.awscdk.IResolvable sybaseSettings) {
            this.props.sybaseSettings(sybaseSettings);
            return this;
        }

        /**
         * One or more tags to be assigned to the endpoint.
         * <p>
         * @return {@code this}
         * @param tags One or more tags to be assigned to the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The user name to be used to log in to the endpoint database.
         * <p>
         * @return {@code this}
         * @param username The user name to be used to log in to the endpoint database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.dms.CfnEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dms.CfnEndpoint build() {
            return new software.amazon.awscdk.services.dms.CfnEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
