package software.amazon.awscdk.services.devopsguru;

/**
 * A CloudFormation `AWS::DevOpsGuru::ResourceCollection`.
 * <p>
 * A collection of AWS resources supported by DevOps Guru. The one type of AWS resource collection supported is AWS CloudFormation stacks. DevOps Guru can be configured to analyze only the AWS resources that are defined in the stacks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.devopsguru.*;
 * CfnResourceCollection cfnResourceCollection = CfnResourceCollection.Builder.create(this, "MyCfnResourceCollection")
 *         .resourceCollectionFilter(ResourceCollectionFilterProperty.builder()
 *                 .cloudFormation(CloudFormationCollectionFilterProperty.builder()
 *                         .stackNames(List.of("stackNames"))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.778Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devopsguru.CfnResourceCollection")
public class CfnResourceCollection extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnResourceCollection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceCollection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.devopsguru.CfnResourceCollection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DevOpsGuru::ResourceCollection`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResourceCollection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.devopsguru.CfnResourceCollectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The type of AWS resource collections to return.
     * <p>
     * The one valid value is <code>CLOUD_FORMATION</code> for AWS CloudFormation stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceCollectionType() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceCollectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResourceCollectionFilter() {
        return software.amazon.jsii.Kernel.get(this, "resourceCollectionFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceCollectionFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourceCollectionFilter", java.util.Objects.requireNonNull(value, "resourceCollectionFilter is required"));
    }

    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceCollectionFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceCollectionFilter", java.util.Objects.requireNonNull(value, "resourceCollectionFilter is required"));
    }
    /**
     * Information about AWS CloudFormation stacks.
     * <p>
     * You can use up to 500 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.devopsguru.*;
     * CloudFormationCollectionFilterProperty cloudFormationCollectionFilterProperty = CloudFormationCollectionFilterProperty.builder()
     *         .stackNames(List.of("stackNames"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devopsguru.CfnResourceCollection.CloudFormationCollectionFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudFormationCollectionFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudFormationCollectionFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of CloudFormation stack names.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStackNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudFormationCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudFormationCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudFormationCollectionFilterProperty> {
            java.util.List<java.lang.String> stackNames;

            /**
             * Sets the value of {@link CloudFormationCollectionFilterProperty#getStackNames}
             * @param stackNames An array of CloudFormation stack names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackNames(java.util.List<java.lang.String> stackNames) {
                this.stackNames = stackNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudFormationCollectionFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudFormationCollectionFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudFormationCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationCollectionFilterProperty {
            private final java.util.List<java.lang.String> stackNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.stackNames = software.amazon.jsii.Kernel.get(this, "stackNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.stackNames = builder.stackNames;
            }

            @Override
            public final java.util.List<java.lang.String> getStackNames() {
                return this.stackNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStackNames() != null) {
                    data.set("stackNames", om.valueToTree(this.getStackNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devopsguru.CfnResourceCollection.CloudFormationCollectionFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudFormationCollectionFilterProperty.Jsii$Proxy that = (CloudFormationCollectionFilterProperty.Jsii$Proxy) o;

                return this.stackNames != null ? this.stackNames.equals(that.stackNames) : that.stackNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.stackNames != null ? this.stackNames.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.devopsguru.*;
     * ResourceCollectionFilterProperty resourceCollectionFilterProperty = ResourceCollectionFilterProperty.builder()
     *         .cloudFormation(CloudFormationCollectionFilterProperty.builder()
     *                 .stackNames(List.of("stackNames"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceCollectionFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceCollectionFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about AWS CloudFormation stacks.
         * <p>
         * You can use up to 500 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <em>AWS CloudFormation User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudFormation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceCollectionFilterProperty> {
            java.lang.Object cloudFormation;

            /**
             * Sets the value of {@link ResourceCollectionFilterProperty#getCloudFormation}
             * @param cloudFormation Information about AWS CloudFormation stacks.
             *                       You can use up to 500 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <em>AWS CloudFormation User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormation(software.amazon.awscdk.services.devopsguru.CfnResourceCollection.CloudFormationCollectionFilterProperty cloudFormation) {
                this.cloudFormation = cloudFormation;
                return this;
            }

            /**
             * Sets the value of {@link ResourceCollectionFilterProperty#getCloudFormation}
             * @param cloudFormation Information about AWS CloudFormation stacks.
             *                       You can use up to 500 stacks to specify which AWS resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <em>AWS CloudFormation User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormation(software.amazon.awscdk.IResolvable cloudFormation) {
                this.cloudFormation = cloudFormation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceCollectionFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceCollectionFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceCollectionFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceCollectionFilterProperty {
            private final java.lang.Object cloudFormation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudFormation = software.amazon.jsii.Kernel.get(this, "cloudFormation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudFormation = builder.cloudFormation;
            }

            @Override
            public final java.lang.Object getCloudFormation() {
                return this.cloudFormation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudFormation() != null) {
                    data.set("cloudFormation", om.valueToTree(this.getCloudFormation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceCollectionFilterProperty.Jsii$Proxy that = (ResourceCollectionFilterProperty.Jsii$Proxy) o;

                return this.cloudFormation != null ? this.cloudFormation.equals(that.cloudFormation) : that.cloudFormation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudFormation != null ? this.cloudFormation.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.devopsguru.CfnResourceCollection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.devopsguru.CfnResourceCollection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.devopsguru.CfnResourceCollectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.devopsguru.CfnResourceCollectionProps.Builder();
        }

        /**
         * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
         * <p>
         * @return {@code this}
         * @param resourceCollectionFilter Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCollectionFilter(final software.amazon.awscdk.services.devopsguru.CfnResourceCollection.ResourceCollectionFilterProperty resourceCollectionFilter) {
            this.props.resourceCollectionFilter(resourceCollectionFilter);
            return this;
        }
        /**
         * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
         * <p>
         * @return {@code this}
         * @param resourceCollectionFilter Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCollectionFilter(final software.amazon.awscdk.IResolvable resourceCollectionFilter) {
            this.props.resourceCollectionFilter(resourceCollectionFilter);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.devopsguru.CfnResourceCollection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.devopsguru.CfnResourceCollection build() {
            return new software.amazon.awscdk.services.devopsguru.CfnResourceCollection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
