package software.amazon.awscdk.services.databrew;

/**
 * A CloudFormation `AWS::DataBrew::Job`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * Object parameters;
 * CfnJob cfnJob = CfnJob.Builder.create(this, "MyCfnJob")
 *         .name("name")
 *         .roleArn("roleArn")
 *         .type("type")
 *         // the properties below are optional
 *         .databaseOutputs(List.of(DatabaseOutputProperty.builder()
 *                 .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .tempDirectory(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .glueConnectionName("glueConnectionName")
 *                 // the properties below are optional
 *                 .databaseOutputMode("databaseOutputMode")
 *                 .build()))
 *         .dataCatalogOutputs(List.of(DataCatalogOutputProperty.builder()
 *                 .databaseName("databaseName")
 *                 .tableName("tableName")
 *                 // the properties below are optional
 *                 .catalogId("catalogId")
 *                 .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .tempDirectory(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .overwrite(false)
 *                 .s3Options(S3TableOutputOptionsProperty.builder()
 *                         .location(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .datasetName("datasetName")
 *         .encryptionKeyArn("encryptionKeyArn")
 *         .encryptionMode("encryptionMode")
 *         .jobSample(JobSampleProperty.builder()
 *                 .mode("mode")
 *                 .size(123)
 *                 .build())
 *         .logSubscription("logSubscription")
 *         .maxCapacity(123)
 *         .maxRetries(123)
 *         .outputLocation(OutputLocationProperty.builder()
 *                 .bucket("bucket")
 *                 // the properties below are optional
 *                 .bucketOwner("bucketOwner")
 *                 .key("key")
 *                 .build())
 *         .outputs(List.of(OutputProperty.builder()
 *                 .location(S3LocationProperty.builder()
 *                         .bucket("bucket")
 *                         // the properties below are optional
 *                         .bucketOwner("bucketOwner")
 *                         .key("key")
 *                         .build())
 *                 // the properties below are optional
 *                 .compressionFormat("compressionFormat")
 *                 .format("format")
 *                 .formatOptions(OutputFormatOptionsProperty.builder()
 *                         .csv(CsvOutputOptionsProperty.builder()
 *                                 .delimiter("delimiter")
 *                                 .build())
 *                         .build())
 *                 .overwrite(false)
 *                 .partitionColumns(List.of("partitionColumns"))
 *                 .build()))
 *         .profileConfiguration(ProfileConfigurationProperty.builder()
 *                 .columnStatisticsConfigurations(List.of(ColumnStatisticsConfigurationProperty.builder()
 *                         .statistics(StatisticsConfigurationProperty.builder()
 *                                 .includedStatistics(List.of("includedStatistics"))
 *                                 .overrides(List.of(StatisticOverrideProperty.builder()
 *                                         .parameters(parameters)
 *                                         .statistic("statistic")
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .selectors(List.of(ColumnSelectorProperty.builder()
 *                                 .name("name")
 *                                 .regex("regex")
 *                                 .build()))
 *                         .build()))
 *                 .datasetStatisticsConfiguration(StatisticsConfigurationProperty.builder()
 *                         .includedStatistics(List.of("includedStatistics"))
 *                         .overrides(List.of(StatisticOverrideProperty.builder()
 *                                 .parameters(parameters)
 *                                 .statistic("statistic")
 *                                 .build()))
 *                         .build())
 *                 .entityDetectorConfiguration(EntityDetectorConfigurationProperty.builder()
 *                         .entityTypes(List.of("entityTypes"))
 *                         // the properties below are optional
 *                         .allowedStatistics(AllowedStatisticsProperty.builder()
 *                                 .statistics(List.of("statistics"))
 *                                 .build())
 *                         .build())
 *                 .profileColumns(List.of(ColumnSelectorProperty.builder()
 *                         .name("name")
 *                         .regex("regex")
 *                         .build()))
 *                 .build())
 *         .projectName("projectName")
 *         .recipe(RecipeProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeout(123)
 *         .validationConfigurations(List.of(ValidationConfigurationProperty.builder()
 *                 .rulesetArn("rulesetArn")
 *                 // the properties below are optional
 *                 .validationMode("validationMode")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.687Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob")
public class CfnJob extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnJob(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJob(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.databrew.CfnJob.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DataBrew::Job`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnJob(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.databrew.CfnJobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::DataBrew::Job.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::DataBrew::Job.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataBrew::Job.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::DataBrew::Job.RoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataBrew::Job.RoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * `AWS::DataBrew::Job.Type`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataBrew::Job.Type`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * `AWS::DataBrew::Job.DatabaseOutputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseOutputs() {
        return software.amazon.jsii.Kernel.get(this, "databaseOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataBrew::Job.DatabaseOutputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseOutputs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "databaseOutputs", value);
    }

    /**
     * `AWS::DataBrew::Job.DatabaseOutputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseOutputs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "databaseOutputs", value);
    }

    /**
     * `AWS::DataBrew::Job.DataCatalogOutputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataCatalogOutputs() {
        return software.amazon.jsii.Kernel.get(this, "dataCatalogOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataBrew::Job.DataCatalogOutputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCatalogOutputs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataCatalogOutputs", value);
    }

    /**
     * `AWS::DataBrew::Job.DataCatalogOutputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCatalogOutputs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "dataCatalogOutputs", value);
    }

    /**
     * `AWS::DataBrew::Job.DatasetName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatasetName() {
        return software.amazon.jsii.Kernel.get(this, "datasetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataBrew::Job.DatasetName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datasetName", value);
    }

    /**
     * `AWS::DataBrew::Job.EncryptionKeyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataBrew::Job.EncryptionKeyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "encryptionKeyArn", value);
    }

    /**
     * `AWS::DataBrew::Job.EncryptionMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMode() {
        return software.amazon.jsii.Kernel.get(this, "encryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataBrew::Job.EncryptionMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "encryptionMode", value);
    }

    /**
     * `AWS::DataBrew::Job.JobSample`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getJobSample() {
        return software.amazon.jsii.Kernel.get(this, "jobSample", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataBrew::Job.JobSample`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobSample(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnJob.JobSampleProperty value) {
        software.amazon.jsii.Kernel.set(this, "jobSample", value);
    }

    /**
     * `AWS::DataBrew::Job.JobSample`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobSample(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "jobSample", value);
    }

    /**
     * `AWS::DataBrew::Job.LogSubscription`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogSubscription() {
        return software.amazon.jsii.Kernel.get(this, "logSubscription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataBrew::Job.LogSubscription`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogSubscription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logSubscription", value);
    }

    /**
     * `AWS::DataBrew::Job.MaxCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::DataBrew::Job.MaxCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxCapacity", value);
    }

    /**
     * `AWS::DataBrew::Job.MaxRetries`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::DataBrew::Job.MaxRetries`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxRetries(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxRetries", value);
    }

    /**
     * `AWS::DataBrew::Job.OutputLocation`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputLocation() {
        return software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataBrew::Job.OutputLocation`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnJob.OutputLocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "outputLocation", value);
    }

    /**
     * `AWS::DataBrew::Job.OutputLocation`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputLocation", value);
    }

    /**
     * `AWS::DataBrew::Job.Outputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
        return software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataBrew::Job.Outputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputs", value);
    }

    /**
     * `AWS::DataBrew::Job.Outputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "outputs", value);
    }

    /**
     * `AWS::DataBrew::Job.ProfileConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProfileConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "profileConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataBrew::Job.ProfileConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProfileConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnJob.ProfileConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "profileConfiguration", value);
    }

    /**
     * `AWS::DataBrew::Job.ProfileConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProfileConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "profileConfiguration", value);
    }

    /**
     * `AWS::DataBrew::Job.ProjectName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProjectName() {
        return software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataBrew::Job.ProjectName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProjectName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "projectName", value);
    }

    /**
     * `AWS::DataBrew::Job.Recipe`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRecipe() {
        return software.amazon.jsii.Kernel.get(this, "recipe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataBrew::Job.Recipe`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecipe(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.databrew.CfnJob.RecipeProperty value) {
        software.amazon.jsii.Kernel.set(this, "recipe", value);
    }

    /**
     * `AWS::DataBrew::Job.Recipe`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecipe(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "recipe", value);
    }

    /**
     * `AWS::DataBrew::Job.Timeout`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::DataBrew::Job.Timeout`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }

    /**
     * `AWS::DataBrew::Job.ValidationConfigurations`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getValidationConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "validationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataBrew::Job.ValidationConfigurations`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "validationConfigurations", value);
    }

    /**
     * `AWS::DataBrew::Job.ValidationConfigurations`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidationConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "validationConfigurations", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * AllowedStatisticsProperty allowedStatisticsProperty = AllowedStatisticsProperty.builder()
     *         .statistics(List.of("statistics"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.AllowedStatisticsProperty")
    @software.amazon.jsii.Jsii.Proxy(AllowedStatisticsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AllowedStatisticsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.AllowedStatisticsProperty.Statistics`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStatistics();

        /**
         * @return a {@link Builder} of {@link AllowedStatisticsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AllowedStatisticsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AllowedStatisticsProperty> {
            java.util.List<java.lang.String> statistics;

            /**
             * Sets the value of {@link AllowedStatisticsProperty#getStatistics}
             * @param statistics `CfnJob.AllowedStatisticsProperty.Statistics`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(java.util.List<java.lang.String> statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AllowedStatisticsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AllowedStatisticsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AllowedStatisticsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllowedStatisticsProperty {
            private final java.util.List<java.lang.String> statistics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statistics = software.amazon.jsii.Kernel.get(this, "statistics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statistics = java.util.Objects.requireNonNull(builder.statistics, "statistics is required");
            }

            @Override
            public final java.util.List<java.lang.String> getStatistics() {
                return this.statistics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statistics", om.valueToTree(this.getStatistics()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.AllowedStatisticsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AllowedStatisticsProperty.Jsii$Proxy that = (AllowedStatisticsProperty.Jsii$Proxy) o;

                return this.statistics.equals(that.statistics);
            }

            @Override
            public final int hashCode() {
                int result = this.statistics.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ColumnSelectorProperty columnSelectorProperty = ColumnSelectorProperty.builder()
     *         .name("name")
     *         .regex("regex")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.ColumnSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.ColumnSelectorProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * `CfnJob.ColumnSelectorProperty.Regex`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnSelectorProperty> {
            java.lang.String name;
            java.lang.String regex;

            /**
             * Sets the value of {@link ColumnSelectorProperty#getName}
             * @param name `CfnJob.ColumnSelectorProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ColumnSelectorProperty#getRegex}
             * @param regex `CfnJob.ColumnSelectorProperty.Regex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnSelectorProperty {
            private final java.lang.String name;
            private final java.lang.String regex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.regex = builder.regex;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.ColumnSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnSelectorProperty.Jsii$Proxy that = (ColumnSelectorProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.regex != null ? this.regex.equals(that.regex) : that.regex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * Object parameters;
     * ColumnStatisticsConfigurationProperty columnStatisticsConfigurationProperty = ColumnStatisticsConfigurationProperty.builder()
     *         .statistics(StatisticsConfigurationProperty.builder()
     *                 .includedStatistics(List.of("includedStatistics"))
     *                 .overrides(List.of(StatisticOverrideProperty.builder()
     *                         .parameters(parameters)
     *                         .statistic("statistic")
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .selectors(List.of(ColumnSelectorProperty.builder()
     *                 .name("name")
     *                 .regex("regex")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.ColumnStatisticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnStatisticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnStatisticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.ColumnStatisticsConfigurationProperty.Statistics`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatistics();

        /**
         * `CfnJob.ColumnStatisticsConfigurationProperty.Selectors`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectors() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnStatisticsConfigurationProperty> {
            java.lang.Object statistics;
            java.lang.Object selectors;

            /**
             * Sets the value of {@link ColumnStatisticsConfigurationProperty#getStatistics}
             * @param statistics `CfnJob.ColumnStatisticsConfigurationProperty.Statistics`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.services.databrew.CfnJob.StatisticsConfigurationProperty statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Sets the value of {@link ColumnStatisticsConfigurationProperty#getStatistics}
             * @param statistics `CfnJob.ColumnStatisticsConfigurationProperty.Statistics`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistics(software.amazon.awscdk.IResolvable statistics) {
                this.statistics = statistics;
                return this;
            }

            /**
             * Sets the value of {@link ColumnStatisticsConfigurationProperty#getSelectors}
             * @param selectors `CfnJob.ColumnStatisticsConfigurationProperty.Selectors`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectors(software.amazon.awscdk.IResolvable selectors) {
                this.selectors = selectors;
                return this;
            }

            /**
             * Sets the value of {@link ColumnStatisticsConfigurationProperty#getSelectors}
             * @param selectors `CfnJob.ColumnStatisticsConfigurationProperty.Selectors`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectors(java.util.List<? extends java.lang.Object> selectors) {
                this.selectors = selectors;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnStatisticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnStatisticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnStatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnStatisticsConfigurationProperty {
            private final java.lang.Object statistics;
            private final java.lang.Object selectors;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statistics = software.amazon.jsii.Kernel.get(this, "statistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selectors = software.amazon.jsii.Kernel.get(this, "selectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statistics = java.util.Objects.requireNonNull(builder.statistics, "statistics is required");
                this.selectors = builder.selectors;
            }

            @Override
            public final java.lang.Object getStatistics() {
                return this.statistics;
            }

            @Override
            public final java.lang.Object getSelectors() {
                return this.selectors;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statistics", om.valueToTree(this.getStatistics()));
                if (this.getSelectors() != null) {
                    data.set("selectors", om.valueToTree(this.getSelectors()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.ColumnStatisticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnStatisticsConfigurationProperty.Jsii$Proxy that = (ColumnStatisticsConfigurationProperty.Jsii$Proxy) o;

                if (!statistics.equals(that.statistics)) return false;
                return this.selectors != null ? this.selectors.equals(that.selectors) : that.selectors == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statistics.hashCode();
                result = 31 * result + (this.selectors != null ? this.selectors.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * CsvOutputOptionsProperty csvOutputOptionsProperty = CsvOutputOptionsProperty.builder()
     *         .delimiter("delimiter")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.CsvOutputOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvOutputOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvOutputOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.CsvOutputOptionsProperty.Delimiter`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvOutputOptionsProperty> {
            java.lang.String delimiter;

            /**
             * Sets the value of {@link CsvOutputOptionsProperty#getDelimiter}
             * @param delimiter `CfnJob.CsvOutputOptionsProperty.Delimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvOutputOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvOutputOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvOutputOptionsProperty {
            private final java.lang.String delimiter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delimiter = builder.delimiter;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.CsvOutputOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvOutputOptionsProperty.Jsii$Proxy that = (CsvOutputOptionsProperty.Jsii$Proxy) o;

                return this.delimiter != null ? this.delimiter.equals(that.delimiter) : that.delimiter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.delimiter != null ? this.delimiter.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DataCatalogOutputProperty dataCatalogOutputProperty = DataCatalogOutputProperty.builder()
     *         .databaseName("databaseName")
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .catalogId("catalogId")
     *         .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .tempDirectory(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .bucketOwner("bucketOwner")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .overwrite(false)
     *         .s3Options(S3TableOutputOptionsProperty.builder()
     *                 .location(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .bucketOwner("bucketOwner")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.DataCatalogOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCatalogOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCatalogOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.DataCatalogOutputProperty.DatabaseName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * `CfnJob.DataCatalogOutputProperty.TableName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * `CfnJob.DataCatalogOutputProperty.CatalogId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * `CfnJob.DataCatalogOutputProperty.DatabaseOptions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseOptions() {
            return null;
        }

        /**
         * `CfnJob.DataCatalogOutputProperty.Overwrite`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwrite() {
            return null;
        }

        /**
         * `CfnJob.DataCatalogOutputProperty.S3Options`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Options() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataCatalogOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCatalogOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCatalogOutputProperty> {
            java.lang.String databaseName;
            java.lang.String tableName;
            java.lang.String catalogId;
            java.lang.Object databaseOptions;
            java.lang.Object overwrite;
            java.lang.Object s3Options;

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getDatabaseName}
             * @param databaseName `CfnJob.DataCatalogOutputProperty.DatabaseName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getTableName}
             * @param tableName `CfnJob.DataCatalogOutputProperty.TableName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getCatalogId}
             * @param catalogId `CfnJob.DataCatalogOutputProperty.CatalogId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getDatabaseOptions}
             * @param databaseOptions `CfnJob.DataCatalogOutputProperty.DatabaseOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOptions(software.amazon.awscdk.services.databrew.CfnJob.DatabaseTableOutputOptionsProperty databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getDatabaseOptions}
             * @param databaseOptions `CfnJob.DataCatalogOutputProperty.DatabaseOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOptions(software.amazon.awscdk.IResolvable databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getOverwrite}
             * @param overwrite `CfnJob.DataCatalogOutputProperty.Overwrite`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(java.lang.Boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getOverwrite}
             * @param overwrite `CfnJob.DataCatalogOutputProperty.Overwrite`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(software.amazon.awscdk.IResolvable overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getS3Options}
             * @param s3Options `CfnJob.DataCatalogOutputProperty.S3Options`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Options(software.amazon.awscdk.services.databrew.CfnJob.S3TableOutputOptionsProperty s3Options) {
                this.s3Options = s3Options;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogOutputProperty#getS3Options}
             * @param s3Options `CfnJob.DataCatalogOutputProperty.S3Options`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Options(software.amazon.awscdk.IResolvable s3Options) {
                this.s3Options = s3Options;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCatalogOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCatalogOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCatalogOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCatalogOutputProperty {
            private final java.lang.String databaseName;
            private final java.lang.String tableName;
            private final java.lang.String catalogId;
            private final java.lang.Object databaseOptions;
            private final java.lang.Object overwrite;
            private final java.lang.Object s3Options;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseOptions = software.amazon.jsii.Kernel.get(this, "databaseOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overwrite = software.amazon.jsii.Kernel.get(this, "overwrite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Options = software.amazon.jsii.Kernel.get(this, "s3Options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.catalogId = builder.catalogId;
                this.databaseOptions = builder.databaseOptions;
                this.overwrite = builder.overwrite;
                this.s3Options = builder.s3Options;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.Object getDatabaseOptions() {
                return this.databaseOptions;
            }

            @Override
            public final java.lang.Object getOverwrite() {
                return this.overwrite;
            }

            @Override
            public final java.lang.Object getS3Options() {
                return this.s3Options;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getDatabaseOptions() != null) {
                    data.set("databaseOptions", om.valueToTree(this.getDatabaseOptions()));
                }
                if (this.getOverwrite() != null) {
                    data.set("overwrite", om.valueToTree(this.getOverwrite()));
                }
                if (this.getS3Options() != null) {
                    data.set("s3Options", om.valueToTree(this.getS3Options()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.DataCatalogOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCatalogOutputProperty.Jsii$Proxy that = (DataCatalogOutputProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!tableName.equals(that.tableName)) return false;
                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                if (this.databaseOptions != null ? !this.databaseOptions.equals(that.databaseOptions) : that.databaseOptions != null) return false;
                if (this.overwrite != null ? !this.overwrite.equals(that.overwrite) : that.overwrite != null) return false;
                return this.s3Options != null ? this.s3Options.equals(that.s3Options) : that.s3Options == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.catalogId != null ? this.catalogId.hashCode() : 0);
                result = 31 * result + (this.databaseOptions != null ? this.databaseOptions.hashCode() : 0);
                result = 31 * result + (this.overwrite != null ? this.overwrite.hashCode() : 0);
                result = 31 * result + (this.s3Options != null ? this.s3Options.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DatabaseOutputProperty databaseOutputProperty = DatabaseOutputProperty.builder()
     *         .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .tempDirectory(S3LocationProperty.builder()
     *                         .bucket("bucket")
     *                         // the properties below are optional
     *                         .bucketOwner("bucketOwner")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .glueConnectionName("glueConnectionName")
     *         // the properties below are optional
     *         .databaseOutputMode("databaseOutputMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.DatabaseOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.DatabaseOutputProperty.DatabaseOptions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDatabaseOptions();

        /**
         * `CfnJob.DatabaseOutputProperty.GlueConnectionName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGlueConnectionName();

        /**
         * `CfnJob.DatabaseOutputProperty.DatabaseOutputMode`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseOutputMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseOutputProperty> {
            java.lang.Object databaseOptions;
            java.lang.String glueConnectionName;
            java.lang.String databaseOutputMode;

            /**
             * Sets the value of {@link DatabaseOutputProperty#getDatabaseOptions}
             * @param databaseOptions `CfnJob.DatabaseOutputProperty.DatabaseOptions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOptions(software.amazon.awscdk.services.databrew.CfnJob.DatabaseTableOutputOptionsProperty databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseOutputProperty#getDatabaseOptions}
             * @param databaseOptions `CfnJob.DatabaseOutputProperty.DatabaseOptions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOptions(software.amazon.awscdk.IResolvable databaseOptions) {
                this.databaseOptions = databaseOptions;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseOutputProperty#getGlueConnectionName}
             * @param glueConnectionName `CfnJob.DatabaseOutputProperty.GlueConnectionName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueConnectionName(java.lang.String glueConnectionName) {
                this.glueConnectionName = glueConnectionName;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseOutputProperty#getDatabaseOutputMode}
             * @param databaseOutputMode `CfnJob.DatabaseOutputProperty.DatabaseOutputMode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseOutputMode(java.lang.String databaseOutputMode) {
                this.databaseOutputMode = databaseOutputMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseOutputProperty {
            private final java.lang.Object databaseOptions;
            private final java.lang.String glueConnectionName;
            private final java.lang.String databaseOutputMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseOptions = software.amazon.jsii.Kernel.get(this, "databaseOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.glueConnectionName = software.amazon.jsii.Kernel.get(this, "glueConnectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseOutputMode = software.amazon.jsii.Kernel.get(this, "databaseOutputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseOptions = java.util.Objects.requireNonNull(builder.databaseOptions, "databaseOptions is required");
                this.glueConnectionName = java.util.Objects.requireNonNull(builder.glueConnectionName, "glueConnectionName is required");
                this.databaseOutputMode = builder.databaseOutputMode;
            }

            @Override
            public final java.lang.Object getDatabaseOptions() {
                return this.databaseOptions;
            }

            @Override
            public final java.lang.String getGlueConnectionName() {
                return this.glueConnectionName;
            }

            @Override
            public final java.lang.String getDatabaseOutputMode() {
                return this.databaseOutputMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseOptions", om.valueToTree(this.getDatabaseOptions()));
                data.set("glueConnectionName", om.valueToTree(this.getGlueConnectionName()));
                if (this.getDatabaseOutputMode() != null) {
                    data.set("databaseOutputMode", om.valueToTree(this.getDatabaseOutputMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.DatabaseOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseOutputProperty.Jsii$Proxy that = (DatabaseOutputProperty.Jsii$Proxy) o;

                if (!databaseOptions.equals(that.databaseOptions)) return false;
                if (!glueConnectionName.equals(that.glueConnectionName)) return false;
                return this.databaseOutputMode != null ? this.databaseOutputMode.equals(that.databaseOutputMode) : that.databaseOutputMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseOptions.hashCode();
                result = 31 * result + (this.glueConnectionName.hashCode());
                result = 31 * result + (this.databaseOutputMode != null ? this.databaseOutputMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * DatabaseTableOutputOptionsProperty databaseTableOutputOptionsProperty = DatabaseTableOutputOptionsProperty.builder()
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .tempDirectory(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.DatabaseTableOutputOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseTableOutputOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseTableOutputOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.DatabaseTableOutputOptionsProperty.TableName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * `CfnJob.DatabaseTableOutputOptionsProperty.TempDirectory`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTempDirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseTableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseTableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseTableOutputOptionsProperty> {
            java.lang.String tableName;
            java.lang.Object tempDirectory;

            /**
             * Sets the value of {@link DatabaseTableOutputOptionsProperty#getTableName}
             * @param tableName `CfnJob.DatabaseTableOutputOptionsProperty.TableName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseTableOutputOptionsProperty#getTempDirectory}
             * @param tempDirectory `CfnJob.DatabaseTableOutputOptionsProperty.TempDirectory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.services.databrew.CfnJob.S3LocationProperty tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseTableOutputOptionsProperty#getTempDirectory}
             * @param tempDirectory `CfnJob.DatabaseTableOutputOptionsProperty.TempDirectory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tempDirectory(software.amazon.awscdk.IResolvable tempDirectory) {
                this.tempDirectory = tempDirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseTableOutputOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseTableOutputOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseTableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseTableOutputOptionsProperty {
            private final java.lang.String tableName;
            private final java.lang.Object tempDirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tempDirectory = software.amazon.jsii.Kernel.get(this, "tempDirectory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.tempDirectory = builder.tempDirectory;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getTempDirectory() {
                return this.tempDirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getTempDirectory() != null) {
                    data.set("tempDirectory", om.valueToTree(this.getTempDirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.DatabaseTableOutputOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseTableOutputOptionsProperty.Jsii$Proxy that = (DatabaseTableOutputOptionsProperty.Jsii$Proxy) o;

                if (!tableName.equals(that.tableName)) return false;
                return this.tempDirectory != null ? this.tempDirectory.equals(that.tempDirectory) : that.tempDirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tableName.hashCode();
                result = 31 * result + (this.tempDirectory != null ? this.tempDirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * EntityDetectorConfigurationProperty entityDetectorConfigurationProperty = EntityDetectorConfigurationProperty.builder()
     *         .entityTypes(List.of("entityTypes"))
     *         // the properties below are optional
     *         .allowedStatistics(AllowedStatisticsProperty.builder()
     *                 .statistics(List.of("statistics"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.EntityDetectorConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EntityDetectorConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EntityDetectorConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.EntityDetectorConfigurationProperty.EntityTypes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEntityTypes();

        /**
         * `CfnJob.EntityDetectorConfigurationProperty.AllowedStatistics`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowedStatistics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EntityDetectorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EntityDetectorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EntityDetectorConfigurationProperty> {
            java.util.List<java.lang.String> entityTypes;
            java.lang.Object allowedStatistics;

            /**
             * Sets the value of {@link EntityDetectorConfigurationProperty#getEntityTypes}
             * @param entityTypes `CfnJob.EntityDetectorConfigurationProperty.EntityTypes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityTypes(java.util.List<java.lang.String> entityTypes) {
                this.entityTypes = entityTypes;
                return this;
            }

            /**
             * Sets the value of {@link EntityDetectorConfigurationProperty#getAllowedStatistics}
             * @param allowedStatistics `CfnJob.EntityDetectorConfigurationProperty.AllowedStatistics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedStatistics(software.amazon.awscdk.services.databrew.CfnJob.AllowedStatisticsProperty allowedStatistics) {
                this.allowedStatistics = allowedStatistics;
                return this;
            }

            /**
             * Sets the value of {@link EntityDetectorConfigurationProperty#getAllowedStatistics}
             * @param allowedStatistics `CfnJob.EntityDetectorConfigurationProperty.AllowedStatistics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedStatistics(software.amazon.awscdk.IResolvable allowedStatistics) {
                this.allowedStatistics = allowedStatistics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EntityDetectorConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EntityDetectorConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EntityDetectorConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EntityDetectorConfigurationProperty {
            private final java.util.List<java.lang.String> entityTypes;
            private final java.lang.Object allowedStatistics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityTypes = software.amazon.jsii.Kernel.get(this, "entityTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedStatistics = software.amazon.jsii.Kernel.get(this, "allowedStatistics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityTypes = java.util.Objects.requireNonNull(builder.entityTypes, "entityTypes is required");
                this.allowedStatistics = builder.allowedStatistics;
            }

            @Override
            public final java.util.List<java.lang.String> getEntityTypes() {
                return this.entityTypes;
            }

            @Override
            public final java.lang.Object getAllowedStatistics() {
                return this.allowedStatistics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityTypes", om.valueToTree(this.getEntityTypes()));
                if (this.getAllowedStatistics() != null) {
                    data.set("allowedStatistics", om.valueToTree(this.getAllowedStatistics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.EntityDetectorConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EntityDetectorConfigurationProperty.Jsii$Proxy that = (EntityDetectorConfigurationProperty.Jsii$Proxy) o;

                if (!entityTypes.equals(that.entityTypes)) return false;
                return this.allowedStatistics != null ? this.allowedStatistics.equals(that.allowedStatistics) : that.allowedStatistics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityTypes.hashCode();
                result = 31 * result + (this.allowedStatistics != null ? this.allowedStatistics.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * JobSampleProperty jobSampleProperty = JobSampleProperty.builder()
     *         .mode("mode")
     *         .size(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.JobSampleProperty")
    @software.amazon.jsii.Jsii.Proxy(JobSampleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JobSampleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.JobSampleProperty.Mode`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * `CfnJob.JobSampleProperty.Size`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JobSampleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JobSampleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JobSampleProperty> {
            java.lang.String mode;
            java.lang.Number size;

            /**
             * Sets the value of {@link JobSampleProperty#getMode}
             * @param mode `CfnJob.JobSampleProperty.Mode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link JobSampleProperty#getSize}
             * @param size `CfnJob.JobSampleProperty.Size`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JobSampleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JobSampleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JobSampleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobSampleProperty {
            private final java.lang.String mode;
            private final java.lang.Number size;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = builder.mode;
                this.size = builder.size;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getSize() != null) {
                    data.set("size", om.valueToTree(this.getSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.JobSampleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JobSampleProperty.Jsii$Proxy that = (JobSampleProperty.Jsii$Proxy) o;

                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.size != null ? this.size.equals(that.size) : that.size == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mode != null ? this.mode.hashCode() : 0;
                result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * OutputFormatOptionsProperty outputFormatOptionsProperty = OutputFormatOptionsProperty.builder()
     *         .csv(CsvOutputOptionsProperty.builder()
     *                 .delimiter("delimiter")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.OutputFormatOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputFormatOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputFormatOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.OutputFormatOptionsProperty.Csv`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsv() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputFormatOptionsProperty> {
            java.lang.Object csv;

            /**
             * Sets the value of {@link OutputFormatOptionsProperty#getCsv}
             * @param csv `CfnJob.OutputFormatOptionsProperty.Csv`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.services.databrew.CfnJob.CsvOutputOptionsProperty csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link OutputFormatOptionsProperty#getCsv}
             * @param csv `CfnJob.OutputFormatOptionsProperty.Csv`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.IResolvable csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputFormatOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputFormatOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputFormatOptionsProperty {
            private final java.lang.Object csv;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csv = software.amazon.jsii.Kernel.get(this, "csv", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csv = builder.csv;
            }

            @Override
            public final java.lang.Object getCsv() {
                return this.csv;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsv() != null) {
                    data.set("csv", om.valueToTree(this.getCsv()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.OutputFormatOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputFormatOptionsProperty.Jsii$Proxy that = (OutputFormatOptionsProperty.Jsii$Proxy) o;

                return this.csv != null ? this.csv.equals(that.csv) : that.csv == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csv != null ? this.csv.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * OutputLocationProperty outputLocationProperty = OutputLocationProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .bucketOwner("bucketOwner")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.OutputLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.OutputLocationProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnJob.OutputLocationProperty.BucketOwner`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwner() {
            return null;
        }

        /**
         * `CfnJob.OutputLocationProperty.Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputLocationProperty> {
            java.lang.String bucket;
            java.lang.String bucketOwner;
            java.lang.String key;

            /**
             * Sets the value of {@link OutputLocationProperty#getBucket}
             * @param bucket `CfnJob.OutputLocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link OutputLocationProperty#getBucketOwner}
             * @param bucketOwner `CfnJob.OutputLocationProperty.BucketOwner`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwner(java.lang.String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link OutputLocationProperty#getKey}
             * @param key `CfnJob.OutputLocationProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputLocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String bucketOwner;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketOwner = software.amazon.jsii.Kernel.get(this, "bucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.bucketOwner = builder.bucketOwner;
                this.key = builder.key;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getBucketOwner() {
                return this.bucketOwner;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getBucketOwner() != null) {
                    data.set("bucketOwner", om.valueToTree(this.getBucketOwner()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.OutputLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputLocationProperty.Jsii$Proxy that = (OutputLocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.bucketOwner != null ? !this.bucketOwner.equals(that.bucketOwner) : that.bucketOwner != null) return false;
                return this.key != null ? this.key.equals(that.key) : that.key == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.bucketOwner != null ? this.bucketOwner.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * OutputProperty outputProperty = OutputProperty.builder()
     *         .location(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         // the properties below are optional
     *         .compressionFormat("compressionFormat")
     *         .format("format")
     *         .formatOptions(OutputFormatOptionsProperty.builder()
     *                 .csv(CsvOutputOptionsProperty.builder()
     *                         .delimiter("delimiter")
     *                         .build())
     *                 .build())
     *         .overwrite(false)
     *         .partitionColumns(List.of("partitionColumns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.OutputProperty.Location`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLocation();

        /**
         * `CfnJob.OutputProperty.CompressionFormat`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionFormat() {
            return null;
        }

        /**
         * `CfnJob.OutputProperty.Format`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * `CfnJob.OutputProperty.FormatOptions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormatOptions() {
            return null;
        }

        /**
         * `CfnJob.OutputProperty.Overwrite`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwrite() {
            return null;
        }

        /**
         * `CfnJob.OutputProperty.PartitionColumns`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPartitionColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputProperty> {
            java.lang.Object location;
            java.lang.String compressionFormat;
            java.lang.String format;
            java.lang.Object formatOptions;
            java.lang.Object overwrite;
            java.util.List<java.lang.String> partitionColumns;

            /**
             * Sets the value of {@link OutputProperty#getLocation}
             * @param location `CfnJob.OutputProperty.Location`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.services.databrew.CfnJob.S3LocationProperty location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getLocation}
             * @param location `CfnJob.OutputProperty.Location`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.IResolvable location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getCompressionFormat}
             * @param compressionFormat `CfnJob.OutputProperty.CompressionFormat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionFormat(java.lang.String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getFormat}
             * @param format `CfnJob.OutputProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getFormatOptions}
             * @param formatOptions `CfnJob.OutputProperty.FormatOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatOptions(software.amazon.awscdk.services.databrew.CfnJob.OutputFormatOptionsProperty formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getFormatOptions}
             * @param formatOptions `CfnJob.OutputProperty.FormatOptions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatOptions(software.amazon.awscdk.IResolvable formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getOverwrite}
             * @param overwrite `CfnJob.OutputProperty.Overwrite`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(java.lang.Boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getOverwrite}
             * @param overwrite `CfnJob.OutputProperty.Overwrite`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwrite(software.amazon.awscdk.IResolvable overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getPartitionColumns}
             * @param partitionColumns `CfnJob.OutputProperty.PartitionColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionColumns(java.util.List<java.lang.String> partitionColumns) {
                this.partitionColumns = partitionColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputProperty {
            private final java.lang.Object location;
            private final java.lang.String compressionFormat;
            private final java.lang.String format;
            private final java.lang.Object formatOptions;
            private final java.lang.Object overwrite;
            private final java.util.List<java.lang.String> partitionColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compressionFormat = software.amazon.jsii.Kernel.get(this, "compressionFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.formatOptions = software.amazon.jsii.Kernel.get(this, "formatOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overwrite = software.amazon.jsii.Kernel.get(this, "overwrite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionColumns = software.amazon.jsii.Kernel.get(this, "partitionColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
                this.compressionFormat = builder.compressionFormat;
                this.format = builder.format;
                this.formatOptions = builder.formatOptions;
                this.overwrite = builder.overwrite;
                this.partitionColumns = builder.partitionColumns;
            }

            @Override
            public final java.lang.Object getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.String getCompressionFormat() {
                return this.compressionFormat;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.Object getFormatOptions() {
                return this.formatOptions;
            }

            @Override
            public final java.lang.Object getOverwrite() {
                return this.overwrite;
            }

            @Override
            public final java.util.List<java.lang.String> getPartitionColumns() {
                return this.partitionColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("location", om.valueToTree(this.getLocation()));
                if (this.getCompressionFormat() != null) {
                    data.set("compressionFormat", om.valueToTree(this.getCompressionFormat()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }
                if (this.getFormatOptions() != null) {
                    data.set("formatOptions", om.valueToTree(this.getFormatOptions()));
                }
                if (this.getOverwrite() != null) {
                    data.set("overwrite", om.valueToTree(this.getOverwrite()));
                }
                if (this.getPartitionColumns() != null) {
                    data.set("partitionColumns", om.valueToTree(this.getPartitionColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputProperty.Jsii$Proxy that = (OutputProperty.Jsii$Proxy) o;

                if (!location.equals(that.location)) return false;
                if (this.compressionFormat != null ? !this.compressionFormat.equals(that.compressionFormat) : that.compressionFormat != null) return false;
                if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
                if (this.formatOptions != null ? !this.formatOptions.equals(that.formatOptions) : that.formatOptions != null) return false;
                if (this.overwrite != null ? !this.overwrite.equals(that.overwrite) : that.overwrite != null) return false;
                return this.partitionColumns != null ? this.partitionColumns.equals(that.partitionColumns) : that.partitionColumns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.location.hashCode();
                result = 31 * result + (this.compressionFormat != null ? this.compressionFormat.hashCode() : 0);
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                result = 31 * result + (this.formatOptions != null ? this.formatOptions.hashCode() : 0);
                result = 31 * result + (this.overwrite != null ? this.overwrite.hashCode() : 0);
                result = 31 * result + (this.partitionColumns != null ? this.partitionColumns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * Object parameters;
     * ProfileConfigurationProperty profileConfigurationProperty = ProfileConfigurationProperty.builder()
     *         .columnStatisticsConfigurations(List.of(ColumnStatisticsConfigurationProperty.builder()
     *                 .statistics(StatisticsConfigurationProperty.builder()
     *                         .includedStatistics(List.of("includedStatistics"))
     *                         .overrides(List.of(StatisticOverrideProperty.builder()
     *                                 .parameters(parameters)
     *                                 .statistic("statistic")
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .selectors(List.of(ColumnSelectorProperty.builder()
     *                         .name("name")
     *                         .regex("regex")
     *                         .build()))
     *                 .build()))
     *         .datasetStatisticsConfiguration(StatisticsConfigurationProperty.builder()
     *                 .includedStatistics(List.of("includedStatistics"))
     *                 .overrides(List.of(StatisticOverrideProperty.builder()
     *                         .parameters(parameters)
     *                         .statistic("statistic")
     *                         .build()))
     *                 .build())
     *         .entityDetectorConfiguration(EntityDetectorConfigurationProperty.builder()
     *                 .entityTypes(List.of("entityTypes"))
     *                 // the properties below are optional
     *                 .allowedStatistics(AllowedStatisticsProperty.builder()
     *                         .statistics(List.of("statistics"))
     *                         .build())
     *                 .build())
     *         .profileColumns(List.of(ColumnSelectorProperty.builder()
     *                 .name("name")
     *                 .regex("regex")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.ProfileConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProfileConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProfileConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.ProfileConfigurationProperty.ColumnStatisticsConfigurations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnStatisticsConfigurations() {
            return null;
        }

        /**
         * `CfnJob.ProfileConfigurationProperty.DatasetStatisticsConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatasetStatisticsConfiguration() {
            return null;
        }

        /**
         * `CfnJob.ProfileConfigurationProperty.EntityDetectorConfiguration`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEntityDetectorConfiguration() {
            return null;
        }

        /**
         * `CfnJob.ProfileConfigurationProperty.ProfileColumns`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProfileColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProfileConfigurationProperty> {
            java.lang.Object columnStatisticsConfigurations;
            java.lang.Object datasetStatisticsConfiguration;
            java.lang.Object entityDetectorConfiguration;
            java.lang.Object profileColumns;

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getColumnStatisticsConfigurations}
             * @param columnStatisticsConfigurations `CfnJob.ProfileConfigurationProperty.ColumnStatisticsConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnStatisticsConfigurations(software.amazon.awscdk.IResolvable columnStatisticsConfigurations) {
                this.columnStatisticsConfigurations = columnStatisticsConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getColumnStatisticsConfigurations}
             * @param columnStatisticsConfigurations `CfnJob.ProfileConfigurationProperty.ColumnStatisticsConfigurations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnStatisticsConfigurations(java.util.List<? extends java.lang.Object> columnStatisticsConfigurations) {
                this.columnStatisticsConfigurations = columnStatisticsConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getDatasetStatisticsConfiguration}
             * @param datasetStatisticsConfiguration `CfnJob.ProfileConfigurationProperty.DatasetStatisticsConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetStatisticsConfiguration(software.amazon.awscdk.services.databrew.CfnJob.StatisticsConfigurationProperty datasetStatisticsConfiguration) {
                this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getDatasetStatisticsConfiguration}
             * @param datasetStatisticsConfiguration `CfnJob.ProfileConfigurationProperty.DatasetStatisticsConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetStatisticsConfiguration(software.amazon.awscdk.IResolvable datasetStatisticsConfiguration) {
                this.datasetStatisticsConfiguration = datasetStatisticsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getEntityDetectorConfiguration}
             * @param entityDetectorConfiguration `CfnJob.ProfileConfigurationProperty.EntityDetectorConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityDetectorConfiguration(software.amazon.awscdk.services.databrew.CfnJob.EntityDetectorConfigurationProperty entityDetectorConfiguration) {
                this.entityDetectorConfiguration = entityDetectorConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getEntityDetectorConfiguration}
             * @param entityDetectorConfiguration `CfnJob.ProfileConfigurationProperty.EntityDetectorConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityDetectorConfiguration(software.amazon.awscdk.IResolvable entityDetectorConfiguration) {
                this.entityDetectorConfiguration = entityDetectorConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getProfileColumns}
             * @param profileColumns `CfnJob.ProfileConfigurationProperty.ProfileColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileColumns(software.amazon.awscdk.IResolvable profileColumns) {
                this.profileColumns = profileColumns;
                return this;
            }

            /**
             * Sets the value of {@link ProfileConfigurationProperty#getProfileColumns}
             * @param profileColumns `CfnJob.ProfileConfigurationProperty.ProfileColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileColumns(java.util.List<? extends java.lang.Object> profileColumns) {
                this.profileColumns = profileColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProfileConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProfileConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProfileConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProfileConfigurationProperty {
            private final java.lang.Object columnStatisticsConfigurations;
            private final java.lang.Object datasetStatisticsConfiguration;
            private final java.lang.Object entityDetectorConfiguration;
            private final java.lang.Object profileColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnStatisticsConfigurations = software.amazon.jsii.Kernel.get(this, "columnStatisticsConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datasetStatisticsConfiguration = software.amazon.jsii.Kernel.get(this, "datasetStatisticsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.entityDetectorConfiguration = software.amazon.jsii.Kernel.get(this, "entityDetectorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.profileColumns = software.amazon.jsii.Kernel.get(this, "profileColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnStatisticsConfigurations = builder.columnStatisticsConfigurations;
                this.datasetStatisticsConfiguration = builder.datasetStatisticsConfiguration;
                this.entityDetectorConfiguration = builder.entityDetectorConfiguration;
                this.profileColumns = builder.profileColumns;
            }

            @Override
            public final java.lang.Object getColumnStatisticsConfigurations() {
                return this.columnStatisticsConfigurations;
            }

            @Override
            public final java.lang.Object getDatasetStatisticsConfiguration() {
                return this.datasetStatisticsConfiguration;
            }

            @Override
            public final java.lang.Object getEntityDetectorConfiguration() {
                return this.entityDetectorConfiguration;
            }

            @Override
            public final java.lang.Object getProfileColumns() {
                return this.profileColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnStatisticsConfigurations() != null) {
                    data.set("columnStatisticsConfigurations", om.valueToTree(this.getColumnStatisticsConfigurations()));
                }
                if (this.getDatasetStatisticsConfiguration() != null) {
                    data.set("datasetStatisticsConfiguration", om.valueToTree(this.getDatasetStatisticsConfiguration()));
                }
                if (this.getEntityDetectorConfiguration() != null) {
                    data.set("entityDetectorConfiguration", om.valueToTree(this.getEntityDetectorConfiguration()));
                }
                if (this.getProfileColumns() != null) {
                    data.set("profileColumns", om.valueToTree(this.getProfileColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.ProfileConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProfileConfigurationProperty.Jsii$Proxy that = (ProfileConfigurationProperty.Jsii$Proxy) o;

                if (this.columnStatisticsConfigurations != null ? !this.columnStatisticsConfigurations.equals(that.columnStatisticsConfigurations) : that.columnStatisticsConfigurations != null) return false;
                if (this.datasetStatisticsConfiguration != null ? !this.datasetStatisticsConfiguration.equals(that.datasetStatisticsConfiguration) : that.datasetStatisticsConfiguration != null) return false;
                if (this.entityDetectorConfiguration != null ? !this.entityDetectorConfiguration.equals(that.entityDetectorConfiguration) : that.entityDetectorConfiguration != null) return false;
                return this.profileColumns != null ? this.profileColumns.equals(that.profileColumns) : that.profileColumns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnStatisticsConfigurations != null ? this.columnStatisticsConfigurations.hashCode() : 0;
                result = 31 * result + (this.datasetStatisticsConfiguration != null ? this.datasetStatisticsConfiguration.hashCode() : 0);
                result = 31 * result + (this.entityDetectorConfiguration != null ? this.entityDetectorConfiguration.hashCode() : 0);
                result = 31 * result + (this.profileColumns != null ? this.profileColumns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * RecipeProperty recipeProperty = RecipeProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.RecipeProperty")
    @software.amazon.jsii.Jsii.Proxy(RecipeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecipeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.RecipeProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnJob.RecipeProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RecipeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecipeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecipeProperty> {
            java.lang.String name;
            java.lang.String version;

            /**
             * Sets the value of {@link RecipeProperty#getName}
             * @param name `CfnJob.RecipeProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RecipeProperty#getVersion}
             * @param version `CfnJob.RecipeProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecipeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecipeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecipeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecipeProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.RecipeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecipeProperty.Jsii$Proxy that = (RecipeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .bucketOwner("bucketOwner")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.S3LocationProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnJob.S3LocationProperty.BucketOwner`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketOwner() {
            return null;
        }

        /**
         * `CfnJob.S3LocationProperty.Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String bucketOwner;
            java.lang.String key;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket `CfnJob.S3LocationProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getBucketOwner}
             * @param bucketOwner `CfnJob.S3LocationProperty.BucketOwner`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketOwner(java.lang.String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key `CfnJob.S3LocationProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String bucketOwner;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketOwner = software.amazon.jsii.Kernel.get(this, "bucketOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.bucketOwner = builder.bucketOwner;
                this.key = builder.key;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getBucketOwner() {
                return this.bucketOwner;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getBucketOwner() != null) {
                    data.set("bucketOwner", om.valueToTree(this.getBucketOwner()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.bucketOwner != null ? !this.bucketOwner.equals(that.bucketOwner) : that.bucketOwner != null) return false;
                return this.key != null ? this.key.equals(that.key) : that.key == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.bucketOwner != null ? this.bucketOwner.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * S3TableOutputOptionsProperty s3TableOutputOptionsProperty = S3TableOutputOptionsProperty.builder()
     *         .location(S3LocationProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .bucketOwner("bucketOwner")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.S3TableOutputOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(S3TableOutputOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3TableOutputOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.S3TableOutputOptionsProperty.Location`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLocation();

        /**
         * @return a {@link Builder} of {@link S3TableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3TableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3TableOutputOptionsProperty> {
            java.lang.Object location;

            /**
             * Sets the value of {@link S3TableOutputOptionsProperty#getLocation}
             * @param location `CfnJob.S3TableOutputOptionsProperty.Location`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.services.databrew.CfnJob.S3LocationProperty location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link S3TableOutputOptionsProperty#getLocation}
             * @param location `CfnJob.S3TableOutputOptionsProperty.Location`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.IResolvable location) {
                this.location = location;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3TableOutputOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3TableOutputOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3TableOutputOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3TableOutputOptionsProperty {
            private final java.lang.Object location;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
            }

            @Override
            public final java.lang.Object getLocation() {
                return this.location;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("location", om.valueToTree(this.getLocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.S3TableOutputOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3TableOutputOptionsProperty.Jsii$Proxy that = (S3TableOutputOptionsProperty.Jsii$Proxy) o;

                return this.location.equals(that.location);
            }

            @Override
            public final int hashCode() {
                int result = this.location.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * Object parameters;
     * StatisticOverrideProperty statisticOverrideProperty = StatisticOverrideProperty.builder()
     *         .parameters(parameters)
     *         .statistic("statistic")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.StatisticOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(StatisticOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatisticOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.StatisticOverrideProperty.Parameters`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getParameters();

        /**
         * `CfnJob.StatisticOverrideProperty.Statistic`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatistic();

        /**
         * @return a {@link Builder} of {@link StatisticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatisticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatisticOverrideProperty> {
            java.lang.Object parameters;
            java.lang.String statistic;

            /**
             * Sets the value of {@link StatisticOverrideProperty#getParameters}
             * @param parameters `CfnJob.StatisticOverrideProperty.Parameters`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.lang.Object parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link StatisticOverrideProperty#getStatistic}
             * @param statistic `CfnJob.StatisticOverrideProperty.Statistic`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatisticOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatisticOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatisticOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatisticOverrideProperty {
            private final java.lang.Object parameters;
            private final java.lang.String statistic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameters = java.util.Objects.requireNonNull(builder.parameters, "parameters is required");
                this.statistic = java.util.Objects.requireNonNull(builder.statistic, "statistic is required");
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameters", om.valueToTree(this.getParameters()));
                data.set("statistic", om.valueToTree(this.getStatistic()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.StatisticOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatisticOverrideProperty.Jsii$Proxy that = (StatisticOverrideProperty.Jsii$Proxy) o;

                if (!parameters.equals(that.parameters)) return false;
                return this.statistic.equals(that.statistic);
            }

            @Override
            public final int hashCode() {
                int result = this.parameters.hashCode();
                result = 31 * result + (this.statistic.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * Object parameters;
     * StatisticsConfigurationProperty statisticsConfigurationProperty = StatisticsConfigurationProperty.builder()
     *         .includedStatistics(List.of("includedStatistics"))
     *         .overrides(List.of(StatisticOverrideProperty.builder()
     *                 .parameters(parameters)
     *                 .statistic("statistic")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.StatisticsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StatisticsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatisticsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.StatisticsConfigurationProperty.IncludedStatistics`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedStatistics() {
            return null;
        }

        /**
         * `CfnJob.StatisticsConfigurationProperty.Overrides`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatisticsConfigurationProperty> {
            java.util.List<java.lang.String> includedStatistics;
            java.lang.Object overrides;

            /**
             * Sets the value of {@link StatisticsConfigurationProperty#getIncludedStatistics}
             * @param includedStatistics `CfnJob.StatisticsConfigurationProperty.IncludedStatistics`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedStatistics(java.util.List<java.lang.String> includedStatistics) {
                this.includedStatistics = includedStatistics;
                return this;
            }

            /**
             * Sets the value of {@link StatisticsConfigurationProperty#getOverrides}
             * @param overrides `CfnJob.StatisticsConfigurationProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link StatisticsConfigurationProperty#getOverrides}
             * @param overrides `CfnJob.StatisticsConfigurationProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(java.util.List<? extends java.lang.Object> overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatisticsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatisticsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatisticsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatisticsConfigurationProperty {
            private final java.util.List<java.lang.String> includedStatistics;
            private final java.lang.Object overrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includedStatistics = software.amazon.jsii.Kernel.get(this, "includedStatistics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includedStatistics = builder.includedStatistics;
                this.overrides = builder.overrides;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedStatistics() {
                return this.includedStatistics;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIncludedStatistics() != null) {
                    data.set("includedStatistics", om.valueToTree(this.getIncludedStatistics()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.StatisticsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatisticsConfigurationProperty.Jsii$Proxy that = (StatisticsConfigurationProperty.Jsii$Proxy) o;

                if (this.includedStatistics != null ? !this.includedStatistics.equals(that.includedStatistics) : that.includedStatistics != null) return false;
                return this.overrides != null ? this.overrides.equals(that.overrides) : that.overrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includedStatistics != null ? this.includedStatistics.hashCode() : 0;
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.databrew.*;
     * ValidationConfigurationProperty validationConfigurationProperty = ValidationConfigurationProperty.builder()
     *         .rulesetArn("rulesetArn")
     *         // the properties below are optional
     *         .validationMode("validationMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJob.ValidationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ValidationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValidationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnJob.ValidationConfigurationProperty.RulesetArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRulesetArn();

        /**
         * `CfnJob.ValidationConfigurationProperty.ValidationMode`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidationMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValidationConfigurationProperty> {
            java.lang.String rulesetArn;
            java.lang.String validationMode;

            /**
             * Sets the value of {@link ValidationConfigurationProperty#getRulesetArn}
             * @param rulesetArn `CfnJob.ValidationConfigurationProperty.RulesetArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesetArn(java.lang.String rulesetArn) {
                this.rulesetArn = rulesetArn;
                return this;
            }

            /**
             * Sets the value of {@link ValidationConfigurationProperty#getValidationMode}
             * @param validationMode `CfnJob.ValidationConfigurationProperty.ValidationMode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationMode(java.lang.String validationMode) {
                this.validationMode = validationMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValidationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValidationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValidationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValidationConfigurationProperty {
            private final java.lang.String rulesetArn;
            private final java.lang.String validationMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rulesetArn = software.amazon.jsii.Kernel.get(this, "rulesetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validationMode = software.amazon.jsii.Kernel.get(this, "validationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rulesetArn = java.util.Objects.requireNonNull(builder.rulesetArn, "rulesetArn is required");
                this.validationMode = builder.validationMode;
            }

            @Override
            public final java.lang.String getRulesetArn() {
                return this.rulesetArn;
            }

            @Override
            public final java.lang.String getValidationMode() {
                return this.validationMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rulesetArn", om.valueToTree(this.getRulesetArn()));
                if (this.getValidationMode() != null) {
                    data.set("validationMode", om.valueToTree(this.getValidationMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJob.ValidationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValidationConfigurationProperty.Jsii$Proxy that = (ValidationConfigurationProperty.Jsii$Proxy) o;

                if (!rulesetArn.equals(that.rulesetArn)) return false;
                return this.validationMode != null ? this.validationMode.equals(that.validationMode) : that.validationMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.rulesetArn.hashCode();
                result = 31 * result + (this.validationMode != null ? this.validationMode.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.databrew.CfnJob}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.databrew.CfnJob> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.databrew.CfnJobProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.databrew.CfnJobProps.Builder();
        }

        /**
         * `AWS::DataBrew::Job.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::DataBrew::Job.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.RoleArn`.
         * <p>
         * @return {@code this}
         * @param roleArn `AWS::DataBrew::Job.RoleArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.Type`.
         * <p>
         * @return {@code this}
         * @param type `AWS::DataBrew::Job.Type`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.DatabaseOutputs`.
         * <p>
         * @return {@code this}
         * @param databaseOutputs `AWS::DataBrew::Job.DatabaseOutputs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseOutputs(final software.amazon.awscdk.IResolvable databaseOutputs) {
            this.props.databaseOutputs(databaseOutputs);
            return this;
        }
        /**
         * `AWS::DataBrew::Job.DatabaseOutputs`.
         * <p>
         * @return {@code this}
         * @param databaseOutputs `AWS::DataBrew::Job.DatabaseOutputs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseOutputs(final java.util.List<? extends java.lang.Object> databaseOutputs) {
            this.props.databaseOutputs(databaseOutputs);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.DataCatalogOutputs`.
         * <p>
         * @return {@code this}
         * @param dataCatalogOutputs `AWS::DataBrew::Job.DataCatalogOutputs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogOutputs(final software.amazon.awscdk.IResolvable dataCatalogOutputs) {
            this.props.dataCatalogOutputs(dataCatalogOutputs);
            return this;
        }
        /**
         * `AWS::DataBrew::Job.DataCatalogOutputs`.
         * <p>
         * @return {@code this}
         * @param dataCatalogOutputs `AWS::DataBrew::Job.DataCatalogOutputs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogOutputs(final java.util.List<? extends java.lang.Object> dataCatalogOutputs) {
            this.props.dataCatalogOutputs(dataCatalogOutputs);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.DatasetName`.
         * <p>
         * @return {@code this}
         * @param datasetName `AWS::DataBrew::Job.DatasetName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetName(final java.lang.String datasetName) {
            this.props.datasetName(datasetName);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.EncryptionKeyArn`.
         * <p>
         * @return {@code this}
         * @param encryptionKeyArn `AWS::DataBrew::Job.EncryptionKeyArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKeyArn(final java.lang.String encryptionKeyArn) {
            this.props.encryptionKeyArn(encryptionKeyArn);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.EncryptionMode`.
         * <p>
         * @return {@code this}
         * @param encryptionMode `AWS::DataBrew::Job.EncryptionMode`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionMode(final java.lang.String encryptionMode) {
            this.props.encryptionMode(encryptionMode);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.JobSample`.
         * <p>
         * @return {@code this}
         * @param jobSample `AWS::DataBrew::Job.JobSample`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobSample(final software.amazon.awscdk.services.databrew.CfnJob.JobSampleProperty jobSample) {
            this.props.jobSample(jobSample);
            return this;
        }
        /**
         * `AWS::DataBrew::Job.JobSample`.
         * <p>
         * @return {@code this}
         * @param jobSample `AWS::DataBrew::Job.JobSample`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobSample(final software.amazon.awscdk.IResolvable jobSample) {
            this.props.jobSample(jobSample);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.LogSubscription`.
         * <p>
         * @return {@code this}
         * @param logSubscription `AWS::DataBrew::Job.LogSubscription`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logSubscription(final java.lang.String logSubscription) {
            this.props.logSubscription(logSubscription);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.MaxCapacity`.
         * <p>
         * @return {@code this}
         * @param maxCapacity `AWS::DataBrew::Job.MaxCapacity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.MaxRetries`.
         * <p>
         * @return {@code this}
         * @param maxRetries `AWS::DataBrew::Job.MaxRetries`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetries(final java.lang.Number maxRetries) {
            this.props.maxRetries(maxRetries);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.OutputLocation`.
         * <p>
         * @return {@code this}
         * @param outputLocation `AWS::DataBrew::Job.OutputLocation`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(final software.amazon.awscdk.services.databrew.CfnJob.OutputLocationProperty outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }
        /**
         * `AWS::DataBrew::Job.OutputLocation`.
         * <p>
         * @return {@code this}
         * @param outputLocation `AWS::DataBrew::Job.OutputLocation`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(final software.amazon.awscdk.IResolvable outputLocation) {
            this.props.outputLocation(outputLocation);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.Outputs`.
         * <p>
         * @return {@code this}
         * @param outputs `AWS::DataBrew::Job.Outputs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final software.amazon.awscdk.IResolvable outputs) {
            this.props.outputs(outputs);
            return this;
        }
        /**
         * `AWS::DataBrew::Job.Outputs`.
         * <p>
         * @return {@code this}
         * @param outputs `AWS::DataBrew::Job.Outputs`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.util.List<? extends java.lang.Object> outputs) {
            this.props.outputs(outputs);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.ProfileConfiguration`.
         * <p>
         * @return {@code this}
         * @param profileConfiguration `AWS::DataBrew::Job.ProfileConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileConfiguration(final software.amazon.awscdk.services.databrew.CfnJob.ProfileConfigurationProperty profileConfiguration) {
            this.props.profileConfiguration(profileConfiguration);
            return this;
        }
        /**
         * `AWS::DataBrew::Job.ProfileConfiguration`.
         * <p>
         * @return {@code this}
         * @param profileConfiguration `AWS::DataBrew::Job.ProfileConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileConfiguration(final software.amazon.awscdk.IResolvable profileConfiguration) {
            this.props.profileConfiguration(profileConfiguration);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.ProjectName`.
         * <p>
         * @return {@code this}
         * @param projectName `AWS::DataBrew::Job.ProjectName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(final java.lang.String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.Recipe`.
         * <p>
         * @return {@code this}
         * @param recipe `AWS::DataBrew::Job.Recipe`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipe(final software.amazon.awscdk.services.databrew.CfnJob.RecipeProperty recipe) {
            this.props.recipe(recipe);
            return this;
        }
        /**
         * `AWS::DataBrew::Job.Recipe`.
         * <p>
         * @return {@code this}
         * @param recipe `AWS::DataBrew::Job.Recipe`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipe(final software.amazon.awscdk.IResolvable recipe) {
            this.props.recipe(recipe);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::DataBrew::Job.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.Timeout`.
         * <p>
         * @return {@code this}
         * @param timeout `AWS::DataBrew::Job.Timeout`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final java.lang.Number timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * `AWS::DataBrew::Job.ValidationConfigurations`.
         * <p>
         * @return {@code this}
         * @param validationConfigurations `AWS::DataBrew::Job.ValidationConfigurations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationConfigurations(final software.amazon.awscdk.IResolvable validationConfigurations) {
            this.props.validationConfigurations(validationConfigurations);
            return this;
        }
        /**
         * `AWS::DataBrew::Job.ValidationConfigurations`.
         * <p>
         * @return {@code this}
         * @param validationConfigurations `AWS::DataBrew::Job.ValidationConfigurations`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationConfigurations(final java.util.List<? extends java.lang.Object> validationConfigurations) {
            this.props.validationConfigurations(validationConfigurations);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.databrew.CfnJob}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.databrew.CfnJob build() {
            return new software.amazon.awscdk.services.databrew.CfnJob(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
