package software.amazon.awscdk.services.config;

/**
 * Determines which resources trigger an evaluation of an AWS Config rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function evalComplianceFn;
 * ManagedRule sshRule = ManagedRule.Builder.create(this, "SSH")
 *         .identifier(ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED)
 *         .ruleScope(RuleScope.fromResource(ResourceType.EC2_SECURITY_GROUP, "sg-1234567890abcdefgh"))
 *         .build();
 * CustomRule customRule = CustomRule.Builder.create(this, "Lambda")
 *         .lambdaFunction(evalComplianceFn)
 *         .configurationChanges(true)
 *         .ruleScope(RuleScope.fromResources(List.of(ResourceType.CLOUDFORMATION_STACK, ResourceType.S3_BUCKET)))
 *         .build();
 * CustomRule tagRule = CustomRule.Builder.create(this, "CostCenterTagRule")
 *         .lambdaFunction(evalComplianceFn)
 *         .configurationChanges(true)
 *         .ruleScope(RuleScope.fromTag("Cost Center", "MyApp"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.643Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.RuleScope")
public class RuleScope extends software.amazon.jsii.JsiiObject {

    protected RuleScope(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RuleScope(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * restricts scope of changes to a specific resource type or resource identifier.
     * <p>
     * @param resourceType This parameter is required.
     * @param resourceId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.RuleScope fromResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.ResourceType resourceType, final @org.jetbrains.annotations.Nullable java.lang.String resourceId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.RuleScope.class, "fromResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class), new Object[] { java.util.Objects.requireNonNull(resourceType, "resourceType is required"), resourceId });
    }

    /**
     * restricts scope of changes to a specific resource type or resource identifier.
     * <p>
     * @param resourceType This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.RuleScope fromResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.ResourceType resourceType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.RuleScope.class, "fromResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class), new Object[] { java.util.Objects.requireNonNull(resourceType, "resourceType is required") });
    }

    /**
     * restricts scope of changes to specific resource types.
     * <p>
     * @param resourceTypes This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.RuleScope fromResources(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.config.ResourceType> resourceTypes) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.RuleScope.class, "fromResources", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class), new Object[] { java.util.Objects.requireNonNull(resourceTypes, "resourceTypes is required") });
    }

    /**
     * restricts scope of changes to a specific tag.
     * <p>
     * @param key This parameter is required.
     * @param value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.RuleScope fromTag(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.RuleScope.class, "fromTag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * restricts scope of changes to a specific tag.
     * <p>
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.config.RuleScope fromTag(final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.config.RuleScope.class, "fromTag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * tag key applied to resources that will trigger evaluation of a rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ID of the only AWS resource that will trigger evaluation of a rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Resource types that will trigger evaluation of a rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.config.ResourceType> getResourceTypes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.config.ResourceType>)(software.amazon.jsii.Kernel.get(this, "resourceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.ResourceType.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * tag value applied to resources that will trigger evaluation of a rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
