package software.amazon.awscdk.services.config;

/**
 * Checks whether your CloudFormation stacks' actual configuration differs, or has drifted, from its expected configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Topic to which compliance notification events will be published
 * Topic complianceTopic = new Topic(this, "ComplianceTopic");
 * CloudFormationStackDriftDetectionCheck rule = new CloudFormationStackDriftDetectionCheck(this, "Drift");
 * rule.onComplianceChange("TopicEvent", OnEventOptions.builder()
 *         .target(new SnsTopic(complianceTopic))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.633Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CloudFormationStackDriftDetectionCheck")
public class CloudFormationStackDriftDetectionCheck extends software.amazon.awscdk.services.config.ManagedRule {

    protected CloudFormationStackDriftDetectionCheck(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationStackDriftDetectionCheck(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudFormationStackDriftDetectionCheck(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheckProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CloudFormationStackDriftDetectionCheck(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheck}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheck> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheckProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A name for the AWS Config rule.
         * <p>
         * Default: - CloudFormation generated name
         * <p>
         * @return {@code this}
         * @param configRuleName A name for the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(final java.lang.String configRuleName) {
            this.props().configRuleName(configRuleName);
            return this;
        }

        /**
         * A description about this AWS Config rule.
         * <p>
         * Default: - No description
         * <p>
         * @return {@code this}
         * @param description A description about this AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Input parameter values that are passed to the AWS Config rule.
         * <p>
         * Default: - No input parameters
         * <p>
         * @return {@code this}
         * @param inputParameters Input parameter values that are passed to the AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputParameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> inputParameters) {
            this.props().inputParameters(inputParameters);
            return this;
        }

        /**
         * The maximum frequency at which the AWS Config rule runs evaluations.
         * <p>
         * Default: MaximumExecutionFrequency.TWENTY_FOUR_HOURS
         * <p>
         * @return {@code this}
         * @param maximumExecutionFrequency The maximum frequency at which the AWS Config rule runs evaluations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(final software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency) {
            this.props().maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        /**
         * Defines which resources trigger an evaluation for an AWS Config rule.
         * <p>
         * Default: - evaluations for the rule are triggered when any resource in the recording group changes.
         * <p>
         * @return {@code this}
         * @param ruleScope Defines which resources trigger an evaluation for an AWS Config rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleScope(final software.amazon.awscdk.services.config.RuleScope ruleScope) {
            this.props().ruleScope(ruleScope);
            return this;
        }

        /**
         * Whether to check only the stack where this rule is deployed.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param ownStackOnly Whether to check only the stack where this rule is deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownStackOnly(final java.lang.Boolean ownStackOnly) {
            this.props().ownStackOnly(ownStackOnly);
            return this;
        }

        /**
         * The IAM role to use for this rule.
         * <p>
         * It must have permissions to detect drift
         * for AWS CloudFormation stacks. Ensure to attach <code>config.amazonaws.com</code> trusted
         * permissions and <code>ReadOnlyAccess</code> policy permissions. For specific policy permissions,
         * refer to https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html.
         * <p>
         * Default: - A role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role to use for this rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheck}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheck build() {
            return new software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheck(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheckProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.config.CloudFormationStackDriftDetectionCheckProps.Builder();
            }
            return this.props;
        }
    }
}
