package software.amazon.awscdk.services.cognito;

/**
 * Props for NumberAttr.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .standardAttributes(StandardAttributes.builder()
 *                 .fullname(StandardAttribute.builder()
 *                         .required(true)
 *                         .mutable(false)
 *                         .build())
 *                 .address(StandardAttribute.builder()
 *                         .required(false)
 *                         .mutable(true)
 *                         .build())
 *                 .build())
 *         .customAttributes(Map.of(
 *                 "myappid", StringAttribute.Builder.create().minLen(5).maxLen(15).mutable(false).build(),
 *                 "callingcode", NumberAttribute.Builder.create().min(1).max(3).mutable(true).build(),
 *                 "isEmployee", BooleanAttribute.Builder.create().mutable(true).build(),
 *                 "joinedOn", new DateTimeAttribute()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.562Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.NumberAttributeProps")
@software.amazon.jsii.Jsii.Proxy(NumberAttributeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NumberAttributeProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.NumberAttributeConstraints, software.amazon.awscdk.services.cognito.CustomAttributeProps {

    /**
     * @return a {@link Builder} of {@link NumberAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NumberAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NumberAttributeProps> {
        java.lang.Number max;
        java.lang.Number min;
        java.lang.Boolean mutable;

        /**
         * Sets the value of {@link NumberAttributeProps#getMax}
         * @param max Maximum value of this attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder max(java.lang.Number max) {
            this.max = max;
            return this;
        }

        /**
         * Sets the value of {@link NumberAttributeProps#getMin}
         * @param min Minimum value of this attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder min(java.lang.Number min) {
            this.min = min;
            return this;
        }

        /**
         * Sets the value of {@link NumberAttributeProps#getMutable}
         * @param mutable Specifies whether the value of the attribute can be changed.
         *                For any user pool attribute that's mapped to an identity provider attribute, you must set this parameter to true.
         *                Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider.
         *                If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutable(java.lang.Boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NumberAttributeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NumberAttributeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NumberAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumberAttributeProps {
        private final java.lang.Number max;
        private final java.lang.Number min;
        private final java.lang.Boolean mutable;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mutable = software.amazon.jsii.Kernel.get(this, "mutable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.max = builder.max;
            this.min = builder.min;
            this.mutable = builder.mutable;
        }

        @Override
        public final java.lang.Number getMax() {
            return this.max;
        }

        @Override
        public final java.lang.Number getMin() {
            return this.min;
        }

        @Override
        public final java.lang.Boolean getMutable() {
            return this.mutable;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMax() != null) {
                data.set("max", om.valueToTree(this.getMax()));
            }
            if (this.getMin() != null) {
                data.set("min", om.valueToTree(this.getMin()));
            }
            if (this.getMutable() != null) {
                data.set("mutable", om.valueToTree(this.getMutable()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.NumberAttributeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NumberAttributeProps.Jsii$Proxy that = (NumberAttributeProps.Jsii$Proxy) o;

            if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
            if (this.min != null ? !this.min.equals(that.min) : that.min != null) return false;
            return this.mutable != null ? this.mutable.equals(that.mutable) : that.mutable == null;
        }

        @Override
        public final int hashCode() {
            int result = this.max != null ? this.max.hashCode() : 0;
            result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
            result = 31 * result + (this.mutable != null ? this.mutable.hashCode() : 0);
            return result;
        }
    }
}
