package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a `CfnUserPool`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object userPoolTags;
 * CfnUserPoolProps cfnUserPoolProps = CfnUserPoolProps.builder()
 *         .accountRecoverySetting(AccountRecoverySettingProperty.builder()
 *                 .recoveryMechanisms(List.of(RecoveryOptionProperty.builder()
 *                         .name("name")
 *                         .priority(123)
 *                         .build()))
 *                 .build())
 *         .adminCreateUserConfig(AdminCreateUserConfigProperty.builder()
 *                 .allowAdminCreateUserOnly(false)
 *                 .inviteMessageTemplate(InviteMessageTemplateProperty.builder()
 *                         .emailMessage("emailMessage")
 *                         .emailSubject("emailSubject")
 *                         .smsMessage("smsMessage")
 *                         .build())
 *                 .unusedAccountValidityDays(123)
 *                 .build())
 *         .aliasAttributes(List.of("aliasAttributes"))
 *         .autoVerifiedAttributes(List.of("autoVerifiedAttributes"))
 *         .deviceConfiguration(DeviceConfigurationProperty.builder()
 *                 .challengeRequiredOnNewDevice(false)
 *                 .deviceOnlyRememberedOnUserPrompt(false)
 *                 .build())
 *         .emailConfiguration(EmailConfigurationProperty.builder()
 *                 .configurationSet("configurationSet")
 *                 .emailSendingAccount("emailSendingAccount")
 *                 .from("from")
 *                 .replyToEmailAddress("replyToEmailAddress")
 *                 .sourceArn("sourceArn")
 *                 .build())
 *         .emailVerificationMessage("emailVerificationMessage")
 *         .emailVerificationSubject("emailVerificationSubject")
 *         .enabledMfas(List.of("enabledMfas"))
 *         .lambdaConfig(LambdaConfigProperty.builder()
 *                 .createAuthChallenge("createAuthChallenge")
 *                 .customEmailSender(CustomEmailSenderProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .lambdaVersion("lambdaVersion")
 *                         .build())
 *                 .customMessage("customMessage")
 *                 .customSmsSender(CustomSMSSenderProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .lambdaVersion("lambdaVersion")
 *                         .build())
 *                 .defineAuthChallenge("defineAuthChallenge")
 *                 .kmsKeyId("kmsKeyId")
 *                 .postAuthentication("postAuthentication")
 *                 .postConfirmation("postConfirmation")
 *                 .preAuthentication("preAuthentication")
 *                 .preSignUp("preSignUp")
 *                 .preTokenGeneration("preTokenGeneration")
 *                 .userMigration("userMigration")
 *                 .verifyAuthChallengeResponse("verifyAuthChallengeResponse")
 *                 .build())
 *         .mfaConfiguration("mfaConfiguration")
 *         .policies(PoliciesProperty.builder()
 *                 .passwordPolicy(PasswordPolicyProperty.builder()
 *                         .minimumLength(123)
 *                         .requireLowercase(false)
 *                         .requireNumbers(false)
 *                         .requireSymbols(false)
 *                         .requireUppercase(false)
 *                         .temporaryPasswordValidityDays(123)
 *                         .build())
 *                 .build())
 *         .schema(List.of(SchemaAttributeProperty.builder()
 *                 .attributeDataType("attributeDataType")
 *                 .developerOnlyAttribute(false)
 *                 .mutable(false)
 *                 .name("name")
 *                 .numberAttributeConstraints(NumberAttributeConstraintsProperty.builder()
 *                         .maxValue("maxValue")
 *                         .minValue("minValue")
 *                         .build())
 *                 .required(false)
 *                 .stringAttributeConstraints(StringAttributeConstraintsProperty.builder()
 *                         .maxLength("maxLength")
 *                         .minLength("minLength")
 *                         .build())
 *                 .build()))
 *         .smsAuthenticationMessage("smsAuthenticationMessage")
 *         .smsConfiguration(SmsConfigurationProperty.builder()
 *                 .externalId("externalId")
 *                 .snsCallerArn("snsCallerArn")
 *                 .build())
 *         .smsVerificationMessage("smsVerificationMessage")
 *         .usernameAttributes(List.of("usernameAttributes"))
 *         .usernameConfiguration(UsernameConfigurationProperty.builder()
 *                 .caseSensitive(false)
 *                 .build())
 *         .userPoolAddOns(UserPoolAddOnsProperty.builder()
 *                 .advancedSecurityMode("advancedSecurityMode")
 *                 .build())
 *         .userPoolName("userPoolName")
 *         .userPoolTags(userPoolTags)
 *         .verificationMessageTemplate(VerificationMessageTemplateProperty.builder()
 *                 .defaultEmailOption("defaultEmailOption")
 *                 .emailMessage("emailMessage")
 *                 .emailMessageByLink("emailMessageByLink")
 *                 .emailSubject("emailSubject")
 *                 .emailSubjectByLink("emailSubjectByLink")
 *                 .smsMessage("smsMessage")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.539Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
     * <p>
     * It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccountRecoverySetting() {
        return null;
    }

    /**
     * The configuration for creating a new user profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdminCreateUserConfig() {
        return null;
    }

    /**
     * Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .
     * <p>
     * <blockquote>
     * <p>
     * This user pool property cannot be updated.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliasAttributes() {
        return null;
    }

    /**
     * The attributes to be auto-verified.
     * <p>
     * Possible values: <em>email</em> , <em>phone_number</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoVerifiedAttributes() {
        return null;
    }

    /**
     * The device configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeviceConfiguration() {
        return null;
    }

    /**
     * The email configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEmailConfiguration() {
        return null;
    }

    /**
     * A string representing the email verification message.
     * <p>
     * EmailVerificationMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailVerificationMessage() {
        return null;
    }

    /**
     * A string representing the email verification subject.
     * <p>
     * EmailVerificationSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEmailVerificationSubject() {
        return null;
    }

    /**
     * Enables MFA on a specified user pool.
     * <p>
     * To disable all MFAs after it has been enabled, set MfaConfiguration to “OFF” and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to “OFF”. Can be one of the following values:
     * <p>
     * <ul>
     * <li><code>SMS_MFA</code> - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.</li>
     * <li><code>SOFTWARE_TOKEN_MFA</code> - Enables software token MFA for the user pool.</li>
     * </ul>
     * <p>
     * Allowed values: <code>SMS_MFA</code> | <code>SOFTWARE_TOKEN_MFA</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnabledMfas() {
        return null;
    }

    /**
     * The Lambda trigger configuration information for the new user pool.
     * <p>
     * <blockquote>
     * <p>
     * In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
     * <p>
     * For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html">AddPermission</a> .
     * <p>
     * For adding permission using the AWS CLI , see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html">add-permission</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfig() {
        return null;
    }

    /**
     * The multi-factor (MFA) configuration. Valid values include:.
     * <p>
     * <ul>
     * <li><code>OFF</code> MFA won't be used for any users.</li>
     * <li><code>ON</code> MFA is required for all users to sign in.</li>
     * <li><code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMfaConfiguration() {
        return null;
    }

    /**
     * The policy associated with a user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return null;
    }

    /**
     * The schema attributes for the new user pool. These attributes can be standard or custom attributes.
     * <p>
     * <blockquote>
     * <p>
     * During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchema() {
        return null;
    }

    /**
     * A string representing the SMS authentication message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSmsAuthenticationMessage() {
        return null;
    }

    /**
     * The SMS configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSmsConfiguration() {
        return null;
    }

    /**
     * A string representing the SMS verification message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSmsVerificationMessage() {
        return null;
    }

    /**
     * Determines whether email addresses or phone numbers can be specified as user names when a user signs up.
     * <p>
     * Possible values: <code>phone_number</code> or <code>email</code> .
     * <p>
     * This user pool property cannot be updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUsernameAttributes() {
        return null;
    }

    /**
     * You can choose to set case sensitivity on the username input for the selected sign-in option.
     * <p>
     * For example, when this is set to <code>False</code> , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUsernameConfiguration() {
        return null;
    }

    /**
     * Enables advanced security risk detection.
     * <p>
     * Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolAddOns() {
        return null;
    }

    /**
     * A string used to name the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolName() {
        return null;
    }

    /**
     * The tag keys and values to assign to the user pool.
     * <p>
     * A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolTags() {
        return null;
    }

    /**
     * The template for the verification message that the user sees when the app requests permission to access the user's information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVerificationMessageTemplate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolProps> {
        java.lang.Object accountRecoverySetting;
        java.lang.Object adminCreateUserConfig;
        java.util.List<java.lang.String> aliasAttributes;
        java.util.List<java.lang.String> autoVerifiedAttributes;
        java.lang.Object deviceConfiguration;
        java.lang.Object emailConfiguration;
        java.lang.String emailVerificationMessage;
        java.lang.String emailVerificationSubject;
        java.util.List<java.lang.String> enabledMfas;
        java.lang.Object lambdaConfig;
        java.lang.String mfaConfiguration;
        java.lang.Object policies;
        java.lang.Object schema;
        java.lang.String smsAuthenticationMessage;
        java.lang.Object smsConfiguration;
        java.lang.String smsVerificationMessage;
        java.util.List<java.lang.String> usernameAttributes;
        java.lang.Object usernameConfiguration;
        java.lang.Object userPoolAddOns;
        java.lang.String userPoolName;
        java.lang.Object userPoolTags;
        java.lang.Object verificationMessageTemplate;

        /**
         * Sets the value of {@link CfnUserPoolProps#getAccountRecoverySetting}
         * @param accountRecoverySetting Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
         *                               It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountRecoverySetting(software.amazon.awscdk.services.cognito.CfnUserPool.AccountRecoverySettingProperty accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAccountRecoverySetting}
         * @param accountRecoverySetting Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` .
         *                               It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountRecoverySetting(software.amazon.awscdk.IResolvable accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAdminCreateUserConfig}
         * @param adminCreateUserConfig The configuration for creating a new user profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminCreateUserConfig(software.amazon.awscdk.services.cognito.CfnUserPool.AdminCreateUserConfigProperty adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAdminCreateUserConfig}
         * @param adminCreateUserConfig The configuration for creating a new user profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adminCreateUserConfig(software.amazon.awscdk.IResolvable adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAliasAttributes}
         * @param aliasAttributes Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .
         *                        <blockquote>
         *                        <p>
         *                        This user pool property cannot be updated.
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasAttributes(java.util.List<java.lang.String> aliasAttributes) {
            this.aliasAttributes = aliasAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getAutoVerifiedAttributes}
         * @param autoVerifiedAttributes The attributes to be auto-verified.
         *                               Possible values: <em>email</em> , <em>phone_number</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoVerifiedAttributes(java.util.List<java.lang.String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = autoVerifiedAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getDeviceConfiguration}
         * @param deviceConfiguration The device configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceConfiguration(software.amazon.awscdk.services.cognito.CfnUserPool.DeviceConfigurationProperty deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getDeviceConfiguration}
         * @param deviceConfiguration The device configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceConfiguration(software.amazon.awscdk.IResolvable deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailConfiguration}
         * @param emailConfiguration The email configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailConfiguration(software.amazon.awscdk.services.cognito.CfnUserPool.EmailConfigurationProperty emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailConfiguration}
         * @param emailConfiguration The email configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailConfiguration(software.amazon.awscdk.IResolvable emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailVerificationMessage}
         * @param emailVerificationMessage A string representing the email verification message.
         *                                 EmailVerificationMessage is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerificationMessage(java.lang.String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEmailVerificationSubject}
         * @param emailVerificationSubject A string representing the email verification subject.
         *                                 EmailVerificationSubject is allowed only if <a href="https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount">EmailSendingAccount</a> is DEVELOPER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerificationSubject(java.lang.String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getEnabledMfas}
         * @param enabledMfas Enables MFA on a specified user pool.
         *                    To disable all MFAs after it has been enabled, set MfaConfiguration to “OFF” and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to “OFF”. Can be one of the following values:
         *                    <p>
         *                    <ul>
         *                    <li><code>SMS_MFA</code> - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.</li>
         *                    <li><code>SOFTWARE_TOKEN_MFA</code> - Enables software token MFA for the user pool.</li>
         *                    </ul>
         *                    <p>
         *                    Allowed values: <code>SMS_MFA</code> | <code>SOFTWARE_TOKEN_MFA</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabledMfas(java.util.List<java.lang.String> enabledMfas) {
            this.enabledMfas = enabledMfas;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getLambdaConfig}
         * @param lambdaConfig The Lambda trigger configuration information for the new user pool.
         *                     <blockquote>
         *                     <p>
         *                     In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
         *                     <p>
         *                     For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html">AddPermission</a> .
         *                     <p>
         *                     For adding permission using the AWS CLI , see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html">add-permission</a> .
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(software.amazon.awscdk.services.cognito.CfnUserPool.LambdaConfigProperty lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getLambdaConfig}
         * @param lambdaConfig The Lambda trigger configuration information for the new user pool.
         *                     <blockquote>
         *                     <p>
         *                     In a push model, event sources (such as Amazon S3 and custom applications) need permission to invoke a function. So you must make an extra call to add permission for these event sources to invoke your Lambda function.
         *                     <p>
         *                     For more information on using the Lambda API to add permission, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html">AddPermission</a> .
         *                     <p>
         *                     For adding permission using the AWS CLI , see <a href="https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html">add-permission</a> .
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(software.amazon.awscdk.IResolvable lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getMfaConfiguration}
         * @param mfaConfiguration The multi-factor (MFA) configuration. Valid values include:.
         *                         <ul>
         *                         <li><code>OFF</code> MFA won't be used for any users.</li>
         *                         <li><code>ON</code> MFA is required for all users to sign in.</li>
         *                         <li><code>OPTIONAL</code> MFA will be required only for individual users who have an MFA factor activated.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mfaConfiguration(java.lang.String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getPolicies}
         * @param policies The policy associated with a user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(software.amazon.awscdk.services.cognito.CfnUserPool.PoliciesProperty policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getPolicies}
         * @param policies The policy associated with a user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(software.amazon.awscdk.IResolvable policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSchema}
         * @param schema The schema attributes for the new user pool. These attributes can be standard or custom attributes.
         *               <blockquote>
         *               <p>
         *               During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(software.amazon.awscdk.IResolvable schema) {
            this.schema = schema;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSchema}
         * @param schema The schema attributes for the new user pool. These attributes can be standard or custom attributes.
         *               <blockquote>
         *               <p>
         *               During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(java.util.List<? extends java.lang.Object> schema) {
            this.schema = schema;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSmsAuthenticationMessage}
         * @param smsAuthenticationMessage A string representing the SMS authentication message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsAuthenticationMessage(java.lang.String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSmsConfiguration}
         * @param smsConfiguration The SMS configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsConfiguration(software.amazon.awscdk.services.cognito.CfnUserPool.SmsConfigurationProperty smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSmsConfiguration}
         * @param smsConfiguration The SMS configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsConfiguration(software.amazon.awscdk.IResolvable smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getSmsVerificationMessage}
         * @param smsVerificationMessage A string representing the SMS verification message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsVerificationMessage(java.lang.String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUsernameAttributes}
         * @param usernameAttributes Determines whether email addresses or phone numbers can be specified as user names when a user signs up.
         *                           Possible values: <code>phone_number</code> or <code>email</code> .
         *                           <p>
         *                           This user pool property cannot be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameAttributes(java.util.List<java.lang.String> usernameAttributes) {
            this.usernameAttributes = usernameAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUsernameConfiguration}
         * @param usernameConfiguration You can choose to set case sensitivity on the username input for the selected sign-in option.
         *                              For example, when this is set to <code>False</code> , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameConfiguration(software.amazon.awscdk.services.cognito.CfnUserPool.UsernameConfigurationProperty usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUsernameConfiguration}
         * @param usernameConfiguration You can choose to set case sensitivity on the username input for the selected sign-in option.
         *                              For example, when this is set to <code>False</code> , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usernameConfiguration(software.amazon.awscdk.IResolvable usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolAddOns}
         * @param userPoolAddOns Enables advanced security risk detection.
         *                       Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolAddOns(software.amazon.awscdk.services.cognito.CfnUserPool.UserPoolAddOnsProperty userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolAddOns}
         * @param userPoolAddOns Enables advanced security risk detection.
         *                       Set the key <code>AdvancedSecurityMode</code> to the value "AUDIT".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolAddOns(software.amazon.awscdk.IResolvable userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolName}
         * @param userPoolName A string used to name the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolName(java.lang.String userPoolName) {
            this.userPoolName = userPoolName;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getUserPoolTags}
         * @param userPoolTags The tag keys and values to assign to the user pool.
         *                     A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolTags(java.lang.Object userPoolTags) {
            this.userPoolTags = userPoolTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getVerificationMessageTemplate}
         * @param verificationMessageTemplate The template for the verification message that the user sees when the app requests permission to access the user's information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationMessageTemplate(software.amazon.awscdk.services.cognito.CfnUserPool.VerificationMessageTemplateProperty verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolProps#getVerificationMessageTemplate}
         * @param verificationMessageTemplate The template for the verification message that the user sees when the app requests permission to access the user's information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verificationMessageTemplate(software.amazon.awscdk.IResolvable verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolProps {
        private final java.lang.Object accountRecoverySetting;
        private final java.lang.Object adminCreateUserConfig;
        private final java.util.List<java.lang.String> aliasAttributes;
        private final java.util.List<java.lang.String> autoVerifiedAttributes;
        private final java.lang.Object deviceConfiguration;
        private final java.lang.Object emailConfiguration;
        private final java.lang.String emailVerificationMessage;
        private final java.lang.String emailVerificationSubject;
        private final java.util.List<java.lang.String> enabledMfas;
        private final java.lang.Object lambdaConfig;
        private final java.lang.String mfaConfiguration;
        private final java.lang.Object policies;
        private final java.lang.Object schema;
        private final java.lang.String smsAuthenticationMessage;
        private final java.lang.Object smsConfiguration;
        private final java.lang.String smsVerificationMessage;
        private final java.util.List<java.lang.String> usernameAttributes;
        private final java.lang.Object usernameConfiguration;
        private final java.lang.Object userPoolAddOns;
        private final java.lang.String userPoolName;
        private final java.lang.Object userPoolTags;
        private final java.lang.Object verificationMessageTemplate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountRecoverySetting = software.amazon.jsii.Kernel.get(this, "accountRecoverySetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.adminCreateUserConfig = software.amazon.jsii.Kernel.get(this, "adminCreateUserConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.aliasAttributes = software.amazon.jsii.Kernel.get(this, "aliasAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.autoVerifiedAttributes = software.amazon.jsii.Kernel.get(this, "autoVerifiedAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.deviceConfiguration = software.amazon.jsii.Kernel.get(this, "deviceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.emailConfiguration = software.amazon.jsii.Kernel.get(this, "emailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.emailVerificationMessage = software.amazon.jsii.Kernel.get(this, "emailVerificationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.emailVerificationSubject = software.amazon.jsii.Kernel.get(this, "emailVerificationSubject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabledMfas = software.amazon.jsii.Kernel.get(this, "enabledMfas", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.lambdaConfig = software.amazon.jsii.Kernel.get(this, "lambdaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mfaConfiguration = software.amazon.jsii.Kernel.get(this, "mfaConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policies = software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.smsAuthenticationMessage = software.amazon.jsii.Kernel.get(this, "smsAuthenticationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.smsConfiguration = software.amazon.jsii.Kernel.get(this, "smsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.smsVerificationMessage = software.amazon.jsii.Kernel.get(this, "smsVerificationMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.usernameAttributes = software.amazon.jsii.Kernel.get(this, "usernameAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.usernameConfiguration = software.amazon.jsii.Kernel.get(this, "usernameConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.userPoolAddOns = software.amazon.jsii.Kernel.get(this, "userPoolAddOns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.userPoolName = software.amazon.jsii.Kernel.get(this, "userPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolTags = software.amazon.jsii.Kernel.get(this, "userPoolTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.verificationMessageTemplate = software.amazon.jsii.Kernel.get(this, "verificationMessageTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountRecoverySetting = builder.accountRecoverySetting;
            this.adminCreateUserConfig = builder.adminCreateUserConfig;
            this.aliasAttributes = builder.aliasAttributes;
            this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
            this.deviceConfiguration = builder.deviceConfiguration;
            this.emailConfiguration = builder.emailConfiguration;
            this.emailVerificationMessage = builder.emailVerificationMessage;
            this.emailVerificationSubject = builder.emailVerificationSubject;
            this.enabledMfas = builder.enabledMfas;
            this.lambdaConfig = builder.lambdaConfig;
            this.mfaConfiguration = builder.mfaConfiguration;
            this.policies = builder.policies;
            this.schema = builder.schema;
            this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
            this.smsConfiguration = builder.smsConfiguration;
            this.smsVerificationMessage = builder.smsVerificationMessage;
            this.usernameAttributes = builder.usernameAttributes;
            this.usernameConfiguration = builder.usernameConfiguration;
            this.userPoolAddOns = builder.userPoolAddOns;
            this.userPoolName = builder.userPoolName;
            this.userPoolTags = builder.userPoolTags;
            this.verificationMessageTemplate = builder.verificationMessageTemplate;
        }

        @Override
        public final java.lang.Object getAccountRecoverySetting() {
            return this.accountRecoverySetting;
        }

        @Override
        public final java.lang.Object getAdminCreateUserConfig() {
            return this.adminCreateUserConfig;
        }

        @Override
        public final java.util.List<java.lang.String> getAliasAttributes() {
            return this.aliasAttributes;
        }

        @Override
        public final java.util.List<java.lang.String> getAutoVerifiedAttributes() {
            return this.autoVerifiedAttributes;
        }

        @Override
        public final java.lang.Object getDeviceConfiguration() {
            return this.deviceConfiguration;
        }

        @Override
        public final java.lang.Object getEmailConfiguration() {
            return this.emailConfiguration;
        }

        @Override
        public final java.lang.String getEmailVerificationMessage() {
            return this.emailVerificationMessage;
        }

        @Override
        public final java.lang.String getEmailVerificationSubject() {
            return this.emailVerificationSubject;
        }

        @Override
        public final java.util.List<java.lang.String> getEnabledMfas() {
            return this.enabledMfas;
        }

        @Override
        public final java.lang.Object getLambdaConfig() {
            return this.lambdaConfig;
        }

        @Override
        public final java.lang.String getMfaConfiguration() {
            return this.mfaConfiguration;
        }

        @Override
        public final java.lang.Object getPolicies() {
            return this.policies;
        }

        @Override
        public final java.lang.Object getSchema() {
            return this.schema;
        }

        @Override
        public final java.lang.String getSmsAuthenticationMessage() {
            return this.smsAuthenticationMessage;
        }

        @Override
        public final java.lang.Object getSmsConfiguration() {
            return this.smsConfiguration;
        }

        @Override
        public final java.lang.String getSmsVerificationMessage() {
            return this.smsVerificationMessage;
        }

        @Override
        public final java.util.List<java.lang.String> getUsernameAttributes() {
            return this.usernameAttributes;
        }

        @Override
        public final java.lang.Object getUsernameConfiguration() {
            return this.usernameConfiguration;
        }

        @Override
        public final java.lang.Object getUserPoolAddOns() {
            return this.userPoolAddOns;
        }

        @Override
        public final java.lang.String getUserPoolName() {
            return this.userPoolName;
        }

        @Override
        public final java.lang.Object getUserPoolTags() {
            return this.userPoolTags;
        }

        @Override
        public final java.lang.Object getVerificationMessageTemplate() {
            return this.verificationMessageTemplate;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountRecoverySetting() != null) {
                data.set("accountRecoverySetting", om.valueToTree(this.getAccountRecoverySetting()));
            }
            if (this.getAdminCreateUserConfig() != null) {
                data.set("adminCreateUserConfig", om.valueToTree(this.getAdminCreateUserConfig()));
            }
            if (this.getAliasAttributes() != null) {
                data.set("aliasAttributes", om.valueToTree(this.getAliasAttributes()));
            }
            if (this.getAutoVerifiedAttributes() != null) {
                data.set("autoVerifiedAttributes", om.valueToTree(this.getAutoVerifiedAttributes()));
            }
            if (this.getDeviceConfiguration() != null) {
                data.set("deviceConfiguration", om.valueToTree(this.getDeviceConfiguration()));
            }
            if (this.getEmailConfiguration() != null) {
                data.set("emailConfiguration", om.valueToTree(this.getEmailConfiguration()));
            }
            if (this.getEmailVerificationMessage() != null) {
                data.set("emailVerificationMessage", om.valueToTree(this.getEmailVerificationMessage()));
            }
            if (this.getEmailVerificationSubject() != null) {
                data.set("emailVerificationSubject", om.valueToTree(this.getEmailVerificationSubject()));
            }
            if (this.getEnabledMfas() != null) {
                data.set("enabledMfas", om.valueToTree(this.getEnabledMfas()));
            }
            if (this.getLambdaConfig() != null) {
                data.set("lambdaConfig", om.valueToTree(this.getLambdaConfig()));
            }
            if (this.getMfaConfiguration() != null) {
                data.set("mfaConfiguration", om.valueToTree(this.getMfaConfiguration()));
            }
            if (this.getPolicies() != null) {
                data.set("policies", om.valueToTree(this.getPolicies()));
            }
            if (this.getSchema() != null) {
                data.set("schema", om.valueToTree(this.getSchema()));
            }
            if (this.getSmsAuthenticationMessage() != null) {
                data.set("smsAuthenticationMessage", om.valueToTree(this.getSmsAuthenticationMessage()));
            }
            if (this.getSmsConfiguration() != null) {
                data.set("smsConfiguration", om.valueToTree(this.getSmsConfiguration()));
            }
            if (this.getSmsVerificationMessage() != null) {
                data.set("smsVerificationMessage", om.valueToTree(this.getSmsVerificationMessage()));
            }
            if (this.getUsernameAttributes() != null) {
                data.set("usernameAttributes", om.valueToTree(this.getUsernameAttributes()));
            }
            if (this.getUsernameConfiguration() != null) {
                data.set("usernameConfiguration", om.valueToTree(this.getUsernameConfiguration()));
            }
            if (this.getUserPoolAddOns() != null) {
                data.set("userPoolAddOns", om.valueToTree(this.getUserPoolAddOns()));
            }
            if (this.getUserPoolName() != null) {
                data.set("userPoolName", om.valueToTree(this.getUserPoolName()));
            }
            if (this.getUserPoolTags() != null) {
                data.set("userPoolTags", om.valueToTree(this.getUserPoolTags()));
            }
            if (this.getVerificationMessageTemplate() != null) {
                data.set("verificationMessageTemplate", om.valueToTree(this.getVerificationMessageTemplate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolProps.Jsii$Proxy that = (CfnUserPoolProps.Jsii$Proxy) o;

            if (this.accountRecoverySetting != null ? !this.accountRecoverySetting.equals(that.accountRecoverySetting) : that.accountRecoverySetting != null) return false;
            if (this.adminCreateUserConfig != null ? !this.adminCreateUserConfig.equals(that.adminCreateUserConfig) : that.adminCreateUserConfig != null) return false;
            if (this.aliasAttributes != null ? !this.aliasAttributes.equals(that.aliasAttributes) : that.aliasAttributes != null) return false;
            if (this.autoVerifiedAttributes != null ? !this.autoVerifiedAttributes.equals(that.autoVerifiedAttributes) : that.autoVerifiedAttributes != null) return false;
            if (this.deviceConfiguration != null ? !this.deviceConfiguration.equals(that.deviceConfiguration) : that.deviceConfiguration != null) return false;
            if (this.emailConfiguration != null ? !this.emailConfiguration.equals(that.emailConfiguration) : that.emailConfiguration != null) return false;
            if (this.emailVerificationMessage != null ? !this.emailVerificationMessage.equals(that.emailVerificationMessage) : that.emailVerificationMessage != null) return false;
            if (this.emailVerificationSubject != null ? !this.emailVerificationSubject.equals(that.emailVerificationSubject) : that.emailVerificationSubject != null) return false;
            if (this.enabledMfas != null ? !this.enabledMfas.equals(that.enabledMfas) : that.enabledMfas != null) return false;
            if (this.lambdaConfig != null ? !this.lambdaConfig.equals(that.lambdaConfig) : that.lambdaConfig != null) return false;
            if (this.mfaConfiguration != null ? !this.mfaConfiguration.equals(that.mfaConfiguration) : that.mfaConfiguration != null) return false;
            if (this.policies != null ? !this.policies.equals(that.policies) : that.policies != null) return false;
            if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) return false;
            if (this.smsAuthenticationMessage != null ? !this.smsAuthenticationMessage.equals(that.smsAuthenticationMessage) : that.smsAuthenticationMessage != null) return false;
            if (this.smsConfiguration != null ? !this.smsConfiguration.equals(that.smsConfiguration) : that.smsConfiguration != null) return false;
            if (this.smsVerificationMessage != null ? !this.smsVerificationMessage.equals(that.smsVerificationMessage) : that.smsVerificationMessage != null) return false;
            if (this.usernameAttributes != null ? !this.usernameAttributes.equals(that.usernameAttributes) : that.usernameAttributes != null) return false;
            if (this.usernameConfiguration != null ? !this.usernameConfiguration.equals(that.usernameConfiguration) : that.usernameConfiguration != null) return false;
            if (this.userPoolAddOns != null ? !this.userPoolAddOns.equals(that.userPoolAddOns) : that.userPoolAddOns != null) return false;
            if (this.userPoolName != null ? !this.userPoolName.equals(that.userPoolName) : that.userPoolName != null) return false;
            if (this.userPoolTags != null ? !this.userPoolTags.equals(that.userPoolTags) : that.userPoolTags != null) return false;
            return this.verificationMessageTemplate != null ? this.verificationMessageTemplate.equals(that.verificationMessageTemplate) : that.verificationMessageTemplate == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountRecoverySetting != null ? this.accountRecoverySetting.hashCode() : 0;
            result = 31 * result + (this.adminCreateUserConfig != null ? this.adminCreateUserConfig.hashCode() : 0);
            result = 31 * result + (this.aliasAttributes != null ? this.aliasAttributes.hashCode() : 0);
            result = 31 * result + (this.autoVerifiedAttributes != null ? this.autoVerifiedAttributes.hashCode() : 0);
            result = 31 * result + (this.deviceConfiguration != null ? this.deviceConfiguration.hashCode() : 0);
            result = 31 * result + (this.emailConfiguration != null ? this.emailConfiguration.hashCode() : 0);
            result = 31 * result + (this.emailVerificationMessage != null ? this.emailVerificationMessage.hashCode() : 0);
            result = 31 * result + (this.emailVerificationSubject != null ? this.emailVerificationSubject.hashCode() : 0);
            result = 31 * result + (this.enabledMfas != null ? this.enabledMfas.hashCode() : 0);
            result = 31 * result + (this.lambdaConfig != null ? this.lambdaConfig.hashCode() : 0);
            result = 31 * result + (this.mfaConfiguration != null ? this.mfaConfiguration.hashCode() : 0);
            result = 31 * result + (this.policies != null ? this.policies.hashCode() : 0);
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            result = 31 * result + (this.smsAuthenticationMessage != null ? this.smsAuthenticationMessage.hashCode() : 0);
            result = 31 * result + (this.smsConfiguration != null ? this.smsConfiguration.hashCode() : 0);
            result = 31 * result + (this.smsVerificationMessage != null ? this.smsVerificationMessage.hashCode() : 0);
            result = 31 * result + (this.usernameAttributes != null ? this.usernameAttributes.hashCode() : 0);
            result = 31 * result + (this.usernameConfiguration != null ? this.usernameConfiguration.hashCode() : 0);
            result = 31 * result + (this.userPoolAddOns != null ? this.userPoolAddOns.hashCode() : 0);
            result = 31 * result + (this.userPoolName != null ? this.userPoolName.hashCode() : 0);
            result = 31 * result + (this.userPoolTags != null ? this.userPoolTags.hashCode() : 0);
            result = 31 * result + (this.verificationMessageTemplate != null ? this.verificationMessageTemplate.hashCode() : 0);
            return result;
        }
    }
}
