package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Properties for importing an existing Jenkins provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * IJenkinsProvider jenkinsProvider = JenkinsProvider.fromJenkinsProviderAttributes(this, "JenkinsProvider", JenkinsProviderAttributes.builder()
 *         .providerName("MyJenkinsProvider")
 *         .serverUrl("http://my-jenkins.com:8080")
 *         .version("2")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.449Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.JenkinsProviderAttributes")
@software.amazon.jsii.Jsii.Proxy(JenkinsProviderAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JenkinsProviderAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated from non-compiling source. May contain errors.
     * "MyJenkinsProvider";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProviderName();

    /**
     * The base URL of your Jenkins server.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated from non-compiling source. May contain errors.
     * "http://myjenkins.com:8080";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerUrl();

    /**
     * The version of your provider.
     * <p>
     * Default: '1'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JenkinsProviderAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JenkinsProviderAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JenkinsProviderAttributes> {
        java.lang.String providerName;
        java.lang.String serverUrl;
        java.lang.String version;

        /**
         * Sets the value of {@link JenkinsProviderAttributes#getProviderName}
         * @param providerName The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerName(java.lang.String providerName) {
            this.providerName = providerName;
            return this;
        }

        /**
         * Sets the value of {@link JenkinsProviderAttributes#getServerUrl}
         * @param serverUrl The base URL of your Jenkins server. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverUrl(java.lang.String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        /**
         * Sets the value of {@link JenkinsProviderAttributes#getVersion}
         * @param version The version of your provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JenkinsProviderAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JenkinsProviderAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JenkinsProviderAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JenkinsProviderAttributes {
        private final java.lang.String providerName;
        private final java.lang.String serverUrl;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.providerName = software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverUrl = software.amazon.jsii.Kernel.get(this, "serverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.providerName = java.util.Objects.requireNonNull(builder.providerName, "providerName is required");
            this.serverUrl = java.util.Objects.requireNonNull(builder.serverUrl, "serverUrl is required");
            this.version = builder.version;
        }

        @Override
        public final java.lang.String getProviderName() {
            return this.providerName;
        }

        @Override
        public final java.lang.String getServerUrl() {
            return this.serverUrl;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("providerName", om.valueToTree(this.getProviderName()));
            data.set("serverUrl", om.valueToTree(this.getServerUrl()));
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.JenkinsProviderAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JenkinsProviderAttributes.Jsii$Proxy that = (JenkinsProviderAttributes.Jsii$Proxy) o;

            if (!providerName.equals(that.providerName)) return false;
            if (!serverUrl.equals(that.serverUrl)) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.providerName.hashCode();
            result = 31 * result + (this.serverUrl.hashCode());
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
