package software.amazon.awscdk.services.cloudwatch;

/**
 * Enumeration indicates state of Alarm used in building Alarm Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Alarm alarm1;
 * Alarm alarm2;
 * Alarm alarm3;
 * Alarm alarm4;
 * IAlarmRule alarmRule = AlarmRule.anyOf(AlarmRule.allOf(AlarmRule.anyOf(alarm1, AlarmRule.fromAlarm(alarm2, AlarmState.OK), alarm3), AlarmRule.not(AlarmRule.fromAlarm(alarm4, AlarmState.INSUFFICIENT_DATA))), AlarmRule.fromBoolean(false));
 * CompositeAlarm.Builder.create(this, "MyAwesomeCompositeAlarm")
 *         .alarmRule(alarmRule)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.111Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.AlarmState")
public enum AlarmState {
    /**
     * State indicates resource is in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALARM,
    /**
     * State indicates resource is not in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OK,
    /**
     * State indicates there is not enough data to determine is resource is in ALARM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSUFFICIENT_DATA,
}
