package software.amazon.awscdk.services.cloudfront;

/**
 * The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
 * <p>
 * CloudFront serves your objects only to browsers or devices that support at least the SSL version that you specify.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Distribution with a custom domain name and a minimum protocol version.
 * Bucket myBucket;
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(new S3Origin(myBucket)).build())
 *         .domainNames(List.of("www.example.com"))
 *         .minimumProtocolVersion(SecurityPolicyProtocol.TLS_V1_2016)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:08.067Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.SecurityPolicyProtocol")
public enum SecurityPolicyProtocol {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SSL_V3,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_2016,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_1_2016,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_2_2018,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_2_2019,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TLS_V1_2_2021,
}
