package software.amazon.awscdk.services.batch;

/**
 * A CloudFormation `AWS::Batch::SchedulingPolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * CfnSchedulingPolicy cfnSchedulingPolicy = CfnSchedulingPolicy.Builder.create(this, "MyCfnSchedulingPolicy")
 *         .fairsharePolicy(FairsharePolicyProperty.builder()
 *                 .computeReservation(123)
 *                 .shareDecaySeconds(123)
 *                 .shareDistribution(List.of(ShareAttributesProperty.builder()
 *                         .shareIdentifier("shareIdentifier")
 *                         .weightFactor(123)
 *                         .build()))
 *                 .build())
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.838Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnSchedulingPolicy")
public class CfnSchedulingPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSchedulingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSchedulingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.CfnSchedulingPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Batch::SchedulingPolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSchedulingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnSchedulingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Batch::SchedulingPolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSchedulingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Batch::SchedulingPolicy.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::Batch::SchedulingPolicy.FairsharePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFairsharePolicy() {
        return software.amazon.jsii.Kernel.get(this, "fairsharePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Batch::SchedulingPolicy.FairsharePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFairsharePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnSchedulingPolicy.FairsharePolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "fairsharePolicy", value);
    }

    /**
     * `AWS::Batch::SchedulingPolicy.FairsharePolicy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFairsharePolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fairsharePolicy", value);
    }

    /**
     * `AWS::Batch::SchedulingPolicy.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Batch::SchedulingPolicy.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * FairsharePolicyProperty fairsharePolicyProperty = FairsharePolicyProperty.builder()
     *         .computeReservation(123)
     *         .shareDecaySeconds(123)
     *         .shareDistribution(List.of(ShareAttributesProperty.builder()
     *                 .shareIdentifier("shareIdentifier")
     *                 .weightFactor(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnSchedulingPolicy.FairsharePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(FairsharePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FairsharePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedulingPolicy.FairsharePolicyProperty.ComputeReservation`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getComputeReservation() {
            return null;
        }

        /**
         * `CfnSchedulingPolicy.FairsharePolicyProperty.ShareDecaySeconds`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShareDecaySeconds() {
            return null;
        }

        /**
         * `CfnSchedulingPolicy.FairsharePolicyProperty.ShareDistribution`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShareDistribution() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FairsharePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FairsharePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FairsharePolicyProperty> {
            java.lang.Number computeReservation;
            java.lang.Number shareDecaySeconds;
            java.lang.Object shareDistribution;

            /**
             * Sets the value of {@link FairsharePolicyProperty#getComputeReservation}
             * @param computeReservation `CfnSchedulingPolicy.FairsharePolicyProperty.ComputeReservation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeReservation(java.lang.Number computeReservation) {
                this.computeReservation = computeReservation;
                return this;
            }

            /**
             * Sets the value of {@link FairsharePolicyProperty#getShareDecaySeconds}
             * @param shareDecaySeconds `CfnSchedulingPolicy.FairsharePolicyProperty.ShareDecaySeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDecaySeconds(java.lang.Number shareDecaySeconds) {
                this.shareDecaySeconds = shareDecaySeconds;
                return this;
            }

            /**
             * Sets the value of {@link FairsharePolicyProperty#getShareDistribution}
             * @param shareDistribution `CfnSchedulingPolicy.FairsharePolicyProperty.ShareDistribution`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDistribution(software.amazon.awscdk.IResolvable shareDistribution) {
                this.shareDistribution = shareDistribution;
                return this;
            }

            /**
             * Sets the value of {@link FairsharePolicyProperty#getShareDistribution}
             * @param shareDistribution `CfnSchedulingPolicy.FairsharePolicyProperty.ShareDistribution`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareDistribution(java.util.List<? extends java.lang.Object> shareDistribution) {
                this.shareDistribution = shareDistribution;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FairsharePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FairsharePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FairsharePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FairsharePolicyProperty {
            private final java.lang.Number computeReservation;
            private final java.lang.Number shareDecaySeconds;
            private final java.lang.Object shareDistribution;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.computeReservation = software.amazon.jsii.Kernel.get(this, "computeReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shareDecaySeconds = software.amazon.jsii.Kernel.get(this, "shareDecaySeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shareDistribution = software.amazon.jsii.Kernel.get(this, "shareDistribution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.computeReservation = builder.computeReservation;
                this.shareDecaySeconds = builder.shareDecaySeconds;
                this.shareDistribution = builder.shareDistribution;
            }

            @Override
            public final java.lang.Number getComputeReservation() {
                return this.computeReservation;
            }

            @Override
            public final java.lang.Number getShareDecaySeconds() {
                return this.shareDecaySeconds;
            }

            @Override
            public final java.lang.Object getShareDistribution() {
                return this.shareDistribution;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComputeReservation() != null) {
                    data.set("computeReservation", om.valueToTree(this.getComputeReservation()));
                }
                if (this.getShareDecaySeconds() != null) {
                    data.set("shareDecaySeconds", om.valueToTree(this.getShareDecaySeconds()));
                }
                if (this.getShareDistribution() != null) {
                    data.set("shareDistribution", om.valueToTree(this.getShareDistribution()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnSchedulingPolicy.FairsharePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FairsharePolicyProperty.Jsii$Proxy that = (FairsharePolicyProperty.Jsii$Proxy) o;

                if (this.computeReservation != null ? !this.computeReservation.equals(that.computeReservation) : that.computeReservation != null) return false;
                if (this.shareDecaySeconds != null ? !this.shareDecaySeconds.equals(that.shareDecaySeconds) : that.shareDecaySeconds != null) return false;
                return this.shareDistribution != null ? this.shareDistribution.equals(that.shareDistribution) : that.shareDistribution == null;
            }

            @Override
            public final int hashCode() {
                int result = this.computeReservation != null ? this.computeReservation.hashCode() : 0;
                result = 31 * result + (this.shareDecaySeconds != null ? this.shareDecaySeconds.hashCode() : 0);
                result = 31 * result + (this.shareDistribution != null ? this.shareDistribution.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * ShareAttributesProperty shareAttributesProperty = ShareAttributesProperty.builder()
     *         .shareIdentifier("shareIdentifier")
     *         .weightFactor(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnSchedulingPolicy.ShareAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(ShareAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ShareAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSchedulingPolicy.ShareAttributesProperty.ShareIdentifier`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShareIdentifier() {
            return null;
        }

        /**
         * `CfnSchedulingPolicy.ShareAttributesProperty.WeightFactor`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightFactor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ShareAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ShareAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ShareAttributesProperty> {
            java.lang.String shareIdentifier;
            java.lang.Number weightFactor;

            /**
             * Sets the value of {@link ShareAttributesProperty#getShareIdentifier}
             * @param shareIdentifier `CfnSchedulingPolicy.ShareAttributesProperty.ShareIdentifier`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shareIdentifier(java.lang.String shareIdentifier) {
                this.shareIdentifier = shareIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ShareAttributesProperty#getWeightFactor}
             * @param weightFactor `CfnSchedulingPolicy.ShareAttributesProperty.WeightFactor`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightFactor(java.lang.Number weightFactor) {
                this.weightFactor = weightFactor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ShareAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ShareAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ShareAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShareAttributesProperty {
            private final java.lang.String shareIdentifier;
            private final java.lang.Number weightFactor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.shareIdentifier = software.amazon.jsii.Kernel.get(this, "shareIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weightFactor = software.amazon.jsii.Kernel.get(this, "weightFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.shareIdentifier = builder.shareIdentifier;
                this.weightFactor = builder.weightFactor;
            }

            @Override
            public final java.lang.String getShareIdentifier() {
                return this.shareIdentifier;
            }

            @Override
            public final java.lang.Number getWeightFactor() {
                return this.weightFactor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getShareIdentifier() != null) {
                    data.set("shareIdentifier", om.valueToTree(this.getShareIdentifier()));
                }
                if (this.getWeightFactor() != null) {
                    data.set("weightFactor", om.valueToTree(this.getWeightFactor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnSchedulingPolicy.ShareAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ShareAttributesProperty.Jsii$Proxy that = (ShareAttributesProperty.Jsii$Proxy) o;

                if (this.shareIdentifier != null ? !this.shareIdentifier.equals(that.shareIdentifier) : that.shareIdentifier != null) return false;
                return this.weightFactor != null ? this.weightFactor.equals(that.weightFactor) : that.weightFactor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.shareIdentifier != null ? this.shareIdentifier.hashCode() : 0;
                result = 31 * result + (this.weightFactor != null ? this.weightFactor.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.CfnSchedulingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.CfnSchedulingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.batch.CfnSchedulingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::Batch::SchedulingPolicy.FairsharePolicy`.
         * <p>
         * @return {@code this}
         * @param fairsharePolicy `AWS::Batch::SchedulingPolicy.FairsharePolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fairsharePolicy(final software.amazon.awscdk.services.batch.CfnSchedulingPolicy.FairsharePolicyProperty fairsharePolicy) {
            this.props().fairsharePolicy(fairsharePolicy);
            return this;
        }
        /**
         * `AWS::Batch::SchedulingPolicy.FairsharePolicy`.
         * <p>
         * @return {@code this}
         * @param fairsharePolicy `AWS::Batch::SchedulingPolicy.FairsharePolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fairsharePolicy(final software.amazon.awscdk.IResolvable fairsharePolicy) {
            this.props().fairsharePolicy(fairsharePolicy);
            return this;
        }

        /**
         * `AWS::Batch::SchedulingPolicy.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::Batch::SchedulingPolicy.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * `AWS::Batch::SchedulingPolicy.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::Batch::SchedulingPolicy.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.CfnSchedulingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.CfnSchedulingPolicy build() {
            return new software.amazon.awscdk.services.batch.CfnSchedulingPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.batch.CfnSchedulingPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.batch.CfnSchedulingPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
