package software.amazon.awscdk.services.autoscaling;

/**
 * Specifies the termination criteria to apply before Amazon EC2 Auto Scaling chooses an instance for termination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .terminationPolicies(List.of(TerminationPolicy.OLDEST_INSTANCE, TerminationPolicy.DEFAULT))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.776Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.TerminationPolicy")
public enum TerminationPolicy {
    /**
     * Terminate instances in the Auto Scaling group to align the remaining instances to the allocation strategy for the type of instance that is terminating (either a Spot Instance or an On-Demand Instance).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALLOCATION_STRATEGY,
    /**
     * Terminate instances that are closest to the next billing hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLOSEST_TO_NEXT_INSTANCE_HOUR,
    /**
     * Terminate instances according to the default termination policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * Terminate the newest instance in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEWEST_INSTANCE,
    /**
     * Terminate the oldest instance in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLDEST_INSTANCE,
    /**
     * Terminate instances that have the oldest launch configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLDEST_LAUNCH_CONFIGURATION,
    /**
     * Terminate instances that have the oldest launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLDEST_LAUNCH_TEMPLATE,
}
