package software.amazon.awscdk.services.autoscaling;

/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`.
 * <p>
 * The <code>AWS::AutoScaling::ScalingPolicy</code> resource specifies an Amazon EC2 Auto Scaling scaling policy so that the Auto Scaling group can scale the number of instances available for your application.
 * <p>
 * For more information about using scaling policies to scale your Auto Scaling group automatically, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scale-based-on-demand.html">Dynamic scaling</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * CfnScalingPolicy cfnScalingPolicy = CfnScalingPolicy.Builder.create(this, "MyCfnScalingPolicy")
 *         .autoScalingGroupName("autoScalingGroupName")
 *         // the properties below are optional
 *         .adjustmentType("adjustmentType")
 *         .cooldown("cooldown")
 *         .estimatedInstanceWarmup(123)
 *         .metricAggregationType("metricAggregationType")
 *         .minAdjustmentMagnitude(123)
 *         .policyType("policyType")
 *         .predictiveScalingConfiguration(PredictiveScalingConfigurationProperty.builder()
 *                 .metricSpecifications(List.of(PredictiveScalingMetricSpecificationProperty.builder()
 *                         .targetValue(123)
 *                         // the properties below are optional
 *                         .predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .maxCapacityBreachBehavior("maxCapacityBreachBehavior")
 *                 .maxCapacityBuffer(123)
 *                 .mode("mode")
 *                 .schedulingBufferTime(123)
 *                 .build())
 *         .scalingAdjustment(123)
 *         .stepAdjustments(List.of(StepAdjustmentProperty.builder()
 *                 .scalingAdjustment(123)
 *                 // the properties below are optional
 *                 .metricIntervalLowerBound(123)
 *                 .metricIntervalUpperBound(123)
 *                 .build()))
 *         .targetTrackingConfiguration(TargetTrackingConfigurationProperty.builder()
 *                 .targetValue(123)
 *                 // the properties below are optional
 *                 .customizedMetricSpecification(CustomizedMetricSpecificationProperty.builder()
 *                         .metricName("metricName")
 *                         .namespace("namespace")
 *                         .statistic("statistic")
 *                         // the properties below are optional
 *                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .unit("unit")
 *                         .build())
 *                 .disableScaleIn(false)
 *                 .predefinedMetricSpecification(PredefinedMetricSpecificationProperty.builder()
 *                         .predefinedMetricType("predefinedMetricType")
 *                         // the properties below are optional
 *                         .resourceLabel("resourceLabel")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.732Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy")
public class CfnScalingPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnScalingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScalingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AutoScaling::ScalingPolicy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScalingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.CfnScalingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingGroupName", java.util.Objects.requireNonNull(value, "autoScalingGroupName is required"));
    }

    /**
     * Specifies how the scaling adjustment is interpreted. The valid values are `ChangeInCapacity` , `ExactCapacity` , and `PercentChangeInCapacity` .
     * <p>
     * Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAdjustmentType() {
        return software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies how the scaling adjustment is interpreted. The valid values are `ChangeInCapacity` , `ExactCapacity` , and `PercentChangeInCapacity` .
     * <p>
     * Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdjustmentType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "adjustmentType", value);
    }

    /**
     * The duration of the policy's cooldown period, in seconds.
     * <p>
     * When a cooldown period is specified here, it overrides the default cooldown period defined for the Auto Scaling group.
     * <p>
     * Valid only if the policy type is <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCooldown() {
        return software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The duration of the policy's cooldown period, in seconds.
     * <p>
     * When a cooldown period is specified here, it overrides the default cooldown period defined for the Auto Scaling group.
     * <p>
     * Valid only if the policy type is <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCooldown(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cooldown", value);
    }

    /**
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     * <p>
     * If not provided, the default is to use the value from the default cooldown period for the Auto Scaling group.
     * <p>
     * Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getEstimatedInstanceWarmup() {
        return software.amazon.jsii.Kernel.get(this, "estimatedInstanceWarmup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     * <p>
     * If not provided, the default is to use the value from the default cooldown period for the Auto Scaling group.
     * <p>
     * Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEstimatedInstanceWarmup(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "estimatedInstanceWarmup", value);
    }

    /**
     * The aggregation type for the CloudWatch metrics.
     * <p>
     * The valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMetricAggregationType() {
        return software.amazon.jsii.Kernel.get(this, "metricAggregationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The aggregation type for the CloudWatch metrics.
     * <p>
     * The valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricAggregationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "metricAggregationType", value);
    }

    /**
     * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity` .
     * <p>
     * For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinAdjustmentMagnitude() {
        return software.amazon.jsii.Kernel.get(this, "minAdjustmentMagnitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity` .
     * <p>
     * For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinAdjustmentMagnitude(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minAdjustmentMagnitude", value);
    }

    /**
     * One of the following policy types:.
     * <p>
     * <ul>
     * <li><code>TargetTrackingScaling</code></li>
     * <li><code>StepScaling</code></li>
     * <li><code>SimpleScaling</code> (default)</li>
     * <li><code>PredictiveScaling</code></li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling policies</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPolicyType() {
        return software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * One of the following policy types:.
     * <p>
     * <ul>
     * <li><code>TargetTrackingScaling</code></li>
     * <li><code>StepScaling</code></li>
     * <li><code>SimpleScaling</code> (default)</li>
     * <li><code>PredictiveScaling</code></li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling policies</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyType", value);
    }

    /**
     * A predictive scaling policy.
     * <p>
     * Includes support for predefined metrics only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPredictiveScalingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "predictiveScalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A predictive scaling policy.
     * <p>
     * Includes support for predefined metrics only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPredictiveScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredictiveScalingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "predictiveScalingConfiguration", value);
    }

    /**
     * A predictive scaling policy.
     * <p>
     * Includes support for predefined metrics only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPredictiveScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "predictiveScalingConfiguration", value);
    }

    /**
     * The amount by which to scale, based on the specified adjustment type.
     * <p>
     * A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
     * <p>
     * Required if the policy type is <code>SimpleScaling</code> . (Not used with any other policy type.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getScalingAdjustment() {
        return software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount by which to scale, based on the specified adjustment type.
     * <p>
     * A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
     * <p>
     * Required if the policy type is <code>SimpleScaling</code> . (Not used with any other policy type.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingAdjustment(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "scalingAdjustment", value);
    }

    /**
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * <p>
     * Required if the policy type is <code>StepScaling</code> . (Not used with any other policy type.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStepAdjustments() {
        return software.amazon.jsii.Kernel.get(this, "stepAdjustments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * <p>
     * Required if the policy type is <code>StepScaling</code> . (Not used with any other policy type.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStepAdjustments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stepAdjustments", value);
    }

    /**
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * <p>
     * Required if the policy type is <code>StepScaling</code> . (Not used with any other policy type.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStepAdjustments(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "stepAdjustments", value);
    }

    /**
     * A target tracking scaling policy. Includes support for predefined or customized metrics.
     * <p>
     * The following predefined metrics are available:
     * <p>
     * <ul>
     * <li><code>ASGAverageCPUUtilization</code></li>
     * <li><code>ASGAverageNetworkIn</code></li>
     * <li><code>ASGAverageNetworkOut</code></li>
     * <li><code>ALBRequestCountPerTarget</code></li>
     * </ul>
     * <p>
     * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetTrackingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "targetTrackingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A target tracking scaling policy. Includes support for predefined or customized metrics.
     * <p>
     * The following predefined metrics are available:
     * <p>
     * <ul>
     * <li><code>ASGAverageCPUUtilization</code></li>
     * <li><code>ASGAverageNetworkIn</code></li>
     * <li><code>ASGAverageNetworkOut</code></li>
     * <li><code>ALBRequestCountPerTarget</code></li>
     * </ul>
     * <p>
     * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetTrackingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.TargetTrackingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetTrackingConfiguration", value);
    }

    /**
     * A target tracking scaling policy. Includes support for predefined or customized metrics.
     * <p>
     * The following predefined metrics are available:
     * <p>
     * <ul>
     * <li><code>ASGAverageCPUUtilization</code></li>
     * <li><code>ASGAverageNetworkIn</code></li>
     * <li><code>ASGAverageNetworkOut</code></li>
     * <li><code>ALBRequestCountPerTarget</code></li>
     * </ul>
     * <p>
     * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetTrackingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetTrackingConfiguration", value);
    }
    /**
     * Contains customized metric specification information for a target tracking scaling policy for Amazon EC2 Auto Scaling.
     * <p>
     * To create your customized metric specification:
     * <p>
     * <ul>
     * <li>Add values for each required property from CloudWatch. You can use an existing metric, or a new metric that you create. To use your own metric, you must first publish the metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish Custom Metrics</a> in the <em>Amazon CloudWatch User Guide</em> .</li>
     * <li>Choose a metric that changes proportionally with capacity. The value of the metric should increase or decrease in inverse proportion to the number of capacity units. That is, the value of the metric should decrease when capacity increases.</li>
     * </ul>
     * <p>
     * For more information about CloudWatch, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch Concepts</a> .
     * <p>
     * <code>CustomizedMetricSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html">AWS::AutoScaling::ScalingPolicy TargetTrackingConfiguration</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * CustomizedMetricSpecificationProperty customizedMetricSpecificationProperty = CustomizedMetricSpecificationProperty.builder()
     *         .metricName("metricName")
     *         .namespace("namespace")
     *         .statistic("statistic")
     *         // the properties below are optional
     *         .dimensions(List.of(MetricDimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomizedMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomizedMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the metric.
         * <p>
         * To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The namespace of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * The statistic of the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatistic();

        /**
         * The dimensions of the metric.
         * <p>
         * Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The unit of the metric.
         * <p>
         * For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomizedMetricSpecificationProperty> {
            java.lang.String metricName;
            java.lang.String namespace;
            java.lang.String statistic;
            java.lang.Object dimensions;
            java.lang.String unit;

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getMetricName}
             * @param metricName The name of the metric. This parameter is required.
             *                   To get the exact metric name, namespace, and dimensions, inspect the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html">Metric</a> object that is returned by a call to <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html">ListMetrics</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getNamespace}
             * @param namespace The namespace of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getStatistic}
             * @param statistic The statistic of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getDimensions}
             * @param dimensions The dimensions of the metric.
             *                   Conditional: If you published your metric with dimensions, you must specify the same dimensions in your scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizedMetricSpecificationProperty#getUnit}
             * @param unit The unit of the metric.
             *             For a complete list of the units that CloudWatch supports, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html">MetricDatum</a> data type in the <em>Amazon CloudWatch API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomizedMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomizedMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomizedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizedMetricSpecificationProperty {
            private final java.lang.String metricName;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.Object dimensions;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
                this.statistic = java.util.Objects.requireNonNull(builder.statistic, "statistic is required");
                this.dimensions = builder.dimensions;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));
                data.set("statistic", om.valueToTree(this.getStatistic()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomizedMetricSpecificationProperty.Jsii$Proxy that = (CustomizedMetricSpecificationProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!namespace.equals(that.namespace)) return false;
                if (!statistic.equals(that.statistic)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                result = 31 * result + (this.statistic.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `MetricDimension` specifies a name/value pair that is part of the identity of a CloudWatch metric for the `Dimensions` property of the [AWS::AutoScaling::ScalingPolicy CustomizedMetricSpecification](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html) property type. Duplicate dimensions are not allowed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the dimension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the dimension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getName}
             * @param name The name of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The value of the dimension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains predefined metric specification information for a target tracking scaling policy for Amazon EC2 Auto Scaling.
     * <p>
     * <code>PredefinedMetricSpecification</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html">AWS::AutoScaling::ScalingPolicy TargetTrackingConfiguration</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * PredefinedMetricSpecificationProperty predefinedMetricSpecificationProperty = PredefinedMetricSpecificationProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredefinedMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredefinedMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type. The following predefined metrics are available.
         * <p>
         * <ul>
         * <li><code>ASGAverageCPUUtilization</code> - Average CPU utilization of the Auto Scaling group.</li>
         * <li><code>ASGAverageNetworkIn</code> - Average number of bytes received on all network interfaces by the Auto Scaling group.</li>
         * <li><code>ASGAverageNetworkOut</code> - Average number of bytes sent out on all network interfaces by the Auto Scaling group.</li>
         * <li><code>ALBRequestCountPerTarget</code> - Number of requests completed per target in an Application Load Balancer target group.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * Identifies the resource associated with the metric type.
         * <p>
         * You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Auto Scaling group.
         * <p>
         * The format is <code>app/ *load-balancer-name* / *load-balancer-id* /targetgroup/ *target-group-name* / *target-group-id*</code> , where
         * <p>
         * <ul>
         * <li><code>app/ *load-balancer-name* / *load-balancer-id*</code> is the final portion of the load balancer ARN, and</li>
         * <li><code>targetgroup/ *target-group-name* / *target-group-id*</code> is the final portion of the target group ARN.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredefinedMetricSpecificationProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredefinedMetricSpecificationProperty#getPredefinedMetricType}
             * @param predefinedMetricType The metric type. The following predefined metrics are available. This parameter is required.
             *                             <ul>
             *                             <li><code>ASGAverageCPUUtilization</code> - Average CPU utilization of the Auto Scaling group.</li>
             *                             <li><code>ASGAverageNetworkIn</code> - Average number of bytes received on all network interfaces by the Auto Scaling group.</li>
             *                             <li><code>ASGAverageNetworkOut</code> - Average number of bytes sent out on all network interfaces by the Auto Scaling group.</li>
             *                             <li><code>ALBRequestCountPerTarget</code> - Number of requests completed per target in an Application Load Balancer target group.</li>
             *                             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredefinedMetricSpecificationProperty#getResourceLabel}
             * @param resourceLabel Identifies the resource associated with the metric type.
             *                      You can't specify a resource label unless the metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Auto Scaling group.
             *                      <p>
             *                      The format is <code>app/ *load-balancer-name* / *load-balancer-id* /targetgroup/ *target-group-name* / *target-group-id*</code> , where
             *                      <p>
             *                      <ul>
             *                      <li><code>app/ *load-balancer-name* / *load-balancer-id*</code> is the final portion of the load balancer ARN, and</li>
             *                      <li><code>targetgroup/ *target-group-name* / *target-group-id*</code> is the final portion of the target group ARN.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredefinedMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredefinedMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredefinedMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredefinedMetricSpecificationProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredefinedMetricSpecificationProperty.Jsii$Proxy that = (PredefinedMetricSpecificationProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `PredictiveScalingConfiguration` is a property of the [AWS::AutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html) resource that specifies a predictive scaling policy for Amazon EC2 Auto Scaling.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PutScalingPolicy.html">PutScalingPolicy</a> in the <em>Amazon EC2 Auto Scaling API Reference</em> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * PredictiveScalingConfigurationProperty predictiveScalingConfigurationProperty = PredictiveScalingConfigurationProperty.builder()
     *         .metricSpecifications(List.of(PredictiveScalingMetricSpecificationProperty.builder()
     *                 .targetValue(123)
     *                 // the properties below are optional
     *                 .predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricProperty.builder()
     *                         .predefinedMetricType("predefinedMetricType")
     *                         // the properties below are optional
     *                         .resourceLabel("resourceLabel")
     *                         .build())
     *                 .predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairProperty.builder()
     *                         .predefinedMetricType("predefinedMetricType")
     *                         // the properties below are optional
     *                         .resourceLabel("resourceLabel")
     *                         .build())
     *                 .predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricProperty.builder()
     *                         .predefinedMetricType("predefinedMetricType")
     *                         // the properties below are optional
     *                         .resourceLabel("resourceLabel")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .maxCapacityBreachBehavior("maxCapacityBreachBehavior")
     *         .maxCapacityBuffer(123)
     *         .mode("mode")
     *         .schedulingBufferTime(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array that contains information about the metrics and target utilization to use for predictive scaling.
         * <p>
         * <blockquote>
         * <p>
         * Adding more than one predictive scaling metric specification to the array is currently not supported.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetricSpecifications();

        /**
         * Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group.
         * <p>
         * Defaults to <code>HonorMaxCapacity</code> if not specified.
         * <p>
         * The following are possible values:
         * <p>
         * <ul>
         * <li><code>HonorMaxCapacity</code> - Amazon EC2 Auto Scaling cannot scale out capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit.</li>
         * <li><code>IncreaseMaxCapacity</code> - Amazon EC2 Auto Scaling can scale out capacity higher than the maximum capacity when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for <code>MaxCapacityBuffer</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaxCapacityBreachBehavior() {
            return null;
        }

        /**
         * The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
         * <p>
         * The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
         * <p>
         * If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
         * <p>
         * Required if the <code>MaxCapacityBreachBehavior</code> property is set to <code>IncreaseMaxCapacity</code> , and cannot be used otherwise.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacityBuffer() {
            return null;
        }

        /**
         * The predictive scaling mode.
         * <p>
         * Defaults to <code>ForecastOnly</code> if not specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * The amount of time, in seconds, by which the instance launch time can be advanced.
         * <p>
         * For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
         * <p>
         * The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingBufferTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingConfigurationProperty> {
            java.lang.Object metricSpecifications;
            java.lang.String maxCapacityBreachBehavior;
            java.lang.Number maxCapacityBuffer;
            java.lang.String mode;
            java.lang.Number schedulingBufferTime;

            /**
             * Sets the value of {@link PredictiveScalingConfigurationProperty#getMetricSpecifications}
             * @param metricSpecifications An array that contains information about the metrics and target utilization to use for predictive scaling. This parameter is required.
             *                             <blockquote>
             *                             <p>
             *                             Adding more than one predictive scaling metric specification to the array is currently not supported.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSpecifications(software.amazon.awscdk.IResolvable metricSpecifications) {
                this.metricSpecifications = metricSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingConfigurationProperty#getMetricSpecifications}
             * @param metricSpecifications An array that contains information about the metrics and target utilization to use for predictive scaling. This parameter is required.
             *                             <blockquote>
             *                             <p>
             *                             Adding more than one predictive scaling metric specification to the array is currently not supported.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSpecifications(java.util.List<? extends java.lang.Object> metricSpecifications) {
                this.metricSpecifications = metricSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingConfigurationProperty#getMaxCapacityBreachBehavior}
             * @param maxCapacityBreachBehavior Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity of the Auto Scaling group.
             *                                  Defaults to <code>HonorMaxCapacity</code> if not specified.
             *                                  <p>
             *                                  The following are possible values:
             *                                  <p>
             *                                  <ul>
             *                                  <li><code>HonorMaxCapacity</code> - Amazon EC2 Auto Scaling cannot scale out capacity higher than the maximum capacity. The maximum capacity is enforced as a hard limit.</li>
             *                                  <li><code>IncreaseMaxCapacity</code> - Amazon EC2 Auto Scaling can scale out capacity higher than the maximum capacity when the forecast capacity is close to or exceeds the maximum capacity. The upper limit is determined by the forecasted capacity and the value for <code>MaxCapacityBuffer</code> .</li>
             *                                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacityBreachBehavior(java.lang.String maxCapacityBreachBehavior) {
                this.maxCapacityBreachBehavior = maxCapacityBreachBehavior;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingConfigurationProperty#getMaxCapacityBuffer}
             * @param maxCapacityBuffer The size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
             *                          The value is specified as a percentage relative to the forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer, such that if the forecast capacity is 50, and the maximum capacity is 40, then the effective maximum capacity is 55.
             *                          <p>
             *                          If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but not exceed forecast capacity.
             *                          <p>
             *                          Required if the <code>MaxCapacityBreachBehavior</code> property is set to <code>IncreaseMaxCapacity</code> , and cannot be used otherwise.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacityBuffer(java.lang.Number maxCapacityBuffer) {
                this.maxCapacityBuffer = maxCapacityBuffer;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingConfigurationProperty#getMode}
             * @param mode The predictive scaling mode.
             *             Defaults to <code>ForecastOnly</code> if not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingConfigurationProperty#getSchedulingBufferTime}
             * @param schedulingBufferTime The amount of time, in seconds, by which the instance launch time can be advanced.
             *                             For example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The intention is to give resources time to be provisioned. It can take a few minutes to launch an EC2 instance. The actual amount of time required depends on several factors, such as the size of the instance and whether there are startup scripts to complete.
             *                             <p>
             *                             The value must be less than the forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds if not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedulingBufferTime(java.lang.Number schedulingBufferTime) {
                this.schedulingBufferTime = schedulingBufferTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingConfigurationProperty {
            private final java.lang.Object metricSpecifications;
            private final java.lang.String maxCapacityBreachBehavior;
            private final java.lang.Number maxCapacityBuffer;
            private final java.lang.String mode;
            private final java.lang.Number schedulingBufferTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricSpecifications = software.amazon.jsii.Kernel.get(this, "metricSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxCapacityBreachBehavior = software.amazon.jsii.Kernel.get(this, "maxCapacityBreachBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxCapacityBuffer = software.amazon.jsii.Kernel.get(this, "maxCapacityBuffer", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schedulingBufferTime = software.amazon.jsii.Kernel.get(this, "schedulingBufferTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricSpecifications = java.util.Objects.requireNonNull(builder.metricSpecifications, "metricSpecifications is required");
                this.maxCapacityBreachBehavior = builder.maxCapacityBreachBehavior;
                this.maxCapacityBuffer = builder.maxCapacityBuffer;
                this.mode = builder.mode;
                this.schedulingBufferTime = builder.schedulingBufferTime;
            }

            @Override
            public final java.lang.Object getMetricSpecifications() {
                return this.metricSpecifications;
            }

            @Override
            public final java.lang.String getMaxCapacityBreachBehavior() {
                return this.maxCapacityBreachBehavior;
            }

            @Override
            public final java.lang.Number getMaxCapacityBuffer() {
                return this.maxCapacityBuffer;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Number getSchedulingBufferTime() {
                return this.schedulingBufferTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricSpecifications", om.valueToTree(this.getMetricSpecifications()));
                if (this.getMaxCapacityBreachBehavior() != null) {
                    data.set("maxCapacityBreachBehavior", om.valueToTree(this.getMaxCapacityBreachBehavior()));
                }
                if (this.getMaxCapacityBuffer() != null) {
                    data.set("maxCapacityBuffer", om.valueToTree(this.getMaxCapacityBuffer()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getSchedulingBufferTime() != null) {
                    data.set("schedulingBufferTime", om.valueToTree(this.getSchedulingBufferTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingConfigurationProperty.Jsii$Proxy that = (PredictiveScalingConfigurationProperty.Jsii$Proxy) o;

                if (!metricSpecifications.equals(that.metricSpecifications)) return false;
                if (this.maxCapacityBreachBehavior != null ? !this.maxCapacityBreachBehavior.equals(that.maxCapacityBreachBehavior) : that.maxCapacityBreachBehavior != null) return false;
                if (this.maxCapacityBuffer != null ? !this.maxCapacityBuffer.equals(that.maxCapacityBuffer) : that.maxCapacityBuffer != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.schedulingBufferTime != null ? this.schedulingBufferTime.equals(that.schedulingBufferTime) : that.schedulingBufferTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricSpecifications.hashCode();
                result = 31 * result + (this.maxCapacityBreachBehavior != null ? this.maxCapacityBreachBehavior.hashCode() : 0);
                result = 31 * result + (this.maxCapacityBuffer != null ? this.maxCapacityBuffer.hashCode() : 0);
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.schedulingBufferTime != null ? this.schedulingBufferTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that specifies a metric specification for the `MetricSpecifications` property of the [AWS::AutoScaling::ScalingPolicy PredictiveScalingConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predictivescalingconfiguration.html) property type.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * PredictiveScalingMetricSpecificationProperty predictiveScalingMetricSpecificationProperty = PredictiveScalingMetricSpecificationProperty.builder()
     *         .targetValue(123)
     *         // the properties below are optional
     *         .predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the target utilization.
         * <p>
         * <blockquote>
         * <p>
         * Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * The load metric specification.
         * <p>
         * If you specify <code>PredefinedMetricPairSpecification</code> , don't specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedLoadMetricSpecification() {
            return null;
        }

        /**
         * The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
         * <p>
         * <blockquote>
         * <p>
         * With predictive scaling, you must specify either a metric pair, or a load metric and a scaling metric individually. Specifying a metric pair instead of individual metrics provides a simpler way to configure metrics for a scaling policy. You choose the metric pair, and the policy automatically knows the correct sum and average statistics to use for the load metric and the scaling metric.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedMetricPairSpecification() {
            return null;
        }

        /**
         * The scaling metric specification.
         * <p>
         * If you specify <code>PredefinedMetricPairSpecification</code> , don't specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedScalingMetricSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingMetricSpecificationProperty> {
            java.lang.Number targetValue;
            java.lang.Object predefinedLoadMetricSpecification;
            java.lang.Object predefinedMetricPairSpecification;
            java.lang.Object predefinedScalingMetricSpecification;

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getTargetValue}
             * @param targetValue Specifies the target utilization. This parameter is required.
             *                    <blockquote>
             *                    <p>
             *                    Some metrics are based on a count instead of a percentage, such as the request count for an Application Load Balancer or the number of messages in an SQS queue. If the scaling policy specifies one of these metrics, specify the target utilization as the optimal average request or message count per instance during any one-minute interval.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedLoadMetricSpecification}
             * @param predefinedLoadMetricSpecification The load metric specification.
             *                                          If you specify <code>PredefinedMetricPairSpecification</code> , don't specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedLoadMetricSpecification(software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedLoadMetricProperty predefinedLoadMetricSpecification) {
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedLoadMetricSpecification}
             * @param predefinedLoadMetricSpecification The load metric specification.
             *                                          If you specify <code>PredefinedMetricPairSpecification</code> , don't specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedLoadMetricSpecification(software.amazon.awscdk.IResolvable predefinedLoadMetricSpecification) {
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedMetricPairSpecification}
             * @param predefinedMetricPairSpecification The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
             *                                          <blockquote>
             *                                          <p>
             *                                          With predictive scaling, you must specify either a metric pair, or a load metric and a scaling metric individually. Specifying a metric pair instead of individual metrics provides a simpler way to configure metrics for a scaling policy. You choose the metric pair, and the policy automatically knows the correct sum and average statistics to use for the load metric and the scaling metric.
             *                                          <p>
             *                                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricPairSpecification(software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedMetricPairProperty predefinedMetricPairSpecification) {
                this.predefinedMetricPairSpecification = predefinedMetricPairSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedMetricPairSpecification}
             * @param predefinedMetricPairSpecification The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling metric and load metric to use.
             *                                          <blockquote>
             *                                          <p>
             *                                          With predictive scaling, you must specify either a metric pair, or a load metric and a scaling metric individually. Specifying a metric pair instead of individual metrics provides a simpler way to configure metrics for a scaling policy. You choose the metric pair, and the policy automatically knows the correct sum and average statistics to use for the load metric and the scaling metric.
             *                                          <p>
             *                                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricPairSpecification(software.amazon.awscdk.IResolvable predefinedMetricPairSpecification) {
                this.predefinedMetricPairSpecification = predefinedMetricPairSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedScalingMetricSpecification}
             * @param predefinedScalingMetricSpecification The scaling metric specification.
             *                                             If you specify <code>PredefinedMetricPairSpecification</code> , don't specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedScalingMetricSpecification(software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedScalingMetricProperty predefinedScalingMetricSpecification) {
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingMetricSpecificationProperty#getPredefinedScalingMetricSpecification}
             * @param predefinedScalingMetricSpecification The scaling metric specification.
             *                                             If you specify <code>PredefinedMetricPairSpecification</code> , don't specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedScalingMetricSpecification(software.amazon.awscdk.IResolvable predefinedScalingMetricSpecification) {
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingMetricSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingMetricSpecificationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object predefinedLoadMetricSpecification;
            private final java.lang.Object predefinedMetricPairSpecification;
            private final java.lang.Object predefinedScalingMetricSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.predefinedLoadMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedLoadMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedMetricPairSpecification = software.amazon.jsii.Kernel.get(this, "predefinedMetricPairSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedScalingMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedScalingMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
                this.predefinedLoadMetricSpecification = builder.predefinedLoadMetricSpecification;
                this.predefinedMetricPairSpecification = builder.predefinedMetricPairSpecification;
                this.predefinedScalingMetricSpecification = builder.predefinedScalingMetricSpecification;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public final java.lang.Object getPredefinedLoadMetricSpecification() {
                return this.predefinedLoadMetricSpecification;
            }

            @Override
            public final java.lang.Object getPredefinedMetricPairSpecification() {
                return this.predefinedMetricPairSpecification;
            }

            @Override
            public final java.lang.Object getPredefinedScalingMetricSpecification() {
                return this.predefinedScalingMetricSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getPredefinedLoadMetricSpecification() != null) {
                    data.set("predefinedLoadMetricSpecification", om.valueToTree(this.getPredefinedLoadMetricSpecification()));
                }
                if (this.getPredefinedMetricPairSpecification() != null) {
                    data.set("predefinedMetricPairSpecification", om.valueToTree(this.getPredefinedMetricPairSpecification()));
                }
                if (this.getPredefinedScalingMetricSpecification() != null) {
                    data.set("predefinedScalingMetricSpecification", om.valueToTree(this.getPredefinedScalingMetricSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingMetricSpecificationProperty.Jsii$Proxy that = (PredictiveScalingMetricSpecificationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.predefinedLoadMetricSpecification != null ? !this.predefinedLoadMetricSpecification.equals(that.predefinedLoadMetricSpecification) : that.predefinedLoadMetricSpecification != null) return false;
                if (this.predefinedMetricPairSpecification != null ? !this.predefinedMetricPairSpecification.equals(that.predefinedMetricPairSpecification) : that.predefinedMetricPairSpecification != null) return false;
                return this.predefinedScalingMetricSpecification != null ? this.predefinedScalingMetricSpecification.equals(that.predefinedScalingMetricSpecification) : that.predefinedScalingMetricSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.predefinedLoadMetricSpecification != null ? this.predefinedLoadMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.predefinedMetricPairSpecification != null ? this.predefinedMetricPairSpecification.hashCode() : 0);
                result = 31 * result + (this.predefinedScalingMetricSpecification != null ? this.predefinedScalingMetricSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains load metric information for the `PredefinedLoadMetricSpecification` property of the [AWS::AutoScaling::ScalingPolicy PredictiveScalingMetricSpecification](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predictivescalingmetricspecification.html) property type.
     * <p>
     * <blockquote>
     * <p>
     * Does not apply to policies that use a <em>metric pair</em> for the metric specification.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * PredictiveScalingPredefinedLoadMetricProperty predictiveScalingPredefinedLoadMetricProperty = PredictiveScalingPredefinedLoadMetricProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedLoadMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingPredefinedLoadMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingPredefinedLoadMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
         * <p>
         * You can't specify a resource label unless the target group is attached to the Auto Scaling group.
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
         * <p>
         * <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
         * <p>
         * Where:
         * <p>
         * <ul>
         * <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
         * <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
         * </ul>
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingPredefinedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingPredefinedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingPredefinedLoadMetricProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredictiveScalingPredefinedLoadMetricProperty#getPredefinedMetricType}
             * @param predefinedMetricType The metric type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPredefinedLoadMetricProperty#getResourceLabel}
             * @param resourceLabel A label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group.
             *                      You can't specify a resource label unless the target group is attached to the Auto Scaling group.
             *                      <p>
             *                      You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
             *                      <p>
             *                      <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
             *                      <p>
             *                      Where:
             *                      <p>
             *                      <ul>
             *                      <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
             *                      <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
             *                      </ul>
             *                      <p>
             *                      To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingPredefinedLoadMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingPredefinedLoadMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingPredefinedLoadMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingPredefinedLoadMetricProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedLoadMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingPredefinedLoadMetricProperty.Jsii$Proxy that = (PredictiveScalingPredefinedLoadMetricProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains metric pair information for the `PredefinedMetricPairSpecification` property of the [AWS::AutoScaling::ScalingPolicy PredictiveScalingMetricSpecification](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predictivescalingmetricspecification.html) property type.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html">Predictive scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * PredictiveScalingPredefinedMetricPairProperty predictiveScalingPredefinedMetricPairProperty = PredictiveScalingPredefinedMetricPairProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedMetricPairProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingPredefinedMetricPairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingPredefinedMetricPairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates which metrics to use.
         * <p>
         * There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is <code>ASGCPUUtilization</code> , the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group.
         * <p>
         * You can't specify a resource label unless the target group is attached to the Auto Scaling group.
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
         * <p>
         * <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
         * <p>
         * Where:
         * <p>
         * <ul>
         * <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
         * <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
         * </ul>
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingPredefinedMetricPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingPredefinedMetricPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingPredefinedMetricPairProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredictiveScalingPredefinedMetricPairProperty#getPredefinedMetricType}
             * @param predefinedMetricType Indicates which metrics to use. This parameter is required.
             *                             There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is <code>ASGCPUUtilization</code> , the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPredefinedMetricPairProperty#getResourceLabel}
             * @param resourceLabel A label that uniquely identifies a specific Application Load Balancer target group from which to determine the total and average request count served by your Auto Scaling group.
             *                      You can't specify a resource label unless the target group is attached to the Auto Scaling group.
             *                      <p>
             *                      You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
             *                      <p>
             *                      <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
             *                      <p>
             *                      Where:
             *                      <p>
             *                      <ul>
             *                      <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
             *                      <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
             *                      </ul>
             *                      <p>
             *                      To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingPredefinedMetricPairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingPredefinedMetricPairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingPredefinedMetricPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingPredefinedMetricPairProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedMetricPairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingPredefinedMetricPairProperty.Jsii$Proxy that = (PredictiveScalingPredefinedMetricPairProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains scaling metric information for the `PredefinedScalingMetricSpecification` property of the [AWS::AutoScaling::ScalingPolicy PredictiveScalingMetricSpecification](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predictivescalingmetricspecification.html) property type.
     * <p>
     * <blockquote>
     * <p>
     * Does not apply to policies that use a <em>metric pair</em> for the metric specification.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * PredictiveScalingPredefinedScalingMetricProperty predictiveScalingPredefinedScalingMetricProperty = PredictiveScalingPredefinedScalingMetricProperty.builder()
     *         .predefinedMetricType("predefinedMetricType")
     *         // the properties below are optional
     *         .resourceLabel("resourceLabel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedScalingMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(PredictiveScalingPredefinedScalingMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredictiveScalingPredefinedScalingMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPredefinedMetricType();

        /**
         * A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group.
         * <p>
         * You can't specify a resource label unless the target group is attached to the Auto Scaling group.
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
         * <p>
         * <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
         * <p>
         * Where:
         * <p>
         * <ul>
         * <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
         * <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
         * </ul>
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredictiveScalingPredefinedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredictiveScalingPredefinedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredictiveScalingPredefinedScalingMetricProperty> {
            java.lang.String predefinedMetricType;
            java.lang.String resourceLabel;

            /**
             * Sets the value of {@link PredictiveScalingPredefinedScalingMetricProperty#getPredefinedMetricType}
             * @param predefinedMetricType The metric type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricType(java.lang.String predefinedMetricType) {
                this.predefinedMetricType = predefinedMetricType;
                return this;
            }

            /**
             * Sets the value of {@link PredictiveScalingPredefinedScalingMetricProperty#getResourceLabel}
             * @param resourceLabel A label that uniquely identifies a specific Application Load Balancer target group from which to determine the average request count served by your Auto Scaling group.
             *                      You can't specify a resource label unless the target group is attached to the Auto Scaling group.
             *                      <p>
             *                      You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
             *                      <p>
             *                      <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code> .
             *                      <p>
             *                      Where:
             *                      <p>
             *                      <ul>
             *                      <li>app/<load-balancer-name>/<load-balancer-id> is the final portion of the load balancer ARN</li>
             *                      <li>targetgroup/<target-group-name>/<target-group-id> is the final portion of the target group ARN.</li>
             *                      </ul>
             *                      <p>
             *                      To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredictiveScalingPredefinedScalingMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredictiveScalingPredefinedScalingMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredictiveScalingPredefinedScalingMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredictiveScalingPredefinedScalingMetricProperty {
            private final java.lang.String predefinedMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedMetricType = software.amazon.jsii.Kernel.get(this, "predefinedMetricType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedMetricType = java.util.Objects.requireNonNull(builder.predefinedMetricType, "predefinedMetricType is required");
                this.resourceLabel = builder.resourceLabel;
            }

            @Override
            public final java.lang.String getPredefinedMetricType() {
                return this.predefinedMetricType;
            }

            @Override
            public final java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedMetricType", om.valueToTree(this.getPredefinedMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.PredictiveScalingPredefinedScalingMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredictiveScalingPredefinedScalingMetricProperty.Jsii$Proxy that = (PredictiveScalingPredefinedScalingMetricProperty.Jsii$Proxy) o;

                if (!predefinedMetricType.equals(that.predefinedMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.predefinedMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `StepAdjustment` specifies a step adjustment for the `StepAdjustments` property of the [AWS::AutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html) resource.
     * <p>
     * For the following examples, suppose that you have an alarm with a breach threshold of 50:
     * <p>
     * <ul>
     * <li>To trigger a step adjustment when the metric is greater than or equal to 50 and less than 60, specify a lower bound of 0 and an upper bound of 10.</li>
     * <li>To trigger a step adjustment when the metric is greater than 40 and less than or equal to 50, specify a lower bound of -10 and an upper bound of 0.</li>
     * </ul>
     * <p>
     * There are a few rules for the step adjustments for your step policy:
     * <p>
     * <ul>
     * <li>The ranges of your step adjustments can't overlap or have a gap.</li>
     * <li>At most one step adjustment can have a null lower bound. If one step adjustment has a negative lower bound, then there must be a step adjustment with a null lower bound.</li>
     * <li>At most one step adjustment can have a null upper bound. If one step adjustment has a positive upper bound, then there must be a step adjustment with a null upper bound.</li>
     * <li>The upper and lower bound can't be null in the same step adjustment.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-steps">Step adjustments</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * You can find a sample template snippet in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#aws-properties-as-policy--examples">Examples</a> section of the <code>AWS::AutoScaling::ScalingPolicy</code> documentation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * StepAdjustmentProperty stepAdjustmentProperty = StepAdjustmentProperty.builder()
     *         .scalingAdjustment(123)
     *         // the properties below are optional
     *         .metricIntervalLowerBound(123)
     *         .metricIntervalUpperBound(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.StepAdjustmentProperty")
    @software.amazon.jsii.Jsii.Proxy(StepAdjustmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepAdjustmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount by which to scale.
         * <p>
         * The adjustment is based on the value that you specified in the <code>AdjustmentType</code> property (either an absolute number or a percentage). A positive value adds to the current capacity and a negative number subtracts from the current capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getScalingAdjustment();

        /**
         * The lower bound for the difference between the alarm threshold and the CloudWatch metric.
         * <p>
         * If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMetricIntervalLowerBound() {
            return null;
        }

        /**
         * The upper bound for the difference between the alarm threshold and the CloudWatch metric.
         * <p>
         * If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMetricIntervalUpperBound() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepAdjustmentProperty> {
            java.lang.Number scalingAdjustment;
            java.lang.Number metricIntervalLowerBound;
            java.lang.Number metricIntervalUpperBound;

            /**
             * Sets the value of {@link StepAdjustmentProperty#getScalingAdjustment}
             * @param scalingAdjustment The amount by which to scale. This parameter is required.
             *                          The adjustment is based on the value that you specified in the <code>AdjustmentType</code> property (either an absolute number or a percentage). A positive value adds to the current capacity and a negative number subtracts from the current capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link StepAdjustmentProperty#getMetricIntervalLowerBound}
             * @param metricIntervalLowerBound The lower bound for the difference between the alarm threshold and the CloudWatch metric.
             *                                 If the metric value is above the breach threshold, the lower bound is inclusive (the metric must be greater than or equal to the threshold plus the lower bound). Otherwise, it is exclusive (the metric must be greater than the threshold plus the lower bound). A null value indicates negative infinity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricIntervalLowerBound(java.lang.Number metricIntervalLowerBound) {
                this.metricIntervalLowerBound = metricIntervalLowerBound;
                return this;
            }

            /**
             * Sets the value of {@link StepAdjustmentProperty#getMetricIntervalUpperBound}
             * @param metricIntervalUpperBound The upper bound for the difference between the alarm threshold and the CloudWatch metric.
             *                                 If the metric value is above the breach threshold, the upper bound is exclusive (the metric must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the metric must be less than or equal to the threshold plus the upper bound). A null value indicates positive infinity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricIntervalUpperBound(java.lang.Number metricIntervalUpperBound) {
                this.metricIntervalUpperBound = metricIntervalUpperBound;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepAdjustmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepAdjustmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepAdjustmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepAdjustmentProperty {
            private final java.lang.Number scalingAdjustment;
            private final java.lang.Number metricIntervalLowerBound;
            private final java.lang.Number metricIntervalUpperBound;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metricIntervalLowerBound = software.amazon.jsii.Kernel.get(this, "metricIntervalLowerBound", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metricIntervalUpperBound = software.amazon.jsii.Kernel.get(this, "metricIntervalUpperBound", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scalingAdjustment = java.util.Objects.requireNonNull(builder.scalingAdjustment, "scalingAdjustment is required");
                this.metricIntervalLowerBound = builder.metricIntervalLowerBound;
                this.metricIntervalUpperBound = builder.metricIntervalUpperBound;
            }

            @Override
            public final java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public final java.lang.Number getMetricIntervalLowerBound() {
                return this.metricIntervalLowerBound;
            }

            @Override
            public final java.lang.Number getMetricIntervalUpperBound() {
                return this.metricIntervalUpperBound;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                if (this.getMetricIntervalLowerBound() != null) {
                    data.set("metricIntervalLowerBound", om.valueToTree(this.getMetricIntervalLowerBound()));
                }
                if (this.getMetricIntervalUpperBound() != null) {
                    data.set("metricIntervalUpperBound", om.valueToTree(this.getMetricIntervalUpperBound()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.StepAdjustmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepAdjustmentProperty.Jsii$Proxy that = (StepAdjustmentProperty.Jsii$Proxy) o;

                if (!scalingAdjustment.equals(that.scalingAdjustment)) return false;
                if (this.metricIntervalLowerBound != null ? !this.metricIntervalLowerBound.equals(that.metricIntervalLowerBound) : that.metricIntervalLowerBound != null) return false;
                return this.metricIntervalUpperBound != null ? this.metricIntervalUpperBound.equals(that.metricIntervalUpperBound) : that.metricIntervalUpperBound == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scalingAdjustment.hashCode();
                result = 31 * result + (this.metricIntervalLowerBound != null ? this.metricIntervalLowerBound.hashCode() : 0);
                result = 31 * result + (this.metricIntervalUpperBound != null ? this.metricIntervalUpperBound.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `TargetTrackingConfiguration` is a property of the [AWS::AutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html) resource that specifies a target tracking scaling policy configuration for Amazon EC2 Auto Scaling.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PutScalingPolicy.html">PutScalingPolicy</a> in the <em>Amazon EC2 Auto Scaling API Reference</em> . For more information about scaling policies, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scale-based-on-demand.html">Dynamic scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.autoscaling.*;
     * TargetTrackingConfigurationProperty targetTrackingConfigurationProperty = TargetTrackingConfigurationProperty.builder()
     *         .targetValue(123)
     *         // the properties below are optional
     *         .customizedMetricSpecification(CustomizedMetricSpecificationProperty.builder()
     *                 .metricName("metricName")
     *                 .namespace("namespace")
     *                 .statistic("statistic")
     *                 // the properties below are optional
     *                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .unit("unit")
     *                 .build())
     *         .disableScaleIn(false)
     *         .predefinedMetricSpecification(PredefinedMetricSpecificationProperty.builder()
     *                 .predefinedMetricType("predefinedMetricType")
     *                 // the properties below are optional
     *                 .resourceLabel("resourceLabel")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.TargetTrackingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetTrackingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target value for the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

        /**
         * A customized metric.
         * <p>
         * You must specify either a predefined metric or a customized metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizedMetricSpecification() {
            return null;
        }

        /**
         * Indicates whether scaling in by the target tracking scaling policy is disabled.
         * <p>
         * If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableScaleIn() {
            return null;
        }

        /**
         * A predefined metric.
         * <p>
         * You must specify either a predefined metric or a customized metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredefinedMetricSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetTrackingConfigurationProperty> {
            java.lang.Number targetValue;
            java.lang.Object customizedMetricSpecification;
            java.lang.Object disableScaleIn;
            java.lang.Object predefinedMetricSpecification;

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getTargetValue}
             * @param targetValue The target value for the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getCustomizedMetricSpecification}
             * @param customizedMetricSpecification A customized metric.
             *                                      You must specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedMetricSpecification(software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty customizedMetricSpecification) {
                this.customizedMetricSpecification = customizedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getCustomizedMetricSpecification}
             * @param customizedMetricSpecification A customized metric.
             *                                      You must specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customizedMetricSpecification(software.amazon.awscdk.IResolvable customizedMetricSpecification) {
                this.customizedMetricSpecification = customizedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scaling in by the target tracking scaling policy is disabled.
             *                       If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getDisableScaleIn}
             * @param disableScaleIn Indicates whether scaling in by the target tracking scaling policy is disabled.
             *                       If scaling in is disabled, the target tracking scaling policy doesn't remove instances from the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from the Auto Scaling group. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableScaleIn(software.amazon.awscdk.IResolvable disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getPredefinedMetricSpecification}
             * @param predefinedMetricSpecification A predefined metric.
             *                                      You must specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricSpecification(software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty predefinedMetricSpecification) {
                this.predefinedMetricSpecification = predefinedMetricSpecification;
                return this;
            }

            /**
             * Sets the value of {@link TargetTrackingConfigurationProperty#getPredefinedMetricSpecification}
             * @param predefinedMetricSpecification A predefined metric.
             *                                      You must specify either a predefined metric or a customized metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predefinedMetricSpecification(software.amazon.awscdk.IResolvable predefinedMetricSpecification) {
                this.predefinedMetricSpecification = predefinedMetricSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetTrackingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingConfigurationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object customizedMetricSpecification;
            private final java.lang.Object disableScaleIn;
            private final java.lang.Object predefinedMetricSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customizedMetricSpecification = software.amazon.jsii.Kernel.get(this, "customizedMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.predefinedMetricSpecification = software.amazon.jsii.Kernel.get(this, "predefinedMetricSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(builder.targetValue, "targetValue is required");
                this.customizedMetricSpecification = builder.customizedMetricSpecification;
                this.disableScaleIn = builder.disableScaleIn;
                this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
            }

            @Override
            public final java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public final java.lang.Object getCustomizedMetricSpecification() {
                return this.customizedMetricSpecification;
            }

            @Override
            public final java.lang.Object getDisableScaleIn() {
                return this.disableScaleIn;
            }

            @Override
            public final java.lang.Object getPredefinedMetricSpecification() {
                return this.predefinedMetricSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getCustomizedMetricSpecification() != null) {
                    data.set("customizedMetricSpecification", om.valueToTree(this.getCustomizedMetricSpecification()));
                }
                if (this.getDisableScaleIn() != null) {
                    data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                }
                if (this.getPredefinedMetricSpecification() != null) {
                    data.set("predefinedMetricSpecification", om.valueToTree(this.getPredefinedMetricSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicy.TargetTrackingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingConfigurationProperty.Jsii$Proxy that = (TargetTrackingConfigurationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.customizedMetricSpecification != null ? !this.customizedMetricSpecification.equals(that.customizedMetricSpecification) : that.customizedMetricSpecification != null) return false;
                if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
                return this.predefinedMetricSpecification != null ? this.predefinedMetricSpecification.equals(that.predefinedMetricSpecification) : that.predefinedMetricSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.customizedMetricSpecification != null ? this.customizedMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
                result = 31 * result + (this.predefinedMetricSpecification != null ? this.predefinedMetricSpecification.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.CfnScalingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.CfnScalingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.CfnScalingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.CfnScalingPolicyProps.Builder();
        }

        /**
         * The name of the Auto Scaling group.
         * <p>
         * @return {@code this}
         * @param autoScalingGroupName The name of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(final java.lang.String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        /**
         * Specifies how the scaling adjustment is interpreted. The valid values are `ChangeInCapacity` , `ExactCapacity` , and `PercentChangeInCapacity` .
         * <p>
         * Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * <p>
         * @return {@code this}
         * @param adjustmentType Specifies how the scaling adjustment is interpreted. The valid values are `ChangeInCapacity` , `ExactCapacity` , and `PercentChangeInCapacity` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(final java.lang.String adjustmentType) {
            this.props.adjustmentType(adjustmentType);
            return this;
        }

        /**
         * The duration of the policy's cooldown period, in seconds.
         * <p>
         * When a cooldown period is specified here, it overrides the default cooldown period defined for the Auto Scaling group.
         * <p>
         * Valid only if the policy type is <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * <p>
         * @return {@code this}
         * @param cooldown The duration of the policy's cooldown period, in seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(final java.lang.String cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        /**
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
         * <p>
         * If not provided, the default is to use the value from the default cooldown period for the Auto Scaling group.
         * <p>
         * Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code> .
         * <p>
         * @return {@code this}
         * @param estimatedInstanceWarmup The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder estimatedInstanceWarmup(final java.lang.Number estimatedInstanceWarmup) {
            this.props.estimatedInstanceWarmup(estimatedInstanceWarmup);
            return this;
        }

        /**
         * The aggregation type for the CloudWatch metrics.
         * <p>
         * The valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
         * <p>
         * Valid only if the policy type is <code>StepScaling</code> .
         * <p>
         * @return {@code this}
         * @param metricAggregationType The aggregation type for the CloudWatch metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricAggregationType(final java.lang.String metricAggregationType) {
            this.props.metricAggregationType(metricAggregationType);
            return this;
        }

        /**
         * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity` .
         * <p>
         * For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
         * <p>
         * Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param minAdjustmentMagnitude The minimum value to scale by when the adjustment type is `PercentChangeInCapacity` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(final java.lang.Number minAdjustmentMagnitude) {
            this.props.minAdjustmentMagnitude(minAdjustmentMagnitude);
            return this;
        }

        /**
         * One of the following policy types:.
         * <p>
         * <ul>
         * <li><code>TargetTrackingScaling</code></li>
         * <li><code>StepScaling</code></li>
         * <li><code>SimpleScaling</code> (default)</li>
         * <li><code>PredictiveScaling</code></li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling policies</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * <p>
         * @return {@code this}
         * @param policyType One of the following policy types:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(final java.lang.String policyType) {
            this.props.policyType(policyType);
            return this;
        }

        /**
         * A predictive scaling policy.
         * <p>
         * Includes support for predefined metrics only.
         * <p>
         * @return {@code this}
         * @param predictiveScalingConfiguration A predictive scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predictiveScalingConfiguration(final software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredictiveScalingConfigurationProperty predictiveScalingConfiguration) {
            this.props.predictiveScalingConfiguration(predictiveScalingConfiguration);
            return this;
        }
        /**
         * A predictive scaling policy.
         * <p>
         * Includes support for predefined metrics only.
         * <p>
         * @return {@code this}
         * @param predictiveScalingConfiguration A predictive scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predictiveScalingConfiguration(final software.amazon.awscdk.IResolvable predictiveScalingConfiguration) {
            this.props.predictiveScalingConfiguration(predictiveScalingConfiguration);
            return this;
        }

        /**
         * The amount by which to scale, based on the specified adjustment type.
         * <p>
         * A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
         * <p>
         * Required if the policy type is <code>SimpleScaling</code> . (Not used with any other policy type.)
         * <p>
         * @return {@code this}
         * @param scalingAdjustment The amount by which to scale, based on the specified adjustment type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingAdjustment(final java.lang.Number scalingAdjustment) {
            this.props.scalingAdjustment(scalingAdjustment);
            return this;
        }

        /**
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * <p>
         * Required if the policy type is <code>StepScaling</code> . (Not used with any other policy type.)
         * <p>
         * @return {@code this}
         * @param stepAdjustments A set of adjustments that enable you to scale based on the size of the alarm breach. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepAdjustments(final software.amazon.awscdk.IResolvable stepAdjustments) {
            this.props.stepAdjustments(stepAdjustments);
            return this;
        }
        /**
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * <p>
         * Required if the policy type is <code>StepScaling</code> . (Not used with any other policy type.)
         * <p>
         * @return {@code this}
         * @param stepAdjustments A set of adjustments that enable you to scale based on the size of the alarm breach. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepAdjustments(final java.util.List<? extends java.lang.Object> stepAdjustments) {
            this.props.stepAdjustments(stepAdjustments);
            return this;
        }

        /**
         * A target tracking scaling policy. Includes support for predefined or customized metrics.
         * <p>
         * The following predefined metrics are available:
         * <p>
         * <ul>
         * <li><code>ASGAverageCPUUtilization</code></li>
         * <li><code>ASGAverageNetworkIn</code></li>
         * <li><code>ASGAverageNetworkOut</code></li>
         * <li><code>ALBRequestCountPerTarget</code></li>
         * </ul>
         * <p>
         * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code> .
         * <p>
         * @return {@code this}
         * @param targetTrackingConfiguration A target tracking scaling policy. Includes support for predefined or customized metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingConfiguration(final software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.TargetTrackingConfigurationProperty targetTrackingConfiguration) {
            this.props.targetTrackingConfiguration(targetTrackingConfiguration);
            return this;
        }
        /**
         * A target tracking scaling policy. Includes support for predefined or customized metrics.
         * <p>
         * The following predefined metrics are available:
         * <p>
         * <ul>
         * <li><code>ASGAverageCPUUtilization</code></li>
         * <li><code>ASGAverageNetworkIn</code></li>
         * <li><code>ASGAverageNetworkOut</code></li>
         * <li><code>ALBRequestCountPerTarget</code></li>
         * </ul>
         * <p>
         * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code> .
         * <p>
         * @return {@code this}
         * @param targetTrackingConfiguration A target tracking scaling policy. Includes support for predefined or customized metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingConfiguration(final software.amazon.awscdk.IResolvable targetTrackingConfiguration) {
            this.props.targetTrackingConfiguration(targetTrackingConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.autoscaling.CfnScalingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.CfnScalingPolicy build() {
            return new software.amazon.awscdk.services.autoscaling.CfnScalingPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
