package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a `CfnGraphQLSchema`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnGraphQLSchemaProps cfnGraphQLSchemaProps = CfnGraphQLSchemaProps.builder()
 *         .apiId("apiId")
 *         // the properties below are optional
 *         .definition("definition")
 *         .definitionS3Location("definitionS3Location")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.634Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLSchemaProps")
@software.amazon.jsii.Jsii.Proxy(CfnGraphQLSchemaProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGraphQLSchemaProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS AppSync GraphQL API identifier to which you want to apply this schema.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The text representation of a GraphQL schema in SDL format.
     * <p>
     * For more information about using the <code>Ref</code> function, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref">Ref</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefinition() {
        return null;
    }

    /**
     * The location of a GraphQL schema file in an Amazon S3 bucket.
     * <p>
     * Use this if you want to provision with the schema living in Amazon S3 rather than embedding it in your CloudFormation template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefinitionS3Location() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGraphQLSchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGraphQLSchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGraphQLSchemaProps> {
        java.lang.String apiId;
        java.lang.String definition;
        java.lang.String definitionS3Location;

        /**
         * Sets the value of {@link CfnGraphQLSchemaProps#getApiId}
         * @param apiId The AWS AppSync GraphQL API identifier to which you want to apply this schema. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLSchemaProps#getDefinition}
         * @param definition The text representation of a GraphQL schema in SDL format.
         *                   For more information about using the <code>Ref</code> function, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref">Ref</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(java.lang.String definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLSchemaProps#getDefinitionS3Location}
         * @param definitionS3Location The location of a GraphQL schema file in an Amazon S3 bucket.
         *                             Use this if you want to provision with the schema living in Amazon S3 rather than embedding it in your CloudFormation template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(java.lang.String definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGraphQLSchemaProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGraphQLSchemaProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGraphQLSchemaProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGraphQLSchemaProps {
        private final java.lang.String apiId;
        private final java.lang.String definition;
        private final java.lang.String definitionS3Location;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definitionS3Location = software.amazon.jsii.Kernel.get(this, "definitionS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.definition = builder.definition;
            this.definitionS3Location = builder.definitionS3Location;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getDefinition() {
            return this.definition;
        }

        @Override
        public final java.lang.String getDefinitionS3Location() {
            return this.definitionS3Location;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            if (this.getDefinition() != null) {
                data.set("definition", om.valueToTree(this.getDefinition()));
            }
            if (this.getDefinitionS3Location() != null) {
                data.set("definitionS3Location", om.valueToTree(this.getDefinitionS3Location()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLSchemaProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGraphQLSchemaProps.Jsii$Proxy that = (CfnGraphQLSchemaProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
            return this.definitionS3Location != null ? this.definitionS3Location.equals(that.definitionS3Location) : that.definitionS3Location == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.definition != null ? this.definition.hashCode() : 0);
            result = 31 * result + (this.definitionS3Location != null ? this.definitionS3Location.hashCode() : 0);
            return result;
        }
    }
}
