package software.amazon.awscdk.services.appmesh;

/**
 * Represents a TLS certificate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * // A Virtual Node with listener TLS from an ACM provided certificate
 * Certificate cert;
 * Mesh mesh;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node"))
 *         .listeners(List.of(VirtualNodeListener.grpc(GrpcVirtualNodeListenerOptions.builder()
 *                 .port(80)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.acm(cert))
 *                         .build())
 *                 .build())))
 *         .build();
 * // A Virtual Gateway with listener TLS from a customer provided file certificate
 * VirtualGateway gateway = VirtualGateway.Builder.create(this, "gateway")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.grpc(GrpcGatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.file("path/to/certChain", "path/to/privateKey"))
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway")
 *         .build();
 * // A Virtual Gateway with listener TLS from a SDS provided certificate
 * VirtualGateway gateway2 = VirtualGateway.Builder.create(this, "gateway2")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.http2(Http2GatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.sds("secrete_certificate"))
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway2")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.529Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.TlsCertificate")
public abstract class TlsCertificate extends software.amazon.jsii.JsiiObject {

    protected TlsCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TlsCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TlsCertificate() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Returns an ACM TLS Certificate.
     * <p>
     * @param certificate This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsCertificate acm(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.TlsCertificate.class, "acm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsCertificate.class), new Object[] { java.util.Objects.requireNonNull(certificate, "certificate is required") });
    }

    /**
     * Returns an File TLS Certificate.
     * <p>
     * @param certificateChainPath This parameter is required.
     * @param privateKeyPath This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.MutualTlsCertificate file(final @org.jetbrains.annotations.NotNull java.lang.String certificateChainPath, final @org.jetbrains.annotations.NotNull java.lang.String privateKeyPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.TlsCertificate.class, "file", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.MutualTlsCertificate.class), new Object[] { java.util.Objects.requireNonNull(certificateChainPath, "certificateChainPath is required"), java.util.Objects.requireNonNull(privateKeyPath, "privateKeyPath is required") });
    }

    /**
     * Returns an SDS TLS Certificate.
     * <p>
     * @param secretName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.MutualTlsCertificate sds(final @org.jetbrains.annotations.NotNull java.lang.String secretName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.TlsCertificate.class, "sds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.MutualTlsCertificate.class), new Object[] { java.util.Objects.requireNonNull(secretName, "secretName is required") });
    }

    /**
     * Returns TLS certificate based provider.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsCertificateConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.TlsCertificate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns TLS certificate based provider.
         * <p>
         * @param _scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsCertificateConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsCertificateConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
        }
    }
}
