package software.amazon.awscdk.services.applicationautoscaling;

/**
 * How adjustment numbers are interpreted.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ScalableAttribute capacity;
 * Metric cpuUtilization;
 * capacity.scaleOnMetric("ScaleToCPU", BasicStepScalingPolicyProps.builder()
 *         .metric(cpuUtilization)
 *         .scalingSteps(List.of(ScalingInterval.builder().upper(10).change(-1).build(), ScalingInterval.builder().lower(50).change(+1).build(), ScalingInterval.builder().lower(70).change(+3).build()))
 *         // Change this to AdjustmentType.PercentChangeInCapacity to interpret the
 *         // 'change' numbers before as percentages instead of capacity counts.
 *         .adjustmentType(AdjustmentType.CHANGE_IN_CAPACITY)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.315Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.AdjustmentType")
public enum AdjustmentType {
    /**
     * Add the adjustment number to the current capacity.
     * <p>
     * A positive number increases capacity, a negative number decreases capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CHANGE_IN_CAPACITY,
    /**
     * Add this percentage of the current capacity to itself.
     * <p>
     * The number must be between -100 and 100; a positive number increases
     * capacity and a negative number decreases it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERCENT_CHANGE_IN_CAPACITY,
    /**
     * Make the capacity equal to the exact number given.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXACT_CAPACITY,
}
