package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Function hello;
 * LambdaIntegration integration = LambdaIntegration.Builder.create(hello)
 *         .proxy(false)
 *         .requestParameters(Map.of(
 *                 // You can define mapping parameters from your method to your integration
 *                 // - Destination parameters (the key) are the integration parameters (used in mappings)
 *                 // - Source parameters (the value) are the source request parameters or expressions
 *                 // &#64;see: https://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
 *                 "integration.request.querystring.who", "method.request.querystring.who"))
 *         .allowTestInvoke(true)
 *         .requestTemplates(Map.of(
 *                 // You can define a mapping that will build a payload for your integration, based
 *                 //  on the integration parameters that you have specified
 *                 // Check: https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
 *                 "application/json", JSON.stringify(Map.of("action", "sayHello", "pollId", "$util.escapeJavaScript($input.params('who'))"))))
 *         // This parameter defines the behavior of the engine is no suitable response template is found
 *         .passthroughBehavior(PassthroughBehavior.NEVER)
 *         .integrationResponses(List.of(IntegrationResponse.builder()
 *                 // Successful response from the Lambda function, no filter defined
 *                 //  - the selectionPattern filter only tests the error message
 *                 // We will set the response status code to 200
 *                 .statusCode("200")
 *                 .responseTemplates(Map.of(
 *                         // This template takes the "message" result from the Lambda function, and embeds it in a JSON response
 *                         // Check https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
 *                         "application/json", JSON.stringify(Map.of("state", "ok", "greeting", "$util.escapeJavaScript($input.body)"))))
 *                 .responseParameters(Map.of(
 *                         // We can map response parameters
 *                         // - Destination parameters (the key) are the response parameters (used in mappings)
 *                         // - Source parameters (the value) are the integration response parameters or expressions
 *                         "method.response.header.Content-Type", "'application/json'",
 *                         "method.response.header.Access-Control-Allow-Origin", "'*'",
 *                         "method.response.header.Access-Control-Allow-Credentials", "'true'"))
 *                 .build(), IntegrationResponse.builder()
 *                 // For errors, we check if the error message is not empty, get the error data
 *                 .selectionPattern("(\n|.)+")
 *                 // We will set the response status code to 200
 *                 .statusCode("400")
 *                 .responseTemplates(Map.of(
 *                         "application/json", JSON.stringify(Map.of("state", "error", "message", "$util.escapeJavaScript($input.path('$.errorMessage'))"))))
 *                 .responseParameters(Map.of(
 *                         "method.response.header.Content-Type", "'application/json'",
 *                         "method.response.header.Access-Control-Allow-Origin", "'*'",
 *                         "method.response.header.Access-Control-Allow-Credentials", "'true'"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:07.142Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.PassthroughBehavior")
public enum PassthroughBehavior {
    /**
     * Passes the request body for unmapped content types through to the integration back end without transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WHEN_NO_MATCH,
    /**
     * Rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEVER,
    /**
     * Allows pass-through when the integration has NO content types mapped to templates.
     * <p>
     * However if there is at least one content type defined,
     * unmapped content types will be rejected with the same 415 response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WHEN_NO_TEMPLATES,
}
