package software.amazon.awscdk;

/**
 * Represents the amount of digital storage.
 * <p>
 * The amount can be specified either as a literal value (e.g: <code>10</code>) which
 * cannot be negative, or as an unresolved number token.
 * <p>
 * When the amount is passed as a token, unit conversion is not possible.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTrainingJob.Builder.create(this, "TrainSagemaker")
 *         .trainingJobName(JsonPath.stringAt("$.JobName"))
 *         .algorithmSpecification(AlgorithmSpecification.builder()
 *                 .algorithmName("BlazingText")
 *                 .trainingInputMode(InputMode.FILE)
 *                 .build())
 *         .inputDataConfig(List.of(Channel.builder()
 *                 .channelName("train")
 *                 .dataSource(DataSource.builder()
 *                         .s3DataSource(S3DataSource.builder()
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .s3Location(S3Location.fromJsonExpression("$.S3Bucket"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .outputDataConfig(OutputDataConfig.builder()
 *                 .s3OutputLocation(S3Location.fromBucket(Bucket.fromBucketName(this, "Bucket", "mybucket"), "myoutputpath"))
 *                 .build())
 *         .resourceConfig(ResourceConfig.builder()
 *                 .instanceCount(1)
 *                 .instanceType(new InstanceType(JsonPath.stringAt("$.InstanceType")))
 *                 .volumeSize(Size.gibibytes(50))
 *                 .build()) // optional: default is 1 instance of EC2 `M4.XLarge` with `10GB` volume
 *         .stoppingCondition(StoppingCondition.builder()
 *                 .maxRuntime(Duration.hours(2))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-01-29T04:34:06.892Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Size")
public class Size extends software.amazon.jsii.JsiiObject {

    protected Size(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Size(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a Storage representing an amount gibibytes.
     * <p>
     * 1 GiB = 1024 MiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of gibibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size gibibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "gibibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount kibibytes.
     * <p>
     * 1 KiB = 1024 bytes
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of kibibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size kibibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "kibibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount mebibytes.
     * <p>
     * 1 MiB = 1024 KiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of mebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size mebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "mebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount pebibytes.
     * <p>
     * 1 PiB = 1024 TiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of pebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size pebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "pebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Create a Storage representing an amount tebibytes.
     * <p>
     * 1 TiB = 1024 GiB
     * <p>
     * @return a new `Size` instance
     * @param amount the amount of tebibytes to be represented. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Size tebibytes(final @org.jetbrains.annotations.NotNull java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Size.class, "tebibytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class), new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Return this storage as a total number of gibibytes.
     * <p>
     * @return the quantity of bytes expressed in gibibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toGibibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toGibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of gibibytes.
     * <p>
     * @return the quantity of bytes expressed in gibibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toGibibytes() {
        return software.amazon.jsii.Kernel.call(this, "toGibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return this storage as a total number of kibibytes.
     * <p>
     * @return the quantity of bytes expressed in kibibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toKibibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toKibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of kibibytes.
     * <p>
     * @return the quantity of bytes expressed in kibibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toKibibytes() {
        return software.amazon.jsii.Kernel.call(this, "toKibibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return this storage as a total number of mebibytes.
     * <p>
     * @return the quantity of bytes expressed in mebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of mebibytes.
     * <p>
     * @return the quantity of bytes expressed in mebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toMebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toMebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return this storage as a total number of pebibytes.
     * <p>
     * @return the quantity of bytes expressed in pebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toPebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toPebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of pebibytes.
     * <p>
     * @return the quantity of bytes expressed in pebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toPebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toPebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Return this storage as a total number of tebibytes.
     * <p>
     * @return the quantity of bytes expressed in tebibytes
     * @param opts the conversion options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toTebibytes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SizeConversionOptions opts) {
        return software.amazon.jsii.Kernel.call(this, "toTebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { opts });
    }

    /**
     * Return this storage as a total number of tebibytes.
     * <p>
     * @return the quantity of bytes expressed in tebibytes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toTebibytes() {
        return software.amazon.jsii.Kernel.call(this, "toTebibytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }
}
