/**
 * <h2>Amazon EC2 Auto Scaling Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h3>Fleet</h3>
 * <p>
 * <h3>Auto Scaling Group</h3>
 * <p>
 * An <code>AutoScalingGroup</code> represents a number of instances on which you run your code. You
 * pick the size of the fleet, the instance type and the OS image:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.ec2.*;
 * 
 * new AutoScalingGroup(this, "ASG", new AutoScalingGroupProps()
 *         .vpc(vpc)
 *         .instanceType(ec2.InstanceType.of(ec2.InstanceClass.getBURSTABLE2(), ec2.InstanceSize.getMICRO()))
 *         .machineImage(new AmazonLinuxImage()));
 * </pre></blockquote>
 * <p>
 * NOTE: AutoScalingGroup has an property called <code>allowAllOutbound</code> (allowing the instances to contact the
 * internet) which is set to <code>true</code> by default. Be sure to set this to <code>false</code>  if you don't want
 * your instances to be able to start arbitrary connections. Alternatively, you can specify an existing security
 * group to attach to the instances that are launched, rather than have the group create a new one.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var mySecurityGroup = SecurityGroup.Builder.create(this, "SecurityGroup")....build();
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(ec2.InstanceType.of(ec2.InstanceClass.getBURSTABLE2(), ec2.InstanceSize.getMICRO()))
 *         .machineImage(new AmazonLinuxImage())
 *         .securityGroup(mySecurityGroup)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Machine Images (AMIs)</h3>
 * <p>
 * AMIs control the OS that gets launched when you start your EC2 instance. The EC2
 * library contains constructs to select the AMI you want to use.
 * <p>
 * Depending on the type of AMI, you select it a different way.
 * <p>
 * The latest version of Amazon Linux and Microsoft Windows images are
 * selectable by instantiating one of these classes:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * // Pick a Windows edition to use
 * WindowsImage windows = new WindowsImage(ec2.WindowsVersion.getWINDOWS_SERVER_2019_ENGLISH_FULL_BASE());
 * 
 * // Pick the right Amazon Linux edition. All arguments shown are optional
 * // and will default to these values when omitted.
 * AmazonLinuxImage amznLinux = new AmazonLinuxImage(new AmazonLinuxImageProps()
 *         .generation(ec2.AmazonLinuxGeneration.getAMAZON_LINUX())
 *         .edition(ec2.AmazonLinuxEdition.getSTANDARD())
 *         .virtualization(ec2.AmazonLinuxVirt.getHVM())
 *         .storage(ec2.AmazonLinuxStorage.getGENERAL_PURPOSE()));
 * 
 * // For other custom (Linux) images, instantiate a `GenericLinuxImage` with
 * // a map giving the AMI to in for each region:
 * 
 * GenericLinuxImage linux = GenericLinuxImage.Builder.create()Map.of(
 *         "us-east-1", "ami-97785bed",
 *         "eu-west-1", "ami-12345678");
 * </pre></blockquote>
 * <p>
 * <blockquote>
 * <p>
 * NOTE: The Amazon Linux images selected will be cached in your <code>cdk.json</code>, so that your
 * AutoScalingGroups don't automatically change out from under you when you're making unrelated
 * changes. To update to the latest version of Amazon Linux, remove the cache entry from the <code>context</code>
 * section of your <code>cdk.json</code>.
 * <p>
 * We will add command-line options to make this step easier in the future.
 * <p>
 * </blockquote>
 * <p>
 * <h3>AutoScaling Instance Counts</h3>
 * <p>
 * AutoScalingGroups make it possible to raise and lower the number of instances in the group,
 * in response to (or in advance of) changes in workload.
 * <p>
 * When you create your AutoScalingGroup, you specify a <code>minCapacity</code> and a
 * <code>maxCapacity</code>. AutoScaling policies that respond to metrics will never go higher
 * or lower than the indicated capacity (but scheduled scaling actions might, see
 * below).
 * <p>
 * There are three ways to scale your capacity:
 * <p>
 * <ul>
 * <li><strong>In response to a metric</strong> (also known as step scaling); for example, you
 * might want to scale out if the CPU usage across your cluster starts to rise,
 * and scale in when it drops again.</li>
 * <li><strong>By trying to keep a certain metric around a given value</strong> (also known as
 * target tracking scaling); you might want to automatically scale out and in to
 * keep your CPU usage around 50%.</li>
 * <li><strong>On a schedule</strong>; you might want to organize your scaling around traffic
 * flows you expect, by scaling out in the morning and scaling in in the
 * evening.</li>
 * </ul>
 * <p>
 * The general pattern of autoscaling will look like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var autoScalingGroup = AutoScalingGroup.Builder.create(this, "ASG")
 *         .minCapacity(5)
 *         .maxCapacity(100)
 *         .build();
 * 
 * // Step scaling
 * autoScalingGroup.scaleOnMetric(...);
 * 
 * // Target tracking scaling
 * autoScalingGroup.scaleOnCpuUtilization(...);
 * autoScalingGroup.scaleOnIncomingBytes(...);
 * autoScalingGroup.scaleOnOutgoingBytes(...);
 * autoScalingGroup.scaleOnRequestCount(...);
 * autoScalingGroup.scaleToTrackMetric(...);
 * 
 * // Scheduled scaling
 * autoScalingGroup.scaleOnSchedule(...);
 * </pre></blockquote>
 * <p>
 * <h4>Step Scaling</h4>
 * <p>
 * This type of scaling scales in and out in deterministics steps that you
 * configure, in response to metric values. For example, your scaling strategy to
 * scale in response to a metric that represents your average worker pool usage
 * might look like this:
 * <p>
 * <blockquote><pre>
 *  Scaling        -1          (no change)          +1       +3
 *             │        │                       │        │        │
 *             ├────────┼───────────────────────┼────────┼────────┤
 *             │        │                       │        │        │
 * Worker use  0%      10%                     50%       70%     100%
 * </pre></blockquote>
 * <p>
 * (Note that this is not necessarily a recommended scaling strategy, but it's
 * a possible one. You will have to determine what thresholds are right for you).
 * <p>
 * Note that in order to set up this scaling strategy, you will have to emit a
 * metric representing your worker utilization from your instances. After that,
 * you would configure the scaling something like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var workerUtilizationMetric = Metric.Builder.create()
 *         .namespace("MyService")
 *         .metricName("WorkerUtilization")
 *         .build();
 * 
 * capacity.scaleOnMetric("ScaleToCPU", Map.of(
 *         "metric", workerUtilizationMetric,
 *         "scalingSteps", asList(Map.of("upper", 10, "change", -1), Map.of("lower", 50, "change", +1), Map.of("lower", 70, "change", +3)),
 * 
 *         // Change this to AdjustmentType.PERCENT_CHANGE_IN_CAPACITY to interpret the
 *         // 'change' numbers before as percentages instead of capacity counts.
 *         "adjustmentType", autoscaling.AdjustmentType.getCHANGE_IN_CAPACITY()));
 * </pre></blockquote>
 * <p>
 * The AutoScaling construct library will create the required CloudWatch alarms and
 * AutoScaling policies for you.
 * <p>
 * <h4>Target Tracking Scaling</h4>
 * <p>
 * This type of scaling scales in and out in order to keep a metric around a value
 * you prefer. There are four types of predefined metrics you can track, or you can
 * choose to track a custom metric. If you do choose to track a custom metric,
 * be aware that the metric has to represent instance utilization in some way
 * (AutoScaling will scale out if the metric is higher than the target, and scale
 * in if the metric is lower than the target).
 * <p>
 * If you configure multiple target tracking policies, AutoScaling will use the
 * one that yields the highest capacity.
 * <p>
 * The following example scales to keep the CPU usage of your instances around
 * 50% utilization:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * autoScalingGroup.scaleOnCpuUtilization("KeepSpareCPU", Map.of(
 *         "targetUtilizationPercent", 50));
 * </pre></blockquote>
 * <p>
 * To scale on average network traffic in and out of your instances:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * autoScalingGroup.scaleOnIncomingBytes("LimitIngressPerInstance", Map.of(
 *         "targetBytesPerSecond", 10 * 1024 * 1024));
 * autoScalingGroup.scaleOnOutcomingBytes("LimitEgressPerInstance", Map.of(
 *         "targetBytesPerSecond", 10 * 1024 * 1024));
 * </pre></blockquote>
 * <p>
 * To scale on the average request count per instance (only works for
 * AutoScalingGroups that have been attached to Application Load
 * Balancers):
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * autoScalingGroup.scaleOnRequestCount("LimitRPS", Map.of(
 *         "targetRequestsPerSecond", 1000));
 * </pre></blockquote>
 * <p>
 * <h4>Scheduled Scaling</h4>
 * <p>
 * This type of scaling is used to change capacities based on time. It works by
 * changing <code>minCapacity</code>, <code>maxCapacity</code> and <code>desiredCapacity</code> of the
 * AutoScalingGroup, and so can be used for two purposes:
 * <p>
 * <ul>
 * <li>Scale in and out on a schedule by setting the <code>minCapacity</code> high or
 * the <code>maxCapacity</code> low.</li>
 * <li>Still allow the regular scaling actions to do their job, but restrict
 * the range they can scale over (by setting both <code>minCapacity</code> and
 * <code>maxCapacity</code> but changing their range over time).</li>
 * </ul>
 * <p>
 * A schedule is expressed as a cron expression. The <code>Schedule</code> class has a <code>cron</code> method to help build cron expressions.
 * <p>
 * The following example scales the fleet out in the morning, going back to natural
 * scaling (all the way down to 1 instance if necessary) at night:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * autoScalingGroup.scaleOnSchedule("PrescaleInTheMorning", Map.of(
 *         "schedule", autoscaling.Schedule.cron(Map.of("hour", "8", "minute", "0")),
 *         "minCapacity", 20));
 * 
 * autoScalingGroup.scaleOnSchedule("AllowDownscalingAtNight", Map.of(
 *         "schedule", autoscaling.Schedule.cron(Map.of("hour", "20", "minute", "0")),
 *         "minCapacity", 1));
 * </pre></blockquote>
 * <p>
 * <h3>Allowing Connections</h3>
 * <p>
 * See the documentation of the <code>&#64;aws-cdk/aws-ec2</code> package for more information
 * about allowing connections between resources backed by instances.
 * <p>
 * <h3>Max Instance Lifetime</h3>
 * <p>
 * To enable the max instance lifetime support, specify <code>maxInstanceLifetime</code> property
 * for the <code>AutoscalingGroup</code> resource. The value must be between 7 and 365 days(inclusive).
 * To clear a previously set value, leave this property undefined.
 * <p>
 * <h3>Instance Monitoring</h3>
 * <p>
 * To disable detailed instance monitoring, specify <code>instanceMonitoring</code> property
 * for the <code>AutoscalingGroup</code> resource as <code>Monitoring.BASIC</code>. Otherwise detailed monitoring
 * will be enabled.
 * <p>
 * <h3>Monitoring Group Metrics</h3>
 * <p>
 * Group metrics are used to monitor group level properties; they describe the group rather than any of its instances (e.g GroupMaxSize, the group maximum size). To enable group metrics monitoring, use the <code>groupMetrics</code> property.
 * All group metrics are reported in a granularity of 1 minute at no additional charge.
 * <p>
 * See <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html#as-group-metrics">EC2 docs</a> for a list of all available group metrics.
 * <p>
 * To enable group metrics monitoring using the <code>groupMetrics</code> property:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // Enable monitoring of all group metrics
 * // Enable monitoring of all group metrics
 * AutoScalingGroup.Builder.create(stack, "ASG")
 *         .groupMetrics(asList(GroupMetrics.all()))
 *         .build();
 * 
 * // Enable monitoring for a subset of group metrics
 * // Enable monitoring for a subset of group metrics
 * AutoScalingGroup.Builder.create(stack, "ASG")
 *         .groupMetrics(asList(new GroupMetrics(GroupMetric.getMIN_SIZE(), GroupMetric.getMAX_SIZE())))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Future work</h3>
 * <p>
 * <ul>
 * <li>[ ] CloudWatch Events (impossible to add currently as the AutoScalingGroup ARN is
 * necessary to make this rule and this cannot be accessed from CloudFormation).</li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.autoscaling;
