package software.amazon.awscdk.services.autoscaling;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.654Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.StepScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(StepScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StepScalingPolicyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.autoscaling.BasicStepScalingPolicyProps {

    /**
     * The auto scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup();

    /**
     * @return a {@link Builder} of {@link StepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StepScalingPolicyProps> {
        private software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> scalingSteps;
        private software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType;
        private software.amazon.awscdk.core.Duration cooldown;
        private software.amazon.awscdk.core.Duration estimatedInstanceWarmup;
        private java.lang.Number minAdjustmentMagnitude;

        /**
         * Sets the value of {@link StepScalingPolicyProps#getAutoScalingGroup}
         * @param autoScalingGroup The auto scaling group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getMetric}
         * @param metric Metric to scale on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getScalingSteps}
         * @param scalingSteps The intervals for scaling. This parameter is required.
         *                     Maps a range of metric values to a particular scaling behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingSteps(java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> scalingSteps) {
            this.scalingSteps = scalingSteps;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getAdjustmentType}
         * @param adjustmentType How the adjustment numbers inside 'intervals' are interpreted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getCooldown}
         * @param cooldown Grace period after scaling activity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.core.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getEstimatedInstanceWarmup}
         * @param estimatedInstanceWarmup Estimated time until a newly launched instance can send metrics to CloudWatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder estimatedInstanceWarmup(software.amazon.awscdk.core.Duration estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingPolicyProps#getMinAdjustmentMagnitude}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling.
         *                               Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         *                               the minimum absolute effect size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StepScalingPolicyProps build() {
            return new Jsii$Proxy(autoScalingGroup, metric, scalingSteps, adjustmentType, cooldown, estimatedInstanceWarmup, minAdjustmentMagnitude);
        }
    }

    /**
     * An implementation for {@link StepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepScalingPolicyProps {
        private final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private final software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> scalingSteps;
        private final software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType;
        private final software.amazon.awscdk.core.Duration cooldown;
        private final software.amazon.awscdk.core.Duration estimatedInstanceWarmup;
        private final java.lang.Number minAdjustmentMagnitude;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroup = this.jsiiGet("autoScalingGroup", software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class);
            this.metric = this.jsiiGet("metric", software.amazon.awscdk.services.cloudwatch.IMetric.class);
            this.scalingSteps = this.jsiiGet("scalingSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingInterval.class)));
            this.adjustmentType = this.jsiiGet("adjustmentType", software.amazon.awscdk.services.autoscaling.AdjustmentType.class);
            this.cooldown = this.jsiiGet("cooldown", software.amazon.awscdk.core.Duration.class);
            this.estimatedInstanceWarmup = this.jsiiGet("estimatedInstanceWarmup", software.amazon.awscdk.core.Duration.class);
            this.minAdjustmentMagnitude = this.jsiiGet("minAdjustmentMagnitude", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup, final software.amazon.awscdk.services.cloudwatch.IMetric metric, final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> scalingSteps, final software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType, final software.amazon.awscdk.core.Duration cooldown, final software.amazon.awscdk.core.Duration estimatedInstanceWarmup, final java.lang.Number minAdjustmentMagnitude) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroup = java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required");
            this.metric = java.util.Objects.requireNonNull(metric, "metric is required");
            this.scalingSteps = java.util.Objects.requireNonNull(scalingSteps, "scalingSteps is required");
            this.adjustmentType = adjustmentType;
            this.cooldown = cooldown;
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
            return this.metric;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.autoscaling.ScalingInterval> getScalingSteps() {
            return this.scalingSteps;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.AdjustmentType getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public software.amazon.awscdk.core.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public software.amazon.awscdk.core.Duration getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public java.lang.Number getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroup", om.valueToTree(this.getAutoScalingGroup()));
            data.set("metric", om.valueToTree(this.getMetric()));
            data.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
            if (this.getAdjustmentType() != null) {
                data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getEstimatedInstanceWarmup() != null) {
                data.set("estimatedInstanceWarmup", om.valueToTree(this.getEstimatedInstanceWarmup()));
            }
            if (this.getMinAdjustmentMagnitude() != null) {
                data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling.StepScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StepScalingPolicyProps.Jsii$Proxy that = (StepScalingPolicyProps.Jsii$Proxy) o;

            if (!autoScalingGroup.equals(that.autoScalingGroup)) return false;
            if (!metric.equals(that.metric)) return false;
            if (!scalingSteps.equals(that.scalingSteps)) return false;
            if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.estimatedInstanceWarmup != null ? !this.estimatedInstanceWarmup.equals(that.estimatedInstanceWarmup) : that.estimatedInstanceWarmup != null) return false;
            return this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude == null;
        }

        @Override
        public int hashCode() {
            int result = this.autoScalingGroup.hashCode();
            result = 31 * result + (this.metric.hashCode());
            result = 31 * result + (this.scalingSteps.hashCode());
            result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.hashCode() : 0);
            result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
            return result;
        }
    }
}
