package software.amazon.awscdk.services.autoscaling;

/**
 * Define a scheduled scaling action.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.652Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.ScheduledAction")
public class ScheduledAction extends software.amazon.awscdk.core.Resource {

    protected ScheduledAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ScheduledAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.ScheduledActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.ScheduledAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.ScheduledAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.ScheduledActionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.ScheduledActionProps.Builder();
        }

        /**
         * When to perform this action.
         * <p>
         * Supports cron expressions.
         * <p>
         * For more information about cron expressions, see https://en.wikipedia.org/wiki/Cron.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * 0;8 * * ?;}</pre></blockquote>
         * <p>
         * @return {@code this}
         * @param schedule When to perform this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.autoscaling.Schedule schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The new desired capacity.
         * <p>
         * At the scheduled time, set the desired capacity to the given capacity.
         * <p>
         * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * <p>
         * Default: - No new desired capacity.
         * <p>
         * @return {@code this}
         * @param desiredCapacity The new desired capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(final java.lang.Number desiredCapacity) {
            this.props.desiredCapacity(desiredCapacity);
            return this;
        }

        /**
         * When this scheduled action expires.
         * <p>
         * Default: - The rule never expires.
         * <p>
         * @return {@code this}
         * @param endTime When this scheduled action expires. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endTime(final java.time.Instant endTime) {
            this.props.endTime(endTime);
            return this;
        }

        /**
         * The new maximum capacity.
         * <p>
         * At the scheduled time, set the maximum capacity to the given capacity.
         * <p>
         * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * <p>
         * Default: - No new maximum capacity.
         * <p>
         * @return {@code this}
         * @param maxCapacity The new maximum capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * The new minimum capacity.
         * <p>
         * At the scheduled time, set the minimum capacity to the given capacity.
         * <p>
         * At least one of maxCapacity, minCapacity, or desiredCapacity must be supplied.
         * <p>
         * Default: - No new minimum capacity.
         * <p>
         * @return {@code this}
         * @param minCapacity The new minimum capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(final java.lang.Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        /**
         * When this scheduled action becomes active.
         * <p>
         * Default: - The rule is activate immediately.
         * <p>
         * @return {@code this}
         * @param startTime When this scheduled action becomes active. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(final java.time.Instant startTime) {
            this.props.startTime(startTime);
            return this;
        }

        /**
         * The AutoScalingGroup to apply the scheduled actions to.
         * <p>
         * @return {@code this}
         * @param autoScalingGroup The AutoScalingGroup to apply the scheduled actions to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.props.autoScalingGroup(autoScalingGroup);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.autoscaling.ScheduledAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.ScheduledAction build() {
            return new software.amazon.awscdk.services.autoscaling.ScheduledAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
