package software.amazon.awscdk.services.autoscaling;

/**
 * Additional settings when a rolling update is selected.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.651Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.RollingUpdateConfiguration")
@software.amazon.jsii.Jsii.Proxy(RollingUpdateConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RollingUpdateConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of instances that AWS CloudFormation updates at once.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBatchSize() {
        return null;
    }

    /**
     * The minimum number of instances that must be in service before more instances are replaced.
     * <p>
     * This number affects the speed of the replacement.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinInstancesInService() {
        return null;
    }

    /**
     * The percentage of instances that must signal success for an update to succeed.
     * <p>
     * If an instance doesn't send a signal within the time specified in the
     * pauseTime property, AWS CloudFormation assumes that the instance wasn't
     * updated.
     * <p>
     * This number affects the success of the replacement.
     * <p>
     * If you specify this property, you must also enable the
     * waitOnResourceSignals and pauseTime properties.
     * <p>
     * Default: 100
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSuccessfulInstancesPercent() {
        return null;
    }

    /**
     * The pause time after making a change to a batch of instances.
     * <p>
     * This is intended to give those instances time to start software applications.
     * <p>
     * Specify PauseTime in the ISO8601 duration format (in the format
     * PT#H#M#S, where each # is the number of hours, minutes, and seconds,
     * respectively). The maximum PauseTime is one hour (PT1H).
     * <p>
     * Default: Duration.minutes(5) if the waitOnResourceSignals property is true, otherwise 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getPauseTime() {
        return null;
    }

    /**
     * Specifies the Auto Scaling processes to suspend during a stack update.
     * <p>
     * Suspending processes prevents Auto Scaling from interfering with a stack
     * update.
     * <p>
     * Default: HealthCheck, ReplaceUnhealthy, AZRebalance, AlarmNotification, ScheduledActions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> getSuspendProcesses() {
        return null;
    }

    /**
     * Specifies whether the Auto Scaling group waits on signals from new instances during an update.
     * <p>
     * AWS CloudFormation must receive a signal from each new instance within
     * the specified PauseTime before continuing the update.
     * <p>
     * To have instances wait for an Elastic Load Balancing health check before
     * they signal success, add a health-check verification by using the
     * cfn-init helper script. For an example, see the verify_instance_health
     * command in the Auto Scaling rolling updates sample template.
     * <p>
     * Default: true if you specified the minSuccessfulInstancesPercent property, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWaitOnResourceSignals() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RollingUpdateConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RollingUpdateConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RollingUpdateConfiguration> {
        private java.lang.Number maxBatchSize;
        private java.lang.Number minInstancesInService;
        private java.lang.Number minSuccessfulInstancesPercent;
        private software.amazon.awscdk.core.Duration pauseTime;
        private java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses;
        private java.lang.Boolean waitOnResourceSignals;

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getMaxBatchSize}
         * @param maxBatchSize The maximum number of instances that AWS CloudFormation updates at once.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(java.lang.Number maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getMinInstancesInService}
         * @param minInstancesInService The minimum number of instances that must be in service before more instances are replaced.
         *                              This number affects the speed of the replacement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minInstancesInService(java.lang.Number minInstancesInService) {
            this.minInstancesInService = minInstancesInService;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getMinSuccessfulInstancesPercent}
         * @param minSuccessfulInstancesPercent The percentage of instances that must signal success for an update to succeed.
         *                                      If an instance doesn't send a signal within the time specified in the
         *                                      pauseTime property, AWS CloudFormation assumes that the instance wasn't
         *                                      updated.
         *                                      <p>
         *                                      This number affects the success of the replacement.
         *                                      <p>
         *                                      If you specify this property, you must also enable the
         *                                      waitOnResourceSignals and pauseTime properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSuccessfulInstancesPercent(java.lang.Number minSuccessfulInstancesPercent) {
            this.minSuccessfulInstancesPercent = minSuccessfulInstancesPercent;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getPauseTime}
         * @param pauseTime The pause time after making a change to a batch of instances.
         *                  This is intended to give those instances time to start software applications.
         *                  <p>
         *                  Specify PauseTime in the ISO8601 duration format (in the format
         *                  PT#H#M#S, where each # is the number of hours, minutes, and seconds,
         *                  respectively). The maximum PauseTime is one hour (PT1H).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pauseTime(software.amazon.awscdk.core.Duration pauseTime) {
            this.pauseTime = pauseTime;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getSuspendProcesses}
         * @param suspendProcesses Specifies the Auto Scaling processes to suspend during a stack update.
         *                         Suspending processes prevents Auto Scaling from interfering with a stack
         *                         update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspendProcesses(java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses) {
            this.suspendProcesses = suspendProcesses;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateConfiguration#getWaitOnResourceSignals}
         * @param waitOnResourceSignals Specifies whether the Auto Scaling group waits on signals from new instances during an update.
         *                              AWS CloudFormation must receive a signal from each new instance within
         *                              the specified PauseTime before continuing the update.
         *                              <p>
         *                              To have instances wait for an Elastic Load Balancing health check before
         *                              they signal success, add a health-check verification by using the
         *                              cfn-init helper script. For an example, see the verify_instance_health
         *                              command in the Auto Scaling rolling updates sample template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitOnResourceSignals(java.lang.Boolean waitOnResourceSignals) {
            this.waitOnResourceSignals = waitOnResourceSignals;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RollingUpdateConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RollingUpdateConfiguration build() {
            return new Jsii$Proxy(maxBatchSize, minInstancesInService, minSuccessfulInstancesPercent, pauseTime, suspendProcesses, waitOnResourceSignals);
        }
    }

    /**
     * An implementation for {@link RollingUpdateConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RollingUpdateConfiguration {
        private final java.lang.Number maxBatchSize;
        private final java.lang.Number minInstancesInService;
        private final java.lang.Number minSuccessfulInstancesPercent;
        private final software.amazon.awscdk.core.Duration pauseTime;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses;
        private final java.lang.Boolean waitOnResourceSignals;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxBatchSize = this.jsiiGet("maxBatchSize", java.lang.Number.class);
            this.minInstancesInService = this.jsiiGet("minInstancesInService", java.lang.Number.class);
            this.minSuccessfulInstancesPercent = this.jsiiGet("minSuccessfulInstancesPercent", java.lang.Number.class);
            this.pauseTime = this.jsiiGet("pauseTime", software.amazon.awscdk.core.Duration.class);
            this.suspendProcesses = this.jsiiGet("suspendProcesses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingProcess.class)));
            this.waitOnResourceSignals = this.jsiiGet("waitOnResourceSignals", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number maxBatchSize, final java.lang.Number minInstancesInService, final java.lang.Number minSuccessfulInstancesPercent, final software.amazon.awscdk.core.Duration pauseTime, final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses, final java.lang.Boolean waitOnResourceSignals) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxBatchSize = maxBatchSize;
            this.minInstancesInService = minInstancesInService;
            this.minSuccessfulInstancesPercent = minSuccessfulInstancesPercent;
            this.pauseTime = pauseTime;
            this.suspendProcesses = suspendProcesses;
            this.waitOnResourceSignals = waitOnResourceSignals;
        }

        @Override
        public java.lang.Number getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public java.lang.Number getMinInstancesInService() {
            return this.minInstancesInService;
        }

        @Override
        public java.lang.Number getMinSuccessfulInstancesPercent() {
            return this.minSuccessfulInstancesPercent;
        }

        @Override
        public software.amazon.awscdk.core.Duration getPauseTime() {
            return this.pauseTime;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> getSuspendProcesses() {
            return this.suspendProcesses;
        }

        @Override
        public java.lang.Boolean getWaitOnResourceSignals() {
            return this.waitOnResourceSignals;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxBatchSize() != null) {
                data.set("maxBatchSize", om.valueToTree(this.getMaxBatchSize()));
            }
            if (this.getMinInstancesInService() != null) {
                data.set("minInstancesInService", om.valueToTree(this.getMinInstancesInService()));
            }
            if (this.getMinSuccessfulInstancesPercent() != null) {
                data.set("minSuccessfulInstancesPercent", om.valueToTree(this.getMinSuccessfulInstancesPercent()));
            }
            if (this.getPauseTime() != null) {
                data.set("pauseTime", om.valueToTree(this.getPauseTime()));
            }
            if (this.getSuspendProcesses() != null) {
                data.set("suspendProcesses", om.valueToTree(this.getSuspendProcesses()));
            }
            if (this.getWaitOnResourceSignals() != null) {
                data.set("waitOnResourceSignals", om.valueToTree(this.getWaitOnResourceSignals()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling.RollingUpdateConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RollingUpdateConfiguration.Jsii$Proxy that = (RollingUpdateConfiguration.Jsii$Proxy) o;

            if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) return false;
            if (this.minInstancesInService != null ? !this.minInstancesInService.equals(that.minInstancesInService) : that.minInstancesInService != null) return false;
            if (this.minSuccessfulInstancesPercent != null ? !this.minSuccessfulInstancesPercent.equals(that.minSuccessfulInstancesPercent) : that.minSuccessfulInstancesPercent != null) return false;
            if (this.pauseTime != null ? !this.pauseTime.equals(that.pauseTime) : that.pauseTime != null) return false;
            if (this.suspendProcesses != null ? !this.suspendProcesses.equals(that.suspendProcesses) : that.suspendProcesses != null) return false;
            return this.waitOnResourceSignals != null ? this.waitOnResourceSignals.equals(that.waitOnResourceSignals) : that.waitOnResourceSignals == null;
        }

        @Override
        public int hashCode() {
            int result = this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0;
            result = 31 * result + (this.minInstancesInService != null ? this.minInstancesInService.hashCode() : 0);
            result = 31 * result + (this.minSuccessfulInstancesPercent != null ? this.minSuccessfulInstancesPercent.hashCode() : 0);
            result = 31 * result + (this.pauseTime != null ? this.pauseTime.hashCode() : 0);
            result = 31 * result + (this.suspendProcesses != null ? this.suspendProcesses.hashCode() : 0);
            result = 31 * result + (this.waitOnResourceSignals != null ? this.waitOnResourceSignals.hashCode() : 0);
            return result;
        }
    }
}
