package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for enabling scaling based on request/second.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.651Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.RequestCountScalingProps")
@software.amazon.jsii.Jsii.Proxy(RequestCountScalingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RequestCountScalingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.autoscaling.BaseTargetTrackingProps {

    /**
     * Target average requests/seconds on each instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTargetRequestsPerSecond();

    /**
     * @return a {@link Builder} of {@link RequestCountScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RequestCountScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RequestCountScalingProps> {
        private java.lang.Number targetRequestsPerSecond;
        private software.amazon.awscdk.core.Duration cooldown;
        private java.lang.Boolean disableScaleIn;
        private software.amazon.awscdk.core.Duration estimatedInstanceWarmup;

        /**
         * Sets the value of {@link RequestCountScalingProps#getTargetRequestsPerSecond}
         * @param targetRequestsPerSecond Target average requests/seconds on each instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetRequestsPerSecond(java.lang.Number targetRequestsPerSecond) {
            this.targetRequestsPerSecond = targetRequestsPerSecond;
            return this;
        }

        /**
         * Sets the value of {@link RequestCountScalingProps#getCooldown}
         * @param cooldown Period after a scaling completes before another scaling activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.core.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link RequestCountScalingProps#getDisableScaleIn}
         * @param disableScaleIn Indicates whether scale in by the target tracking policy is disabled.
         *                       If the value is true, scale in is disabled and the target tracking policy
         *                       won't remove capacity from the autoscaling group. Otherwise, scale in is
         *                       enabled and the target tracking policy can remove capacity from the
         *                       group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link RequestCountScalingProps#getEstimatedInstanceWarmup}
         * @param estimatedInstanceWarmup Estimated time until a newly launched instance can send metrics to CloudWatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder estimatedInstanceWarmup(software.amazon.awscdk.core.Duration estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RequestCountScalingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RequestCountScalingProps build() {
            return new Jsii$Proxy(targetRequestsPerSecond, cooldown, disableScaleIn, estimatedInstanceWarmup);
        }
    }

    /**
     * An implementation for {@link RequestCountScalingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestCountScalingProps {
        private final java.lang.Number targetRequestsPerSecond;
        private final software.amazon.awscdk.core.Duration cooldown;
        private final java.lang.Boolean disableScaleIn;
        private final software.amazon.awscdk.core.Duration estimatedInstanceWarmup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetRequestsPerSecond = this.jsiiGet("targetRequestsPerSecond", java.lang.Number.class);
            this.cooldown = this.jsiiGet("cooldown", software.amazon.awscdk.core.Duration.class);
            this.disableScaleIn = this.jsiiGet("disableScaleIn", java.lang.Boolean.class);
            this.estimatedInstanceWarmup = this.jsiiGet("estimatedInstanceWarmup", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number targetRequestsPerSecond, final software.amazon.awscdk.core.Duration cooldown, final java.lang.Boolean disableScaleIn, final software.amazon.awscdk.core.Duration estimatedInstanceWarmup) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetRequestsPerSecond = java.util.Objects.requireNonNull(targetRequestsPerSecond, "targetRequestsPerSecond is required");
            this.cooldown = cooldown;
            this.disableScaleIn = disableScaleIn;
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        @Override
        public java.lang.Number getTargetRequestsPerSecond() {
            return this.targetRequestsPerSecond;
        }

        @Override
        public software.amazon.awscdk.core.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public java.lang.Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public software.amazon.awscdk.core.Duration getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetRequestsPerSecond", om.valueToTree(this.getTargetRequestsPerSecond()));
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getDisableScaleIn() != null) {
                data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
            }
            if (this.getEstimatedInstanceWarmup() != null) {
                data.set("estimatedInstanceWarmup", om.valueToTree(this.getEstimatedInstanceWarmup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling.RequestCountScalingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RequestCountScalingProps.Jsii$Proxy that = (RequestCountScalingProps.Jsii$Proxy) o;

            if (!targetRequestsPerSecond.equals(that.targetRequestsPerSecond)) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
            return this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.equals(that.estimatedInstanceWarmup) : that.estimatedInstanceWarmup == null;
        }

        @Override
        public int hashCode() {
            int result = this.targetRequestsPerSecond.hashCode();
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
            result = 31 * result + (this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.hashCode() : 0);
            return result;
        }
    }
}
