package software.amazon.awscdk.services.autoscaling;

/**
 * An AutoScalingGroup.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.648Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.IAutoScalingGroup")
@software.amazon.jsii.Jsii.Proxy(IAutoScalingGroup.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IAutoScalingGroup extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource, software.amazon.awscdk.services.iam.IGrantable {

    /**
     * The arn of the AutoScalingGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupArn();

    /**
     * The name of the AutoScalingGroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName();

    /**
     * The operating system family that the instances in this auto-scaling group belong to.
     * <p>
     * Is 'UNKNOWN' for imported ASGs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType getOsType();

    /**
     * Send a message to either an SQS queue or SNS topic when instances launch or terminate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHook addLifecycleHook(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps props);

    /**
     * Add command to the startup script of fleet instances.
     * <p>
     * The command must be in the scripting language supported by the fleet's OS (i.e. Linux/Windows).
     * Does nothing for imported ASGs.
     * <p>
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addUserData(final @org.jetbrains.annotations.NotNull java.lang.String... commands);

    /**
     * Scale out or in to achieve a target CPU utilization.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnCpuUtilization(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.CpuUtilizationScalingProps props);

    /**
     * Scale out or in to achieve a target network ingress rate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnIncomingBytes(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps props);

    /**
     * Scale out or in, in response to a metric.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.StepScalingPolicy scaleOnMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicStepScalingPolicyProps props);

    /**
     * Scale out or in to achieve a target network egress rate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnOutgoingBytes(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps props);

    /**
     * Scale out or in based on time.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.ScheduledAction scaleOnSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicScheduledActionProps props);

    /**
     * Scale out or in in order to keep a metric around a target value.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleToTrackMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.MetricTargetTrackingProps props);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.autoscaling.IAutoScalingGroup {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The arn of the AutoScalingGroup.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupArn() {
            return this.jsiiGet("autoScalingGroupArn", java.lang.String.class);
        }

        /**
         * The name of the AutoScalingGroup.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName() {
            return this.jsiiGet("autoScalingGroupName", java.lang.String.class);
        }

        /**
         * The operating system family that the instances in this auto-scaling group belong to.
         * <p>
         * Is 'UNKNOWN' for imported ASGs.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
            return this.jsiiGet("osType", software.amazon.awscdk.services.ec2.OperatingSystemType.class);
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return this.jsiiGet("env", software.amazon.awscdk.core.ResourceEnvironment.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
        }

        /**
         * Send a message to either an SQS queue or SNS topic when instances launch or terminate.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHook addLifecycleHook(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps props) {
            return this.jsiiCall("addLifecycleHook", software.amazon.awscdk.services.autoscaling.LifecycleHook.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Add command to the startup script of fleet instances.
         * <p>
         * The command must be in the scripting language supported by the fleet's OS (i.e. Linux/Windows).
         * Does nothing for imported ASGs.
         * <p>
         * @param commands This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addUserData(final @org.jetbrains.annotations.NotNull java.lang.String... commands) {
            this.jsiiCall("addUserData", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(commands).toArray(Object[]::new));
        }

        /**
         * Scale out or in to achieve a target CPU utilization.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnCpuUtilization(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.CpuUtilizationScalingProps props) {
            return this.jsiiCall("scaleOnCpuUtilization", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Scale out or in to achieve a target network ingress rate.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnIncomingBytes(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps props) {
            return this.jsiiCall("scaleOnIncomingBytes", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Scale out or in, in response to a metric.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.StepScalingPolicy scaleOnMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicStepScalingPolicyProps props) {
            return this.jsiiCall("scaleOnMetric", software.amazon.awscdk.services.autoscaling.StepScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Scale out or in to achieve a target network egress rate.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnOutgoingBytes(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps props) {
            return this.jsiiCall("scaleOnOutgoingBytes", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Scale out or in based on time.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.ScheduledAction scaleOnSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicScheduledActionProps props) {
            return this.jsiiCall("scaleOnSchedule", software.amazon.awscdk.services.autoscaling.ScheduledAction.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }

        /**
         * Scale out or in in order to keep a metric around a target value.
         * <p>
         * @param id This parameter is required.
         * @param props This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleToTrackMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.MetricTargetTrackingProps props) {
            return this.jsiiCall("scaleToTrackMetric", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
        }
    }
}
