package software.amazon.awscdk.services.autoscaling;

/**
 * Basic properties of an AutoScalingGroup, except the exact machines to run and where they should run.
 * <p>
 * Constructs that want to create AutoScalingGroups can inherit
 * this interface and specialize the essential parts in various ways.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.645Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.CommonAutoScalingGroupProps")
@software.amazon.jsii.Jsii.Proxy(CommonAutoScalingGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonAutoScalingGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the instances can initiate connections to anywhere by default.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
     * <p>
     * Default: - Use subnet setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssociatePublicIpAddress() {
        return null;
    }

    /**
     * The name of the Auto Scaling group.
     * <p>
     * This name must be unique per Region per account.
     * <p>
     * Default: - Auto generated by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingGroupName() {
        return null;
    }

    /**
     * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     * <p>
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     * <p>
     * Default: - Uses the block device mapping of the AMI
     * <p>
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> getBlockDevices() {
        return null;
    }

    /**
     * Default scaling cooldown for this AutoScalingGroup.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getCooldown() {
        return null;
    }

    /**
     * Initial amount of instances in the fleet.
     * <p>
     * If this is set to a number, every deployment will reset the amount of
     * instances to this number. It is recommended to leave this value blank.
     * <p>
     * Default: minCapacity, and leave unchanged during deployment
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCapacity() {
        return null;
    }

    /**
     * Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
     * <p>
     * To report all group metrics use <code>GroupMetrics.all()</code>
     * Group metrics are reported in a granularity of 1 minute at no additional charge.
     * <p>
     * Default: - no group metrics will be reported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> getGroupMetrics() {
        return null;
    }

    /**
     * Configuration for health checks.
     * <p>
     * Default: - HealthCheck.ec2 with no grace period
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * If the ASG has scheduled actions, don't reset unchanged group sizes.
     * <p>
     * Only used if the ASG has scheduled actions (which may scale your ASG up
     * or down regardless of cdk deployments). If true, the size of the group
     * will only be reset if it has been changed in the CDK app. If false, the
     * sizes will always be changed back to what they were in the CDK app
     * on deployment.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreUnmodifiedSizeProperties() {
        return null;
    }

    /**
     * Controls whether instances in this group are launched with detailed or basic monitoring.
     * <p>
     * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
     * is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
     * <p>
     * Default: - Monitoring.DETAILED
     * <p>
     * @see https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.Monitoring getInstanceMonitoring() {
        return null;
    }

    /**
     * Name of SSH keypair to grant access to instances.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * Maximum number of instances in the fleet.
     * <p>
     * Default: desiredCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * The maximum amount of time that an instance can be in service.
     * <p>
     * The maximum duration applies
     * to all current and future instances in the group. As an instance approaches its maximum duration,
     * it is terminated and replaced, and cannot be used again.
     * <p>
     * You must specify a value of at least 604,800 seconds (7 days). To clear a previously set value,
     * leave this property undefined.
     * <p>
     * Default: none
     * <p>
     * @see https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxInstanceLifetime() {
        return null;
    }

    /**
     * Minimum number of instances in the fleet.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
        return null;
    }

    /**
     * Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
     * <p>
     * Default: - No fleet change notifications will be sent.
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> getNotifications() {
        return null;
    }

    /**
     * SNS topic to send notifications about fleet changes.
     * <p>
     * Default: - No fleet change notifications will be sent.
     * <p>
     * @deprecated use `notifications`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getNotificationsTopic() {
        return null;
    }

    /**
     * Configuration for replacing updates.
     * <p>
     * Only used if updateType == UpdateType.ReplacingUpdate. Specifies how
     * many instances must signal success for the update to succeed.
     * <p>
     * Default: minSuccessfulInstancesPercent
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReplacingUpdateMinSuccessfulInstancesPercent() {
        return null;
    }

    /**
     * How many ResourceSignal calls CloudFormation expects before the resource is considered created.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getResourceSignalCount() {
        return null;
    }

    /**
     * The length of time to wait for the resourceSignalCount.
     * <p>
     * The maximum value is 43200 (12 hours).
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getResourceSignalTimeout() {
        return null;
    }

    /**
     * Configuration for rolling updates.
     * <p>
     * Only used if updateType == UpdateType.RollingUpdate.
     * <p>
     * Default: - RollingUpdateConfiguration with defaults.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration getRollingUpdateConfiguration() {
        return null;
    }

    /**
     * The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
     * <p>
     * Spot Instances are
     * launched when the price you specify exceeds the current Spot market price.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
        return null;
    }

    /**
     * What to do when an AutoScalingGroup's instance configuration is changed.
     * <p>
     * This is applied when any of the settings on the ASG are changed that
     * affect how the instances should be created (VPC, instance type, startup
     * scripts, etc.). It indicates how the existing instances should be
     * replaced with new instances matching the new config. By default, nothing
     * is done and only new instances are launched with the new config.
     * <p>
     * Default: UpdateType.None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.UpdateType getUpdateType() {
        return null;
    }

    /**
     * Where to place instances within the VPC.
     * <p>
     * Default: - All Private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonAutoScalingGroupProps> {
        private java.lang.Boolean allowAllOutbound;
        private java.lang.Boolean associatePublicIpAddress;
        private java.lang.String autoScalingGroupName;
        private java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices;
        private software.amazon.awscdk.core.Duration cooldown;
        private java.lang.Number desiredCapacity;
        private java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics;
        private software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck;
        private java.lang.Boolean ignoreUnmodifiedSizeProperties;
        private software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring;
        private java.lang.String keyName;
        private java.lang.Number maxCapacity;
        private software.amazon.awscdk.core.Duration maxInstanceLifetime;
        private java.lang.Number minCapacity;
        private java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications;
        private software.amazon.awscdk.services.sns.ITopic notificationsTopic;
        private java.lang.Number replacingUpdateMinSuccessfulInstancesPercent;
        private java.lang.Number resourceSignalCount;
        private software.amazon.awscdk.core.Duration resourceSignalTimeout;
        private software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration rollingUpdateConfiguration;
        private java.lang.String spotPrice;
        private software.amazon.awscdk.services.autoscaling.UpdateType updateType;
        private software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether the instances can initiate connections to anywhere by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getAutoScalingGroupName}
         * @param autoScalingGroupName The name of the Auto Scaling group.
         *                             This name must be unique per Region per account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDevices(java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getCooldown}
         * @param cooldown Default scaling cooldown for this AutoScalingGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.core.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getDesiredCapacity}
         * @param desiredCapacity Initial amount of instances in the fleet.
         *                        If this is set to a number, every deployment will reset the amount of
         *                        instances to this number. It is recommended to leave this value blank.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(java.lang.Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getGroupMetrics}
         * @param groupMetrics Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
         *                     To report all group metrics use <code>GroupMetrics.all()</code>
         *                     Group metrics are reported in a granularity of 1 minute at no additional charge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupMetrics(java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics) {
            this.groupMetrics = groupMetrics;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getHealthCheck}
         * @param healthCheck Configuration for health checks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getIgnoreUnmodifiedSizeProperties}
         * @param ignoreUnmodifiedSizeProperties If the ASG has scheduled actions, don't reset unchanged group sizes.
         *                                       Only used if the ASG has scheduled actions (which may scale your ASG up
         *                                       or down regardless of cdk deployments). If true, the size of the group
         *                                       will only be reset if it has been changed in the CDK app. If false, the
         *                                       sizes will always be changed back to what they were in the CDK app
         *                                       on deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreUnmodifiedSizeProperties(java.lang.Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getInstanceMonitoring}
         * @param instanceMonitoring Controls whether instances in this group are launched with detailed or basic monitoring.
         *                           When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
         *                           is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMaxCapacity}
         * @param maxCapacity Maximum number of instances in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMaxInstanceLifetime}
         * @param maxInstanceLifetime The maximum amount of time that an instance can be in service.
         *                            The maximum duration applies
         *                            to all current and future instances in the group. As an instance approaches its maximum duration,
         *                            it is terminated and replaced, and cannot be used again.
         *                            <p>
         *                            You must specify a value of at least 604,800 seconds (7 days). To clear a previously set value,
         *                            leave this property undefined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInstanceLifetime(software.amazon.awscdk.core.Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getMinCapacity}
         * @param minCapacity Minimum number of instances in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getNotifications}
         * @param notifications Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications) {
            this.notifications = notifications;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getNotificationsTopic}
         * @param notificationsTopic SNS topic to send notifications about fleet changes.
         * @return {@code this}
         * @deprecated use `notifications`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder notificationsTopic(software.amazon.awscdk.services.sns.ITopic notificationsTopic) {
            this.notificationsTopic = notificationsTopic;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getReplacingUpdateMinSuccessfulInstancesPercent}
         * @param replacingUpdateMinSuccessfulInstancesPercent Configuration for replacing updates.
         *                                                     Only used if updateType == UpdateType.ReplacingUpdate. Specifies how
         *                                                     many instances must signal success for the update to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replacingUpdateMinSuccessfulInstancesPercent(java.lang.Number replacingUpdateMinSuccessfulInstancesPercent) {
            this.replacingUpdateMinSuccessfulInstancesPercent = replacingUpdateMinSuccessfulInstancesPercent;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getResourceSignalCount}
         * @param resourceSignalCount How many ResourceSignal calls CloudFormation expects before the resource is considered created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalCount(java.lang.Number resourceSignalCount) {
            this.resourceSignalCount = resourceSignalCount;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getResourceSignalTimeout}
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount.
         *                              The maximum value is 43200 (12 hours).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalTimeout(software.amazon.awscdk.core.Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getRollingUpdateConfiguration}
         * @param rollingUpdateConfiguration Configuration for rolling updates.
         *                                   Only used if updateType == UpdateType.RollingUpdate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rollingUpdateConfiguration(software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration rollingUpdateConfiguration) {
            this.rollingUpdateConfiguration = rollingUpdateConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getSpotPrice}
         * @param spotPrice The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
         *                  Spot Instances are
         *                  launched when the price you specify exceeds the current Spot market price.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotPrice(java.lang.String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getUpdateType}
         * @param updateType What to do when an AutoScalingGroup's instance configuration is changed.
         *                   This is applied when any of the settings on the ASG are changed that
         *                   affect how the instances should be created (VPC, instance type, startup
         *                   scripts, etc.). It indicates how the existing instances should be
         *                   replaced with new instances matching the new config. By default, nothing
         *                   is done and only new instances are launched with the new config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateType(software.amazon.awscdk.services.autoscaling.UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        /**
         * Sets the value of {@link CommonAutoScalingGroupProps#getVpcSubnets}
         * @param vpcSubnets Where to place instances within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonAutoScalingGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonAutoScalingGroupProps build() {
            return new Jsii$Proxy(allowAllOutbound, associatePublicIpAddress, autoScalingGroupName, blockDevices, cooldown, desiredCapacity, groupMetrics, healthCheck, ignoreUnmodifiedSizeProperties, instanceMonitoring, keyName, maxCapacity, maxInstanceLifetime, minCapacity, notifications, notificationsTopic, replacingUpdateMinSuccessfulInstancesPercent, resourceSignalCount, resourceSignalTimeout, rollingUpdateConfiguration, spotPrice, updateType, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link CommonAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonAutoScalingGroupProps {
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean associatePublicIpAddress;
        private final java.lang.String autoScalingGroupName;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices;
        private final software.amazon.awscdk.core.Duration cooldown;
        private final java.lang.Number desiredCapacity;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics;
        private final software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck;
        private final java.lang.Boolean ignoreUnmodifiedSizeProperties;
        private final software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring;
        private final java.lang.String keyName;
        private final java.lang.Number maxCapacity;
        private final software.amazon.awscdk.core.Duration maxInstanceLifetime;
        private final java.lang.Number minCapacity;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications;
        private final software.amazon.awscdk.services.sns.ITopic notificationsTopic;
        private final java.lang.Number replacingUpdateMinSuccessfulInstancesPercent;
        private final java.lang.Number resourceSignalCount;
        private final software.amazon.awscdk.core.Duration resourceSignalTimeout;
        private final software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration rollingUpdateConfiguration;
        private final java.lang.String spotPrice;
        private final software.amazon.awscdk.services.autoscaling.UpdateType updateType;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowAllOutbound = this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
            this.associatePublicIpAddress = this.jsiiGet("associatePublicIpAddress", java.lang.Boolean.class);
            this.autoScalingGroupName = this.jsiiGet("autoScalingGroupName", java.lang.String.class);
            this.blockDevices = this.jsiiGet("blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDevice.class)));
            this.cooldown = this.jsiiGet("cooldown", software.amazon.awscdk.core.Duration.class);
            this.desiredCapacity = this.jsiiGet("desiredCapacity", java.lang.Number.class);
            this.groupMetrics = this.jsiiGet("groupMetrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.GroupMetrics.class)));
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.autoscaling.HealthCheck.class);
            this.ignoreUnmodifiedSizeProperties = this.jsiiGet("ignoreUnmodifiedSizeProperties", java.lang.Boolean.class);
            this.instanceMonitoring = this.jsiiGet("instanceMonitoring", software.amazon.awscdk.services.autoscaling.Monitoring.class);
            this.keyName = this.jsiiGet("keyName", java.lang.String.class);
            this.maxCapacity = this.jsiiGet("maxCapacity", java.lang.Number.class);
            this.maxInstanceLifetime = this.jsiiGet("maxInstanceLifetime", software.amazon.awscdk.core.Duration.class);
            this.minCapacity = this.jsiiGet("minCapacity", java.lang.Number.class);
            this.notifications = this.jsiiGet("notifications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.NotificationConfiguration.class)));
            this.notificationsTopic = this.jsiiGet("notificationsTopic", software.amazon.awscdk.services.sns.ITopic.class);
            this.replacingUpdateMinSuccessfulInstancesPercent = this.jsiiGet("replacingUpdateMinSuccessfulInstancesPercent", java.lang.Number.class);
            this.resourceSignalCount = this.jsiiGet("resourceSignalCount", java.lang.Number.class);
            this.resourceSignalTimeout = this.jsiiGet("resourceSignalTimeout", software.amazon.awscdk.core.Duration.class);
            this.rollingUpdateConfiguration = this.jsiiGet("rollingUpdateConfiguration", software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration.class);
            this.spotPrice = this.jsiiGet("spotPrice", java.lang.String.class);
            this.updateType = this.jsiiGet("updateType", software.amazon.awscdk.services.autoscaling.UpdateType.class);
            this.vpcSubnets = this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean allowAllOutbound, final java.lang.Boolean associatePublicIpAddress, final java.lang.String autoScalingGroupName, final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices, final software.amazon.awscdk.core.Duration cooldown, final java.lang.Number desiredCapacity, final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics, final software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck, final java.lang.Boolean ignoreUnmodifiedSizeProperties, final software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring, final java.lang.String keyName, final java.lang.Number maxCapacity, final software.amazon.awscdk.core.Duration maxInstanceLifetime, final java.lang.Number minCapacity, final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications, final software.amazon.awscdk.services.sns.ITopic notificationsTopic, final java.lang.Number replacingUpdateMinSuccessfulInstancesPercent, final java.lang.Number resourceSignalCount, final software.amazon.awscdk.core.Duration resourceSignalTimeout, final software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration rollingUpdateConfiguration, final java.lang.String spotPrice, final software.amazon.awscdk.services.autoscaling.UpdateType updateType, final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowAllOutbound = allowAllOutbound;
            this.associatePublicIpAddress = associatePublicIpAddress;
            this.autoScalingGroupName = autoScalingGroupName;
            this.blockDevices = blockDevices;
            this.cooldown = cooldown;
            this.desiredCapacity = desiredCapacity;
            this.groupMetrics = groupMetrics;
            this.healthCheck = healthCheck;
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            this.instanceMonitoring = instanceMonitoring;
            this.keyName = keyName;
            this.maxCapacity = maxCapacity;
            this.maxInstanceLifetime = maxInstanceLifetime;
            this.minCapacity = minCapacity;
            this.notifications = notifications;
            this.notificationsTopic = notificationsTopic;
            this.replacingUpdateMinSuccessfulInstancesPercent = replacingUpdateMinSuccessfulInstancesPercent;
            this.resourceSignalCount = resourceSignalCount;
            this.resourceSignalTimeout = resourceSignalTimeout;
            this.rollingUpdateConfiguration = rollingUpdateConfiguration;
            this.spotPrice = spotPrice;
            this.updateType = updateType;
            this.vpcSubnets = vpcSubnets;
        }

        @Override
        public java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public java.lang.Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public software.amazon.awscdk.core.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public java.lang.Number getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> getGroupMetrics() {
            return this.groupMetrics;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.Boolean getIgnoreUnmodifiedSizeProperties() {
            return this.ignoreUnmodifiedSizeProperties;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.Monitoring getInstanceMonitoring() {
            return this.instanceMonitoring;
        }

        @Override
        public java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxInstanceLifetime() {
            return this.maxInstanceLifetime;
        }

        @Override
        public java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> getNotifications() {
            return this.notifications;
        }

        @Override
        public software.amazon.awscdk.services.sns.ITopic getNotificationsTopic() {
            return this.notificationsTopic;
        }

        @Override
        public java.lang.Number getReplacingUpdateMinSuccessfulInstancesPercent() {
            return this.replacingUpdateMinSuccessfulInstancesPercent;
        }

        @Override
        public java.lang.Number getResourceSignalCount() {
            return this.resourceSignalCount;
        }

        @Override
        public software.amazon.awscdk.core.Duration getResourceSignalTimeout() {
            return this.resourceSignalTimeout;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration getRollingUpdateConfiguration() {
            return this.rollingUpdateConfiguration;
        }

        @Override
        public java.lang.String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.UpdateType getUpdateType() {
            return this.updateType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getAutoScalingGroupName() != null) {
                data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            }
            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getDesiredCapacity() != null) {
                data.set("desiredCapacity", om.valueToTree(this.getDesiredCapacity()));
            }
            if (this.getGroupMetrics() != null) {
                data.set("groupMetrics", om.valueToTree(this.getGroupMetrics()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getIgnoreUnmodifiedSizeProperties() != null) {
                data.set("ignoreUnmodifiedSizeProperties", om.valueToTree(this.getIgnoreUnmodifiedSizeProperties()));
            }
            if (this.getInstanceMonitoring() != null) {
                data.set("instanceMonitoring", om.valueToTree(this.getInstanceMonitoring()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMaxInstanceLifetime() != null) {
                data.set("maxInstanceLifetime", om.valueToTree(this.getMaxInstanceLifetime()));
            }
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }
            if (this.getNotifications() != null) {
                data.set("notifications", om.valueToTree(this.getNotifications()));
            }
            if (this.getNotificationsTopic() != null) {
                data.set("notificationsTopic", om.valueToTree(this.getNotificationsTopic()));
            }
            if (this.getReplacingUpdateMinSuccessfulInstancesPercent() != null) {
                data.set("replacingUpdateMinSuccessfulInstancesPercent", om.valueToTree(this.getReplacingUpdateMinSuccessfulInstancesPercent()));
            }
            if (this.getResourceSignalCount() != null) {
                data.set("resourceSignalCount", om.valueToTree(this.getResourceSignalCount()));
            }
            if (this.getResourceSignalTimeout() != null) {
                data.set("resourceSignalTimeout", om.valueToTree(this.getResourceSignalTimeout()));
            }
            if (this.getRollingUpdateConfiguration() != null) {
                data.set("rollingUpdateConfiguration", om.valueToTree(this.getRollingUpdateConfiguration()));
            }
            if (this.getSpotPrice() != null) {
                data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
            }
            if (this.getUpdateType() != null) {
                data.set("updateType", om.valueToTree(this.getUpdateType()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling.CommonAutoScalingGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonAutoScalingGroupProps.Jsii$Proxy that = (CommonAutoScalingGroupProps.Jsii$Proxy) o;

            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.autoScalingGroupName != null ? !this.autoScalingGroupName.equals(that.autoScalingGroupName) : that.autoScalingGroupName != null) return false;
            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.desiredCapacity != null ? !this.desiredCapacity.equals(that.desiredCapacity) : that.desiredCapacity != null) return false;
            if (this.groupMetrics != null ? !this.groupMetrics.equals(that.groupMetrics) : that.groupMetrics != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.ignoreUnmodifiedSizeProperties != null ? !this.ignoreUnmodifiedSizeProperties.equals(that.ignoreUnmodifiedSizeProperties) : that.ignoreUnmodifiedSizeProperties != null) return false;
            if (this.instanceMonitoring != null ? !this.instanceMonitoring.equals(that.instanceMonitoring) : that.instanceMonitoring != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.maxInstanceLifetime != null ? !this.maxInstanceLifetime.equals(that.maxInstanceLifetime) : that.maxInstanceLifetime != null) return false;
            if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
            if (this.notifications != null ? !this.notifications.equals(that.notifications) : that.notifications != null) return false;
            if (this.notificationsTopic != null ? !this.notificationsTopic.equals(that.notificationsTopic) : that.notificationsTopic != null) return false;
            if (this.replacingUpdateMinSuccessfulInstancesPercent != null ? !this.replacingUpdateMinSuccessfulInstancesPercent.equals(that.replacingUpdateMinSuccessfulInstancesPercent) : that.replacingUpdateMinSuccessfulInstancesPercent != null) return false;
            if (this.resourceSignalCount != null ? !this.resourceSignalCount.equals(that.resourceSignalCount) : that.resourceSignalCount != null) return false;
            if (this.resourceSignalTimeout != null ? !this.resourceSignalTimeout.equals(that.resourceSignalTimeout) : that.resourceSignalTimeout != null) return false;
            if (this.rollingUpdateConfiguration != null ? !this.rollingUpdateConfiguration.equals(that.rollingUpdateConfiguration) : that.rollingUpdateConfiguration != null) return false;
            if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
            if (this.updateType != null ? !this.updateType.equals(that.updateType) : that.updateType != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0;
            result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
            result = 31 * result + (this.autoScalingGroupName != null ? this.autoScalingGroupName.hashCode() : 0);
            result = 31 * result + (this.blockDevices != null ? this.blockDevices.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.desiredCapacity != null ? this.desiredCapacity.hashCode() : 0);
            result = 31 * result + (this.groupMetrics != null ? this.groupMetrics.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.ignoreUnmodifiedSizeProperties != null ? this.ignoreUnmodifiedSizeProperties.hashCode() : 0);
            result = 31 * result + (this.instanceMonitoring != null ? this.instanceMonitoring.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.maxInstanceLifetime != null ? this.maxInstanceLifetime.hashCode() : 0);
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            result = 31 * result + (this.notifications != null ? this.notifications.hashCode() : 0);
            result = 31 * result + (this.notificationsTopic != null ? this.notificationsTopic.hashCode() : 0);
            result = 31 * result + (this.replacingUpdateMinSuccessfulInstancesPercent != null ? this.replacingUpdateMinSuccessfulInstancesPercent.hashCode() : 0);
            result = 31 * result + (this.resourceSignalCount != null ? this.resourceSignalCount.hashCode() : 0);
            result = 31 * result + (this.resourceSignalTimeout != null ? this.resourceSignalTimeout.hashCode() : 0);
            result = 31 * result + (this.rollingUpdateConfiguration != null ? this.rollingUpdateConfiguration.hashCode() : 0);
            result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            result = 31 * result + (this.updateType != null ? this.updateType.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
