package software.amazon.awscdk.services.autoscaling;

/**
 * A CloudFormation `AWS::AutoScaling::LaunchConfiguration`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.630Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.CfnLaunchConfiguration")
public class CfnLaunchConfiguration extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnLaunchConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunchConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::AutoScaling::LaunchConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLaunchConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.CfnLaunchConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.ImageId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-imageid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
        return this.jsiiGet("imageId", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.ImageId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-imageid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("imageId", java.util.Objects.requireNonNull(value, "imageId is required"));
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceType() {
        return this.jsiiGet("instanceType", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
        return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatePublicIpAddress(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("associatePublicIpAddress", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatePublicIpAddress(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("associatePublicIpAddress", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
        return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlockDeviceMappings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("blockDeviceMappings", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlockDeviceMappings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("blockDeviceMappings", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClassicLinkVpcId() {
        return this.jsiiGet("classicLinkVpcId", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClassicLinkVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("classicLinkVpcId", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCSecurityGroups`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcsecuritygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClassicLinkVpcSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("classicLinkVpcSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCSecurityGroups`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcsecuritygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClassicLinkVpcSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("classicLinkVpcSecurityGroups", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
        return this.jsiiGet("ebsOptimized", java.lang.Object.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptimized(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("ebsOptimized", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptimized(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ebsOptimized", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.IamInstanceProfile`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-iaminstanceprofile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIamInstanceProfile() {
        return this.jsiiGet("iamInstanceProfile", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.IamInstanceProfile`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-iaminstanceprofile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamInstanceProfile(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("iamInstanceProfile", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return this.jsiiGet("instanceId", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("instanceId", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceMonitoring() {
        return this.jsiiGet("instanceMonitoring", java.lang.Object.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceMonitoring(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("instanceMonitoring", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceMonitoring(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("instanceMonitoring", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.KernelId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-kernelid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKernelId() {
        return this.jsiiGet("kernelId", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.KernelId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-kernelid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKernelId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("kernelId", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.KeyName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-keyname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return this.jsiiGet("keyName", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.KeyName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-keyname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("keyName", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.LaunchConfigurationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-autoscaling-launchconfig-launchconfigurationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchConfigurationName() {
        return this.jsiiGet("launchConfigurationName", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.LaunchConfigurationName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-autoscaling-launchconfig-launchconfigurationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchConfigurationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("launchConfigurationName", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.PlacementTenancy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-placementtenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlacementTenancy() {
        return this.jsiiGet("placementTenancy", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.PlacementTenancy`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-placementtenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementTenancy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("placementTenancy", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.RamDiskId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ramdiskid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRamDiskId() {
        return this.jsiiGet("ramDiskId", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.RamDiskId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ramdiskid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRamDiskId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("ramDiskId", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.SecurityGroups`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.SecurityGroups`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroups", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.SpotPrice`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-spotprice
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
        return this.jsiiGet("spotPrice", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.SpotPrice`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-spotprice
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpotPrice(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("spotPrice", value);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.UserData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-userdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
        return this.jsiiGet("userData", java.lang.String.class);
    }

    /**
     * `AWS::AutoScaling::LaunchConfiguration.UserData`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-userdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserData(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("userData", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.CfnLaunchConfiguration.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockDeviceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.DeviceName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-devicename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeviceName();

        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.Ebs`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-ebs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbs() {
            return null;
        }

        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.NoDevice`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-nodevice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoDevice() {
            return null;
        }

        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.VirtualName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-virtualname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVirtualName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            private java.lang.String deviceName;
            private java.lang.Object ebs;
            private java.lang.Object noDevice;
            private java.lang.String virtualName;

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getDeviceName}
             * @param deviceName `CfnLaunchConfiguration.BlockDeviceMappingProperty.DeviceName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceName(java.lang.String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs `CfnLaunchConfiguration.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.core.IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getEbs}
             * @param ebs `CfnLaunchConfiguration.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebs(software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration.BlockDeviceProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getNoDevice}
             * @param noDevice `CfnLaunchConfiguration.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(java.lang.Boolean noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getNoDevice}
             * @param noDevice `CfnLaunchConfiguration.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noDevice(software.amazon.awscdk.core.IResolvable noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceMappingProperty#getVirtualName}
             * @param virtualName `CfnLaunchConfiguration.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualName(java.lang.String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockDeviceMappingProperty build() {
                return new Jsii$Proxy(deviceName, ebs, noDevice, virtualName);
            }
        }

        /**
         * An implementation for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceMappingProperty {
            private final java.lang.String deviceName;
            private final java.lang.Object ebs;
            private final java.lang.Object noDevice;
            private final java.lang.String virtualName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceName = this.jsiiGet("deviceName", java.lang.String.class);
                this.ebs = this.jsiiGet("ebs", java.lang.Object.class);
                this.noDevice = this.jsiiGet("noDevice", java.lang.Object.class);
                this.virtualName = this.jsiiGet("virtualName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String deviceName, final java.lang.Object ebs, final java.lang.Object noDevice, final java.lang.String virtualName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceName = java.util.Objects.requireNonNull(deviceName, "deviceName is required");
                this.ebs = ebs;
                this.noDevice = noDevice;
                this.virtualName = virtualName;
            }

            @Override
            public java.lang.String getDeviceName() {
                return this.deviceName;
            }

            @Override
            public java.lang.Object getEbs() {
                return this.ebs;
            }

            @Override
            public java.lang.Object getNoDevice() {
                return this.noDevice;
            }

            @Override
            public java.lang.String getVirtualName() {
                return this.virtualName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deviceName", om.valueToTree(this.getDeviceName()));
                if (this.getEbs() != null) {
                    data.set("ebs", om.valueToTree(this.getEbs()));
                }
                if (this.getNoDevice() != null) {
                    data.set("noDevice", om.valueToTree(this.getNoDevice()));
                }
                if (this.getVirtualName() != null) {
                    data.set("virtualName", om.valueToTree(this.getVirtualName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling.CfnLaunchConfiguration.BlockDeviceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceMappingProperty.Jsii$Proxy that = (BlockDeviceMappingProperty.Jsii$Proxy) o;

                if (!deviceName.equals(that.deviceName)) return false;
                if (this.ebs != null ? !this.ebs.equals(that.ebs) : that.ebs != null) return false;
                if (this.noDevice != null ? !this.noDevice.equals(that.noDevice) : that.noDevice != null) return false;
                return this.virtualName != null ? this.virtualName.equals(that.virtualName) : that.virtualName == null;
            }

            @Override
            public int hashCode() {
                int result = this.deviceName.hashCode();
                result = 31 * result + (this.ebs != null ? this.ebs.hashCode() : 0);
                result = 31 * result + (this.noDevice != null ? this.noDevice.hashCode() : 0);
                result = 31 * result + (this.virtualName != null ? this.virtualName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.CfnLaunchConfiguration.BlockDeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockDeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockDeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.DeleteOnTermination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-deleteonterm
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteOnTermination() {
            return null;
        }

        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.Encrypted`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-encrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.Iops`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.SnapshotId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-snapshotid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.VolumeSize`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.VolumeType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockDeviceProperty> {
            private java.lang.Object deleteOnTermination;
            private java.lang.Object encrypted;
            private java.lang.Number iops;
            private java.lang.String snapshotId;
            private java.lang.Number volumeSize;
            private java.lang.String volumeType;

            /**
             * Sets the value of {@link BlockDeviceProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnLaunchConfiguration.BlockDeviceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceProperty#getDeleteOnTermination}
             * @param deleteOnTermination `CfnLaunchConfiguration.BlockDeviceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteOnTermination(software.amazon.awscdk.core.IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceProperty#getEncrypted}
             * @param encrypted `CfnLaunchConfiguration.BlockDeviceProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceProperty#getEncrypted}
             * @param encrypted `CfnLaunchConfiguration.BlockDeviceProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.core.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceProperty#getIops}
             * @param iops `CfnLaunchConfiguration.BlockDeviceProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceProperty#getSnapshotId}
             * @param snapshotId `CfnLaunchConfiguration.BlockDeviceProperty.SnapshotId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceProperty#getVolumeSize}
             * @param volumeSize `CfnLaunchConfiguration.BlockDeviceProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link BlockDeviceProperty#getVolumeType}
             * @param volumeType `CfnLaunchConfiguration.BlockDeviceProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockDeviceProperty build() {
                return new Jsii$Proxy(deleteOnTermination, encrypted, iops, snapshotId, volumeSize, volumeType);
            }
        }

        /**
         * An implementation for {@link BlockDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDeviceProperty {
            private final java.lang.Object deleteOnTermination;
            private final java.lang.Object encrypted;
            private final java.lang.Number iops;
            private final java.lang.String snapshotId;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleteOnTermination = this.jsiiGet("deleteOnTermination", java.lang.Object.class);
                this.encrypted = this.jsiiGet("encrypted", java.lang.Object.class);
                this.iops = this.jsiiGet("iops", java.lang.Number.class);
                this.snapshotId = this.jsiiGet("snapshotId", java.lang.String.class);
                this.volumeSize = this.jsiiGet("volumeSize", java.lang.Number.class);
                this.volumeType = this.jsiiGet("volumeType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object deleteOnTermination, final java.lang.Object encrypted, final java.lang.Number iops, final java.lang.String snapshotId, final java.lang.Number volumeSize, final java.lang.String volumeType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleteOnTermination = deleteOnTermination;
                this.encrypted = encrypted;
                this.iops = iops;
                this.snapshotId = snapshotId;
                this.volumeSize = volumeSize;
                this.volumeType = volumeType;
            }

            @Override
            public java.lang.Object getDeleteOnTermination() {
                return this.deleteOnTermination;
            }

            @Override
            public java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleteOnTermination() != null) {
                    data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                }
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling.CfnLaunchConfiguration.BlockDeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockDeviceProperty.Jsii$Proxy that = (BlockDeviceProperty.Jsii$Proxy) o;

                if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public int hashCode() {
                int result = this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0;
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.CfnLaunchConfigurationProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.CfnLaunchConfigurationProps.Builder();
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.ImageId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-imageid
         * @param imageId `AWS::AutoScaling::LaunchConfiguration.ImageId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageId(final java.lang.String imageId) {
            this.props.imageId(imageId);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.InstanceType`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancetype
         * @param instanceType `AWS::AutoScaling::LaunchConfiguration.InstanceType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
         * @param associatePublicIpAddress `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final java.lang.Boolean associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }
        /**
         * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
         * @param associatePublicIpAddress `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final software.amazon.awscdk.core.IResolvable associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
         * @param blockDeviceMappings `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(final software.amazon.awscdk.core.IResolvable blockDeviceMappings) {
            this.props.blockDeviceMappings(blockDeviceMappings);
            return this;
        }
        /**
         * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
         * @param blockDeviceMappings `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(final java.util.List<java.lang.Object> blockDeviceMappings) {
            this.props.blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcid
         * @param classicLinkVpcId `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classicLinkVpcId(final java.lang.String classicLinkVpcId) {
            this.props.classicLinkVpcId(classicLinkVpcId);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCSecurityGroups`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcsecuritygroups
         * @param classicLinkVpcSecurityGroups `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCSecurityGroups`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classicLinkVpcSecurityGroups(final java.util.List<java.lang.String> classicLinkVpcSecurityGroups) {
            this.props.classicLinkVpcSecurityGroups(classicLinkVpcSecurityGroups);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
         * @param ebsOptimized `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(final java.lang.Boolean ebsOptimized) {
            this.props.ebsOptimized(ebsOptimized);
            return this;
        }
        /**
         * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
         * @param ebsOptimized `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(final software.amazon.awscdk.core.IResolvable ebsOptimized) {
            this.props.ebsOptimized(ebsOptimized);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.IamInstanceProfile`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-iaminstanceprofile
         * @param iamInstanceProfile `AWS::AutoScaling::LaunchConfiguration.IamInstanceProfile`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamInstanceProfile(final java.lang.String iamInstanceProfile) {
            this.props.iamInstanceProfile(iamInstanceProfile);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.InstanceId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instanceid
         * @param instanceId `AWS::AutoScaling::LaunchConfiguration.InstanceId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(final java.lang.String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
         * @param instanceMonitoring `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(final java.lang.Boolean instanceMonitoring) {
            this.props.instanceMonitoring(instanceMonitoring);
            return this;
        }
        /**
         * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
         * @param instanceMonitoring `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(final software.amazon.awscdk.core.IResolvable instanceMonitoring) {
            this.props.instanceMonitoring(instanceMonitoring);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.KernelId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-kernelid
         * @param kernelId `AWS::AutoScaling::LaunchConfiguration.KernelId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernelId(final java.lang.String kernelId) {
            this.props.kernelId(kernelId);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.KeyName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-keyname
         * @param keyName `AWS::AutoScaling::LaunchConfiguration.KeyName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.LaunchConfigurationName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-autoscaling-launchconfig-launchconfigurationname
         * @param launchConfigurationName `AWS::AutoScaling::LaunchConfiguration.LaunchConfigurationName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchConfigurationName(final java.lang.String launchConfigurationName) {
            this.props.launchConfigurationName(launchConfigurationName);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.PlacementTenancy`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-placementtenancy
         * @param placementTenancy `AWS::AutoScaling::LaunchConfiguration.PlacementTenancy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementTenancy(final java.lang.String placementTenancy) {
            this.props.placementTenancy(placementTenancy);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.RamDiskId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ramdiskid
         * @param ramDiskId `AWS::AutoScaling::LaunchConfiguration.RamDiskId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ramDiskId(final java.lang.String ramDiskId) {
            this.props.ramDiskId(ramDiskId);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.SecurityGroups`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-securitygroups
         * @param securityGroups `AWS::AutoScaling::LaunchConfiguration.SecurityGroups`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<java.lang.String> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.SpotPrice`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-spotprice
         * @param spotPrice `AWS::AutoScaling::LaunchConfiguration.SpotPrice`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotPrice(final java.lang.String spotPrice) {
            this.props.spotPrice(spotPrice);
            return this;
        }

        /**
         * `AWS::AutoScaling::LaunchConfiguration.UserData`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-userdata
         * @param userData `AWS::AutoScaling::LaunchConfiguration.UserData`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final java.lang.String userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration build() {
            return new software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
