package software.amazon.awscdk.services.autoscaling;

/**
 * Basic properties for a lifecycle hook.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.624Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.BasicLifecycleHookProps")
@software.amazon.jsii.Jsii.Proxy(BasicLifecycleHookProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BasicLifecycleHookProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The state of the Amazon EC2 instance to which you want to attach the lifecycle hook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleTransition getLifecycleTransition();

    /**
     * The target of the lifecycle hook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget getNotificationTarget();

    /**
     * The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs.
     * <p>
     * Default: Continue
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.DefaultResult getDefaultResult() {
        return null;
    }

    /**
     * Maximum time between calls to RecordLifecycleActionHeartbeat for the hook.
     * <p>
     * If the lifecycle hook times out, perform the action in DefaultResult.
     * <p>
     * Default: - No heartbeat timeout.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getHeartbeatTimeout() {
        return null;
    }

    /**
     * Name of the lifecycle hook.
     * <p>
     * Default: - Automatically generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLifecycleHookName() {
        return null;
    }

    /**
     * Additional data to pass to the lifecycle hook target.
     * <p>
     * Default: - No metadata.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNotificationMetadata() {
        return null;
    }

    /**
     * The role that allows publishing to the notification target.
     * <p>
     * Default: - A role is automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BasicLifecycleHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BasicLifecycleHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BasicLifecycleHookProps> {
        private software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition;
        private software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget;
        private software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult;
        private software.amazon.awscdk.core.Duration heartbeatTimeout;
        private java.lang.String lifecycleHookName;
        private java.lang.String notificationMetadata;
        private software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link BasicLifecycleHookProps#getLifecycleTransition}
         * @param lifecycleTransition The state of the Amazon EC2 instance to which you want to attach the lifecycle hook. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleTransition(software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        /**
         * Sets the value of {@link BasicLifecycleHookProps#getNotificationTarget}
         * @param notificationTarget The target of the lifecycle hook. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTarget(software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        /**
         * Sets the value of {@link BasicLifecycleHookProps#getDefaultResult}
         * @param defaultResult The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultResult(software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        /**
         * Sets the value of {@link BasicLifecycleHookProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Maximum time between calls to RecordLifecycleActionHeartbeat for the hook.
         *                         If the lifecycle hook times out, perform the action in DefaultResult.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.core.Duration heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link BasicLifecycleHookProps#getLifecycleHookName}
         * @param lifecycleHookName Name of the lifecycle hook.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleHookName(java.lang.String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        /**
         * Sets the value of {@link BasicLifecycleHookProps#getNotificationMetadata}
         * @param notificationMetadata Additional data to pass to the lifecycle hook target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationMetadata(java.lang.String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        /**
         * Sets the value of {@link BasicLifecycleHookProps#getRole}
         * @param role The role that allows publishing to the notification target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BasicLifecycleHookProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BasicLifecycleHookProps build() {
            return new Jsii$Proxy(lifecycleTransition, notificationTarget, defaultResult, heartbeatTimeout, lifecycleHookName, notificationMetadata, role);
        }
    }

    /**
     * An implementation for {@link BasicLifecycleHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicLifecycleHookProps {
        private final software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition;
        private final software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget;
        private final software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult;
        private final software.amazon.awscdk.core.Duration heartbeatTimeout;
        private final java.lang.String lifecycleHookName;
        private final java.lang.String notificationMetadata;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lifecycleTransition = this.jsiiGet("lifecycleTransition", software.amazon.awscdk.services.autoscaling.LifecycleTransition.class);
            this.notificationTarget = this.jsiiGet("notificationTarget", software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget.class);
            this.defaultResult = this.jsiiGet("defaultResult", software.amazon.awscdk.services.autoscaling.DefaultResult.class);
            this.heartbeatTimeout = this.jsiiGet("heartbeatTimeout", software.amazon.awscdk.core.Duration.class);
            this.lifecycleHookName = this.jsiiGet("lifecycleHookName", java.lang.String.class);
            this.notificationMetadata = this.jsiiGet("notificationMetadata", java.lang.String.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition, final software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget, final software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult, final software.amazon.awscdk.core.Duration heartbeatTimeout, final java.lang.String lifecycleHookName, final java.lang.String notificationMetadata, final software.amazon.awscdk.services.iam.IRole role) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lifecycleTransition = java.util.Objects.requireNonNull(lifecycleTransition, "lifecycleTransition is required");
            this.notificationTarget = java.util.Objects.requireNonNull(notificationTarget, "notificationTarget is required");
            this.defaultResult = defaultResult;
            this.heartbeatTimeout = heartbeatTimeout;
            this.lifecycleHookName = lifecycleHookName;
            this.notificationMetadata = notificationMetadata;
            this.role = role;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.LifecycleTransition getLifecycleTransition() {
            return this.lifecycleTransition;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget getNotificationTarget() {
            return this.notificationTarget;
        }

        @Override
        public software.amazon.awscdk.services.autoscaling.DefaultResult getDefaultResult() {
            return this.defaultResult;
        }

        @Override
        public software.amazon.awscdk.core.Duration getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public java.lang.String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public java.lang.String getNotificationMetadata() {
            return this.notificationMetadata;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lifecycleTransition", om.valueToTree(this.getLifecycleTransition()));
            data.set("notificationTarget", om.valueToTree(this.getNotificationTarget()));
            if (this.getDefaultResult() != null) {
                data.set("defaultResult", om.valueToTree(this.getDefaultResult()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getLifecycleHookName() != null) {
                data.set("lifecycleHookName", om.valueToTree(this.getLifecycleHookName()));
            }
            if (this.getNotificationMetadata() != null) {
                data.set("notificationMetadata", om.valueToTree(this.getNotificationMetadata()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscaling.BasicLifecycleHookProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BasicLifecycleHookProps.Jsii$Proxy that = (BasicLifecycleHookProps.Jsii$Proxy) o;

            if (!lifecycleTransition.equals(that.lifecycleTransition)) return false;
            if (!notificationTarget.equals(that.notificationTarget)) return false;
            if (this.defaultResult != null ? !this.defaultResult.equals(that.defaultResult) : that.defaultResult != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.lifecycleHookName != null ? !this.lifecycleHookName.equals(that.lifecycleHookName) : that.lifecycleHookName != null) return false;
            if (this.notificationMetadata != null ? !this.notificationMetadata.equals(that.notificationMetadata) : that.notificationMetadata != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public int hashCode() {
            int result = this.lifecycleTransition.hashCode();
            result = 31 * result + (this.notificationTarget.hashCode());
            result = 31 * result + (this.defaultResult != null ? this.defaultResult.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.lifecycleHookName != null ? this.lifecycleHookName.hashCode() : 0);
            result = 31 * result + (this.notificationMetadata != null ? this.notificationMetadata.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
