package software.amazon.awscdk.services.autoscaling;

/**
 * A Fleet represents a managed set of EC2 instances.
 * <p>
 * The Fleet models a number of AutoScalingGroups, a launch configuration, a
 * security group and an instance role.
 * <p>
 * It allows adding arbitrary commands to the startup scripts of the instances
 * in the fleet.
 * <p>
 * The ASG spans the availability zones specified by vpcSubnets, falling back to
 * the Vpc default strategy if not specified.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.620Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscaling.$Module.class, fqn = "@aws-cdk/aws-autoscaling.AutoScalingGroup")
public class AutoScalingGroup extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget,software.amazon.awscdk.services.ec2.IConnectable,software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget,software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget,software.amazon.awscdk.services.autoscaling.IAutoScalingGroup {

    protected AutoScalingGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AutoScalingGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AutoScalingGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param autoScalingGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup fromAutoScalingGroupName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String autoScalingGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class, "fromAutoScalingGroupName", software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(autoScalingGroupName, "autoScalingGroupName is required") });
    }

    /**
     * Send a message to either an SQS queue or SNS topic when instances launch or terminate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHook addLifecycleHook(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps props) {
        return this.jsiiCall("addLifecycleHook", software.amazon.awscdk.services.autoscaling.LifecycleHook.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add the security group to all instances via the launch configuration security groups array.
     * <p>
     * @param securityGroup : The security group to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        this.jsiiCall("addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Adds a statement to the IAM role assumed by instances of this fleet.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Add command to the startup script of fleet instances.
     * <p>
     * The command must be in the scripting language supported by the fleet's OS (i.e. Linux/Windows).
     * Does nothing for imported ASGs.
     * <p>
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addUserData(final @org.jetbrains.annotations.NotNull java.lang.String... commands) {
        this.jsiiCall("addUserData", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(commands).toArray(Object[]::new));
    }

    /**
     * Attach to ELBv2 Application Target Group.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
        return this.jsiiCall("attachToApplicationTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Attach to a classic load balancer.
     * <p>
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        this.jsiiCall("attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * Attach to ELBv2 Application Target Group.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return this.jsiiCall("attachToNetworkTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Scale out or in to achieve a target CPU utilization.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnCpuUtilization(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.CpuUtilizationScalingProps props) {
        return this.jsiiCall("scaleOnCpuUtilization", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in to achieve a target network ingress rate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnIncomingBytes(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps props) {
        return this.jsiiCall("scaleOnIncomingBytes", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in, in response to a metric.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.StepScalingPolicy scaleOnMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicStepScalingPolicyProps props) {
        return this.jsiiCall("scaleOnMetric", software.amazon.awscdk.services.autoscaling.StepScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in to achieve a target network egress rate.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnOutgoingBytes(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.NetworkUtilizationScalingProps props) {
        return this.jsiiCall("scaleOnOutgoingBytes", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in to achieve a target request handling rate.
     * <p>
     * The AutoScalingGroup must have been attached to an Application Load Balancer
     * in order to be able to call this.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleOnRequestCount(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.RequestCountScalingProps props) {
        return this.jsiiCall("scaleOnRequestCount", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in based on time.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.ScheduledAction scaleOnSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BasicScheduledActionProps props) {
        return this.jsiiCall("scaleOnSchedule", software.amazon.awscdk.services.autoscaling.ScheduledAction.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in in order to keep a metric around a target value.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy scaleToTrackMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.MetricTargetTrackingProps props) {
        return this.jsiiCall("scaleToTrackMetric", software.amazon.awscdk.services.autoscaling.TargetTrackingScalingPolicy.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Arn of the AutoScalingGroup.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupArn() {
        return this.jsiiGet("autoScalingGroupArn", java.lang.String.class);
    }

    /**
     * Name of the AutoScalingGroup.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName() {
        return this.jsiiGet("autoScalingGroupName", java.lang.String.class);
    }

    /**
     * Allows specify security group connections for instances of this fleet.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * The type of OS instances of this fleet are running.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
        return this.jsiiGet("osType", software.amazon.awscdk.services.ec2.OperatingSystemType.class);
    }

    /**
     * The IAM role assumed by instances of this fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * UserData for the instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData getUserData() {
        return this.jsiiGet("userData", software.amazon.awscdk.services.ec2.UserData.class);
    }

    /**
     * The maximum amount of time that an instance can be in service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxInstanceLifetime() {
        return this.jsiiGet("maxInstanceLifetime", software.amazon.awscdk.core.Duration.class);
    }

    /**
     * The maximum spot price configured for the autoscaling group.
     * <p>
     * <code>undefined</code>
     * indicates that this group uses on-demand capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
        return this.jsiiGet("spotPrice", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup getAlbTargetGroup() {
        return this.jsiiGet("albTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setAlbTargetGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup value) {
        this.jsiiSet("albTargetGroup", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.AutoScalingGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.AutoScalingGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.AutoScalingGroupProps.Builder();
        }

        /**
         * Whether the instances can initiate connections to anywhere by default.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether the instances can initiate connections to anywhere by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
         * <p>
         * Default: - Use subnet setting.
         * <p>
         * @return {@code this}
         * @param associatePublicIpAddress Whether instances in the Auto Scaling Group should have public IP addresses associated with them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final java.lang.Boolean associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        /**
         * The name of the Auto Scaling group.
         * <p>
         * This name must be unique per Region per account.
         * <p>
         * Default: - Auto generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param autoScalingGroupName The name of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(final java.lang.String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        /**
         * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         * <p>
         * Each instance that is launched has an associated root device volume,
         * either an Amazon EBS volume or an instance store volume.
         * You can use block device mappings to specify additional EBS volumes or
         * instance store volumes to attach to an instance when it is launched.
         * <p>
         * Default: - Uses the block device mapping of the AMI
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDevices(final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        /**
         * Default scaling cooldown for this AutoScalingGroup.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param cooldown Default scaling cooldown for this AutoScalingGroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(final software.amazon.awscdk.core.Duration cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        /**
         * Initial amount of instances in the fleet.
         * <p>
         * If this is set to a number, every deployment will reset the amount of
         * instances to this number. It is recommended to leave this value blank.
         * <p>
         * Default: minCapacity, and leave unchanged during deployment
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity
         * @param desiredCapacity Initial amount of instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(final java.lang.Number desiredCapacity) {
            this.props.desiredCapacity(desiredCapacity);
            return this;
        }

        /**
         * Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
         * <p>
         * To report all group metrics use <code>GroupMetrics.all()</code>
         * Group metrics are reported in a granularity of 1 minute at no additional charge.
         * <p>
         * Default: - no group metrics will be reported
         * <p>
         * @return {@code this}
         * @param groupMetrics Enable monitoring for group metrics, these metrics describe the group rather than any of its instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupMetrics(final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics) {
            this.props.groupMetrics(groupMetrics);
            return this;
        }

        /**
         * Configuration for health checks.
         * <p>
         * Default: - HealthCheck.ec2 with no grace period
         * <p>
         * @return {@code this}
         * @param healthCheck Configuration for health checks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * If the ASG has scheduled actions, don't reset unchanged group sizes.
         * <p>
         * Only used if the ASG has scheduled actions (which may scale your ASG up
         * or down regardless of cdk deployments). If true, the size of the group
         * will only be reset if it has been changed in the CDK app. If false, the
         * sizes will always be changed back to what they were in the CDK app
         * on deployment.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param ignoreUnmodifiedSizeProperties If the ASG has scheduled actions, don't reset unchanged group sizes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreUnmodifiedSizeProperties(final java.lang.Boolean ignoreUnmodifiedSizeProperties) {
            this.props.ignoreUnmodifiedSizeProperties(ignoreUnmodifiedSizeProperties);
            return this;
        }

        /**
         * Controls whether instances in this group are launched with detailed or basic monitoring.
         * <p>
         * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
         * is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
         * <p>
         * Default: - Monitoring.DETAILED
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics
         * @param instanceMonitoring Controls whether instances in this group are launched with detailed or basic monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(final software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring) {
            this.props.instanceMonitoring(instanceMonitoring);
            return this;
        }

        /**
         * Name of SSH keypair to grant access to instances.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @param keyName Name of SSH keypair to grant access to instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * Maximum number of instances in the fleet.
         * <p>
         * Default: desiredCapacity
         * <p>
         * @return {@code this}
         * @param maxCapacity Maximum number of instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * The maximum amount of time that an instance can be in service.
         * <p>
         * The maximum duration applies
         * to all current and future instances in the group. As an instance approaches its maximum duration,
         * it is terminated and replaced, and cannot be used again.
         * <p>
         * You must specify a value of at least 604,800 seconds (7 days). To clear a previously set value,
         * leave this property undefined.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html
         * @param maxInstanceLifetime The maximum amount of time that an instance can be in service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInstanceLifetime(final software.amazon.awscdk.core.Duration maxInstanceLifetime) {
            this.props.maxInstanceLifetime(maxInstanceLifetime);
            return this;
        }

        /**
         * Minimum number of instances in the fleet.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param minCapacity Minimum number of instances in the fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(final java.lang.Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        /**
         * Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
         * <p>
         * Default: - No fleet change notifications will be sent.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations
         * @param notifications Configure autoscaling group to send notifications about fleet changes to an SNS topic(s). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications) {
            this.props.notifications(notifications);
            return this;
        }

        /**
         * SNS topic to send notifications about fleet changes.
         * <p>
         * Default: - No fleet change notifications will be sent.
         * <p>
         * @return {@code this}
         * @deprecated use `notifications`
         * @param notificationsTopic SNS topic to send notifications about fleet changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder notificationsTopic(final software.amazon.awscdk.services.sns.ITopic notificationsTopic) {
            this.props.notificationsTopic(notificationsTopic);
            return this;
        }

        /**
         * Configuration for replacing updates.
         * <p>
         * Only used if updateType == UpdateType.ReplacingUpdate. Specifies how
         * many instances must signal success for the update to succeed.
         * <p>
         * Default: minSuccessfulInstancesPercent
         * <p>
         * @return {@code this}
         * @param replacingUpdateMinSuccessfulInstancesPercent Configuration for replacing updates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replacingUpdateMinSuccessfulInstancesPercent(final java.lang.Number replacingUpdateMinSuccessfulInstancesPercent) {
            this.props.replacingUpdateMinSuccessfulInstancesPercent(replacingUpdateMinSuccessfulInstancesPercent);
            return this;
        }

        /**
         * How many ResourceSignal calls CloudFormation expects before the resource is considered created.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param resourceSignalCount How many ResourceSignal calls CloudFormation expects before the resource is considered created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalCount(final java.lang.Number resourceSignalCount) {
            this.props.resourceSignalCount(resourceSignalCount);
            return this;
        }

        /**
         * The length of time to wait for the resourceSignalCount.
         * <p>
         * The maximum value is 43200 (12 hours).
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalTimeout(final software.amazon.awscdk.core.Duration resourceSignalTimeout) {
            this.props.resourceSignalTimeout(resourceSignalTimeout);
            return this;
        }

        /**
         * Configuration for rolling updates.
         * <p>
         * Only used if updateType == UpdateType.RollingUpdate.
         * <p>
         * Default: - RollingUpdateConfiguration with defaults.
         * <p>
         * @return {@code this}
         * @param rollingUpdateConfiguration Configuration for rolling updates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rollingUpdateConfiguration(final software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration rollingUpdateConfiguration) {
            this.props.rollingUpdateConfiguration(rollingUpdateConfiguration);
            return this;
        }

        /**
         * The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
         * <p>
         * Spot Instances are
         * launched when the price you specify exceeds the current Spot market price.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param spotPrice The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotPrice(final java.lang.String spotPrice) {
            this.props.spotPrice(spotPrice);
            return this;
        }

        /**
         * What to do when an AutoScalingGroup's instance configuration is changed.
         * <p>
         * This is applied when any of the settings on the ASG are changed that
         * affect how the instances should be created (VPC, instance type, startup
         * scripts, etc.). It indicates how the existing instances should be
         * replaced with new instances matching the new config. By default, nothing
         * is done and only new instances are launched with the new config.
         * <p>
         * Default: UpdateType.None
         * <p>
         * @return {@code this}
         * @param updateType What to do when an AutoScalingGroup's instance configuration is changed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateType(final software.amazon.awscdk.services.autoscaling.UpdateType updateType) {
            this.props.updateType(updateType);
            return this;
        }

        /**
         * Where to place instances within the VPC.
         * <p>
         * Default: - All Private subnets.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place instances within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * Type of instance to launch.
         * <p>
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * AMI to launch.
         * <p>
         * @return {@code this}
         * @param machineImage AMI to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * VPC to launch these instances in.
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch these instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
         * <p>
         * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * <p>
         * Default: A role will automatically be created, it can be accessed via the `role` property
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * var role = Role.Builder.create(this, "MyRole")
         *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
         *         .build();}</pre></blockquote>
         * <p>
         * @return {@code this}
         * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Security group to launch the instances in.
         * <p>
         * Default: - A SecurityGroup will be created if none is specified.
         * <p>
         * @return {@code this}
         * @param securityGroup Security group to launch the instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Specific UserData to use.
         * <p>
         * The UserData may still be mutated after creation.
         * <p>
         * Default: - A UserData object appropriate for the MachineImage's
         * Operating System is created.
         * <p>
         * @return {@code this}
         * @param userData Specific UserData to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.autoscaling.AutoScalingGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.AutoScalingGroup build() {
            return new software.amazon.awscdk.services.autoscaling.AutoScalingGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
