package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Define a step scaling action.
 * <p>
 * This kind of scaling policy adjusts the target capacity in configurable
 * steps. The size of the step is configurable based on the metric's distance
 * to its alarm threshold.
 * <p>
 * This Action must be used as the target of a CloudWatch alarm to take effect.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:06.036Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.StepScalingAction")
public class StepScalingAction extends software.amazon.awscdk.core.Construct {

    protected StepScalingAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StepScalingAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StepScalingAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.StepScalingActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add an adjusment interval to the ScalingAction.
     * <p>
     * @param adjustment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addAdjustment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.AdjustmentTier adjustment) {
        this.jsiiCall("addAdjustment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(adjustment, "adjustment is required") });
    }

    /**
     * ARN of the scaling policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScalingPolicyArn() {
        return this.jsiiGet("scalingPolicyArn", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationautoscaling.StepScalingAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationautoscaling.StepScalingAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationautoscaling.StepScalingActionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationautoscaling.StepScalingActionProps.Builder();
        }

        /**
         * The scalable target.
         * <p>
         * @return {@code this}
         * @param scalingTarget The scalable target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTarget(final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget) {
            this.props.scalingTarget(scalingTarget);
            return this;
        }

        /**
         * How the adjustment numbers are interpreted.
         * <p>
         * Default: ChangeInCapacity
         * <p>
         * @return {@code this}
         * @param adjustmentType How the adjustment numbers are interpreted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType) {
            this.props.adjustmentType(adjustmentType);
            return this;
        }

        /**
         * Grace period after scaling activity.
         * <p>
         * For scale out policies, multiple scale outs during the cooldown period are
         * squashed so that only the biggest scale out happens.
         * <p>
         * For scale in policies, subsequent scale ins during the cooldown period are
         * ignored.
         * <p>
         * Default: No cooldown period
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html
         * @param cooldown Grace period after scaling activity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(final software.amazon.awscdk.core.Duration cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        /**
         * The aggregation type for the CloudWatch metrics.
         * <p>
         * Default: Average
         * <p>
         * @return {@code this}
         * @param metricAggregationType The aggregation type for the CloudWatch metrics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricAggregationType(final software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType) {
            this.props.metricAggregationType(metricAggregationType);
            return this;
        }

        /**
         * Minimum absolute number to adjust capacity with as result of percentage scaling.
         * <p>
         * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         * the minimum absolute effect size.
         * <p>
         * Default: No minimum scaling effect
         * <p>
         * @return {@code this}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(final java.lang.Number minAdjustmentMagnitude) {
            this.props.minAdjustmentMagnitude(minAdjustmentMagnitude);
            return this;
        }

        /**
         * A name for the scaling policy.
         * <p>
         * Default: Automatically generated name
         * <p>
         * @return {@code this}
         * @param policyName A name for the scaling policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(final java.lang.String policyName) {
            this.props.policyName(policyName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.applicationautoscaling.StepScalingAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationautoscaling.StepScalingAction build() {
            return new software.amazon.awscdk.services.applicationautoscaling.StepScalingAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
