package software.amazon.awscdk.services.applicationautoscaling;

/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalableTarget`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:03.392Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.CfnScalableTarget")
public class CfnScalableTarget extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnScalableTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScalableTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApplicationAutoScaling::ScalableTarget`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScalableTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.CfnScalableTargetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MaxCapacity`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity() {
        return this.jsiiGet("maxCapacity", java.lang.Number.class);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MaxCapacity`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxCapacity(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        this.jsiiSet("maxCapacity", java.util.Objects.requireNonNull(value, "maxCapacity is required"));
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MinCapacity`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity() {
        return this.jsiiGet("minCapacity", java.lang.Number.class);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MinCapacity`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinCapacity(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        this.jsiiSet("minCapacity", java.util.Objects.requireNonNull(value, "minCapacity is required"));
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ResourceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return this.jsiiGet("resourceId", java.lang.String.class);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ResourceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.RoleARN`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return this.jsiiGet("roleArn", java.lang.String.class);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.RoleARN`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScalableDimension`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScalableDimension() {
        return this.jsiiGet("scalableDimension", java.lang.String.class);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScalableDimension`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalableDimension(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("scalableDimension", java.util.Objects.requireNonNull(value, "scalableDimension is required"));
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ServiceNamespace`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceNamespace() {
        return this.jsiiGet("serviceNamespace", java.lang.String.class);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ServiceNamespace`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceNamespace(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("serviceNamespace", java.util.Objects.requireNonNull(value, "serviceNamespace is required"));
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScheduledActions() {
        return this.jsiiGet("scheduledActions", java.lang.Object.class);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledActions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("scheduledActions", value);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("scheduledActions", value);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSuspendedState() {
        return this.jsiiGet("suspendedState", java.lang.Object.class);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuspendedState(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("suspendedState", value);
    }

    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuspendedState(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.SuspendedStateProperty value) {
        this.jsiiSet("suspendedState", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.CfnScalableTarget.ScalableTargetActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalableTargetActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalableTargetActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalableTarget.ScalableTargetActionProperty.MaxCapacity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-maxcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
            return null;
        }

        /**
         * `CfnScalableTarget.ScalableTargetActionProperty.MinCapacity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-mincapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalableTargetActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalableTargetActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalableTargetActionProperty> {
            private java.lang.Number maxCapacity;
            private java.lang.Number minCapacity;

            /**
             * Sets the value of {@link ScalableTargetActionProperty#getMaxCapacity}
             * @param maxCapacity `CfnScalableTarget.ScalableTargetActionProperty.MaxCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalableTargetActionProperty#getMinCapacity}
             * @param minCapacity `CfnScalableTarget.ScalableTargetActionProperty.MinCapacity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalableTargetActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalableTargetActionProperty build() {
                return new Jsii$Proxy(maxCapacity, minCapacity);
            }
        }

        /**
         * An implementation for {@link ScalableTargetActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalableTargetActionProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = this.jsiiGet("maxCapacity", java.lang.Number.class);
                this.minCapacity = this.jsiiGet("minCapacity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number maxCapacity, final java.lang.Number minCapacity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = maxCapacity;
                this.minCapacity = minCapacity;
            }

            @Override
            public java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxCapacity() != null) {
                    data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                }
                if (this.getMinCapacity() != null) {
                    data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-applicationautoscaling.CfnScalableTarget.ScalableTargetActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalableTargetActionProperty.Jsii$Proxy that = (ScalableTargetActionProperty.Jsii$Proxy) o;

                if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
                return this.minCapacity != null ? this.minCapacity.equals(that.minCapacity) : that.minCapacity == null;
            }

            @Override
            public int hashCode() {
                int result = this.maxCapacity != null ? this.maxCapacity.hashCode() : 0;
                result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.CfnScalableTarget.ScheduledActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduledActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduledActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalableTarget.ScheduledActionProperty.Schedule`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-schedule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSchedule();

        /**
         * `CfnScalableTarget.ScheduledActionProperty.ScheduledActionName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scheduledactionname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduledActionName();

        /**
         * `CfnScalableTarget.ScheduledActionProperty.EndTime`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-endtime
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEndTime() {
            return null;
        }

        /**
         * `CfnScalableTarget.ScheduledActionProperty.ScalableTargetAction`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scalabletargetaction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScalableTargetAction() {
            return null;
        }

        /**
         * `CfnScalableTarget.ScheduledActionProperty.StartTime`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-starttime
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduledActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduledActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduledActionProperty> {
            private java.lang.String schedule;
            private java.lang.String scheduledActionName;
            private java.lang.Object endTime;
            private java.lang.Object scalableTargetAction;
            private java.lang.Object startTime;

            /**
             * Sets the value of {@link ScheduledActionProperty#getSchedule}
             * @param schedule `CfnScalableTarget.ScheduledActionProperty.Schedule`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(java.lang.String schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getScheduledActionName}
             * @param scheduledActionName `CfnScalableTarget.ScheduledActionProperty.ScheduledActionName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledActionName(java.lang.String scheduledActionName) {
                this.scheduledActionName = scheduledActionName;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getEndTime}
             * @param endTime `CfnScalableTarget.ScheduledActionProperty.EndTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(software.amazon.awscdk.core.IResolvable endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getEndTime}
             * @param endTime `CfnScalableTarget.ScheduledActionProperty.EndTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.time.Instant endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getScalableTargetAction}
             * @param scalableTargetAction `CfnScalableTarget.ScheduledActionProperty.ScalableTargetAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalableTargetAction(software.amazon.awscdk.core.IResolvable scalableTargetAction) {
                this.scalableTargetAction = scalableTargetAction;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getScalableTargetAction}
             * @param scalableTargetAction `CfnScalableTarget.ScheduledActionProperty.ScalableTargetAction`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalableTargetAction(software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.ScalableTargetActionProperty scalableTargetAction) {
                this.scalableTargetAction = scalableTargetAction;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getStartTime}
             * @param startTime `CfnScalableTarget.ScheduledActionProperty.StartTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(software.amazon.awscdk.core.IResolvable startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionProperty#getStartTime}
             * @param startTime `CfnScalableTarget.ScheduledActionProperty.StartTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.time.Instant startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduledActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduledActionProperty build() {
                return new Jsii$Proxy(schedule, scheduledActionName, endTime, scalableTargetAction, startTime);
            }
        }

        /**
         * An implementation for {@link ScheduledActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledActionProperty {
            private final java.lang.String schedule;
            private final java.lang.String scheduledActionName;
            private final java.lang.Object endTime;
            private final java.lang.Object scalableTargetAction;
            private final java.lang.Object startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schedule = this.jsiiGet("schedule", java.lang.String.class);
                this.scheduledActionName = this.jsiiGet("scheduledActionName", java.lang.String.class);
                this.endTime = this.jsiiGet("endTime", java.lang.Object.class);
                this.scalableTargetAction = this.jsiiGet("scalableTargetAction", java.lang.Object.class);
                this.startTime = this.jsiiGet("startTime", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String schedule, final java.lang.String scheduledActionName, final java.lang.Object endTime, final java.lang.Object scalableTargetAction, final java.lang.Object startTime) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schedule = java.util.Objects.requireNonNull(schedule, "schedule is required");
                this.scheduledActionName = java.util.Objects.requireNonNull(scheduledActionName, "scheduledActionName is required");
                this.endTime = endTime;
                this.scalableTargetAction = scalableTargetAction;
                this.startTime = startTime;
            }

            @Override
            public java.lang.String getSchedule() {
                return this.schedule;
            }

            @Override
            public java.lang.String getScheduledActionName() {
                return this.scheduledActionName;
            }

            @Override
            public java.lang.Object getEndTime() {
                return this.endTime;
            }

            @Override
            public java.lang.Object getScalableTargetAction() {
                return this.scalableTargetAction;
            }

            @Override
            public java.lang.Object getStartTime() {
                return this.startTime;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("schedule", om.valueToTree(this.getSchedule()));
                data.set("scheduledActionName", om.valueToTree(this.getScheduledActionName()));
                if (this.getEndTime() != null) {
                    data.set("endTime", om.valueToTree(this.getEndTime()));
                }
                if (this.getScalableTargetAction() != null) {
                    data.set("scalableTargetAction", om.valueToTree(this.getScalableTargetAction()));
                }
                if (this.getStartTime() != null) {
                    data.set("startTime", om.valueToTree(this.getStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-applicationautoscaling.CfnScalableTarget.ScheduledActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduledActionProperty.Jsii$Proxy that = (ScheduledActionProperty.Jsii$Proxy) o;

                if (!schedule.equals(that.schedule)) return false;
                if (!scheduledActionName.equals(that.scheduledActionName)) return false;
                if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) return false;
                if (this.scalableTargetAction != null ? !this.scalableTargetAction.equals(that.scalableTargetAction) : that.scalableTargetAction != null) return false;
                return this.startTime != null ? this.startTime.equals(that.startTime) : that.startTime == null;
            }

            @Override
            public int hashCode() {
                int result = this.schedule.hashCode();
                result = 31 * result + (this.scheduledActionName.hashCode());
                result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
                result = 31 * result + (this.scalableTargetAction != null ? this.scalableTargetAction.hashCode() : 0);
                result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.CfnScalableTarget.SuspendedStateProperty")
    @software.amazon.jsii.Jsii.Proxy(SuspendedStateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuspendedStateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalableTarget.SuspendedStateProperty.DynamicScalingInSuspended`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-dynamicscalinginsuspended
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamicScalingInSuspended() {
            return null;
        }

        /**
         * `CfnScalableTarget.SuspendedStateProperty.DynamicScalingOutSuspended`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-dynamicscalingoutsuspended
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamicScalingOutSuspended() {
            return null;
        }

        /**
         * `CfnScalableTarget.SuspendedStateProperty.ScheduledScalingSuspended`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-scheduledscalingsuspended
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScheduledScalingSuspended() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuspendedStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuspendedStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuspendedStateProperty> {
            private java.lang.Object dynamicScalingInSuspended;
            private java.lang.Object dynamicScalingOutSuspended;
            private java.lang.Object scheduledScalingSuspended;

            /**
             * Sets the value of {@link SuspendedStateProperty#getDynamicScalingInSuspended}
             * @param dynamicScalingInSuspended `CfnScalableTarget.SuspendedStateProperty.DynamicScalingInSuspended`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicScalingInSuspended(java.lang.Boolean dynamicScalingInSuspended) {
                this.dynamicScalingInSuspended = dynamicScalingInSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getDynamicScalingInSuspended}
             * @param dynamicScalingInSuspended `CfnScalableTarget.SuspendedStateProperty.DynamicScalingInSuspended`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicScalingInSuspended(software.amazon.awscdk.core.IResolvable dynamicScalingInSuspended) {
                this.dynamicScalingInSuspended = dynamicScalingInSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getDynamicScalingOutSuspended}
             * @param dynamicScalingOutSuspended `CfnScalableTarget.SuspendedStateProperty.DynamicScalingOutSuspended`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicScalingOutSuspended(java.lang.Boolean dynamicScalingOutSuspended) {
                this.dynamicScalingOutSuspended = dynamicScalingOutSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getDynamicScalingOutSuspended}
             * @param dynamicScalingOutSuspended `CfnScalableTarget.SuspendedStateProperty.DynamicScalingOutSuspended`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicScalingOutSuspended(software.amazon.awscdk.core.IResolvable dynamicScalingOutSuspended) {
                this.dynamicScalingOutSuspended = dynamicScalingOutSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getScheduledScalingSuspended}
             * @param scheduledScalingSuspended `CfnScalableTarget.SuspendedStateProperty.ScheduledScalingSuspended`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledScalingSuspended(java.lang.Boolean scheduledScalingSuspended) {
                this.scheduledScalingSuspended = scheduledScalingSuspended;
                return this;
            }

            /**
             * Sets the value of {@link SuspendedStateProperty#getScheduledScalingSuspended}
             * @param scheduledScalingSuspended `CfnScalableTarget.SuspendedStateProperty.ScheduledScalingSuspended`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledScalingSuspended(software.amazon.awscdk.core.IResolvable scheduledScalingSuspended) {
                this.scheduledScalingSuspended = scheduledScalingSuspended;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuspendedStateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuspendedStateProperty build() {
                return new Jsii$Proxy(dynamicScalingInSuspended, dynamicScalingOutSuspended, scheduledScalingSuspended);
            }
        }

        /**
         * An implementation for {@link SuspendedStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuspendedStateProperty {
            private final java.lang.Object dynamicScalingInSuspended;
            private final java.lang.Object dynamicScalingOutSuspended;
            private final java.lang.Object scheduledScalingSuspended;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dynamicScalingInSuspended = this.jsiiGet("dynamicScalingInSuspended", java.lang.Object.class);
                this.dynamicScalingOutSuspended = this.jsiiGet("dynamicScalingOutSuspended", java.lang.Object.class);
                this.scheduledScalingSuspended = this.jsiiGet("scheduledScalingSuspended", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object dynamicScalingInSuspended, final java.lang.Object dynamicScalingOutSuspended, final java.lang.Object scheduledScalingSuspended) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dynamicScalingInSuspended = dynamicScalingInSuspended;
                this.dynamicScalingOutSuspended = dynamicScalingOutSuspended;
                this.scheduledScalingSuspended = scheduledScalingSuspended;
            }

            @Override
            public java.lang.Object getDynamicScalingInSuspended() {
                return this.dynamicScalingInSuspended;
            }

            @Override
            public java.lang.Object getDynamicScalingOutSuspended() {
                return this.dynamicScalingOutSuspended;
            }

            @Override
            public java.lang.Object getScheduledScalingSuspended() {
                return this.scheduledScalingSuspended;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDynamicScalingInSuspended() != null) {
                    data.set("dynamicScalingInSuspended", om.valueToTree(this.getDynamicScalingInSuspended()));
                }
                if (this.getDynamicScalingOutSuspended() != null) {
                    data.set("dynamicScalingOutSuspended", om.valueToTree(this.getDynamicScalingOutSuspended()));
                }
                if (this.getScheduledScalingSuspended() != null) {
                    data.set("scheduledScalingSuspended", om.valueToTree(this.getScheduledScalingSuspended()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-applicationautoscaling.CfnScalableTarget.SuspendedStateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuspendedStateProperty.Jsii$Proxy that = (SuspendedStateProperty.Jsii$Proxy) o;

                if (this.dynamicScalingInSuspended != null ? !this.dynamicScalingInSuspended.equals(that.dynamicScalingInSuspended) : that.dynamicScalingInSuspended != null) return false;
                if (this.dynamicScalingOutSuspended != null ? !this.dynamicScalingOutSuspended.equals(that.dynamicScalingOutSuspended) : that.dynamicScalingOutSuspended != null) return false;
                return this.scheduledScalingSuspended != null ? this.scheduledScalingSuspended.equals(that.scheduledScalingSuspended) : that.scheduledScalingSuspended == null;
            }

            @Override
            public int hashCode() {
                int result = this.dynamicScalingInSuspended != null ? this.dynamicScalingInSuspended.hashCode() : 0;
                result = 31 * result + (this.dynamicScalingOutSuspended != null ? this.dynamicScalingOutSuspended.hashCode() : 0);
                result = 31 * result + (this.scheduledScalingSuspended != null ? this.scheduledScalingSuspended.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationautoscaling.CfnScalableTargetProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationautoscaling.CfnScalableTargetProps.Builder();
        }

        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.MaxCapacity`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
         * @param maxCapacity `AWS::ApplicationAutoScaling::ScalableTarget.MaxCapacity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.MinCapacity`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
         * @param minCapacity `AWS::ApplicationAutoScaling::ScalableTarget.MinCapacity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(final java.lang.Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.ResourceId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid
         * @param resourceId `AWS::ApplicationAutoScaling::ScalableTarget.ResourceId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.RoleARN`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn
         * @param roleArn `AWS::ApplicationAutoScaling::ScalableTarget.RoleARN`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.ScalableDimension`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension
         * @param scalableDimension `AWS::ApplicationAutoScaling::ScalableTarget.ScalableDimension`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalableDimension(final java.lang.String scalableDimension) {
            this.props.scalableDimension(scalableDimension);
            return this;
        }

        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.ServiceNamespace`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace
         * @param serviceNamespace `AWS::ApplicationAutoScaling::ScalableTarget.ServiceNamespace`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(final java.lang.String serviceNamespace) {
            this.props.serviceNamespace(serviceNamespace);
            return this;
        }

        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
         * @param scheduledActions `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActions(final software.amazon.awscdk.core.IResolvable scheduledActions) {
            this.props.scheduledActions(scheduledActions);
            return this;
        }
        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
         * @param scheduledActions `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActions(final java.util.List<java.lang.Object> scheduledActions) {
            this.props.scheduledActions(scheduledActions);
            return this;
        }

        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate
         * @param suspendedState `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspendedState(final software.amazon.awscdk.core.IResolvable suspendedState) {
            this.props.suspendedState(suspendedState);
            return this;
        }
        /**
         * `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate
         * @param suspendedState `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suspendedState(final software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.SuspendedStateProperty suspendedState) {
            this.props.suspendedState(suspendedState);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget build() {
            return new software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
