package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Properties for a Target Tracking policy that include the metric but exclude the target.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.906Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.BasicTargetTrackingScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(BasicTargetTrackingScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BasicTargetTrackingScalingPolicyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.BaseTargetTrackingProps {

    /**
     * The target value for the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

    /**
     * A custom metric for application autoscaling.
     * <p>
     * The metric must track utilization. Scaling out will happen if the metric is higher than
     * the target value, scaling in will happen in the metric is lower than the target value.
     * <p>
     * Exactly one of customMetric or predefinedMetric must be specified.
     * <p>
     * Default: - No custom metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.IMetric getCustomMetric() {
        return null;
    }

    /**
     * A predefined metric for application autoscaling.
     * <p>
     * The metric must track utilization. Scaling out will happen if the metric is higher than
     * the target value, scaling in will happen in the metric is lower than the target value.
     * <p>
     * Exactly one of customMetric or predefinedMetric must be specified.
     * <p>
     * Default: - No predefined metrics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric getPredefinedMetric() {
        return null;
    }

    /**
     * Identify the resource associated with the metric type.
     * <p>
     * Only used for predefined metric ALBRequestCountPerTarget.
     * <p>
     * Default: - No resource label.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * app / <load-balancer - name > /<load-balancer-id>/targetgroup / <target-group - name > /<target-group-id>;}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BasicTargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BasicTargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BasicTargetTrackingScalingPolicyProps> {
        private java.lang.Number targetValue;
        private software.amazon.awscdk.services.cloudwatch.IMetric customMetric;
        private software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric predefinedMetric;
        private java.lang.String resourceLabel;
        private java.lang.Boolean disableScaleIn;
        private java.lang.String policyName;
        private software.amazon.awscdk.core.Duration scaleInCooldown;
        private software.amazon.awscdk.core.Duration scaleOutCooldown;

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getTargetValue}
         * @param targetValue The target value for the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetValue(java.lang.Number targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getCustomMetric}
         * @param customMetric A custom metric for application autoscaling.
         *                     The metric must track utilization. Scaling out will happen if the metric is higher than
         *                     the target value, scaling in will happen in the metric is lower than the target value.
         *                     <p>
         *                     Exactly one of customMetric or predefinedMetric must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customMetric(software.amazon.awscdk.services.cloudwatch.IMetric customMetric) {
            this.customMetric = customMetric;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getPredefinedMetric}
         * @param predefinedMetric A predefined metric for application autoscaling.
         *                         The metric must track utilization. Scaling out will happen if the metric is higher than
         *                         the target value, scaling in will happen in the metric is lower than the target value.
         *                         <p>
         *                         Exactly one of customMetric or predefinedMetric must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predefinedMetric(software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric predefinedMetric) {
            this.predefinedMetric = predefinedMetric;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getResourceLabel}
         * @param resourceLabel Identify the resource associated with the metric type.
         *                      Only used for predefined metric ALBRequestCountPerTarget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceLabel(java.lang.String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getDisableScaleIn}
         * @param disableScaleIn Indicates whether scale in by the target tracking policy is disabled.
         *                       If the value is true, scale in is disabled and the target tracking policy
         *                       won't remove capacity from the scalable resource. Otherwise, scale in is
         *                       enabled and the target tracking policy can remove capacity from the
         *                       scalable resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getPolicyName}
         * @param policyName A name for the scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getScaleInCooldown}
         * @param scaleInCooldown Period after a scale in activity completes before another scale in activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleInCooldown(software.amazon.awscdk.core.Duration scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getScaleOutCooldown}
         * @param scaleOutCooldown Period after a scale out activity completes before another scale out activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaleOutCooldown(software.amazon.awscdk.core.Duration scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BasicTargetTrackingScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BasicTargetTrackingScalingPolicyProps build() {
            return new Jsii$Proxy(targetValue, customMetric, predefinedMetric, resourceLabel, disableScaleIn, policyName, scaleInCooldown, scaleOutCooldown);
        }
    }

    /**
     * An implementation for {@link BasicTargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicTargetTrackingScalingPolicyProps {
        private final java.lang.Number targetValue;
        private final software.amazon.awscdk.services.cloudwatch.IMetric customMetric;
        private final software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric predefinedMetric;
        private final java.lang.String resourceLabel;
        private final java.lang.Boolean disableScaleIn;
        private final java.lang.String policyName;
        private final software.amazon.awscdk.core.Duration scaleInCooldown;
        private final software.amazon.awscdk.core.Duration scaleOutCooldown;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetValue = this.jsiiGet("targetValue", java.lang.Number.class);
            this.customMetric = this.jsiiGet("customMetric", software.amazon.awscdk.services.cloudwatch.IMetric.class);
            this.predefinedMetric = this.jsiiGet("predefinedMetric", software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric.class);
            this.resourceLabel = this.jsiiGet("resourceLabel", java.lang.String.class);
            this.disableScaleIn = this.jsiiGet("disableScaleIn", java.lang.Boolean.class);
            this.policyName = this.jsiiGet("policyName", java.lang.String.class);
            this.scaleInCooldown = this.jsiiGet("scaleInCooldown", software.amazon.awscdk.core.Duration.class);
            this.scaleOutCooldown = this.jsiiGet("scaleOutCooldown", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number targetValue, final software.amazon.awscdk.services.cloudwatch.IMetric customMetric, final software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric predefinedMetric, final java.lang.String resourceLabel, final java.lang.Boolean disableScaleIn, final java.lang.String policyName, final software.amazon.awscdk.core.Duration scaleInCooldown, final software.amazon.awscdk.core.Duration scaleOutCooldown) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetValue = java.util.Objects.requireNonNull(targetValue, "targetValue is required");
            this.customMetric = customMetric;
            this.predefinedMetric = predefinedMetric;
            this.resourceLabel = resourceLabel;
            this.disableScaleIn = disableScaleIn;
            this.policyName = policyName;
            this.scaleInCooldown = scaleInCooldown;
            this.scaleOutCooldown = scaleOutCooldown;
        }

        @Override
        public java.lang.Number getTargetValue() {
            return this.targetValue;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.IMetric getCustomMetric() {
            return this.customMetric;
        }

        @Override
        public software.amazon.awscdk.services.applicationautoscaling.PredefinedMetric getPredefinedMetric() {
            return this.predefinedMetric;
        }

        @Override
        public java.lang.String getResourceLabel() {
            return this.resourceLabel;
        }

        @Override
        public java.lang.Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        public software.amazon.awscdk.core.Duration getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        @Override
        public software.amazon.awscdk.core.Duration getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetValue", om.valueToTree(this.getTargetValue()));
            if (this.getCustomMetric() != null) {
                data.set("customMetric", om.valueToTree(this.getCustomMetric()));
            }
            if (this.getPredefinedMetric() != null) {
                data.set("predefinedMetric", om.valueToTree(this.getPredefinedMetric()));
            }
            if (this.getResourceLabel() != null) {
                data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
            }
            if (this.getDisableScaleIn() != null) {
                data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
            }
            if (this.getPolicyName() != null) {
                data.set("policyName", om.valueToTree(this.getPolicyName()));
            }
            if (this.getScaleInCooldown() != null) {
                data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
            }
            if (this.getScaleOutCooldown() != null) {
                data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-applicationautoscaling.BasicTargetTrackingScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BasicTargetTrackingScalingPolicyProps.Jsii$Proxy that = (BasicTargetTrackingScalingPolicyProps.Jsii$Proxy) o;

            if (!targetValue.equals(that.targetValue)) return false;
            if (this.customMetric != null ? !this.customMetric.equals(that.customMetric) : that.customMetric != null) return false;
            if (this.predefinedMetric != null ? !this.predefinedMetric.equals(that.predefinedMetric) : that.predefinedMetric != null) return false;
            if (this.resourceLabel != null ? !this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel != null) return false;
            if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
            if (this.policyName != null ? !this.policyName.equals(that.policyName) : that.policyName != null) return false;
            if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
            return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
        }

        @Override
        public int hashCode() {
            int result = this.targetValue.hashCode();
            result = 31 * result + (this.customMetric != null ? this.customMetric.hashCode() : 0);
            result = 31 * result + (this.predefinedMetric != null ? this.predefinedMetric.hashCode() : 0);
            result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
            result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
            result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
            result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
            result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
            return result;
        }
    }
}
