package software.amazon.awscdk.services.applicationautoscaling;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.906Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.BasicStepScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(BasicStepScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BasicStepScalingPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Metric to scale on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric getMetric();

    /**
     * The intervals for scaling.
     * <p>
     * Maps a range of metric values to a particular scaling behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps();

    /**
     * How the adjustment numbers inside 'intervals' are interpreted.
     * <p>
     * Default: ChangeInCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.AdjustmentType getAdjustmentType() {
        return null;
    }

    /**
     * Grace period after scaling activity.
     * <p>
     * Subsequent scale outs during the cooldown period are squashed so that only
     * the biggest scale out happens.
     * <p>
     * Subsequent scale ins during the cooldown period are ignored.
     * <p>
     * Default: No cooldown period
     * <p>
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getCooldown() {
        return null;
    }

    /**
     * Minimum absolute number to adjust capacity with as result of percentage scaling.
     * <p>
     * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
     * the minimum absolute effect size.
     * <p>
     * Default: No minimum scaling effect
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinAdjustmentMagnitude() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BasicStepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BasicStepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BasicStepScalingPolicyProps> {
        private software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        private software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType;
        private software.amazon.awscdk.core.Duration cooldown;
        private java.lang.Number minAdjustmentMagnitude;

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getMetric}
         * @param metric Metric to scale on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.metric = metric;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getScalingSteps}
         * @param scalingSteps The intervals for scaling. This parameter is required.
         *                     Maps a range of metric values to a particular scaling behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingSteps(java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps) {
            this.scalingSteps = scalingSteps;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getAdjustmentType}
         * @param adjustmentType How the adjustment numbers inside 'intervals' are interpreted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getCooldown}
         * @param cooldown Grace period after scaling activity.
         *                 Subsequent scale outs during the cooldown period are squashed so that only
         *                 the biggest scale out happens.
         *                 <p>
         *                 Subsequent scale ins during the cooldown period are ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.core.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link BasicStepScalingPolicyProps#getMinAdjustmentMagnitude}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling.
         *                               Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         *                               the minimum absolute effect size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BasicStepScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BasicStepScalingPolicyProps build() {
            return new Jsii$Proxy(metric, scalingSteps, adjustmentType, cooldown, minAdjustmentMagnitude);
        }
    }

    /**
     * An implementation for {@link BasicStepScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicStepScalingPolicyProps {
        private final software.amazon.awscdk.services.cloudwatch.IMetric metric;
        private final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        private final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType;
        private final software.amazon.awscdk.core.Duration cooldown;
        private final java.lang.Number minAdjustmentMagnitude;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metric = this.jsiiGet("metric", software.amazon.awscdk.services.cloudwatch.IMetric.class);
            this.scalingSteps = this.jsiiGet("scalingSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.ScalingInterval.class)));
            this.adjustmentType = this.jsiiGet("adjustmentType", software.amazon.awscdk.services.applicationautoscaling.AdjustmentType.class);
            this.cooldown = this.jsiiGet("cooldown", software.amazon.awscdk.core.Duration.class);
            this.minAdjustmentMagnitude = this.jsiiGet("minAdjustmentMagnitude", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.cloudwatch.IMetric metric, final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps, final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType, final software.amazon.awscdk.core.Duration cooldown, final java.lang.Number minAdjustmentMagnitude) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metric = java.util.Objects.requireNonNull(metric, "metric is required");
            this.scalingSteps = java.util.Objects.requireNonNull(scalingSteps, "scalingSteps is required");
            this.adjustmentType = adjustmentType;
            this.cooldown = cooldown;
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        @Override
        public software.amazon.awscdk.services.cloudwatch.IMetric getMetric() {
            return this.metric;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
            return this.scalingSteps;
        }

        @Override
        public software.amazon.awscdk.services.applicationautoscaling.AdjustmentType getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public software.amazon.awscdk.core.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public java.lang.Number getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metric", om.valueToTree(this.getMetric()));
            data.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
            if (this.getAdjustmentType() != null) {
                data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getMinAdjustmentMagnitude() != null) {
                data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-applicationautoscaling.BasicStepScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BasicStepScalingPolicyProps.Jsii$Proxy that = (BasicStepScalingPolicyProps.Jsii$Proxy) o;

            if (!metric.equals(that.metric)) return false;
            if (!scalingSteps.equals(that.scalingSteps)) return false;
            if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            return this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude == null;
        }

        @Override
        public int hashCode() {
            int result = this.metric.hashCode();
            result = 31 * result + (this.scalingSteps.hashCode());
            result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
            return result;
        }
    }
}
