package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Properties for a ScalableTableAttribute.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.905Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.BaseScalableAttributeProps")
@software.amazon.jsii.Jsii.Proxy(BaseScalableAttributeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseScalableAttributeProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps {

    /**
     * Scalable dimension of the attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDimension();

    /**
     * Resource ID of the attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * Role to use for scaling.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole();

    /**
     * Service namespace of the scalable attribute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace getServiceNamespace();

    /**
     * @return a {@link Builder} of {@link BaseScalableAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseScalableAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseScalableAttributeProps> {
        private java.lang.String dimension;
        private java.lang.String resourceId;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace serviceNamespace;
        private java.lang.Number maxCapacity;
        private java.lang.Number minCapacity;

        /**
         * Sets the value of {@link BaseScalableAttributeProps#getDimension}
         * @param dimension Scalable dimension of the attribute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimension(java.lang.String dimension) {
            this.dimension = dimension;
            return this;
        }

        /**
         * Sets the value of {@link BaseScalableAttributeProps#getResourceId}
         * @param resourceId Resource ID of the attribute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link BaseScalableAttributeProps#getRole}
         * @param role Role to use for scaling. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link BaseScalableAttributeProps#getServiceNamespace}
         * @param serviceNamespace Service namespace of the scalable attribute. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        /**
         * Sets the value of {@link BaseScalableAttributeProps#getMaxCapacity}
         * @param maxCapacity Maximum capacity to scale to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link BaseScalableAttributeProps#getMinCapacity}
         * @param minCapacity Minimum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseScalableAttributeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseScalableAttributeProps build() {
            return new Jsii$Proxy(dimension, resourceId, role, serviceNamespace, maxCapacity, minCapacity);
        }
    }

    /**
     * An implementation for {@link BaseScalableAttributeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseScalableAttributeProps {
        private final java.lang.String dimension;
        private final java.lang.String resourceId;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace serviceNamespace;
        private final java.lang.Number maxCapacity;
        private final java.lang.Number minCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dimension = this.jsiiGet("dimension", java.lang.String.class);
            this.resourceId = this.jsiiGet("resourceId", java.lang.String.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.serviceNamespace = this.jsiiGet("serviceNamespace", software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace.class);
            this.maxCapacity = this.jsiiGet("maxCapacity", java.lang.Number.class);
            this.minCapacity = this.jsiiGet("minCapacity", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String dimension, final java.lang.String resourceId, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace serviceNamespace, final java.lang.Number maxCapacity, final java.lang.Number minCapacity) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dimension = java.util.Objects.requireNonNull(dimension, "dimension is required");
            this.resourceId = java.util.Objects.requireNonNull(resourceId, "resourceId is required");
            this.role = java.util.Objects.requireNonNull(role, "role is required");
            this.serviceNamespace = java.util.Objects.requireNonNull(serviceNamespace, "serviceNamespace is required");
            this.maxCapacity = java.util.Objects.requireNonNull(maxCapacity, "maxCapacity is required");
            this.minCapacity = minCapacity;
        }

        @Override
        public java.lang.String getDimension() {
            return this.dimension;
        }

        @Override
        public java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dimension", om.valueToTree(this.getDimension()));
            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("role", om.valueToTree(this.getRole()));
            data.set("serviceNamespace", om.valueToTree(this.getServiceNamespace()));
            data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-applicationautoscaling.BaseScalableAttributeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseScalableAttributeProps.Jsii$Proxy that = (BaseScalableAttributeProps.Jsii$Proxy) o;

            if (!dimension.equals(that.dimension)) return false;
            if (!resourceId.equals(that.resourceId)) return false;
            if (!role.equals(that.role)) return false;
            if (!serviceNamespace.equals(that.serviceNamespace)) return false;
            if (!maxCapacity.equals(that.maxCapacity)) return false;
            return this.minCapacity != null ? this.minCapacity.equals(that.minCapacity) : that.minCapacity == null;
        }

        @Override
        public int hashCode() {
            int result = this.dimension.hashCode();
            result = 31 * result + (this.resourceId.hashCode());
            result = 31 * result + (this.role.hashCode());
            result = 31 * result + (this.serviceNamespace.hashCode());
            result = 31 * result + (this.maxCapacity.hashCode());
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            return result;
        }
    }
}
