package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Represent an attribute for which autoscaling can be configured.
 * <p>
 * This class is basically a light wrapper around ScalableTarget, but with
 * all methods protected instead of public so they can be selectively
 * exposed and/or more specific versions of them can be exposed by derived
 * classes for individual services support autoscaling.
 * <p>
 * Typical use cases:
 * <p>
 * <ul>
 * <li>Hide away the PredefinedMetric enum for target tracking policies.</li>
 * <li>Don't expose all scaling methods (for example Dynamo tables don't support
 * Step Scaling, so the Dynamo subclass won't expose this method).</li>
 * </ul>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:02.904Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.applicationautoscaling.$Module.class, fqn = "@aws-cdk/aws-applicationautoscaling.BaseScalableAttribute")
public abstract class BaseScalableAttribute extends software.amazon.awscdk.core.Construct {

    protected BaseScalableAttribute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseScalableAttribute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BaseScalableAttribute(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.BaseScalableAttributeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in based on a metric value.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void doScaleOnMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.BasicStepScalingPolicyProps props) {
        this.jsiiCall("doScaleOnMetric", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in based on time.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void doScaleOnSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.ScalingSchedule props) {
        this.jsiiCall("doScaleOnSchedule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Scale out or in in order to keep a metric around a target value.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void doScaleToTrackMetric(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.BasicTargetTrackingScalingPolicyProps props) {
        this.jsiiCall("doScaleToTrackMetric", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.BaseScalableAttributeProps getProps() {
        return this.jsiiGet("props", software.amazon.awscdk.services.applicationautoscaling.BaseScalableAttributeProps.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.applicationautoscaling.BaseScalableAttribute {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }
    }
}
