package software.amazon.awscdk.services.apigateway;

/**
 * RateLimitedApiKey properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:23.587Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RateLimitedApiKeyProps")
@software.amazon.jsii.Jsii.Proxy(RateLimitedApiKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RateLimitedApiKeyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ApiKeyProps {

    /**
     * API Stages to be associated with the RateLimitedApiKey.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages() {
        return null;
    }

    /**
     * Number of requests clients can make in a given time period.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.QuotaSettings getQuota() {
        return null;
    }

    /**
     * Overall throttle settings for the API.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RateLimitedApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RateLimitedApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RateLimitedApiKeyProps> {
        private java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages;
        private software.amazon.awscdk.services.apigateway.QuotaSettings quota;
        private software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;
        private java.lang.String customerId;
        private java.lang.String description;
        private java.lang.Boolean enabled;
        private java.lang.Boolean generateDistinctId;
        private java.util.List<software.amazon.awscdk.services.apigateway.RestApi> resources;
        private java.lang.String apiKeyName;
        private java.lang.String value;
        private software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getApiStages}
         * @param apiStages API Stages to be associated with the RateLimitedApiKey.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages) {
            this.apiStages = apiStages;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getQuota}
         * @param quota Number of requests clients can make in a given time period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(software.amazon.awscdk.services.apigateway.QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getThrottle}
         * @param throttle Overall throttle settings for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getCustomerId}
         * @param customerId An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerId(java.lang.String customerId) {
            this.customerId = customerId;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getDescription}
         * @param description A description of the purpose of the API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getEnabled}
         * @param enabled Indicates whether the API key can be used by clients.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getGenerateDistinctId}
         * @param generateDistinctId Specifies whether the key identifier is distinct from the created API key value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateDistinctId(java.lang.Boolean generateDistinctId) {
            this.generateDistinctId = generateDistinctId;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getResources}
         * @param resources [disable-awslint:ref-via-interface] A list of resources this api key is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<software.amazon.awscdk.services.apigateway.RestApi> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getApiKeyName}
         * @param apiKeyName A name for the API key.
         *                   If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyName(java.lang.String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getValue}
         * @param value The value of the API key.
         *              Must be at least 20 characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getDefaultCorsPreflightOptions}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources.
         *                                    You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getDefaultIntegration}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getDefaultMethodOptions}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RateLimitedApiKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RateLimitedApiKeyProps build() {
            return new Jsii$Proxy(apiStages, quota, throttle, customerId, description, enabled, generateDistinctId, resources, apiKeyName, value, defaultCorsPreflightOptions, defaultIntegration, defaultMethodOptions);
        }
    }

    /**
     * An implementation for {@link RateLimitedApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitedApiKeyProps {
        private final java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages;
        private final software.amazon.awscdk.services.apigateway.QuotaSettings quota;
        private final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;
        private final java.lang.String customerId;
        private final java.lang.String description;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean generateDistinctId;
        private final java.util.List<software.amazon.awscdk.services.apigateway.RestApi> resources;
        private final java.lang.String apiKeyName;
        private final java.lang.String value;
        private final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private final software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiStages = this.jsiiGet("apiStages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage.class)));
            this.quota = this.jsiiGet("quota", software.amazon.awscdk.services.apigateway.QuotaSettings.class);
            this.throttle = this.jsiiGet("throttle", software.amazon.awscdk.services.apigateway.ThrottleSettings.class);
            this.customerId = this.jsiiGet("customerId", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.enabled = this.jsiiGet("enabled", java.lang.Boolean.class);
            this.generateDistinctId = this.jsiiGet("generateDistinctId", java.lang.Boolean.class);
            this.resources = this.jsiiGet("resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.RestApi.class)));
            this.apiKeyName = this.jsiiGet("apiKeyName", java.lang.String.class);
            this.value = this.jsiiGet("value", java.lang.String.class);
            this.defaultCorsPreflightOptions = this.jsiiGet("defaultCorsPreflightOptions", software.amazon.awscdk.services.apigateway.CorsOptions.class);
            this.defaultIntegration = this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
            this.defaultMethodOptions = this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages, final software.amazon.awscdk.services.apigateway.QuotaSettings quota, final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle, final java.lang.String customerId, final java.lang.String description, final java.lang.Boolean enabled, final java.lang.Boolean generateDistinctId, final java.util.List<software.amazon.awscdk.services.apigateway.RestApi> resources, final java.lang.String apiKeyName, final java.lang.String value, final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions, final software.amazon.awscdk.services.apigateway.Integration defaultIntegration, final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiStages = apiStages;
            this.quota = quota;
            this.throttle = throttle;
            this.customerId = customerId;
            this.description = description;
            this.enabled = enabled;
            this.generateDistinctId = generateDistinctId;
            this.resources = resources;
            this.apiKeyName = apiKeyName;
            this.value = value;
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            this.defaultIntegration = defaultIntegration;
            this.defaultMethodOptions = defaultMethodOptions;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages() {
            return this.apiStages;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.QuotaSettings getQuota() {
            return this.quota;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        public java.lang.String getCustomerId() {
            return this.customerId;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public java.lang.Boolean getGenerateDistinctId() {
            return this.generateDistinctId;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources() {
            return this.resources;
        }

        @Override
        public java.lang.String getApiKeyName() {
            return this.apiKeyName;
        }

        @Override
        public java.lang.String getValue() {
            return this.value;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.CorsOptions getDefaultCorsPreflightOptions() {
            return this.defaultCorsPreflightOptions;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.defaultIntegration;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.defaultMethodOptions;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiStages() != null) {
                data.set("apiStages", om.valueToTree(this.getApiStages()));
            }
            if (this.getQuota() != null) {
                data.set("quota", om.valueToTree(this.getQuota()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }
            if (this.getCustomerId() != null) {
                data.set("customerId", om.valueToTree(this.getCustomerId()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getGenerateDistinctId() != null) {
                data.set("generateDistinctId", om.valueToTree(this.getGenerateDistinctId()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getApiKeyName() != null) {
                data.set("apiKeyName", om.valueToTree(this.getApiKeyName()));
            }
            if (this.getValue() != null) {
                data.set("value", om.valueToTree(this.getValue()));
            }
            if (this.getDefaultCorsPreflightOptions() != null) {
                data.set("defaultCorsPreflightOptions", om.valueToTree(this.getDefaultCorsPreflightOptions()));
            }
            if (this.getDefaultIntegration() != null) {
                data.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
            }
            if (this.getDefaultMethodOptions() != null) {
                data.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.RateLimitedApiKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RateLimitedApiKeyProps.Jsii$Proxy that = (RateLimitedApiKeyProps.Jsii$Proxy) o;

            if (this.apiStages != null ? !this.apiStages.equals(that.apiStages) : that.apiStages != null) return false;
            if (this.quota != null ? !this.quota.equals(that.quota) : that.quota != null) return false;
            if (this.throttle != null ? !this.throttle.equals(that.throttle) : that.throttle != null) return false;
            if (this.customerId != null ? !this.customerId.equals(that.customerId) : that.customerId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.generateDistinctId != null ? !this.generateDistinctId.equals(that.generateDistinctId) : that.generateDistinctId != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            if (this.apiKeyName != null ? !this.apiKeyName.equals(that.apiKeyName) : that.apiKeyName != null) return false;
            if (this.value != null ? !this.value.equals(that.value) : that.value != null) return false;
            if (this.defaultCorsPreflightOptions != null ? !this.defaultCorsPreflightOptions.equals(that.defaultCorsPreflightOptions) : that.defaultCorsPreflightOptions != null) return false;
            if (this.defaultIntegration != null ? !this.defaultIntegration.equals(that.defaultIntegration) : that.defaultIntegration != null) return false;
            return this.defaultMethodOptions != null ? this.defaultMethodOptions.equals(that.defaultMethodOptions) : that.defaultMethodOptions == null;
        }

        @Override
        public int hashCode() {
            int result = this.apiStages != null ? this.apiStages.hashCode() : 0;
            result = 31 * result + (this.quota != null ? this.quota.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            result = 31 * result + (this.customerId != null ? this.customerId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.generateDistinctId != null ? this.generateDistinctId.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.apiKeyName != null ? this.apiKeyName.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.defaultCorsPreflightOptions != null ? this.defaultCorsPreflightOptions.hashCode() : 0);
            result = 31 * result + (this.defaultIntegration != null ? this.defaultIntegration.hashCode() : 0);
            result = 31 * result + (this.defaultMethodOptions != null ? this.defaultMethodOptions.hashCode() : 0);
            return result;
        }
    }
}
