package software.amazon.awscdk.services.acmpca;

/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 * <p>
 * The <code>AWS::ACMPCA::Certificate</code> resource is used to issue a certificate using your private certificate authority. For more information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate</a> action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.acmpca.*;
 * CfnCertificate cfnCertificate = CfnCertificate.Builder.create(this, "MyCfnCertificate")
 *         .certificateAuthorityArn("certificateAuthorityArn")
 *         .certificateSigningRequest("certificateSigningRequest")
 *         .signingAlgorithm("signingAlgorithm")
 *         .validity(ValidityProperty.builder()
 *                 .type("type")
 *                 .value(123)
 *                 .build())
 *         // the properties below are optional
 *         .apiPassthrough(ApiPassthroughProperty.builder()
 *                 .extensions(ExtensionsProperty.builder()
 *                         .certificatePolicies(List.of(PolicyInformationProperty.builder()
 *                                 .certPolicyId("certPolicyId")
 *                                 // the properties below are optional
 *                                 .policyQualifiers(List.of(PolicyQualifierInfoProperty.builder()
 *                                         .policyQualifierId("policyQualifierId")
 *                                         .qualifier(QualifierProperty.builder()
 *                                                 .cpsUri("cpsUri")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .customExtensions(List.of(CustomExtensionProperty.builder()
 *                                 .objectIdentifier("objectIdentifier")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .critical(false)
 *                                 .build()))
 *                         .extendedKeyUsage(List.of(ExtendedKeyUsageProperty.builder()
 *                                 .extendedKeyUsageObjectIdentifier("extendedKeyUsageObjectIdentifier")
 *                                 .extendedKeyUsageType("extendedKeyUsageType")
 *                                 .build()))
 *                         .keyUsage(KeyUsageProperty.builder()
 *                                 .crlSign(false)
 *                                 .dataEncipherment(false)
 *                                 .decipherOnly(false)
 *                                 .digitalSignature(false)
 *                                 .encipherOnly(false)
 *                                 .keyAgreement(false)
 *                                 .keyCertSign(false)
 *                                 .keyEncipherment(false)
 *                                 .nonRepudiation(false)
 *                                 .build())
 *                         .subjectAlternativeNames(List.of(GeneralNameProperty.builder()
 *                                 .directoryName(SubjectProperty.builder()
 *                                         .commonName("commonName")
 *                                         .country("country")
 *                                         .customAttributes(List.of(CustomAttributeProperty.builder()
 *                                                 .objectIdentifier("objectIdentifier")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .distinguishedNameQualifier("distinguishedNameQualifier")
 *                                         .generationQualifier("generationQualifier")
 *                                         .givenName("givenName")
 *                                         .initials("initials")
 *                                         .locality("locality")
 *                                         .organization("organization")
 *                                         .organizationalUnit("organizationalUnit")
 *                                         .pseudonym("pseudonym")
 *                                         .serialNumber("serialNumber")
 *                                         .state("state")
 *                                         .surname("surname")
 *                                         .title("title")
 *                                         .build())
 *                                 .dnsName("dnsName")
 *                                 .ediPartyName(EdiPartyNameProperty.builder()
 *                                         .nameAssigner("nameAssigner")
 *                                         .partyName("partyName")
 *                                         .build())
 *                                 .ipAddress("ipAddress")
 *                                 .otherName(OtherNameProperty.builder()
 *                                         .typeId("typeId")
 *                                         .value("value")
 *                                         .build())
 *                                 .registeredId("registeredId")
 *                                 .rfc822Name("rfc822Name")
 *                                 .uniformResourceIdentifier("uniformResourceIdentifier")
 *                                 .build()))
 *                         .build())
 *                 .subject(SubjectProperty.builder()
 *                         .commonName("commonName")
 *                         .country("country")
 *                         .customAttributes(List.of(CustomAttributeProperty.builder()
 *                                 .objectIdentifier("objectIdentifier")
 *                                 .value("value")
 *                                 .build()))
 *                         .distinguishedNameQualifier("distinguishedNameQualifier")
 *                         .generationQualifier("generationQualifier")
 *                         .givenName("givenName")
 *                         .initials("initials")
 *                         .locality("locality")
 *                         .organization("organization")
 *                         .organizationalUnit("organizationalUnit")
 *                         .pseudonym("pseudonym")
 *                         .serialNumber("serialNumber")
 *                         .state("state")
 *                         .surname("surname")
 *                         .title("title")
 *                         .build())
 *                 .build())
 *         .templateArn("templateArn")
 *         .validityNotBefore(ValidityProperty.builder()
 *                 .type("type")
 *                 .value(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:23.100Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate")
public class CfnCertificate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.acmpca.CfnCertificate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ACMPCA::Certificate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCertificate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.acmpca.CfnCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the issued certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The issued Base64 PEM-encoded certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCertificate() {
        return software.amazon.jsii.Kernel.get(this, "attrCertificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) for the private CA issues the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateAuthorityArn() {
        return software.amazon.jsii.Kernel.get(this, "certificateAuthorityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the private CA issues the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateAuthorityArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateAuthorityArn", java.util.Objects.requireNonNull(value, "certificateAuthorityArn is required"));
    }

    /**
     * The certificate signing request (CSR) for the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateSigningRequest() {
        return software.amazon.jsii.Kernel.get(this, "certificateSigningRequest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The certificate signing request (CSR) for the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCertificateSigningRequest(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "certificateSigningRequest", java.util.Objects.requireNonNull(value, "certificateSigningRequest is required"));
    }

    /**
     * The name of the algorithm that will be used to sign the certificate to be issued.
     * <p>
     * This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.
     * <p>
     * <blockquote>
     * <p>
     * The specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA's secret key.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSigningAlgorithm() {
        return software.amazon.jsii.Kernel.get(this, "signingAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the algorithm that will be used to sign the certificate to be issued.
     * <p>
     * This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.
     * <p>
     * <blockquote>
     * <p>
     * The specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA's secret key.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSigningAlgorithm(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "signingAlgorithm", java.util.Objects.requireNonNull(value, "signingAlgorithm is required"));
    }

    /**
     * The period of time during which the certificate will be valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getValidity() {
        return software.amazon.jsii.Kernel.get(this, "validity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The period of time during which the certificate will be valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.acmpca.CfnCertificate.ValidityProperty value) {
        software.amazon.jsii.Kernel.set(this, "validity", java.util.Objects.requireNonNull(value, "validity is required"));
    }

    /**
     * The period of time during which the certificate will be valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "validity", java.util.Objects.requireNonNull(value, "validity is required"));
    }

    /**
     * Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApiPassthrough() {
        return software.amazon.jsii.Kernel.get(this, "apiPassthrough", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiPassthrough(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "apiPassthrough", value);
    }

    /**
     * Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiPassthrough(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.acmpca.CfnCertificate.ApiPassthroughProperty value) {
        software.amazon.jsii.Kernel.set(this, "apiPassthrough", value);
    }

    /**
     * Specifies a custom configuration template to use when issuing a certificate.
     * <p>
     * If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For more information about ACM Private CA templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateArn() {
        return software.amazon.jsii.Kernel.get(this, "templateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies a custom configuration template to use when issuing a certificate.
     * <p>
     * If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For more information about ACM Private CA templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateArn", value);
    }

    /**
     * Information describing the start of the validity period of the certificate.
     * <p>
     * This parameter sets the “Not Before" date for the certificate.
     * <p>
     * By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value.
     * <p>
     * Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.
     * <p>
     * The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getValidityNotBefore() {
        return software.amazon.jsii.Kernel.get(this, "validityNotBefore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information describing the start of the validity period of the certificate.
     * <p>
     * This parameter sets the “Not Before" date for the certificate.
     * <p>
     * By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value.
     * <p>
     * Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.
     * <p>
     * The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidityNotBefore(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.acmpca.CfnCertificate.ValidityProperty value) {
        software.amazon.jsii.Kernel.set(this, "validityNotBefore", value);
    }

    /**
     * Information describing the start of the validity period of the certificate.
     * <p>
     * This parameter sets the “Not Before" date for the certificate.
     * <p>
     * By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value.
     * <p>
     * Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.
     * <p>
     * The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValidityNotBefore(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "validityNotBefore", value);
    }
    /**
     * Contains X.509 certificate information to be placed in an issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
     * <p>
     * If conflicting or duplicate certificate information is supplied from other sources, ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of operation rules</a> to determine what information is used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * ApiPassthroughProperty apiPassthroughProperty = ApiPassthroughProperty.builder()
     *         .extensions(ExtensionsProperty.builder()
     *                 .certificatePolicies(List.of(PolicyInformationProperty.builder()
     *                         .certPolicyId("certPolicyId")
     *                         // the properties below are optional
     *                         .policyQualifiers(List.of(PolicyQualifierInfoProperty.builder()
     *                                 .policyQualifierId("policyQualifierId")
     *                                 .qualifier(QualifierProperty.builder()
     *                                         .cpsUri("cpsUri")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 .customExtensions(List.of(CustomExtensionProperty.builder()
     *                         .objectIdentifier("objectIdentifier")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .critical(false)
     *                         .build()))
     *                 .extendedKeyUsage(List.of(ExtendedKeyUsageProperty.builder()
     *                         .extendedKeyUsageObjectIdentifier("extendedKeyUsageObjectIdentifier")
     *                         .extendedKeyUsageType("extendedKeyUsageType")
     *                         .build()))
     *                 .keyUsage(KeyUsageProperty.builder()
     *                         .crlSign(false)
     *                         .dataEncipherment(false)
     *                         .decipherOnly(false)
     *                         .digitalSignature(false)
     *                         .encipherOnly(false)
     *                         .keyAgreement(false)
     *                         .keyCertSign(false)
     *                         .keyEncipherment(false)
     *                         .nonRepudiation(false)
     *                         .build())
     *                 .subjectAlternativeNames(List.of(GeneralNameProperty.builder()
     *                         .directoryName(SubjectProperty.builder()
     *                                 .commonName("commonName")
     *                                 .country("country")
     *                                 .customAttributes(List.of(CustomAttributeProperty.builder()
     *                                         .objectIdentifier("objectIdentifier")
     *                                         .value("value")
     *                                         .build()))
     *                                 .distinguishedNameQualifier("distinguishedNameQualifier")
     *                                 .generationQualifier("generationQualifier")
     *                                 .givenName("givenName")
     *                                 .initials("initials")
     *                                 .locality("locality")
     *                                 .organization("organization")
     *                                 .organizationalUnit("organizationalUnit")
     *                                 .pseudonym("pseudonym")
     *                                 .serialNumber("serialNumber")
     *                                 .state("state")
     *                                 .surname("surname")
     *                                 .title("title")
     *                                 .build())
     *                         .dnsName("dnsName")
     *                         .ediPartyName(EdiPartyNameProperty.builder()
     *                                 .nameAssigner("nameAssigner")
     *                                 .partyName("partyName")
     *                                 .build())
     *                         .ipAddress("ipAddress")
     *                         .otherName(OtherNameProperty.builder()
     *                                 .typeId("typeId")
     *                                 .value("value")
     *                                 .build())
     *                         .registeredId("registeredId")
     *                         .rfc822Name("rfc822Name")
     *                         .uniformResourceIdentifier("uniformResourceIdentifier")
     *                         .build()))
     *                 .build())
     *         .subject(SubjectProperty.builder()
     *                 .commonName("commonName")
     *                 .country("country")
     *                 .customAttributes(List.of(CustomAttributeProperty.builder()
     *                         .objectIdentifier("objectIdentifier")
     *                         .value("value")
     *                         .build()))
     *                 .distinguishedNameQualifier("distinguishedNameQualifier")
     *                 .generationQualifier("generationQualifier")
     *                 .givenName("givenName")
     *                 .initials("initials")
     *                 .locality("locality")
     *                 .organization("organization")
     *                 .organizationalUnit("organizationalUnit")
     *                 .pseudonym("pseudonym")
     *                 .serialNumber("serialNumber")
     *                 .state("state")
     *                 .surname("surname")
     *                 .title("title")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.ApiPassthroughProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiPassthroughProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiPassthroughProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies X.509 extension information for a certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtensions() {
            return null;
        }

        /**
         * Contains information about the certificate subject.
         * <p>
         * The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubject() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiPassthroughProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiPassthroughProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiPassthroughProperty> {
            java.lang.Object extensions;
            java.lang.Object subject;

            /**
             * Sets the value of {@link ApiPassthroughProperty#getExtensions}
             * @param extensions Specifies X.509 extension information for a certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extensions(software.amazon.awscdk.core.IResolvable extensions) {
                this.extensions = extensions;
                return this;
            }

            /**
             * Sets the value of {@link ApiPassthroughProperty#getExtensions}
             * @param extensions Specifies X.509 extension information for a certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extensions(software.amazon.awscdk.services.acmpca.CfnCertificate.ExtensionsProperty extensions) {
                this.extensions = extensions;
                return this;
            }

            /**
             * Sets the value of {@link ApiPassthroughProperty#getSubject}
             * @param subject Contains information about the certificate subject.
             *                The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subject(software.amazon.awscdk.core.IResolvable subject) {
                this.subject = subject;
                return this;
            }

            /**
             * Sets the value of {@link ApiPassthroughProperty#getSubject}
             * @param subject Contains information about the certificate subject.
             *                The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subject(software.amazon.awscdk.services.acmpca.CfnCertificate.SubjectProperty subject) {
                this.subject = subject;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiPassthroughProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiPassthroughProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiPassthroughProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiPassthroughProperty {
            private final java.lang.Object extensions;
            private final java.lang.Object subject;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.extensions = software.amazon.jsii.Kernel.get(this, "extensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subject = software.amazon.jsii.Kernel.get(this, "subject", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.extensions = builder.extensions;
                this.subject = builder.subject;
            }

            @Override
            public final java.lang.Object getExtensions() {
                return this.extensions;
            }

            @Override
            public final java.lang.Object getSubject() {
                return this.subject;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExtensions() != null) {
                    data.set("extensions", om.valueToTree(this.getExtensions()));
                }
                if (this.getSubject() != null) {
                    data.set("subject", om.valueToTree(this.getSubject()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.ApiPassthroughProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiPassthroughProperty.Jsii$Proxy that = (ApiPassthroughProperty.Jsii$Proxy) o;

                if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) return false;
                return this.subject != null ? this.subject.equals(that.subject) : that.subject == null;
            }

            @Override
            public final int hashCode() {
                int result = this.extensions != null ? this.extensions.hashCode() : 0;
                result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the X.500 relative distinguished name (RDN).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * CustomAttributeProperty customAttributeProperty = CustomAttributeProperty.builder()
     *         .objectIdentifier("objectIdentifier")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.CustomAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectIdentifier();

        /**
         * Specifies the attribute value of relative distinguished name (RDN).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link CustomAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomAttributeProperty> {
            java.lang.String objectIdentifier;
            java.lang.String value;

            /**
             * Sets the value of {@link CustomAttributeProperty#getObjectIdentifier}
             * @param objectIdentifier Specifies the object identifier (OID) of the attribute type of the relative distinguished name (RDN). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectIdentifier(java.lang.String objectIdentifier) {
                this.objectIdentifier = objectIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link CustomAttributeProperty#getValue}
             * @param value Specifies the attribute value of relative distinguished name (RDN). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomAttributeProperty {
            private final java.lang.String objectIdentifier;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectIdentifier = software.amazon.jsii.Kernel.get(this, "objectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectIdentifier = java.util.Objects.requireNonNull(builder.objectIdentifier, "objectIdentifier is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getObjectIdentifier() {
                return this.objectIdentifier;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectIdentifier", om.valueToTree(this.getObjectIdentifier()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.CustomAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomAttributeProperty.Jsii$Proxy that = (CustomAttributeProperty.Jsii$Proxy) o;

                if (!objectIdentifier.equals(that.objectIdentifier)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.objectIdentifier.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the X.509 extension information for a certificate.
     * <p>
     * Extensions present in <code>CustomExtensions</code> follow the <code>ApiPassthrough</code> <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">template rules</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * CustomExtensionProperty customExtensionProperty = CustomExtensionProperty.builder()
     *         .objectIdentifier("objectIdentifier")
     *         .value("value")
     *         // the properties below are optional
     *         .critical(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.CustomExtensionProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomExtensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomExtensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectIdentifier();

        /**
         * Specifies the base64-encoded value of the X.509 extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * Specifies the critical flag of the X.509 extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCritical() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomExtensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomExtensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomExtensionProperty> {
            java.lang.String objectIdentifier;
            java.lang.String value;
            java.lang.Object critical;

            /**
             * Sets the value of {@link CustomExtensionProperty#getObjectIdentifier}
             * @param objectIdentifier Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectIdentifier(java.lang.String objectIdentifier) {
                this.objectIdentifier = objectIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link CustomExtensionProperty#getValue}
             * @param value Specifies the base64-encoded value of the X.509 extension. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link CustomExtensionProperty#getCritical}
             * @param critical Specifies the critical flag of the X.509 extension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder critical(java.lang.Boolean critical) {
                this.critical = critical;
                return this;
            }

            /**
             * Sets the value of {@link CustomExtensionProperty#getCritical}
             * @param critical Specifies the critical flag of the X.509 extension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder critical(software.amazon.awscdk.core.IResolvable critical) {
                this.critical = critical;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomExtensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomExtensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomExtensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomExtensionProperty {
            private final java.lang.String objectIdentifier;
            private final java.lang.String value;
            private final java.lang.Object critical;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectIdentifier = software.amazon.jsii.Kernel.get(this, "objectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.critical = software.amazon.jsii.Kernel.get(this, "critical", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectIdentifier = java.util.Objects.requireNonNull(builder.objectIdentifier, "objectIdentifier is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.critical = builder.critical;
            }

            @Override
            public final java.lang.String getObjectIdentifier() {
                return this.objectIdentifier;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.Object getCritical() {
                return this.critical;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectIdentifier", om.valueToTree(this.getObjectIdentifier()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getCritical() != null) {
                    data.set("critical", om.valueToTree(this.getCritical()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.CustomExtensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomExtensionProperty.Jsii$Proxy that = (CustomExtensionProperty.Jsii$Proxy) o;

                if (!objectIdentifier.equals(that.objectIdentifier)) return false;
                if (!value.equals(that.value)) return false;
                return this.critical != null ? this.critical.equals(that.critical) : that.critical == null;
            }

            @Override
            public final int hashCode() {
                int result = this.objectIdentifier.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.critical != null ? this.critical.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an Electronic Data Interchange (EDI) entity as described in as defined in [Subject Alternative Name](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) in RFC 5280.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * EdiPartyNameProperty ediPartyNameProperty = EdiPartyNameProperty.builder()
     *         .nameAssigner("nameAssigner")
     *         .partyName("partyName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.EdiPartyNameProperty")
    @software.amazon.jsii.Jsii.Proxy(EdiPartyNameProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EdiPartyNameProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the name assigner.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNameAssigner();

        /**
         * Specifies the party name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPartyName();

        /**
         * @return a {@link Builder} of {@link EdiPartyNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EdiPartyNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EdiPartyNameProperty> {
            java.lang.String nameAssigner;
            java.lang.String partyName;

            /**
             * Sets the value of {@link EdiPartyNameProperty#getNameAssigner}
             * @param nameAssigner Specifies the name assigner. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nameAssigner(java.lang.String nameAssigner) {
                this.nameAssigner = nameAssigner;
                return this;
            }

            /**
             * Sets the value of {@link EdiPartyNameProperty#getPartyName}
             * @param partyName Specifies the party name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partyName(java.lang.String partyName) {
                this.partyName = partyName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EdiPartyNameProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EdiPartyNameProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EdiPartyNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EdiPartyNameProperty {
            private final java.lang.String nameAssigner;
            private final java.lang.String partyName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nameAssigner = software.amazon.jsii.Kernel.get(this, "nameAssigner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partyName = software.amazon.jsii.Kernel.get(this, "partyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nameAssigner = java.util.Objects.requireNonNull(builder.nameAssigner, "nameAssigner is required");
                this.partyName = java.util.Objects.requireNonNull(builder.partyName, "partyName is required");
            }

            @Override
            public final java.lang.String getNameAssigner() {
                return this.nameAssigner;
            }

            @Override
            public final java.lang.String getPartyName() {
                return this.partyName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("nameAssigner", om.valueToTree(this.getNameAssigner()));
                data.set("partyName", om.valueToTree(this.getPartyName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.EdiPartyNameProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EdiPartyNameProperty.Jsii$Proxy that = (EdiPartyNameProperty.Jsii$Proxy) o;

                if (!nameAssigner.equals(that.nameAssigner)) return false;
                return this.partyName.equals(that.partyName);
            }

            @Override
            public final int hashCode() {
                int result = this.nameAssigner.hashCode();
                result = 31 * result + (this.partyName.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the `KeyUsage` extension.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * ExtendedKeyUsageProperty extendedKeyUsageProperty = ExtendedKeyUsageProperty.builder()
     *         .extendedKeyUsageObjectIdentifier("extendedKeyUsageObjectIdentifier")
     *         .extendedKeyUsageType("extendedKeyUsageType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.ExtendedKeyUsageProperty")
    @software.amazon.jsii.Jsii.Proxy(ExtendedKeyUsageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExtendedKeyUsageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a custom `ExtendedKeyUsage` with an object identifier (OID).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExtendedKeyUsageObjectIdentifier() {
            return null;
        }

        /**
         * Specifies a standard `ExtendedKeyUsage` as defined as in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.12) .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExtendedKeyUsageType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExtendedKeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExtendedKeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExtendedKeyUsageProperty> {
            java.lang.String extendedKeyUsageObjectIdentifier;
            java.lang.String extendedKeyUsageType;

            /**
             * Sets the value of {@link ExtendedKeyUsageProperty#getExtendedKeyUsageObjectIdentifier}
             * @param extendedKeyUsageObjectIdentifier Specifies a custom `ExtendedKeyUsage` with an object identifier (OID).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extendedKeyUsageObjectIdentifier(java.lang.String extendedKeyUsageObjectIdentifier) {
                this.extendedKeyUsageObjectIdentifier = extendedKeyUsageObjectIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedKeyUsageProperty#getExtendedKeyUsageType}
             * @param extendedKeyUsageType Specifies a standard `ExtendedKeyUsage` as defined as in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.12) .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extendedKeyUsageType(java.lang.String extendedKeyUsageType) {
                this.extendedKeyUsageType = extendedKeyUsageType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExtendedKeyUsageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExtendedKeyUsageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExtendedKeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtendedKeyUsageProperty {
            private final java.lang.String extendedKeyUsageObjectIdentifier;
            private final java.lang.String extendedKeyUsageType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.extendedKeyUsageObjectIdentifier = software.amazon.jsii.Kernel.get(this, "extendedKeyUsageObjectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.extendedKeyUsageType = software.amazon.jsii.Kernel.get(this, "extendedKeyUsageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.extendedKeyUsageObjectIdentifier = builder.extendedKeyUsageObjectIdentifier;
                this.extendedKeyUsageType = builder.extendedKeyUsageType;
            }

            @Override
            public final java.lang.String getExtendedKeyUsageObjectIdentifier() {
                return this.extendedKeyUsageObjectIdentifier;
            }

            @Override
            public final java.lang.String getExtendedKeyUsageType() {
                return this.extendedKeyUsageType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExtendedKeyUsageObjectIdentifier() != null) {
                    data.set("extendedKeyUsageObjectIdentifier", om.valueToTree(this.getExtendedKeyUsageObjectIdentifier()));
                }
                if (this.getExtendedKeyUsageType() != null) {
                    data.set("extendedKeyUsageType", om.valueToTree(this.getExtendedKeyUsageType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.ExtendedKeyUsageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExtendedKeyUsageProperty.Jsii$Proxy that = (ExtendedKeyUsageProperty.Jsii$Proxy) o;

                if (this.extendedKeyUsageObjectIdentifier != null ? !this.extendedKeyUsageObjectIdentifier.equals(that.extendedKeyUsageObjectIdentifier) : that.extendedKeyUsageObjectIdentifier != null) return false;
                return this.extendedKeyUsageType != null ? this.extendedKeyUsageType.equals(that.extendedKeyUsageType) : that.extendedKeyUsageType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.extendedKeyUsageObjectIdentifier != null ? this.extendedKeyUsageObjectIdentifier.hashCode() : 0;
                result = 31 * result + (this.extendedKeyUsageType != null ? this.extendedKeyUsageType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains X.509 extension information for a certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * ExtensionsProperty extensionsProperty = ExtensionsProperty.builder()
     *         .certificatePolicies(List.of(PolicyInformationProperty.builder()
     *                 .certPolicyId("certPolicyId")
     *                 // the properties below are optional
     *                 .policyQualifiers(List.of(PolicyQualifierInfoProperty.builder()
     *                         .policyQualifierId("policyQualifierId")
     *                         .qualifier(QualifierProperty.builder()
     *                                 .cpsUri("cpsUri")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .customExtensions(List.of(CustomExtensionProperty.builder()
     *                 .objectIdentifier("objectIdentifier")
     *                 .value("value")
     *                 // the properties below are optional
     *                 .critical(false)
     *                 .build()))
     *         .extendedKeyUsage(List.of(ExtendedKeyUsageProperty.builder()
     *                 .extendedKeyUsageObjectIdentifier("extendedKeyUsageObjectIdentifier")
     *                 .extendedKeyUsageType("extendedKeyUsageType")
     *                 .build()))
     *         .keyUsage(KeyUsageProperty.builder()
     *                 .crlSign(false)
     *                 .dataEncipherment(false)
     *                 .decipherOnly(false)
     *                 .digitalSignature(false)
     *                 .encipherOnly(false)
     *                 .keyAgreement(false)
     *                 .keyCertSign(false)
     *                 .keyEncipherment(false)
     *                 .nonRepudiation(false)
     *                 .build())
     *         .subjectAlternativeNames(List.of(GeneralNameProperty.builder()
     *                 .directoryName(SubjectProperty.builder()
     *                         .commonName("commonName")
     *                         .country("country")
     *                         .customAttributes(List.of(CustomAttributeProperty.builder()
     *                                 .objectIdentifier("objectIdentifier")
     *                                 .value("value")
     *                                 .build()))
     *                         .distinguishedNameQualifier("distinguishedNameQualifier")
     *                         .generationQualifier("generationQualifier")
     *                         .givenName("givenName")
     *                         .initials("initials")
     *                         .locality("locality")
     *                         .organization("organization")
     *                         .organizationalUnit("organizationalUnit")
     *                         .pseudonym("pseudonym")
     *                         .serialNumber("serialNumber")
     *                         .state("state")
     *                         .surname("surname")
     *                         .title("title")
     *                         .build())
     *                 .dnsName("dnsName")
     *                 .ediPartyName(EdiPartyNameProperty.builder()
     *                         .nameAssigner("nameAssigner")
     *                         .partyName("partyName")
     *                         .build())
     *                 .ipAddress("ipAddress")
     *                 .otherName(OtherNameProperty.builder()
     *                         .typeId("typeId")
     *                         .value("value")
     *                         .build())
     *                 .registeredId("registeredId")
     *                 .rfc822Name("rfc822Name")
     *                 .uniformResourceIdentifier("uniformResourceIdentifier")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.ExtensionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ExtensionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExtensionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers.
         * <p>
         * For more information, see NIST's definition of <a href="https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a> .
         * <p>
         * In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCertificatePolicies() {
            return null;
        }

        /**
         * Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29).
         * <p>
         * <blockquote>
         * <p>
         * The OID value of a <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CustomExtension.html">CustomExtension</a> must not match the OID of a predefined extension.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomExtensions() {
            return null;
        }

        /**
         * Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the `KeyUsage` extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExtendedKeyUsage() {
            return null;
        }

        /**
         * Defines one or more purposes for which the key contained in the certificate can be used.
         * <p>
         * Default value for each option is false.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyUsage() {
            return null;
        }

        /**
         * The subject alternative name extension allows identities to be bound to the subject of the certificate.
         * <p>
         * These identities may be included in addition to or in place of the identity in the subject field of the certificate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubjectAlternativeNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExtensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExtensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExtensionsProperty> {
            java.lang.Object certificatePolicies;
            java.lang.Object customExtensions;
            java.lang.Object extendedKeyUsage;
            java.lang.Object keyUsage;
            java.lang.Object subjectAlternativeNames;

            /**
             * Sets the value of {@link ExtensionsProperty#getCertificatePolicies}
             * @param certificatePolicies Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers.
             *                            For more information, see NIST's definition of <a href="https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a> .
             *                            <p>
             *                            In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificatePolicies(software.amazon.awscdk.core.IResolvable certificatePolicies) {
                this.certificatePolicies = certificatePolicies;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getCertificatePolicies}
             * @param certificatePolicies Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers.
             *                            For more information, see NIST's definition of <a href="https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a> .
             *                            <p>
             *                            In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificatePolicies(java.util.List<? extends java.lang.Object> certificatePolicies) {
                this.certificatePolicies = certificatePolicies;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getCustomExtensions}
             * @param customExtensions Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29).
             *                         <blockquote>
             *                         <p>
             *                         The OID value of a <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CustomExtension.html">CustomExtension</a> must not match the OID of a predefined extension.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customExtensions(software.amazon.awscdk.core.IResolvable customExtensions) {
                this.customExtensions = customExtensions;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getCustomExtensions}
             * @param customExtensions Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://docs.aws.amazon.com/https://oidref.com/2.5.29).
             *                         <blockquote>
             *                         <p>
             *                         The OID value of a <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CustomExtension.html">CustomExtension</a> must not match the OID of a predefined extension.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customExtensions(java.util.List<? extends java.lang.Object> customExtensions) {
                this.customExtensions = customExtensions;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getExtendedKeyUsage}
             * @param extendedKeyUsage Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the `KeyUsage` extension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extendedKeyUsage(software.amazon.awscdk.core.IResolvable extendedKeyUsage) {
                this.extendedKeyUsage = extendedKeyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getExtendedKeyUsage}
             * @param extendedKeyUsage Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the `KeyUsage` extension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extendedKeyUsage(java.util.List<? extends java.lang.Object> extendedKeyUsage) {
                this.extendedKeyUsage = extendedKeyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getKeyUsage}
             * @param keyUsage Defines one or more purposes for which the key contained in the certificate can be used.
             *                 Default value for each option is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.core.IResolvable keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getKeyUsage}
             * @param keyUsage Defines one or more purposes for which the key contained in the certificate can be used.
             *                 Default value for each option is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(software.amazon.awscdk.services.acmpca.CfnCertificate.KeyUsageProperty keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames The subject alternative name extension allows identities to be bound to the subject of the certificate.
             *                                These identities may be included in addition to or in place of the identity in the subject field of the certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(software.amazon.awscdk.core.IResolvable subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Sets the value of {@link ExtensionsProperty#getSubjectAlternativeNames}
             * @param subjectAlternativeNames The subject alternative name extension allows identities to be bound to the subject of the certificate.
             *                                These identities may be included in addition to or in place of the identity in the subject field of the certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectAlternativeNames(java.util.List<? extends java.lang.Object> subjectAlternativeNames) {
                this.subjectAlternativeNames = subjectAlternativeNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExtensionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExtensionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExtensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtensionsProperty {
            private final java.lang.Object certificatePolicies;
            private final java.lang.Object customExtensions;
            private final java.lang.Object extendedKeyUsage;
            private final java.lang.Object keyUsage;
            private final java.lang.Object subjectAlternativeNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificatePolicies = software.amazon.jsii.Kernel.get(this, "certificatePolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customExtensions = software.amazon.jsii.Kernel.get(this, "customExtensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extendedKeyUsage = software.amazon.jsii.Kernel.get(this, "extendedKeyUsage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyUsage = software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subjectAlternativeNames = software.amazon.jsii.Kernel.get(this, "subjectAlternativeNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificatePolicies = builder.certificatePolicies;
                this.customExtensions = builder.customExtensions;
                this.extendedKeyUsage = builder.extendedKeyUsage;
                this.keyUsage = builder.keyUsage;
                this.subjectAlternativeNames = builder.subjectAlternativeNames;
            }

            @Override
            public final java.lang.Object getCertificatePolicies() {
                return this.certificatePolicies;
            }

            @Override
            public final java.lang.Object getCustomExtensions() {
                return this.customExtensions;
            }

            @Override
            public final java.lang.Object getExtendedKeyUsage() {
                return this.extendedKeyUsage;
            }

            @Override
            public final java.lang.Object getKeyUsage() {
                return this.keyUsage;
            }

            @Override
            public final java.lang.Object getSubjectAlternativeNames() {
                return this.subjectAlternativeNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificatePolicies() != null) {
                    data.set("certificatePolicies", om.valueToTree(this.getCertificatePolicies()));
                }
                if (this.getCustomExtensions() != null) {
                    data.set("customExtensions", om.valueToTree(this.getCustomExtensions()));
                }
                if (this.getExtendedKeyUsage() != null) {
                    data.set("extendedKeyUsage", om.valueToTree(this.getExtendedKeyUsage()));
                }
                if (this.getKeyUsage() != null) {
                    data.set("keyUsage", om.valueToTree(this.getKeyUsage()));
                }
                if (this.getSubjectAlternativeNames() != null) {
                    data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.ExtensionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExtensionsProperty.Jsii$Proxy that = (ExtensionsProperty.Jsii$Proxy) o;

                if (this.certificatePolicies != null ? !this.certificatePolicies.equals(that.certificatePolicies) : that.certificatePolicies != null) return false;
                if (this.customExtensions != null ? !this.customExtensions.equals(that.customExtensions) : that.customExtensions != null) return false;
                if (this.extendedKeyUsage != null ? !this.extendedKeyUsage.equals(that.extendedKeyUsage) : that.extendedKeyUsage != null) return false;
                if (this.keyUsage != null ? !this.keyUsage.equals(that.keyUsage) : that.keyUsage != null) return false;
                return this.subjectAlternativeNames != null ? this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificatePolicies != null ? this.certificatePolicies.hashCode() : 0;
                result = 31 * result + (this.customExtensions != null ? this.customExtensions.hashCode() : 0);
                result = 31 * result + (this.extendedKeyUsage != null ? this.extendedKeyUsage.hashCode() : 0);
                result = 31 * result + (this.keyUsage != null ? this.keyUsage.hashCode() : 0);
                result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an ASN.1 X.400 `GeneralName` as defined in [RFC 5280](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280) . Only one of the following naming options should be provided. Providing more than one option results in an `InvalidArgsException` error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * GeneralNameProperty generalNameProperty = GeneralNameProperty.builder()
     *         .directoryName(SubjectProperty.builder()
     *                 .commonName("commonName")
     *                 .country("country")
     *                 .customAttributes(List.of(CustomAttributeProperty.builder()
     *                         .objectIdentifier("objectIdentifier")
     *                         .value("value")
     *                         .build()))
     *                 .distinguishedNameQualifier("distinguishedNameQualifier")
     *                 .generationQualifier("generationQualifier")
     *                 .givenName("givenName")
     *                 .initials("initials")
     *                 .locality("locality")
     *                 .organization("organization")
     *                 .organizationalUnit("organizationalUnit")
     *                 .pseudonym("pseudonym")
     *                 .serialNumber("serialNumber")
     *                 .state("state")
     *                 .surname("surname")
     *                 .title("title")
     *                 .build())
     *         .dnsName("dnsName")
     *         .ediPartyName(EdiPartyNameProperty.builder()
     *                 .nameAssigner("nameAssigner")
     *                 .partyName("partyName")
     *                 .build())
     *         .ipAddress("ipAddress")
     *         .otherName(OtherNameProperty.builder()
     *                 .typeId("typeId")
     *                 .value("value")
     *                 .build())
     *         .registeredId("registeredId")
     *         .rfc822Name("rfc822Name")
     *         .uniformResourceIdentifier("uniformResourceIdentifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.GeneralNameProperty")
    @software.amazon.jsii.Jsii.Proxy(GeneralNameProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeneralNameProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains information about the certificate subject.
         * <p>
         * The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDirectoryName() {
            return null;
        }

        /**
         * Represents `GeneralName` as a DNS name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDnsName() {
            return null;
        }

        /**
         * Represents `GeneralName` as an `EdiPartyName` object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEdiPartyName() {
            return null;
        }

        /**
         * Represents `GeneralName` as an IPv4 or IPv6 address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpAddress() {
            return null;
        }

        /**
         * Represents `GeneralName` using an `OtherName` object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOtherName() {
            return null;
        }

        /**
         * Represents `GeneralName` as an object identifier (OID).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegisteredId() {
            return null;
        }

        /**
         * Represents `GeneralName` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRfc822Name() {
            return null;
        }

        /**
         * Represents `GeneralName` as a URI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUniformResourceIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeneralNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeneralNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeneralNameProperty> {
            java.lang.Object directoryName;
            java.lang.String dnsName;
            java.lang.Object ediPartyName;
            java.lang.String ipAddress;
            java.lang.Object otherName;
            java.lang.String registeredId;
            java.lang.String rfc822Name;
            java.lang.String uniformResourceIdentifier;

            /**
             * Sets the value of {@link GeneralNameProperty#getDirectoryName}
             * @param directoryName Contains information about the certificate subject.
             *                      The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directoryName(software.amazon.awscdk.core.IResolvable directoryName) {
                this.directoryName = directoryName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getDirectoryName}
             * @param directoryName Contains information about the certificate subject.
             *                      The certificate can be one issued by your private certificate authority (CA) or it can be your private CA certificate. The Subject field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The Subject must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate. The DN must be unique for each entity, but your private CA can issue more than one certificate with the same DN to the same entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder directoryName(software.amazon.awscdk.services.acmpca.CfnCertificate.SubjectProperty directoryName) {
                this.directoryName = directoryName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getDnsName}
             * @param dnsName Represents `GeneralName` as a DNS name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getEdiPartyName}
             * @param ediPartyName Represents `GeneralName` as an `EdiPartyName` object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ediPartyName(software.amazon.awscdk.core.IResolvable ediPartyName) {
                this.ediPartyName = ediPartyName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getEdiPartyName}
             * @param ediPartyName Represents `GeneralName` as an `EdiPartyName` object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ediPartyName(software.amazon.awscdk.services.acmpca.CfnCertificate.EdiPartyNameProperty ediPartyName) {
                this.ediPartyName = ediPartyName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getIpAddress}
             * @param ipAddress Represents `GeneralName` as an IPv4 or IPv6 address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddress(java.lang.String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getOtherName}
             * @param otherName Represents `GeneralName` using an `OtherName` object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder otherName(software.amazon.awscdk.core.IResolvable otherName) {
                this.otherName = otherName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getOtherName}
             * @param otherName Represents `GeneralName` using an `OtherName` object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder otherName(software.amazon.awscdk.services.acmpca.CfnCertificate.OtherNameProperty otherName) {
                this.otherName = otherName;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getRegisteredId}
             * @param registeredId Represents `GeneralName` as an object identifier (OID).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registeredId(java.lang.String registeredId) {
                this.registeredId = registeredId;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getRfc822Name}
             * @param rfc822Name Represents `GeneralName` as an [RFC 822](https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc822) email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rfc822Name(java.lang.String rfc822Name) {
                this.rfc822Name = rfc822Name;
                return this;
            }

            /**
             * Sets the value of {@link GeneralNameProperty#getUniformResourceIdentifier}
             * @param uniformResourceIdentifier Represents `GeneralName` as a URI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniformResourceIdentifier(java.lang.String uniformResourceIdentifier) {
                this.uniformResourceIdentifier = uniformResourceIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeneralNameProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeneralNameProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeneralNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeneralNameProperty {
            private final java.lang.Object directoryName;
            private final java.lang.String dnsName;
            private final java.lang.Object ediPartyName;
            private final java.lang.String ipAddress;
            private final java.lang.Object otherName;
            private final java.lang.String registeredId;
            private final java.lang.String rfc822Name;
            private final java.lang.String uniformResourceIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.directoryName = software.amazon.jsii.Kernel.get(this, "directoryName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ediPartyName = software.amazon.jsii.Kernel.get(this, "ediPartyName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipAddress = software.amazon.jsii.Kernel.get(this, "ipAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.otherName = software.amazon.jsii.Kernel.get(this, "otherName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.registeredId = software.amazon.jsii.Kernel.get(this, "registeredId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rfc822Name = software.amazon.jsii.Kernel.get(this, "rfc822Name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uniformResourceIdentifier = software.amazon.jsii.Kernel.get(this, "uniformResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.directoryName = builder.directoryName;
                this.dnsName = builder.dnsName;
                this.ediPartyName = builder.ediPartyName;
                this.ipAddress = builder.ipAddress;
                this.otherName = builder.otherName;
                this.registeredId = builder.registeredId;
                this.rfc822Name = builder.rfc822Name;
                this.uniformResourceIdentifier = builder.uniformResourceIdentifier;
            }

            @Override
            public final java.lang.Object getDirectoryName() {
                return this.directoryName;
            }

            @Override
            public final java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public final java.lang.Object getEdiPartyName() {
                return this.ediPartyName;
            }

            @Override
            public final java.lang.String getIpAddress() {
                return this.ipAddress;
            }

            @Override
            public final java.lang.Object getOtherName() {
                return this.otherName;
            }

            @Override
            public final java.lang.String getRegisteredId() {
                return this.registeredId;
            }

            @Override
            public final java.lang.String getRfc822Name() {
                return this.rfc822Name;
            }

            @Override
            public final java.lang.String getUniformResourceIdentifier() {
                return this.uniformResourceIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDirectoryName() != null) {
                    data.set("directoryName", om.valueToTree(this.getDirectoryName()));
                }
                if (this.getDnsName() != null) {
                    data.set("dnsName", om.valueToTree(this.getDnsName()));
                }
                if (this.getEdiPartyName() != null) {
                    data.set("ediPartyName", om.valueToTree(this.getEdiPartyName()));
                }
                if (this.getIpAddress() != null) {
                    data.set("ipAddress", om.valueToTree(this.getIpAddress()));
                }
                if (this.getOtherName() != null) {
                    data.set("otherName", om.valueToTree(this.getOtherName()));
                }
                if (this.getRegisteredId() != null) {
                    data.set("registeredId", om.valueToTree(this.getRegisteredId()));
                }
                if (this.getRfc822Name() != null) {
                    data.set("rfc822Name", om.valueToTree(this.getRfc822Name()));
                }
                if (this.getUniformResourceIdentifier() != null) {
                    data.set("uniformResourceIdentifier", om.valueToTree(this.getUniformResourceIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.GeneralNameProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeneralNameProperty.Jsii$Proxy that = (GeneralNameProperty.Jsii$Proxy) o;

                if (this.directoryName != null ? !this.directoryName.equals(that.directoryName) : that.directoryName != null) return false;
                if (this.dnsName != null ? !this.dnsName.equals(that.dnsName) : that.dnsName != null) return false;
                if (this.ediPartyName != null ? !this.ediPartyName.equals(that.ediPartyName) : that.ediPartyName != null) return false;
                if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) return false;
                if (this.otherName != null ? !this.otherName.equals(that.otherName) : that.otherName != null) return false;
                if (this.registeredId != null ? !this.registeredId.equals(that.registeredId) : that.registeredId != null) return false;
                if (this.rfc822Name != null ? !this.rfc822Name.equals(that.rfc822Name) : that.rfc822Name != null) return false;
                return this.uniformResourceIdentifier != null ? this.uniformResourceIdentifier.equals(that.uniformResourceIdentifier) : that.uniformResourceIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.directoryName != null ? this.directoryName.hashCode() : 0;
                result = 31 * result + (this.dnsName != null ? this.dnsName.hashCode() : 0);
                result = 31 * result + (this.ediPartyName != null ? this.ediPartyName.hashCode() : 0);
                result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
                result = 31 * result + (this.otherName != null ? this.otherName.hashCode() : 0);
                result = 31 * result + (this.registeredId != null ? this.registeredId.hashCode() : 0);
                result = 31 * result + (this.rfc822Name != null ? this.rfc822Name.hashCode() : 0);
                result = 31 * result + (this.uniformResourceIdentifier != null ? this.uniformResourceIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines one or more purposes for which the key contained in the certificate can be used.
     * <p>
     * Default value for each option is false.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * KeyUsageProperty keyUsageProperty = KeyUsageProperty.builder()
     *         .crlSign(false)
     *         .dataEncipherment(false)
     *         .decipherOnly(false)
     *         .digitalSignature(false)
     *         .encipherOnly(false)
     *         .keyAgreement(false)
     *         .keyCertSign(false)
     *         .keyEncipherment(false)
     *         .nonRepudiation(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.KeyUsageProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyUsageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyUsageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Key can be used to sign CRLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrlSign() {
            return null;
        }

        /**
         * Key can be used to decipher data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataEncipherment() {
            return null;
        }

        /**
         * Key can be used only to decipher data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecipherOnly() {
            return null;
        }

        /**
         * Key can be used for digital signing.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDigitalSignature() {
            return null;
        }

        /**
         * Key can be used only to encipher data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncipherOnly() {
            return null;
        }

        /**
         * Key can be used in a key-agreement protocol.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyAgreement() {
            return null;
        }

        /**
         * Key can be used to sign certificates.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyCertSign() {
            return null;
        }

        /**
         * Key can be used to encipher data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKeyEncipherment() {
            return null;
        }

        /**
         * Key can be used for non-repudiation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNonRepudiation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyUsageProperty> {
            java.lang.Object crlSign;
            java.lang.Object dataEncipherment;
            java.lang.Object decipherOnly;
            java.lang.Object digitalSignature;
            java.lang.Object encipherOnly;
            java.lang.Object keyAgreement;
            java.lang.Object keyCertSign;
            java.lang.Object keyEncipherment;
            java.lang.Object nonRepudiation;

            /**
             * Sets the value of {@link KeyUsageProperty#getCrlSign}
             * @param crlSign Key can be used to sign CRLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crlSign(java.lang.Boolean crlSign) {
                this.crlSign = crlSign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getCrlSign}
             * @param crlSign Key can be used to sign CRLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crlSign(software.amazon.awscdk.core.IResolvable crlSign) {
                this.crlSign = crlSign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDataEncipherment}
             * @param dataEncipherment Key can be used to decipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataEncipherment(java.lang.Boolean dataEncipherment) {
                this.dataEncipherment = dataEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDataEncipherment}
             * @param dataEncipherment Key can be used to decipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataEncipherment(software.amazon.awscdk.core.IResolvable dataEncipherment) {
                this.dataEncipherment = dataEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDecipherOnly}
             * @param decipherOnly Key can be used only to decipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decipherOnly(java.lang.Boolean decipherOnly) {
                this.decipherOnly = decipherOnly;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDecipherOnly}
             * @param decipherOnly Key can be used only to decipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decipherOnly(software.amazon.awscdk.core.IResolvable decipherOnly) {
                this.decipherOnly = decipherOnly;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDigitalSignature}
             * @param digitalSignature Key can be used for digital signing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder digitalSignature(java.lang.Boolean digitalSignature) {
                this.digitalSignature = digitalSignature;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getDigitalSignature}
             * @param digitalSignature Key can be used for digital signing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder digitalSignature(software.amazon.awscdk.core.IResolvable digitalSignature) {
                this.digitalSignature = digitalSignature;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getEncipherOnly}
             * @param encipherOnly Key can be used only to encipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encipherOnly(java.lang.Boolean encipherOnly) {
                this.encipherOnly = encipherOnly;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getEncipherOnly}
             * @param encipherOnly Key can be used only to encipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encipherOnly(software.amazon.awscdk.core.IResolvable encipherOnly) {
                this.encipherOnly = encipherOnly;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyAgreement}
             * @param keyAgreement Key can be used in a key-agreement protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAgreement(java.lang.Boolean keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyAgreement}
             * @param keyAgreement Key can be used in a key-agreement protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAgreement(software.amazon.awscdk.core.IResolvable keyAgreement) {
                this.keyAgreement = keyAgreement;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyCertSign}
             * @param keyCertSign Key can be used to sign certificates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyCertSign(java.lang.Boolean keyCertSign) {
                this.keyCertSign = keyCertSign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyCertSign}
             * @param keyCertSign Key can be used to sign certificates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyCertSign(software.amazon.awscdk.core.IResolvable keyCertSign) {
                this.keyCertSign = keyCertSign;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyEncipherment}
             * @param keyEncipherment Key can be used to encipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyEncipherment(java.lang.Boolean keyEncipherment) {
                this.keyEncipherment = keyEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getKeyEncipherment}
             * @param keyEncipherment Key can be used to encipher data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyEncipherment(software.amazon.awscdk.core.IResolvable keyEncipherment) {
                this.keyEncipherment = keyEncipherment;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getNonRepudiation}
             * @param nonRepudiation Key can be used for non-repudiation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonRepudiation(java.lang.Boolean nonRepudiation) {
                this.nonRepudiation = nonRepudiation;
                return this;
            }

            /**
             * Sets the value of {@link KeyUsageProperty#getNonRepudiation}
             * @param nonRepudiation Key can be used for non-repudiation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonRepudiation(software.amazon.awscdk.core.IResolvable nonRepudiation) {
                this.nonRepudiation = nonRepudiation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyUsageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyUsageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyUsageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyUsageProperty {
            private final java.lang.Object crlSign;
            private final java.lang.Object dataEncipherment;
            private final java.lang.Object decipherOnly;
            private final java.lang.Object digitalSignature;
            private final java.lang.Object encipherOnly;
            private final java.lang.Object keyAgreement;
            private final java.lang.Object keyCertSign;
            private final java.lang.Object keyEncipherment;
            private final java.lang.Object nonRepudiation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.crlSign = software.amazon.jsii.Kernel.get(this, "crlSign", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataEncipherment = software.amazon.jsii.Kernel.get(this, "dataEncipherment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.decipherOnly = software.amazon.jsii.Kernel.get(this, "decipherOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.digitalSignature = software.amazon.jsii.Kernel.get(this, "digitalSignature", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encipherOnly = software.amazon.jsii.Kernel.get(this, "encipherOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyAgreement = software.amazon.jsii.Kernel.get(this, "keyAgreement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyCertSign = software.amazon.jsii.Kernel.get(this, "keyCertSign", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyEncipherment = software.amazon.jsii.Kernel.get(this, "keyEncipherment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nonRepudiation = software.amazon.jsii.Kernel.get(this, "nonRepudiation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.crlSign = builder.crlSign;
                this.dataEncipherment = builder.dataEncipherment;
                this.decipherOnly = builder.decipherOnly;
                this.digitalSignature = builder.digitalSignature;
                this.encipherOnly = builder.encipherOnly;
                this.keyAgreement = builder.keyAgreement;
                this.keyCertSign = builder.keyCertSign;
                this.keyEncipherment = builder.keyEncipherment;
                this.nonRepudiation = builder.nonRepudiation;
            }

            @Override
            public final java.lang.Object getCrlSign() {
                return this.crlSign;
            }

            @Override
            public final java.lang.Object getDataEncipherment() {
                return this.dataEncipherment;
            }

            @Override
            public final java.lang.Object getDecipherOnly() {
                return this.decipherOnly;
            }

            @Override
            public final java.lang.Object getDigitalSignature() {
                return this.digitalSignature;
            }

            @Override
            public final java.lang.Object getEncipherOnly() {
                return this.encipherOnly;
            }

            @Override
            public final java.lang.Object getKeyAgreement() {
                return this.keyAgreement;
            }

            @Override
            public final java.lang.Object getKeyCertSign() {
                return this.keyCertSign;
            }

            @Override
            public final java.lang.Object getKeyEncipherment() {
                return this.keyEncipherment;
            }

            @Override
            public final java.lang.Object getNonRepudiation() {
                return this.nonRepudiation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCrlSign() != null) {
                    data.set("crlSign", om.valueToTree(this.getCrlSign()));
                }
                if (this.getDataEncipherment() != null) {
                    data.set("dataEncipherment", om.valueToTree(this.getDataEncipherment()));
                }
                if (this.getDecipherOnly() != null) {
                    data.set("decipherOnly", om.valueToTree(this.getDecipherOnly()));
                }
                if (this.getDigitalSignature() != null) {
                    data.set("digitalSignature", om.valueToTree(this.getDigitalSignature()));
                }
                if (this.getEncipherOnly() != null) {
                    data.set("encipherOnly", om.valueToTree(this.getEncipherOnly()));
                }
                if (this.getKeyAgreement() != null) {
                    data.set("keyAgreement", om.valueToTree(this.getKeyAgreement()));
                }
                if (this.getKeyCertSign() != null) {
                    data.set("keyCertSign", om.valueToTree(this.getKeyCertSign()));
                }
                if (this.getKeyEncipherment() != null) {
                    data.set("keyEncipherment", om.valueToTree(this.getKeyEncipherment()));
                }
                if (this.getNonRepudiation() != null) {
                    data.set("nonRepudiation", om.valueToTree(this.getNonRepudiation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.KeyUsageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyUsageProperty.Jsii$Proxy that = (KeyUsageProperty.Jsii$Proxy) o;

                if (this.crlSign != null ? !this.crlSign.equals(that.crlSign) : that.crlSign != null) return false;
                if (this.dataEncipherment != null ? !this.dataEncipherment.equals(that.dataEncipherment) : that.dataEncipherment != null) return false;
                if (this.decipherOnly != null ? !this.decipherOnly.equals(that.decipherOnly) : that.decipherOnly != null) return false;
                if (this.digitalSignature != null ? !this.digitalSignature.equals(that.digitalSignature) : that.digitalSignature != null) return false;
                if (this.encipherOnly != null ? !this.encipherOnly.equals(that.encipherOnly) : that.encipherOnly != null) return false;
                if (this.keyAgreement != null ? !this.keyAgreement.equals(that.keyAgreement) : that.keyAgreement != null) return false;
                if (this.keyCertSign != null ? !this.keyCertSign.equals(that.keyCertSign) : that.keyCertSign != null) return false;
                if (this.keyEncipherment != null ? !this.keyEncipherment.equals(that.keyEncipherment) : that.keyEncipherment != null) return false;
                return this.nonRepudiation != null ? this.nonRepudiation.equals(that.nonRepudiation) : that.nonRepudiation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.crlSign != null ? this.crlSign.hashCode() : 0;
                result = 31 * result + (this.dataEncipherment != null ? this.dataEncipherment.hashCode() : 0);
                result = 31 * result + (this.decipherOnly != null ? this.decipherOnly.hashCode() : 0);
                result = 31 * result + (this.digitalSignature != null ? this.digitalSignature.hashCode() : 0);
                result = 31 * result + (this.encipherOnly != null ? this.encipherOnly.hashCode() : 0);
                result = 31 * result + (this.keyAgreement != null ? this.keyAgreement.hashCode() : 0);
                result = 31 * result + (this.keyCertSign != null ? this.keyCertSign.hashCode() : 0);
                result = 31 * result + (this.keyEncipherment != null ? this.keyEncipherment.hashCode() : 0);
                result = 31 * result + (this.nonRepudiation != null ? this.nonRepudiation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a custom ASN.1 X.400 `GeneralName` using an object identifier (OID) and value. The OID must satisfy the regular expression shown below. For more information, see NIST's definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier) .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * OtherNameProperty otherNameProperty = OtherNameProperty.builder()
     *         .typeId("typeId")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.OtherNameProperty")
    @software.amazon.jsii.Jsii.Proxy(OtherNameProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OtherNameProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies an OID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTypeId();

        /**
         * Specifies an OID value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link OtherNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OtherNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OtherNameProperty> {
            java.lang.String typeId;
            java.lang.String value;

            /**
             * Sets the value of {@link OtherNameProperty#getTypeId}
             * @param typeId Specifies an OID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeId(java.lang.String typeId) {
                this.typeId = typeId;
                return this;
            }

            /**
             * Sets the value of {@link OtherNameProperty#getValue}
             * @param value Specifies an OID value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OtherNameProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OtherNameProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OtherNameProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OtherNameProperty {
            private final java.lang.String typeId;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.typeId = software.amazon.jsii.Kernel.get(this, "typeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.typeId = java.util.Objects.requireNonNull(builder.typeId, "typeId is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getTypeId() {
                return this.typeId;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("typeId", om.valueToTree(this.getTypeId()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.OtherNameProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OtherNameProperty.Jsii$Proxy that = (OtherNameProperty.Jsii$Proxy) o;

                if (!typeId.equals(that.typeId)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.typeId.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines the X.509 `CertificatePolicies` extension.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * PolicyInformationProperty policyInformationProperty = PolicyInformationProperty.builder()
     *         .certPolicyId("certPolicyId")
     *         // the properties below are optional
     *         .policyQualifiers(List.of(PolicyQualifierInfoProperty.builder()
     *                 .policyQualifierId("policyQualifierId")
     *                 .qualifier(QualifierProperty.builder()
     *                         .cpsUri("cpsUri")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.PolicyInformationProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyInformationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyInformationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the object identifier (OID) of the certificate policy under which the certificate was issued.
         * <p>
         * For more information, see NIST's definition of <a href="https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertPolicyId();

        /**
         * Modifies the given `CertPolicyId` with a qualifier.
         * <p>
         * ACM Private CA supports the certification practice statement (CPS) qualifier.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyQualifiers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyInformationProperty> {
            java.lang.String certPolicyId;
            java.lang.Object policyQualifiers;

            /**
             * Sets the value of {@link PolicyInformationProperty#getCertPolicyId}
             * @param certPolicyId Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. This parameter is required.
             *                     For more information, see NIST's definition of <a href="https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certPolicyId(java.lang.String certPolicyId) {
                this.certPolicyId = certPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link PolicyInformationProperty#getPolicyQualifiers}
             * @param policyQualifiers Modifies the given `CertPolicyId` with a qualifier.
             *                         ACM Private CA supports the certification practice statement (CPS) qualifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyQualifiers(software.amazon.awscdk.core.IResolvable policyQualifiers) {
                this.policyQualifiers = policyQualifiers;
                return this;
            }

            /**
             * Sets the value of {@link PolicyInformationProperty#getPolicyQualifiers}
             * @param policyQualifiers Modifies the given `CertPolicyId` with a qualifier.
             *                         ACM Private CA supports the certification practice statement (CPS) qualifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyQualifiers(java.util.List<? extends java.lang.Object> policyQualifiers) {
                this.policyQualifiers = policyQualifiers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyInformationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyInformationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyInformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyInformationProperty {
            private final java.lang.String certPolicyId;
            private final java.lang.Object policyQualifiers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certPolicyId = software.amazon.jsii.Kernel.get(this, "certPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.policyQualifiers = software.amazon.jsii.Kernel.get(this, "policyQualifiers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certPolicyId = java.util.Objects.requireNonNull(builder.certPolicyId, "certPolicyId is required");
                this.policyQualifiers = builder.policyQualifiers;
            }

            @Override
            public final java.lang.String getCertPolicyId() {
                return this.certPolicyId;
            }

            @Override
            public final java.lang.Object getPolicyQualifiers() {
                return this.policyQualifiers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certPolicyId", om.valueToTree(this.getCertPolicyId()));
                if (this.getPolicyQualifiers() != null) {
                    data.set("policyQualifiers", om.valueToTree(this.getPolicyQualifiers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.PolicyInformationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyInformationProperty.Jsii$Proxy that = (PolicyInformationProperty.Jsii$Proxy) o;

                if (!certPolicyId.equals(that.certPolicyId)) return false;
                return this.policyQualifiers != null ? this.policyQualifiers.equals(that.policyQualifiers) : that.policyQualifiers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certPolicyId.hashCode();
                result = 31 * result + (this.policyQualifiers != null ? this.policyQualifiers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Modifies the `CertPolicyId` of a `PolicyInformation` object with a qualifier.
     * <p>
     * ACM Private CA supports the certification practice statement (CPS) qualifier.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * PolicyQualifierInfoProperty policyQualifierInfoProperty = PolicyQualifierInfoProperty.builder()
     *         .policyQualifierId("policyQualifierId")
     *         .qualifier(QualifierProperty.builder()
     *                 .cpsUri("cpsUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.PolicyQualifierInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyQualifierInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyQualifierInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Identifies the qualifier modifying a `CertPolicyId` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyQualifierId();

        /**
         * Defines the qualifier type.
         * <p>
         * ACM Private CA supports the use of a URI for a CPS qualifier in this field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQualifier();

        /**
         * @return a {@link Builder} of {@link PolicyQualifierInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyQualifierInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyQualifierInfoProperty> {
            java.lang.String policyQualifierId;
            java.lang.Object qualifier;

            /**
             * Sets the value of {@link PolicyQualifierInfoProperty#getPolicyQualifierId}
             * @param policyQualifierId Identifies the qualifier modifying a `CertPolicyId` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyQualifierId(java.lang.String policyQualifierId) {
                this.policyQualifierId = policyQualifierId;
                return this;
            }

            /**
             * Sets the value of {@link PolicyQualifierInfoProperty#getQualifier}
             * @param qualifier Defines the qualifier type. This parameter is required.
             *                  ACM Private CA supports the use of a URI for a CPS qualifier in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qualifier(software.amazon.awscdk.core.IResolvable qualifier) {
                this.qualifier = qualifier;
                return this;
            }

            /**
             * Sets the value of {@link PolicyQualifierInfoProperty#getQualifier}
             * @param qualifier Defines the qualifier type. This parameter is required.
             *                  ACM Private CA supports the use of a URI for a CPS qualifier in this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qualifier(software.amazon.awscdk.services.acmpca.CfnCertificate.QualifierProperty qualifier) {
                this.qualifier = qualifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyQualifierInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyQualifierInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyQualifierInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyQualifierInfoProperty {
            private final java.lang.String policyQualifierId;
            private final java.lang.Object qualifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyQualifierId = software.amazon.jsii.Kernel.get(this, "policyQualifierId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyQualifierId = java.util.Objects.requireNonNull(builder.policyQualifierId, "policyQualifierId is required");
                this.qualifier = java.util.Objects.requireNonNull(builder.qualifier, "qualifier is required");
            }

            @Override
            public final java.lang.String getPolicyQualifierId() {
                return this.policyQualifierId;
            }

            @Override
            public final java.lang.Object getQualifier() {
                return this.qualifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policyQualifierId", om.valueToTree(this.getPolicyQualifierId()));
                data.set("qualifier", om.valueToTree(this.getQualifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.PolicyQualifierInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyQualifierInfoProperty.Jsii$Proxy that = (PolicyQualifierInfoProperty.Jsii$Proxy) o;

                if (!policyQualifierId.equals(that.policyQualifierId)) return false;
                return this.qualifier.equals(that.qualifier);
            }

            @Override
            public final int hashCode() {
                int result = this.policyQualifierId.hashCode();
                result = 31 * result + (this.qualifier.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines a `PolicyInformation` qualifier.
     * <p>
     * ACM Private CA supports the <a href="https://docs.aws.amazon.com/https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.4">certification practice statement (CPS) qualifier</a> defined in RFC 5280.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * QualifierProperty qualifierProperty = QualifierProperty.builder()
     *         .cpsUri("cpsUri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.QualifierProperty")
    @software.amazon.jsii.Jsii.Proxy(QualifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QualifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains a pointer to a certification practice statement (CPS) published by the CA.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCpsUri();

        /**
         * @return a {@link Builder} of {@link QualifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QualifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QualifierProperty> {
            java.lang.String cpsUri;

            /**
             * Sets the value of {@link QualifierProperty#getCpsUri}
             * @param cpsUri Contains a pointer to a certification practice statement (CPS) published by the CA. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpsUri(java.lang.String cpsUri) {
                this.cpsUri = cpsUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QualifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QualifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QualifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QualifierProperty {
            private final java.lang.String cpsUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpsUri = software.amazon.jsii.Kernel.get(this, "cpsUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpsUri = java.util.Objects.requireNonNull(builder.cpsUri, "cpsUri is required");
            }

            @Override
            public final java.lang.String getCpsUri() {
                return this.cpsUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpsUri", om.valueToTree(this.getCpsUri()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.QualifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QualifierProperty.Jsii$Proxy that = (QualifierProperty.Jsii$Proxy) o;

                return this.cpsUri.equals(that.cpsUri);
            }

            @Override
            public final int hashCode() {
                int result = this.cpsUri.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about the certificate subject.
     * <p>
     * The <code>Subject</code> field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The <code>Subject</code> must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * SubjectProperty subjectProperty = SubjectProperty.builder()
     *         .commonName("commonName")
     *         .country("country")
     *         .customAttributes(List.of(CustomAttributeProperty.builder()
     *                 .objectIdentifier("objectIdentifier")
     *                 .value("value")
     *                 .build()))
     *         .distinguishedNameQualifier("distinguishedNameQualifier")
     *         .generationQualifier("generationQualifier")
     *         .givenName("givenName")
     *         .initials("initials")
     *         .locality("locality")
     *         .organization("organization")
     *         .organizationalUnit("organizationalUnit")
     *         .pseudonym("pseudonym")
     *         .serialNumber("serialNumber")
     *         .state("state")
     *         .surname("surname")
     *         .title("title")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.SubjectProperty")
    @software.amazon.jsii.Jsii.Proxy(SubjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length limit.
         * <p>
         * Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated with the certificate subject.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCommonName() {
            return null;
        }

        /**
         * Two-digit code that specifies the country in which the certificate subject located.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountry() {
            return null;
        }

        /**
         * Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier) .
         * <p>
         * <blockquote>
         * <p>
         * Custom attributes cannot be used in combination with standard attributes.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAttributes() {
            return null;
        }

        /**
         * Disambiguating information for the certificate subject.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDistinguishedNameQualifier() {
            return null;
        }

        /**
         * Typically a qualifier appended to the name of an individual.
         * <p>
         * Examples include Jr. for junior, Sr. for senior, and III for third.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGenerationQualifier() {
            return null;
        }

        /**
         * First name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGivenName() {
            return null;
        }

        /**
         * Concatenation that typically contains the first letter of the *GivenName* , the first letter of the middle name if one exists, and the first letter of the *Surname* .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInitials() {
            return null;
        }

        /**
         * The locality (such as a city or town) in which the certificate subject is located.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocality() {
            return null;
        }

        /**
         * Legal name of the organization with which the certificate subject is affiliated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrganization() {
            return null;
        }

        /**
         * A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationalUnit() {
            return null;
        }

        /**
         * Typically a shortened version of a longer *GivenName* .
         * <p>
         * For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPseudonym() {
            return null;
        }

        /**
         * The certificate serial number.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSerialNumber() {
            return null;
        }

        /**
         * State in which the subject of the certificate is located.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * Family name.
         * <p>
         * In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSurname() {
            return null;
        }

        /**
         * A title such as Mr.
         * <p>
         * or Ms., which is pre-pended to the name to refer formally to the certificate subject.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SubjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubjectProperty> {
            java.lang.String commonName;
            java.lang.String country;
            java.lang.Object customAttributes;
            java.lang.String distinguishedNameQualifier;
            java.lang.String generationQualifier;
            java.lang.String givenName;
            java.lang.String initials;
            java.lang.String locality;
            java.lang.String organization;
            java.lang.String organizationalUnit;
            java.lang.String pseudonym;
            java.lang.String serialNumber;
            java.lang.String state;
            java.lang.String surname;
            java.lang.String title;

            /**
             * Sets the value of {@link SubjectProperty#getCommonName}
             * @param commonName For CA and end-entity certificates in a private PKI, the common name (CN) can be any string within the length limit.
             *                   Note: In publicly trusted certificates, the common name must be a fully qualified domain name (FQDN) associated with the certificate subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commonName(java.lang.String commonName) {
                this.commonName = commonName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getCountry}
             * @param country Two-digit code that specifies the country in which the certificate subject located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder country(java.lang.String country) {
                this.country = country;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getCustomAttributes}
             * @param customAttributes Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier) .
             *                         <blockquote>
             *                         <p>
             *                         Custom attributes cannot be used in combination with standard attributes.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(software.amazon.awscdk.core.IResolvable customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getCustomAttributes}
             * @param customAttributes Contains a sequence of one or more X.500 relative distinguished names (RDNs), each of which consists of an object identifier (OID) and a value. For more information, see NIST’s definition of [Object Identifier (OID)](https://docs.aws.amazon.com/https://csrc.nist.gov/glossary/term/Object_Identifier) .
             *                         <blockquote>
             *                         <p>
             *                         Custom attributes cannot be used in combination with standard attributes.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(java.util.List<? extends java.lang.Object> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getDistinguishedNameQualifier}
             * @param distinguishedNameQualifier Disambiguating information for the certificate subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder distinguishedNameQualifier(java.lang.String distinguishedNameQualifier) {
                this.distinguishedNameQualifier = distinguishedNameQualifier;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getGenerationQualifier}
             * @param generationQualifier Typically a qualifier appended to the name of an individual.
             *                            Examples include Jr. for junior, Sr. for senior, and III for third.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generationQualifier(java.lang.String generationQualifier) {
                this.generationQualifier = generationQualifier;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getGivenName}
             * @param givenName First name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder givenName(java.lang.String givenName) {
                this.givenName = givenName;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getInitials}
             * @param initials Concatenation that typically contains the first letter of the *GivenName* , the first letter of the middle name if one exists, and the first letter of the *Surname* .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initials(java.lang.String initials) {
                this.initials = initials;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getLocality}
             * @param locality The locality (such as a city or town) in which the certificate subject is located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locality(java.lang.String locality) {
                this.locality = locality;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getOrganization}
             * @param organization Legal name of the organization with which the certificate subject is affiliated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organization(java.lang.String organization) {
                this.organization = organization;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getOrganizationalUnit}
             * @param organizationalUnit A subdivision or unit of the organization (such as sales or finance) with which the certificate subject is affiliated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationalUnit(java.lang.String organizationalUnit) {
                this.organizationalUnit = organizationalUnit;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getPseudonym}
             * @param pseudonym Typically a shortened version of a longer *GivenName* .
             *                  For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth, Liz, or Eliza.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pseudonym(java.lang.String pseudonym) {
                this.pseudonym = pseudonym;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getSerialNumber}
             * @param serialNumber The certificate serial number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serialNumber(java.lang.String serialNumber) {
                this.serialNumber = serialNumber;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getState}
             * @param state State in which the subject of the certificate is located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getSurname}
             * @param surname Family name.
             *                In the US and the UK, for example, the surname of an individual is ordered last. In Asian cultures the surname is typically ordered first.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder surname(java.lang.String surname) {
                this.surname = surname;
                return this;
            }

            /**
             * Sets the value of {@link SubjectProperty#getTitle}
             * @param title A title such as Mr.
             *              or Ms., which is pre-pended to the name to refer formally to the certificate subject.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubjectProperty {
            private final java.lang.String commonName;
            private final java.lang.String country;
            private final java.lang.Object customAttributes;
            private final java.lang.String distinguishedNameQualifier;
            private final java.lang.String generationQualifier;
            private final java.lang.String givenName;
            private final java.lang.String initials;
            private final java.lang.String locality;
            private final java.lang.String organization;
            private final java.lang.String organizationalUnit;
            private final java.lang.String pseudonym;
            private final java.lang.String serialNumber;
            private final java.lang.String state;
            private final java.lang.String surname;
            private final java.lang.String title;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.commonName = software.amazon.jsii.Kernel.get(this, "commonName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.country = software.amazon.jsii.Kernel.get(this, "country", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.distinguishedNameQualifier = software.amazon.jsii.Kernel.get(this, "distinguishedNameQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.generationQualifier = software.amazon.jsii.Kernel.get(this, "generationQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.givenName = software.amazon.jsii.Kernel.get(this, "givenName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.initials = software.amazon.jsii.Kernel.get(this, "initials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locality = software.amazon.jsii.Kernel.get(this, "locality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organization = software.amazon.jsii.Kernel.get(this, "organization", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationalUnit = software.amazon.jsii.Kernel.get(this, "organizationalUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pseudonym = software.amazon.jsii.Kernel.get(this, "pseudonym", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serialNumber = software.amazon.jsii.Kernel.get(this, "serialNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.surname = software.amazon.jsii.Kernel.get(this, "surname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.commonName = builder.commonName;
                this.country = builder.country;
                this.customAttributes = builder.customAttributes;
                this.distinguishedNameQualifier = builder.distinguishedNameQualifier;
                this.generationQualifier = builder.generationQualifier;
                this.givenName = builder.givenName;
                this.initials = builder.initials;
                this.locality = builder.locality;
                this.organization = builder.organization;
                this.organizationalUnit = builder.organizationalUnit;
                this.pseudonym = builder.pseudonym;
                this.serialNumber = builder.serialNumber;
                this.state = builder.state;
                this.surname = builder.surname;
                this.title = builder.title;
            }

            @Override
            public final java.lang.String getCommonName() {
                return this.commonName;
            }

            @Override
            public final java.lang.String getCountry() {
                return this.country;
            }

            @Override
            public final java.lang.Object getCustomAttributes() {
                return this.customAttributes;
            }

            @Override
            public final java.lang.String getDistinguishedNameQualifier() {
                return this.distinguishedNameQualifier;
            }

            @Override
            public final java.lang.String getGenerationQualifier() {
                return this.generationQualifier;
            }

            @Override
            public final java.lang.String getGivenName() {
                return this.givenName;
            }

            @Override
            public final java.lang.String getInitials() {
                return this.initials;
            }

            @Override
            public final java.lang.String getLocality() {
                return this.locality;
            }

            @Override
            public final java.lang.String getOrganization() {
                return this.organization;
            }

            @Override
            public final java.lang.String getOrganizationalUnit() {
                return this.organizationalUnit;
            }

            @Override
            public final java.lang.String getPseudonym() {
                return this.pseudonym;
            }

            @Override
            public final java.lang.String getSerialNumber() {
                return this.serialNumber;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.lang.String getSurname() {
                return this.surname;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommonName() != null) {
                    data.set("commonName", om.valueToTree(this.getCommonName()));
                }
                if (this.getCountry() != null) {
                    data.set("country", om.valueToTree(this.getCountry()));
                }
                if (this.getCustomAttributes() != null) {
                    data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
                }
                if (this.getDistinguishedNameQualifier() != null) {
                    data.set("distinguishedNameQualifier", om.valueToTree(this.getDistinguishedNameQualifier()));
                }
                if (this.getGenerationQualifier() != null) {
                    data.set("generationQualifier", om.valueToTree(this.getGenerationQualifier()));
                }
                if (this.getGivenName() != null) {
                    data.set("givenName", om.valueToTree(this.getGivenName()));
                }
                if (this.getInitials() != null) {
                    data.set("initials", om.valueToTree(this.getInitials()));
                }
                if (this.getLocality() != null) {
                    data.set("locality", om.valueToTree(this.getLocality()));
                }
                if (this.getOrganization() != null) {
                    data.set("organization", om.valueToTree(this.getOrganization()));
                }
                if (this.getOrganizationalUnit() != null) {
                    data.set("organizationalUnit", om.valueToTree(this.getOrganizationalUnit()));
                }
                if (this.getPseudonym() != null) {
                    data.set("pseudonym", om.valueToTree(this.getPseudonym()));
                }
                if (this.getSerialNumber() != null) {
                    data.set("serialNumber", om.valueToTree(this.getSerialNumber()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }
                if (this.getSurname() != null) {
                    data.set("surname", om.valueToTree(this.getSurname()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.SubjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubjectProperty.Jsii$Proxy that = (SubjectProperty.Jsii$Proxy) o;

                if (this.commonName != null ? !this.commonName.equals(that.commonName) : that.commonName != null) return false;
                if (this.country != null ? !this.country.equals(that.country) : that.country != null) return false;
                if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
                if (this.distinguishedNameQualifier != null ? !this.distinguishedNameQualifier.equals(that.distinguishedNameQualifier) : that.distinguishedNameQualifier != null) return false;
                if (this.generationQualifier != null ? !this.generationQualifier.equals(that.generationQualifier) : that.generationQualifier != null) return false;
                if (this.givenName != null ? !this.givenName.equals(that.givenName) : that.givenName != null) return false;
                if (this.initials != null ? !this.initials.equals(that.initials) : that.initials != null) return false;
                if (this.locality != null ? !this.locality.equals(that.locality) : that.locality != null) return false;
                if (this.organization != null ? !this.organization.equals(that.organization) : that.organization != null) return false;
                if (this.organizationalUnit != null ? !this.organizationalUnit.equals(that.organizationalUnit) : that.organizationalUnit != null) return false;
                if (this.pseudonym != null ? !this.pseudonym.equals(that.pseudonym) : that.pseudonym != null) return false;
                if (this.serialNumber != null ? !this.serialNumber.equals(that.serialNumber) : that.serialNumber != null) return false;
                if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
                if (this.surname != null ? !this.surname.equals(that.surname) : that.surname != null) return false;
                return this.title != null ? this.title.equals(that.title) : that.title == null;
            }

            @Override
            public final int hashCode() {
                int result = this.commonName != null ? this.commonName.hashCode() : 0;
                result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
                result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
                result = 31 * result + (this.distinguishedNameQualifier != null ? this.distinguishedNameQualifier.hashCode() : 0);
                result = 31 * result + (this.generationQualifier != null ? this.generationQualifier.hashCode() : 0);
                result = 31 * result + (this.givenName != null ? this.givenName.hashCode() : 0);
                result = 31 * result + (this.initials != null ? this.initials.hashCode() : 0);
                result = 31 * result + (this.locality != null ? this.locality.hashCode() : 0);
                result = 31 * result + (this.organization != null ? this.organization.hashCode() : 0);
                result = 31 * result + (this.organizationalUnit != null ? this.organizationalUnit.hashCode() : 0);
                result = 31 * result + (this.pseudonym != null ? this.pseudonym.hashCode() : 0);
                result = 31 * result + (this.serialNumber != null ? this.serialNumber.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                result = 31 * result + (this.surname != null ? this.surname.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Length of time for which the certificate issued by your private certificate authority (CA), or by the private CA itself, is valid in days, months, or years.
     * <p>
     * You can issue a certificate by calling the <code>IssueCertificate</code> operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.acmpca.*;
     * ValidityProperty validityProperty = ValidityProperty.builder()
     *         .type("type")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.acmpca.$Module.class, fqn = "@aws-cdk/aws-acmpca.CfnCertificate.ValidityProperty")
    @software.amazon.jsii.Jsii.Proxy(ValidityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ValidityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the `Value` parameter represents days, months, or years.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A long integer interpreted according to the value of `Type` , below.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link ValidityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ValidityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ValidityProperty> {
            java.lang.String type;
            java.lang.Number value;

            /**
             * Sets the value of {@link ValidityProperty#getType}
             * @param type Specifies whether the `Value` parameter represents days, months, or years. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ValidityProperty#getValue}
             * @param value A long integer interpreted according to the value of `Type` , below. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ValidityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ValidityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ValidityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ValidityProperty {
            private final java.lang.String type;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-acmpca.CfnCertificate.ValidityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ValidityProperty.Jsii$Proxy that = (ValidityProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.acmpca.CfnCertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.acmpca.CfnCertificate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.acmpca.CfnCertificateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.acmpca.CfnCertificateProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) for the private CA issues the certificate.
         * <p>
         * @return {@code this}
         * @param certificateAuthorityArn The Amazon Resource Name (ARN) for the private CA issues the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateAuthorityArn(final java.lang.String certificateAuthorityArn) {
            this.props.certificateAuthorityArn(certificateAuthorityArn);
            return this;
        }

        /**
         * The certificate signing request (CSR) for the certificate.
         * <p>
         * @return {@code this}
         * @param certificateSigningRequest The certificate signing request (CSR) for the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateSigningRequest(final java.lang.String certificateSigningRequest) {
            this.props.certificateSigningRequest(certificateSigningRequest);
            return this;
        }

        /**
         * The name of the algorithm that will be used to sign the certificate to be issued.
         * <p>
         * This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.
         * <p>
         * <blockquote>
         * <p>
         * The specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA's secret key.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param signingAlgorithm The name of the algorithm that will be used to sign the certificate to be issued. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingAlgorithm(final java.lang.String signingAlgorithm) {
            this.props.signingAlgorithm(signingAlgorithm);
            return this;
        }

        /**
         * The period of time during which the certificate will be valid.
         * <p>
         * @return {@code this}
         * @param validity The period of time during which the certificate will be valid. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validity(final software.amazon.awscdk.services.acmpca.CfnCertificate.ValidityProperty validity) {
            this.props.validity(validity);
            return this;
        }
        /**
         * The period of time during which the certificate will be valid.
         * <p>
         * @return {@code this}
         * @param validity The period of time during which the certificate will be valid. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validity(final software.amazon.awscdk.core.IResolvable validity) {
            this.props.validity(validity);
            return this;
        }

        /**
         * Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
         * <p>
         * @return {@code this}
         * @param apiPassthrough Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiPassthrough(final software.amazon.awscdk.core.IResolvable apiPassthrough) {
            this.props.apiPassthrough(apiPassthrough);
            return this;
        }
        /**
         * Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
         * <p>
         * @return {@code this}
         * @param apiPassthrough Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiPassthrough(final software.amazon.awscdk.services.acmpca.CfnCertificate.ApiPassthroughProperty apiPassthrough) {
            this.props.apiPassthrough(apiPassthrough);
            return this;
        }

        /**
         * Specifies a custom configuration template to use when issuing a certificate.
         * <p>
         * If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For more information about ACM Private CA templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a> .
         * <p>
         * @return {@code this}
         * @param templateArn Specifies a custom configuration template to use when issuing a certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateArn(final java.lang.String templateArn) {
            this.props.templateArn(templateArn);
            return this;
        }

        /**
         * Information describing the start of the validity period of the certificate.
         * <p>
         * This parameter sets the “Not Before" date for the certificate.
         * <p>
         * By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value.
         * <p>
         * Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.
         * <p>
         * The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code> .
         * <p>
         * @return {@code this}
         * @param validityNotBefore Information describing the start of the validity period of the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validityNotBefore(final software.amazon.awscdk.services.acmpca.CfnCertificate.ValidityProperty validityNotBefore) {
            this.props.validityNotBefore(validityNotBefore);
            return this;
        }
        /**
         * Information describing the start of the validity period of the certificate.
         * <p>
         * This parameter sets the “Not Before" date for the certificate.
         * <p>
         * By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value.
         * <p>
         * Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.
         * <p>
         * The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code> .
         * <p>
         * @return {@code this}
         * @param validityNotBefore Information describing the start of the validity period of the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validityNotBefore(final software.amazon.awscdk.core.IResolvable validityNotBefore) {
            this.props.validityNotBefore(validityNotBefore);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.acmpca.CfnCertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.acmpca.CfnCertificate build() {
            return new software.amazon.awscdk.services.acmpca.CfnCertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
