/*
 * Decompiled with CFR 0.152.
 */
package tw.com.softworld.messagescenter;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import tw.com.softworld.messagescenter.AsyncResponse;
import tw.com.softworld.messagescenter.CLog;
import tw.com.softworld.messagescenter.Config;

public class Server {
    private static final String TAG = "messagescenter";
    private Context ctx;
    private AsyncResponse ar;

    public Server(Context ctx, AsyncResponse ar) {
        this.ctx = ctx;
        this.ar = ar;
    }

    public void pushBundle(String action, Bundle messages) {
        String key;
        if (action == null || messages == null) {
            this.ar.onFailure(100);
            return;
        }
        if (Config.messagesList.containsKey(action) && !(key = Config.messagesList.get(action)).equals("MESSAGES_BUNDLE")) {
            this.ar.onFailure(101);
            CLog.e(TAG, "MULTIPLE_VALUE:" + action);
            return;
        }
        Intent broadcast = new Intent(action);
        broadcast.putExtra("MESSAGES_BUNDLE", messages);
        Config.messagesList.put(action, "MESSAGES_BUNDLE");
        LocalBroadcastManager.getInstance((Context)this.ctx).sendBroadcast(broadcast);
    }

    public void pushBoolean(String action, boolean messages) {
        String key;
        if (action == null) {
            this.ar.onFailure(100);
            return;
        }
        if (Config.messagesList.containsKey(action) && !(key = Config.messagesList.get(action)).equals("MESSAGES_BOOLEAN")) {
            this.ar.onFailure(101);
            CLog.e(TAG, "MULTIPLE_VALUE:" + action);
            return;
        }
        Intent broadcast = new Intent(action);
        broadcast.putExtra("MESSAGES_BOOLEAN", messages);
        Config.messagesList.put(action, "MESSAGES_BOOLEAN");
        LocalBroadcastManager.getInstance((Context)this.ctx).sendBroadcast(broadcast);
    }

    public void pushString(String action, String messages) {
        String key;
        if (action == null || messages == null) {
            this.ar.onFailure(100);
            return;
        }
        if (Config.messagesList.containsKey(action) && !(key = Config.messagesList.get(action)).equals("MESSAGES_STRING")) {
            this.ar.onFailure(101);
            CLog.e(TAG, "MULTIPLE_VALUE:" + action);
            return;
        }
        Intent broadcast = new Intent(action);
        broadcast.putExtra("MESSAGES_STRING", messages);
        Config.messagesList.put(action, "MESSAGES_STRING");
        LocalBroadcastManager.getInstance((Context)this.ctx).sendBroadcast(broadcast);
    }

    public void pushInt(String action, int messages) {
        String key;
        if (action == null) {
            this.ar.onFailure(100);
            return;
        }
        if (Config.messagesList.containsKey(action) && !(key = Config.messagesList.get(action)).equals("MESSAGES_INT")) {
            this.ar.onFailure(101);
            CLog.e(TAG, "MULTIPLE_VALUE:" + action);
            return;
        }
        Intent broadcast = new Intent(action);
        broadcast.putExtra("MESSAGES_INT", messages);
        Config.messagesList.put(action, "MESSAGES_INT");
        LocalBroadcastManager.getInstance((Context)this.ctx).sendBroadcast(broadcast);
    }

    public void pushDouble(String action, double messages) {
        String key;
        if (action == null) {
            this.ar.onFailure(100);
            return;
        }
        if (Config.messagesList.containsKey(action) && !(key = Config.messagesList.get(action)).equals("MESSAGES_DOUBLE")) {
            this.ar.onFailure(101);
            CLog.e(TAG, "MULTIPLE_VALUE:" + action);
            return;
        }
        Intent broadcast = new Intent(action);
        broadcast.putExtra("MESSAGES_DOUBLE", messages);
        Config.messagesList.put(action, "MESSAGES_DOUBLE");
        LocalBroadcastManager.getInstance((Context)this.ctx).sendBroadcast(broadcast);
    }

    public void pushByte(String action, byte messages) {
        String key;
        if (action == null) {
            this.ar.onFailure(100);
            return;
        }
        if (Config.messagesList.containsKey(action) && !(key = Config.messagesList.get(action)).equals("MESSAGES_BYTE")) {
            this.ar.onFailure(101);
            CLog.e(TAG, "MULTIPLE_VALUE:" + action);
            return;
        }
        Intent broadcast = new Intent(action);
        broadcast.putExtra("MESSAGES_BYTE", messages);
        Config.messagesList.put(action, "MESSAGES_BYTE");
        LocalBroadcastManager.getInstance((Context)this.ctx).sendBroadcast(broadcast);
    }
}

