/*
 * Decompiled with CFR 0.152.
 */
package tw.com.softworld.messagescenter;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import tw.com.softworld.messagescenter.CLog;
import tw.com.softworld.messagescenter.Config;
import tw.com.softworld.messagescenter.CustomReceiver;
import tw.com.softworld.messagescenter.Result;

public class Client {
    private static final String TAG = "messagescenter";
    private Context ctx;
    private Result result;
    private CustomReceiver cr;
    private BroadcastReceiver broadcastReceiver;
    private LocalBroadcastManager broadcastManager;

    public Client(Context ctx, CustomReceiver cr) {
        this.ctx = ctx;
        this.cr = cr;
        this.result = new Result();
    }

    public void gotMessages(final String action) {
        this.broadcastManager = LocalBroadcastManager.getInstance((Context)this.ctx);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(action);
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (Config.messagesList.get(action) != null) {
                    if (Config.messagesList.get(action).equals("MESSAGES_BUNDLE")) {
                        Client.this.result.setBundle(intent.getBundleExtra("MESSAGES_BUNDLE"));
                        Client.this.cr.onBroadcastReceive(Client.this.result);
                        CLog.d(Client.TAG, "(" + action + ")You got a message");
                    } else if (Config.messagesList.get(action).equals("MESSAGES_BOOLEAN")) {
                        Client.this.result.setBoolean(intent.getBooleanExtra("MESSAGES_BOOLEAN", false));
                        Client.this.cr.onBroadcastReceive(Client.this.result);
                        CLog.d(Client.TAG, "(" + action + ")You got a message");
                    } else if (Config.messagesList.get(action).equals("MESSAGES_STRING")) {
                        Client.this.result.setString(intent.getStringExtra("MESSAGES_STRING"));
                        Client.this.cr.onBroadcastReceive(Client.this.result);
                        CLog.d(Client.TAG, "(" + action + ")You got a message");
                    } else if (Config.messagesList.get(action).equals("MESSAGES_INT")) {
                        Client.this.result.setInt(intent.getIntExtra("MESSAGES_INT", -1));
                        Client.this.cr.onBroadcastReceive(Client.this.result);
                        CLog.d(Client.TAG, "(" + action + ")You got a message");
                    } else if (Config.messagesList.get(action).equals("MESSAGES_DOUBLE")) {
                        Client.this.result.setDouble(intent.getDoubleExtra("MESSAGES_DOUBLE", 0.0));
                        Client.this.cr.onBroadcastReceive(Client.this.result);
                        CLog.d(Client.TAG, "(" + action + ")You got a message");
                    }
                }
            }
        };
        this.broadcastManager.registerReceiver(this.broadcastReceiver, intentFilter);
    }

    public void unRegister(String actionName) {
        Config.messagesList.remove(actionName);
    }

    public void release() {
        if (this.broadcastReceiver != null) {
            this.broadcastManager.unregisterReceiver(this.broadcastReceiver);
        }
    }
}

