/*
 * Decompiled with CFR 0.152.
 */
package com.craftman.cardform;

import android.support.annotation.Nullable;

public class StripeTextUtils {
    public static boolean hasAnyPrefix(String number, String ... prefixes) {
        if (number == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!number.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWholePositiveNumber(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String nullIfBlank(String value) {
        if (StripeTextUtils.isBlank(value)) {
            return null;
        }
        return value;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    @Nullable
    public static String asCardBrand(@Nullable String possibleCardType) {
        if (StripeTextUtils.isBlank(possibleCardType)) {
            return null;
        }
        if ("American Express".equalsIgnoreCase(possibleCardType)) {
            return "American Express";
        }
        if ("MasterCard".equalsIgnoreCase(possibleCardType)) {
            return "MasterCard";
        }
        if ("Diners Club".equalsIgnoreCase(possibleCardType)) {
            return "Diners Club";
        }
        if ("Discover".equalsIgnoreCase(possibleCardType)) {
            return "Discover";
        }
        if ("JCB".equalsIgnoreCase(possibleCardType)) {
            return "JCB";
        }
        if ("Visa".equalsIgnoreCase(possibleCardType)) {
            return "Visa";
        }
        return "Unknown";
    }

    @Nullable
    public static String asFundingType(@Nullable String possibleFundingType) {
        if (StripeTextUtils.isBlank(possibleFundingType)) {
            return null;
        }
        if ("credit".equalsIgnoreCase(possibleFundingType)) {
            return "credit";
        }
        if ("debit".equalsIgnoreCase(possibleFundingType)) {
            return "debit";
        }
        if ("prepaid".equalsIgnoreCase(possibleFundingType)) {
            return "prepaid";
        }
        return "unknown";
    }

    @Nullable
    public static String asTokenType(@Nullable String possibleTokenType) {
        if ("card".equals(possibleTokenType)) {
            return "card";
        }
        return null;
    }
}

