/*
 * Decompiled with CFR 0.152.
 */
package com.craftman.cardform;

import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.craftman.cardform.DateUtils;
import com.craftman.cardform.StripeTextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CreditCard {
    public static final String AMERICAN_EXPRESS = "American Express";
    public static final String DISCOVER = "Discover";
    public static final String JCB = "JCB";
    public static final String DINERS_CLUB = "Diners Club";
    public static final String VISA = "Visa";
    public static final String MASTERCARD = "MasterCard";
    public static final String UNKNOWN = "Unknown";
    public static final String FUNDING_CREDIT = "credit";
    public static final String FUNDING_DEBIT = "debit";
    public static final String FUNDING_PREPAID = "prepaid";
    public static final String FUNDING_UNKNOWN = "unknown";
    public static final String[] PREFIXES_AMERICAN_EXPRESS = new String[]{"34", "37"};
    public static final String[] PREFIXES_DISCOVER = new String[]{"60", "62", "64", "65"};
    public static final String[] PREFIXES_JCB = new String[]{"35"};
    public static final String[] PREFIXES_DINERS_CLUB = new String[]{"300", "301", "302", "303", "304", "305", "309", "36", "38", "39"};
    public static final String[] PREFIXES_VISA = new String[]{"4"};
    public static final String[] PREFIXES_MASTERCARD = new String[]{"2221", "2222", "2223", "2224", "2225", "2226", "2227", "2228", "2229", "223", "224", "225", "226", "227", "228", "229", "23", "24", "25", "26", "270", "271", "2720", "50", "51", "52", "53", "54", "55"};
    public static final int MAX_LENGTH_STANDARD = 16;
    public static final int MAX_LENGTH_AMERICAN_EXPRESS = 15;
    public static final int MAX_LENGTH_DINERS_CLUB = 14;
    private String number;
    private String cvc;
    private Integer expMonth;
    private Integer expYear;
    private String name;
    private String addressLine1;
    private String addressLine2;
    private String addressCity;
    private String addressState;
    private String addressZip;
    private String addressCountry;
    @Size(value=4L)
    private String last4;
    private String brand;
    private String funding;
    private String fingerprint;
    private String country;
    private String currency;

    public CreditCard(String number, Integer expMonth, Integer expYear, String cvc, String name, String addressLine1, String addressLine2, String addressCity, String addressState, String addressZip, String addressCountry, String brand, @Size(value=4L) String last4, String fingerprint, String funding, String country, String currency) {
        this.number = StripeTextUtils.nullIfBlank(this.normalizeCardNumber(number));
        this.expMonth = expMonth;
        this.expYear = expYear;
        this.cvc = StripeTextUtils.nullIfBlank(cvc);
        this.name = StripeTextUtils.nullIfBlank(name);
        this.addressLine1 = StripeTextUtils.nullIfBlank(addressLine1);
        this.addressLine2 = StripeTextUtils.nullIfBlank(addressLine2);
        this.addressCity = StripeTextUtils.nullIfBlank(addressCity);
        this.addressState = StripeTextUtils.nullIfBlank(addressState);
        this.addressZip = StripeTextUtils.nullIfBlank(addressZip);
        this.addressCountry = StripeTextUtils.nullIfBlank(addressCountry);
        this.brand = StripeTextUtils.asCardBrand(brand) == null ? this.getBrand() : brand;
        this.last4 = StripeTextUtils.nullIfBlank(last4) == null ? this.getLast4() : last4;
        this.fingerprint = StripeTextUtils.nullIfBlank(fingerprint);
        this.country = StripeTextUtils.nullIfBlank(country);
        this.currency = StripeTextUtils.nullIfBlank(currency);
    }

    public CreditCard(String number, Integer expMonth, Integer expYear, String cvc, String name, String addressLine1, String addressLine2, String addressCity, String addressState, String addressZip, String addressCountry, String currency) {
        this(number, expMonth, expYear, cvc, name, addressLine1, addressLine2, addressCity, addressState, addressZip, addressCountry, null, null, null, null, null, currency);
    }

    public CreditCard(String number, Integer expMonth, Integer expYear, String cvc) {
        this(number, expMonth, expYear, cvc, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private CreditCard(Builder builder) {
        this.number = StripeTextUtils.nullIfBlank(this.normalizeCardNumber(builder.number));
        this.expMonth = builder.expMonth;
        this.expYear = builder.expYear;
        this.cvc = StripeTextUtils.nullIfBlank(builder.cvc);
        this.name = StripeTextUtils.nullIfBlank(builder.name);
        this.addressLine1 = StripeTextUtils.nullIfBlank(builder.addressLine1);
        this.addressLine2 = StripeTextUtils.nullIfBlank(builder.addressLine2);
        this.addressCity = StripeTextUtils.nullIfBlank(builder.addressCity);
        this.addressState = StripeTextUtils.nullIfBlank(builder.addressState);
        this.addressZip = StripeTextUtils.nullIfBlank(builder.addressZip);
        this.addressCountry = StripeTextUtils.nullIfBlank(builder.addressCountry);
        this.last4 = StripeTextUtils.nullIfBlank(builder.last4) == null ? this.getLast4() : builder.last4;
        this.brand = StripeTextUtils.asCardBrand(builder.brand) == null ? this.getBrand() : builder.brand;
        this.fingerprint = StripeTextUtils.nullIfBlank(builder.fingerprint);
        this.country = StripeTextUtils.nullIfBlank(builder.country);
        this.currency = StripeTextUtils.nullIfBlank(builder.currency);
    }

    public boolean validateCard() {
        if (this.cvc == null) {
            return this.validateNumber() && this.validateExpiryDate();
        }
        return this.validateNumber() && this.validateExpiryDate() && this.validateCVC();
    }

    public boolean validateNumber() {
        if (StripeTextUtils.isBlank(this.number)) {
            return false;
        }
        String rawNumber = this.number.trim().replaceAll("\\s+|-", "");
        if (StripeTextUtils.isBlank(rawNumber) || !StripeTextUtils.isWholePositiveNumber(rawNumber) || !this.isValidLuhnNumber(rawNumber)) {
            return false;
        }
        String updatedType = this.getBrand();
        if (AMERICAN_EXPRESS.equals(updatedType)) {
            return rawNumber.length() == 15;
        }
        if (DINERS_CLUB.equals(updatedType)) {
            return rawNumber.length() == 14;
        }
        return rawNumber.length() == 16;
    }

    public boolean validateExpiryDate() {
        if (!this.validateExpMonth()) {
            return false;
        }
        if (!this.validateExpYear()) {
            return false;
        }
        return !DateUtils.hasMonthPassed(this.expYear, this.expMonth);
    }

    public boolean validateCVC() {
        if (StripeTextUtils.isBlank(this.cvc)) {
            return false;
        }
        String cvcValue = this.cvc.trim();
        String updatedType = this.getBrand();
        boolean validLength = updatedType == null && cvcValue.length() >= 3 && cvcValue.length() <= 4 || AMERICAN_EXPRESS.equals(updatedType) && cvcValue.length() == 4 || cvcValue.length() == 3;
        return StripeTextUtils.isWholePositiveNumber(cvcValue) && validLength;
    }

    public boolean validateExpMonth() {
        return this.expMonth != null && this.expMonth >= 1 && this.expMonth <= 12;
    }

    public boolean validateExpYear() {
        return this.expYear != null && !DateUtils.hasYearPassed(this.expYear);
    }

    public String getNumber() {
        return this.number;
    }

    @Deprecated
    public void setNumber(String number) {
        this.number = number;
        this.brand = null;
        this.last4 = null;
    }

    public String getCVC() {
        return this.cvc;
    }

    @Deprecated
    public void setCVC(String cvc) {
        this.cvc = cvc;
    }

    @Nullable
    @IntRange(from=1L, to=12L)
    public Integer getExpMonth() {
        return this.expMonth;
    }

    @Deprecated
    public void setExpMonth(@Nullable @IntRange(from=1L, to=12L) Integer expMonth) {
        this.expMonth = expMonth;
    }

    public Integer getExpYear() {
        return this.expYear;
    }

    @Deprecated
    public void setExpYear(Integer expYear) {
        this.expYear = expYear;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    @Deprecated
    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    @Deprecated
    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressCity() {
        return this.addressCity;
    }

    @Deprecated
    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    public String getAddressZip() {
        return this.addressZip;
    }

    @Deprecated
    public void setAddressZip(String addressZip) {
        this.addressZip = addressZip;
    }

    public String getAddressState() {
        return this.addressState;
    }

    @Deprecated
    public void setAddressState(String addressState) {
        this.addressState = addressState;
    }

    public String getAddressCountry() {
        return this.addressCountry;
    }

    @Deprecated
    public void setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
    }

    public String getCurrency() {
        return this.currency;
    }

    @Deprecated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getLast4() {
        if (!StripeTextUtils.isBlank(this.last4)) {
            return this.last4;
        }
        if (this.number != null && this.number.length() > 4) {
            this.last4 = this.number.substring(this.number.length() - 4, this.number.length());
            return this.last4;
        }
        return null;
    }

    @Deprecated
    public String getType() {
        return this.getBrand();
    }

    public String getBrand() {
        if (StripeTextUtils.isBlank(this.brand) && !StripeTextUtils.isBlank(this.number)) {
            String evaluatedType = StripeTextUtils.hasAnyPrefix(this.number, PREFIXES_AMERICAN_EXPRESS) ? AMERICAN_EXPRESS : (StripeTextUtils.hasAnyPrefix(this.number, PREFIXES_DISCOVER) ? DISCOVER : (StripeTextUtils.hasAnyPrefix(this.number, PREFIXES_JCB) ? JCB : (StripeTextUtils.hasAnyPrefix(this.number, PREFIXES_DINERS_CLUB) ? DINERS_CLUB : (StripeTextUtils.hasAnyPrefix(this.number, PREFIXES_VISA) ? VISA : (StripeTextUtils.hasAnyPrefix(this.number, PREFIXES_MASTERCARD) ? MASTERCARD : UNKNOWN)))));
            this.brand = evaluatedType;
        }
        return this.brand;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    @Nullable
    public String getFunding() {
        return this.funding;
    }

    public String getCountry() {
        return this.country;
    }

    private boolean isValidLuhnNumber(String number) {
        boolean isOdd = true;
        int sum = 0;
        for (int index = number.length() - 1; index >= 0; --index) {
            char c = number.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Integer.parseInt("" + c);
            boolean bl = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }

    private String normalizeCardNumber(String number) {
        if (number == null) {
            return null;
        }
        return number.trim().replaceAll("\\s+|-", "");
    }

    public static class Builder {
        private final String number;
        private final String cvc;
        private final Integer expMonth;
        private final Integer expYear;
        private String name;
        private String addressLine1;
        private String addressLine2;
        private String addressCity;
        private String addressState;
        private String addressZip;
        private String addressCountry;
        private String brand;
        private String funding;
        @Size(value=4L)
        private String last4;
        private String fingerprint;
        private String country;
        private String currency;

        public Builder(String number, @IntRange(from=1L, to=12L) Integer expMonth, @IntRange(from=0L) Integer expYear, String cvc) {
            this.number = number;
            this.expMonth = expMonth;
            this.expYear = expYear;
            this.cvc = cvc;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addressLine1(String address) {
            this.addressLine1 = address;
            return this;
        }

        public Builder addressLine2(String address) {
            this.addressLine2 = address;
            return this;
        }

        public Builder addressCity(String city) {
            this.addressCity = city;
            return this;
        }

        public Builder addressState(String state) {
            this.addressState = state;
            return this;
        }

        public Builder addressZip(String zip) {
            this.addressZip = zip;
            return this;
        }

        public Builder addressCountry(String country) {
            this.addressCountry = country;
            return this;
        }

        public Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder funding(String funding) {
            this.funding = funding;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder last4(String last4) {
            this.last4 = last4;
            return this;
        }

        public CreditCard build() {
            return new CreditCard(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FundingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CardBrand {
    }
}

