/*
 * Decompiled with CFR 0.152.
 */
package com.craftman.cardform;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.Context;
import android.support.v7.widget.LinearLayoutCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.craftman.cardform.CreditCard;
import com.craftman.cardform.OnPayBtnClickListner;
import com.wireless.creditcardlib.R;
import java.util.Date;

public class CardForm
extends LinearLayoutCompat {
    private static final char space = ' ';
    boolean isBackShowing = false;
    String amount = "$500.00";
    OnPayBtnClickListner onPayBtnClickListner;
    String cardNameError = "Correct CreditCard Name is requierd";
    String cardNumberError = "Correct CreditCard Number is requierd";
    String cvcError = "Correct  cvc is requierd";
    String expiryDateError = "Correct  expiry date is requierd";
    private EditText cardName;
    private EditText cardNumber;
    private TextView paymentAmountTextHolder;
    private TextView previewCardType;
    private EditText cvc;
    private EditText expiryDate;
    private TextView previewCardName;
    private TextView previewCardNumber;
    private TextView previewCvc;
    private TextView previewExpiry;
    private TextView paymentAmount;
    private ViewGroup cardBack;
    private ViewGroup cardFront;
    private Button btnPay;
    private char slash = (char)47;

    public CardForm(Context context) {
        super(context);
        this.init();
    }

    public CardForm(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CardForm(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setAmount(String amount) {
        this.amount = amount;
        this.paymentAmount.setText((CharSequence)amount);
    }

    public void setCardNameError(String cardNameError) {
        this.cardNameError = cardNameError;
    }

    public void setCardNumberError(String cardNumberError) {
        this.cardNumberError = cardNumberError;
    }

    public void setCvcError(String cvcError) {
        this.cvcError = cvcError;
    }

    public void setExpiryDateError(String expiryDateError) {
        this.expiryDateError = expiryDateError;
    }

    public CreditCard getCard() {
        String[] expiry = this.getString(this.expiryDate).split(String.valueOf(this.slash));
        Integer month = 0;
        Integer year = 0;
        if (expiry.length >= 2) {
            month = Integer.parseInt(expiry[0]);
            year = Integer.parseInt(this.parseDate(expiry[1]));
        }
        return new CreditCard(this.getString(this.cardNumber).replaceAll(String.valueOf(' '), ""), month, year, this.getString(this.cvc), this.getString(this.cardName), "", "", "", "", "", "", "");
    }

    private String parseDate(String str) {
        int year = Integer.valueOf(str);
        year = year + 100 > new Date().getYear() + 5 ? (year += 1900) : (year += 2000);
        return String.valueOf(year);
    }

    private String getString(EditText ed) {
        return ed.getText().toString().trim();
    }

    private Integer getInt(EditText ed) {
        return Integer.parseInt(ed.getText().toString().trim());
    }

    private void init() {
        CardForm.inflate((Context)this.getContext(), (int)R.layout.cardformlayout, (ViewGroup)this);
        this.cardName = (EditText)this.findViewById(R.id.card_name);
        this.cardNumber = (EditText)this.findViewById(R.id.card_number);
        this.cvc = (EditText)this.findViewById(R.id.cvc);
        this.expiryDate = (EditText)this.findViewById(R.id.expiry_date);
        this.previewCardName = (TextView)this.findViewById(R.id.card_preview_name);
        this.previewCardNumber = (TextView)this.findViewById(R.id.card_preview_number);
        this.previewCvc = (TextView)this.findViewById(R.id.card_preview_cvc);
        this.previewExpiry = (TextView)this.findViewById(R.id.card_preview_expiry);
        this.paymentAmount = (TextView)this.findViewById(R.id.payment_amount);
        this.paymentAmountTextHolder = (TextView)this.findViewById(R.id.payment_amount_holder);
        this.previewCardType = (TextView)this.findViewById(R.id.card_preview_type);
        this.cardFront = (ViewGroup)this.findViewById(R.id.card_preview_front);
        this.cardBack = (ViewGroup)this.findViewById(R.id.card_preview_back);
        this.btnPay = (Button)this.findViewById(R.id.btn_pay);
        this.paymentAmount.setText((CharSequence)this.amount);
        this.btnPay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TextUtils.isEmpty((CharSequence)CardForm.this.getString(CardForm.this.cardName))) {
                    CardForm.this.cardName.setError((CharSequence)CardForm.this.cardNameError);
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)CardForm.this.getString(CardForm.this.cardNumber))) {
                    CardForm.this.cardNumber.setError((CharSequence)CardForm.this.cardNumberError);
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)CardForm.this.getString(CardForm.this.cvc))) {
                    CardForm.this.cvc.setError((CharSequence)CardForm.this.cvcError);
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)CardForm.this.getString(CardForm.this.expiryDate))) {
                    CardForm.this.expiryDate.setError((CharSequence)CardForm.this.expiryDateError);
                    return;
                }
                if (CardForm.this.cardIsvalid()) {
                    CardForm.this.onPayBtnClickListner.onClick(CardForm.this.getCard());
                }
            }
        });
        this.cardNumber.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                char c;
                if (editable.length() > 0 && editable.length() % 5 == 0 && ' ' == (c = editable.charAt(editable.length() - 1))) {
                    editable.delete(editable.length() - 1, editable.length());
                }
                if (editable.length() > 0 && editable.length() % 5 == 0 && Character.isDigit(c = editable.charAt(editable.length() - 1)) && TextUtils.split((String)editable.toString(), (String)String.valueOf(' ')).length <= 3) {
                    editable.insert(editable.length() - 1, (CharSequence)String.valueOf(' '));
                }
                if (editable.length() >= 16) {
                    CardForm.this.previewCardType.setText((CharSequence)new CreditCard(editable.toString(), 0, 0, "").getBrand());
                }
                CardForm.this.previewCardNumber.setText((CharSequence)editable.toString());
            }
        });
        this.expiryDate.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                char c;
                switch (editable.length()) {
                    case 1: {
                        if (Integer.parseInt(editable.toString()) <= 1) break;
                        editable.clear();
                        break;
                    }
                    case 2: {
                        if (editable.charAt(0) <= '\u0000' || editable.charAt(1) <= '\u0002') break;
                        editable.delete(1, 1);
                    }
                }
                if (editable.length() > 0 && editable.length() % 3 == 0 && Character.isDigit(c = editable.charAt(editable.length() - 1))) {
                    editable.insert(editable.length() - 1, (CharSequence)String.valueOf(CardForm.this.slash));
                }
                CardForm.this.previewExpiry.setText((CharSequence)editable.toString());
            }
        });
        this.cardName.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (editable.toString().trim().length() > 0) {
                    CardForm.this.previewCardName.setText((CharSequence)editable.toString());
                }
            }
        });
        this.cvc.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (editable.toString().trim().length() > 0) {
                    CardForm.this.previewCvc.setText((CharSequence)editable.toString());
                }
            }
        });
        this.cvc.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    CardForm.this.showBack();
                }
            }
        });
        this.cardName.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    CardForm.this.showFront();
                }
            }
        });
        this.cardNumber.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    CardForm.this.showFront();
                }
            }
        });
        this.expiryDate.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    CardForm.this.showFront();
                }
            }
        });
    }

    private boolean cardIsvalid() {
        CreditCard creditCard = this.getCard();
        if (!creditCard.validateNumber()) {
            this.cardNumber.setError((CharSequence)this.cardNumberError);
        }
        if (!creditCard.validateExpiryDate()) {
            this.expiryDate.setError((CharSequence)this.expiryDateError);
        }
        if (!creditCard.validateCVC()) {
            this.cvc.setError((CharSequence)this.expiryDateError);
        }
        return creditCard.validateCard();
    }

    private void showBack() {
        if (!this.isBackShowing) {
            Animator cardFlipLeftIn = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)R.animator.card_flip_left_in);
            cardFlipLeftIn.setTarget((Object)this.cardFront);
            cardFlipLeftIn.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator2) {
                }

                public void onAnimationEnd(Animator animator2) {
                    CardForm.this.cardFront.setVisibility(8);
                    CardForm.this.cardBack.setVisibility(0);
                    CardForm.this.isBackShowing = true;
                }

                public void onAnimationCancel(Animator animator2) {
                }

                public void onAnimationRepeat(Animator animator2) {
                }
            });
            cardFlipLeftIn.start();
        }
    }

    private void showFront() {
        if (this.isBackShowing) {
            Animator cardFlipRightIn = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)R.animator.card_flip_right_in);
            cardFlipRightIn.setTarget((Object)this.cardBack);
            cardFlipRightIn.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator2) {
                }

                public void onAnimationEnd(Animator animator2) {
                    CardForm.this.cardBack.setVisibility(8);
                    CardForm.this.cardFront.setVisibility(0);
                    CardForm.this.isBackShowing = false;
                }

                public void onAnimationCancel(Animator animator2) {
                }

                public void onAnimationRepeat(Animator animator2) {
                }
            });
            cardFlipRightIn.start();
        }
    }

    public void setPayBtnClickListner(OnPayBtnClickListner onPayBtnClickListner) {
        this.onPayBtnClickListner = onPayBtnClickListner;
    }
}

